#include "game.h"

static void DrawRiverSegment(int *sx, int *sy, int wid, int angle, int len, int type);
static void DrawRiverStrip(double x, double y, int angle, int width);
static void DrawRiverCell(double x, double y);

#define R_SEGMENT_STRAIGHT	0
#define R_SEGMENT_CURVELEFT	1
#define R_SEGMENT_CURVERIGHT	2
#define R_SEGMENT_WINDY_MEDIUM	3
#define R_SEGMENT_WINDY_TIGHT	4
#define R_SEGMENT_RANDOM	5

/*
** Draw a river which starts at (cx,cy) and extends for 
** length L. The river should start off with width W and get narrow toward the
** far end.
*/

void
River(int cx, int cy, int W, int L)
	{
	int seglen,angle,tlen=0;

	angle = Random(360);

	while(tlen < L)
	   {
	   seglen = 3 + Random(4);
	   DrawRiverSegment(&cx,&cy,W,angle,seglen,R_SEGMENT_STRAIGHT);
	   tlen += seglen;
	   if (tlen >= L/2) W = 1 + Random(2);
	   else {W -= W/3 - 1; if (W<1) W=1;}
	   angle += 25 - Random(51);
	   if (angle>360) angle-=360;
	   if (angle<0) angle+=360;
	   }
	}

/*
** Draw a piece of a river, returning the finishing coords int (sx,sy).
**
** angle is the initial direction of the segment in degrees (0-359) and
** type is one of the predefined R_SEGMENT types
*/

static void
DrawRiverSegment(int *sx, int *sy, int wid, int angle, int len, int type)
	{
	double x,y,inc,dx,dy;
	int th;

	if (len<=0) return;

	x = (double)*sx; y=(double)*sy; th=angle;
	x+=0.5; y+=0.5; inc = 0.3;
	dx = sine(th); dy = -cosine(th);

	while(len--) switch(type)
	   {
	   default:
	   case R_SEGMENT_STRAIGHT:
		DrawRiverStrip(x,y,angle+90,1);
		x += inc * dx; y += inc * dy;
		if (Random(100) == 0)
		   River((unsigned)(x+0.5),(unsigned)(y+0.5),1,
					Random(30) + 10);
		break;
	   }
		
	*sx = (unsigned int) x;
	*sy = (unsigned int) y;
	}

/*
** We are passed the coords of the midpoint of this lateral river strip
** as the pair of doubles (x,y), the direction of the strip as angle (0-359)
** and the width of the strip.
*/
static void
DrawRiverStrip(double x, double y, int angle, int width)
	{
	int w;
	double dx,dy;

	/* Simple optimisation */
	if (width<=1) {DrawRiverCell(x,y); return;}

	/* Direction vector */
	dx = sine(angle); dy = - cosine(angle);

	/* Calculate starting point */
	x -= dx * width/2; y -= dy * width/2;

	/* For smoothness, oversample by 2x */
	width<<=1; dx/=2; dy/=2;
	while(width--) 
	   {
	   DrawRiverCell(x,y);
	   x += dx; y += dy;
	   }
	}

static void
DrawRiverCell(double x, double y)
	{
	unsigned int cx = (unsigned int) (x+0.5);
	unsigned int cy = (unsigned int) (y+0.5);

	if (!iswater(cy,cx))
	   {
	   Set_TerrainTypeIndex(cy,cx,T_DEEP_WATER,0);
	   }
	}
