#include "game.h"

static int sr;		/* swamp radius, used everywhere */
static int cx,cy;	/* centre of the swamp */

static void add_rivers(int cx, int cy, int angle, int dist);
static void add_water(int cx,int cy, int angle, int dist);
static void add_mud(int cx, int cy, int angle, int dist);
static void Perturb(void);

static int myRandom(int n)
	{
	if (OneIn(100)) Perturb();
	return Random(n);
	}

void
create_swamp()
	{
	int angle,dist;
	int x,y,n,nm;

	cx = Random(CELLS_ACROSS); cy = Random(CELLS_DOWN);

	Log("Swamp %d %d\n",cx,cy);

	/* sr is the "swamp radius" - a measure of the size of this swamp */
	sr = 30 + Random(100);

	/* create lots of lakes in this area */
	n = 5 + Random(5);
	while(n--)
	   create_lake('c',cx + sr - myRandom(2*sr+1),
			   cy + sr - myRandom(2*sr+1));

	/* add in a few rivers */
	n = 20 + Random(20);
	while(n--) add_rivers(cx,cy,myRandom(360),myRandom(sr));

	/* The land around the swamp should be mostly mud */
	n = (sr*sr) * 2;
	while(n--) add_mud(cx,cy,myRandom(360),myRandom(sr));

	/* create lots of little bits of water */
	n = (sr*sr)/2 + myRandom(30);
	while(n--) add_water(cx,cy,myRandom(360),myRandom(sr));

	/* Add some QuagSpots */
	n = 3 + myRandom(10);
	while(n--)
	   {
	   int r,n1;
	   int x1,y1,x2,y2;

	   angle = myRandom(360); dist = 20 + myRandom(sr*2);
	   x1 = cx + (int)(sine(angle) * (double)dist + 0.5);
	   y1 = cy - (int)(cosine(angle) * (double)dist - 0.5);
	   r = 3 + myRandom(10);
	   n1 = 3*r*r + myRandom(r*r);
	   while(n1--)
		{
	   	angle = myRandom(360); dist = myRandom(r);
	   	x2 = x1 + (int)(sine(angle) * (double)dist + 0.5);
	   	y2 = y1 - (int)(cosine(angle) * (double)dist - 0.5);
		Set_TerrainTypeIndex(y2,x2,T_QUAGMIRE,0);
		if (OneIn(8)) {x1 += 5 - myRandom(11); y1 += 5 - myRandom(11);}
		}
	   }
	   
	}

static void
add_water(int cx,int cy, int angle, int dist)
	{
	int x,y;

	x = cx + (int)(sine(angle) * (double)dist + 0.5);
	y = cy - (int)(cosine(angle) * (double)dist - 0.5);
	Set_TerrainTypeIndex(y,x,T_DEEP_WATER,0);
	}

static void
add_mud(int cx, int cy, int angle, int dist)
	{
	int type,x,y;

	if (myRandom(sr) > dist) type = T_QUAGMIRE;
	else type = T_MUD;

	x = cx + (int)(sine(angle) * (double)dist + 0.5);
	y = cy - (int)(cosine(angle) * (double)dist - 0.5);
	Set_TerrainTypeIndex(y,x,type,RandomTileVariant(type));
	}

static void
add_rivers(int cx, int cy, int angle, int dist)
	{
	int x,y;

	angle = myRandom(360); dist = myRandom(sr);
	x = cx + (int)(sine(angle) * (double)dist + 0.5);
	y = cy - (int)(cosine(angle) * (double)dist - 0.5);
	River(x,y,1,myRandom(30));
	}

static void Perturb()
	{
	/* move the centre of the swamp a bit, just to make
	** the landscape more interesting
	*/
	cx = cx + 15 - Random(31);
	cy = cy + 15 - Random(31);
	}
