/*
** Text output routines.
**
** Text is drawn underneath the map.
*/

#include "game.h"

#include <stdarg.h>

static int __done_init=0;
static GrObject *Char[256];
static int _GrTEXT_XMIN=0, _GrTEXT_YMIN=0, _GrTEXT_YMAX=0, _GrTEXT_XMAX=0;
static GrObject *gr_text = NULL;
static int text_changed=0;

void
GrSetTextRegion(int x1, int y1, int x2, int y2)
	{
	_GrTEXT_XMIN = x1;
	_GrTEXT_YMIN = y1;
	_GrTEXT_XMAX = x2;
	_GrTEXT_YMAX = y2;

	/*
	** Create an object to hold this text
	*/
	if (gr_text != NULL) GrDestroyObject(gr_text);
	gr_text = GrCreateObject(x2-x1+1,y2-y1+1);
	GrFillObject(gr_text,Colour[DARK_BLUE]);
	text_changed=2;
	}

int
TextInit()
	{
	int i,x,y,n;
	extern ushort ascii8x16[];

	/* Convert our bitmaps into Objects suitable for blitting */
	for(i=32; i<128; ++i)
	   {
	   Char[i] = GrCreateObject(8,16);
	   for(n=y=0; y<16; ++y) for(x=0; x<8; ++x,++n)
		if (ascii8x16[16 * (i-32) + y] & (128>>x))
		     Char[i]->data[n] = Colour[WHITE];
		else Char[i]->data[n] = Colour[DARK_BLUE];
	   }
	for(i=0; i<32; ++i) Char[i] = Char['?'];
	for(i=128; i<256; ++i) Char[i] = Char['?'];
	__done_init=1;
	return 0;
	}

int
Print(int row, int col, char *format, ...)
	{
	va_list args;
	static char buf[4096],*ch;
	int x,y;

	if (row<0 || col<0) return;
	if (!__done_init && TextInit())
	   Die("Error initialising fonts");

	if (!gr_text) Die("print: gr_text region uninitialised");

	va_start(args,format);
	vsprintf(buf,format,args);
	
	y = row*16; if (y>=gr_text->Height-16) return;
	x = col*8;  if (x>=gr_text->Width-8) return;

	ch=buf;
	while(*ch)
	   {
	   if (x<=gr_text->Width-8)
		{
		GrMergeObjectNC(gr_text,Char[*ch],x,y,GrWRITE);
		text_changed=4;
		}
	   ++ch; x += 8;
	   }

	return 0;
	}

void
RefreshText()
	{
	if (!gr_text) return;
	if (text_changed<=0) return;

	/*
	** Output the gr_text object at (_GrTEXT_XMIN,_GrTEXT_YMIN)
	*/
	GrDrawObjectNC(gr_text,_GrTEXT_XMIN,_GrTEXT_YMIN);
	--text_changed;
	}
