#include "game.h"

static FILE *log = NULL;

void Log(char *format,...)
	{
	va_list arg;
	char msg[2048];

	if (log == NULL) log = fopen("altair.log","ab");
	if (log == NULL) Die("Could not open log file altair.log");

	va_start(arg,format);
	vsprintf(msg,format,arg);
	fprintf(log,"%s",msg); fflush(log);
	}

void Die(char *format,...)
	{
	va_list arg;
	char msg[2048];

	va_start(arg,format);
	vsprintf(msg,format,arg);
	printf("%s\n",msg);
	Log("Fatal Message: %s\n",msg);
	GrShutdown();
	printf("%s\n",msg);
	exit(1);
	}

int Random(n)
	{
	/* Returns an integer between 0 and n-1 */
	return rand() % n;
	}

int OneIn(n)
	{
	/* returns TRUE one time in n */
	if ((rand()%n) == 0) return 1;
	return 0;
	}

/*
** This routine checks for overlap between two rectangles in pixel coordinates.
*/

int Overlap_p(int ax1,int ay1, int ax2, int ay2,
	      int bx1, int by1, int bx2, int by2)
	{
	if (ax2 < bx1 || bx2 < ax1 || ay2 < by1 || ay1 > by2) return 0;
	return 1;
	}

/*
** This routine checks for overlap, and returns the overlapping region in
** rectangle c
*/
int Overlap_c(int ax1, int ay1, int ax2, int ay2,
	      int bx1, int by1, int bx2, int by2,
	      int *cx1, int *cy1, int *cx2, int *cy2)
	{
	if (ax2 < bx1 || bx2 < ax1 || ay2 < by1 || ay1 > by2) return 0;

	*cx1 = ax1; *cy1 = ay1; *cx2 = ax2; *cy2 = ay2;
	if (*cx1 < bx1) *cx1 = bx1;
	if (*cy1 < by1) *cy1 = by1;
	if (*cx2 > bx2) *cx2 = bx2;
	if (*cy2 > by2) *cy2 = by2;
	return 1;
	}

#define lowercase(a) (((a)>='A' && (a)<='Z') ? ((a)+32) : (a))
int 
_my_strcasecmp(char *s1, char *s2)
	{
	while(*s1 && *s2 && lowercase(*s1) == lowercase(*s2)) {++s1; ++s2;}

	if (*s1==0 && *s2==0) return 0;
	return 1;
	}

#ifdef USE_JUGL
int
access(char *fname, int mode)
	{
	FILE *z=NULL;

	switch(mode)
	   {
	   case R_OK: z = fopen(fname,"rb"); break;
	   case W_OK: z = fopen(fname,"ab"); break;
	   case X_OK: z = NULL; break;
	   }

	if (z)
	   {
	   fclose(z); return 0;
	   }
	return 1;
	}

void
bzero(char *data, int len)
	{
	while(len--) *(data++)=0;
	}
#endif
