/*
 * Copyright (C) 1989-95 GROUPE BULL
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * GROUPE BULL BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the name of GROUPE BULL shall not be
 * used in advertising or otherwise to promote the sale, use or other dealings
 * in this Software without prior written authorization from GROUPE BULL.
 */

/*****************************************************************************\
*  RdFToGr.c:                                                                  *
*                                                                             *
*  XPM library                                                                *
*  Parse an XPM file and create a GrObject                                    *
*                                                                             *
*  Developed by Arnaud Le Hors (heavily hacked by Anthony Wesley)             *
\*****************************************************************************/

#include "xpmP.h"

LFUNC(OpenReadFile, int, (char *filename, xpmData *mdata));
LFUNC(xpmDataClose, void, (xpmData *mdata));

GrObject *
XpmReadFileToGrObject(char *filename, char *rgbdata)
{
    static int init=0;
    GrObject *gr;
    xpmData mdata;
    int ErrorStatus;

    if (!init)
	{
	ErrorStatus = xpmReadRgbNames(rgbdata);
	if (!ErrorStatus) Die("Xpm: Could not load RGB data file %s",rgbdata);
	init=1;
	}

    /* open file to read */
    if ((ErrorStatus = OpenReadFile(filename, &mdata)) != XpmSuccess)
	Die("Xpm: Error Opening file %s",filename);

    /* create the XpmImage from the XpmData */
    gr = xpmParseData(&mdata);
    if (gr == NULL) Die("Xpm: Parse error while reading %s",filename);

    xpmDataClose(&mdata);

    return gr;
}

/*
 * open the given file to be read as an xpmData which is returned.
 */
static int
OpenReadFile(char *filename, xpmData *mdata)
    {

    if (!(mdata->stream.file = fopen(filename, "r"))) return (XpmOpenFailed);
    mdata->type = XPMFILE;
    mdata->CommentLength = 0;
    return (XpmSuccess);
}

/*
 * close the file related to the xpmData if any
 */
static void
xpmDataClose(mdata)
    xpmData *mdata;
{
	    fclose(mdata->stream.file);
}
