/*
 * Copyright (C) 1989-95 GROUPE BULL
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * GROUPE BULL BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the name of GROUPE BULL shall not be
 * used in advertising or otherwise to promote the sale, use or other dealings
 * in this Software without prior written authorization from GROUPE BULL.
 */

/*****************************************************************************\
* rgb.c:                                                                      *
*                                                                             *
*  XPM library                                                                *
*  Rgb file utilities                                                         *
*                                                                             *
*  Developed by Arnaud Le Hors                                                *
\*****************************************************************************/

/*
 * The code related to FOR_MSW has been added by
 * HeDu (hedu@cul-ipn.uni-kiel.de) 4/94
 */

/*
 * Part of this code has been taken from the ppmtoxpm.c file written by Mark
 * W. Snitily but has been modified for my special need
 */

#include "xpmP.h"
#include <ctype.h>
#include <string.h>

static xpmRgbName Table[MAX_RGBNAMES+1];
static int nColours=0;
static int init=0;

static int myatoi(char *);
static int
myatoi(char *s)
	{
	int err,v;

	err = sscanf(s,"%x",&v);
	if (err != 1) Die("Xpm: Invalid color string \"%s\"",s);
	return v;
	}

/*
 * Read a rgb text file.  It stores the rgb values (0->65535)
 * and the rgb mnemonics (malloc'ed) into the "rgbn" array.  Returns the
 * number of entries stored.
 */
int
xpmReadRgbNames(char *rgb_fname)

{
    FILE *rgbf;
    int n, items, red, green, blue;
    char line[512], name[512], *rgbname, *s1, *s2;
    xpmRgbName *rgb;

    if (init) return;

    /* Open the rgb text file.  Abort if error. */
    if ((rgbf = fopen(rgb_fname, "r")) == NULL)
	return 0;

    /* Loop reading each line in the file. */
    n = 0;
    rgb = Table;
    /* Quit if rgb text file has too many entries. */
    while (fgets(line, sizeof(line), rgbf) && n < MAX_RGBNAMES) {

	/* Skip silently if line is bad. */
	items = sscanf(line, "%d %d %d %[^\n]\n", &red, &green, &blue, name);
	if (items != 4)
	    continue;

	/*
	 * Make sure rgb values are within 0->255 range. Skip silently if
	 * bad.
	 */
	if (red < 0 || red > 0xFF ||
	    green < 0 || green > 0xFF ||
	    blue < 0 || blue > 0xFF)
	    continue;

	/* Allocate memory for ascii name. If error give up here. */
	if (!(rgbname = (char *) XpmMalloc(strlen(name) + 1)))
	    break;

	/* Copy string to ascii name and lowercase it. */
	for (s1 = name, s2 = rgbname; *s1>=32; s1++)
	    *s2++ = tolower(*s1);
	*s2 = '\0';

	/* Save the rgb values and ascii name in the array. */
	rgb->r = red * 257;		/* 65535/255 = 257 */
	rgb->g = green * 257;
	rgb->b = blue * 257;
	rgb->name = rgbname;
	rgb++;
	n++;
        nColours++;
    }

    fclose(rgbf);
    init=1;

    /* Return the number of read rgb names. */
    return n < 0 ? 0 : n;
}

/*
 * Return the color name corresponding to the given rgb values
 */
char *
xpmGetRgbName(int red, int green, int blue)
{
    int i;
    xpmRgbName *rgb;

    if (!init) Die("xpmGetRgbName: Called before initialisation");
    /*
     * Just perform a dumb linear search over the rgb values of the color
     * mnemonics.  One could speed things up by sorting the rgb values and
     * using a binary search, or building a hash table, etc...
     */
    for (i = 0, rgb = Table; i < nColours; i++, rgb++)
	if (red == rgb->r && green == rgb->g && blue == rgb->b)
	    return rgb->name;

    /* if not found return NULL */
    return NULL;
}

/*
 * Free the strings which have been malloc'ed in xpmReadRgbNames
 */
void
xpmFreeRgbNames()
{
    int i;
    xpmRgbName *rgb;

    for (i = 0, rgb = Table; i < nColours; i++, rgb++)
	XpmFree(rgb->name);
}

int
xpmGetRgbFromName(char *name, int *red, int *green, int *blue)
	{
	int i;

    	if (!init) Die("xpmGetRgbFromName: Called before initialisation");

	/*
	** Is this a name of the form "#rrggbb" etc ?
	*/
	if (name[0]=='#')
	   {
	   char s[10],*p = name+1;

	   switch(strlen(p))
		{
		case 6:  /* rrggbb */
			s[0]= *(p++); s[1] = *(p++); s[2]=0;
			*red = myatoi(s) * 257;
			s[0]= *(p++); s[1] = *(p++); s[2]=0;
			*green = myatoi(s) * 257;
			s[0]= *(p++); s[1] = *(p++); s[2]=0;
			*blue = myatoi(s) * 257;
			break;
		case 9:  /* rrrgggbbb */
			s[0]= *(p++); s[1] = *(p++); s[2] = *(p++); s[3]=0;
			*red = myatoi(s) * 16;
			s[0]= *(p++); s[1] = *(p++); s[2] = *(p++); s[3]=0;
			*green = myatoi(s) * 16;
			s[0]= *(p++); s[1] = *(p++); s[2] = *(p++); s[3]=0;
			*blue = myatoi(s) * 16;
			break;
		case 12:  /* rrrrggggbbbb */
			s[0]= *(p++); s[1] = *(p++); s[2] = *(p++); s[3] = *(p++); s[4]=0;
			*red = myatoi(s);
			s[0]= *(p++); s[1] = *(p++); s[2] = *(p++); s[3] = *(p++); s[4]=0;
			*green = myatoi(s);
			s[0]= *(p++); s[1] = *(p++); s[2] = *(p++); s[3] = *(p++); s[4]=0;
			*blue = myatoi(s);
			break;
		default: return 0;
		}
	   return 1;
	   }

	/*
	** Look through the table to see if we get an exact match
	*/
	for(i=0; i<nColours; ++i) if (!strcmp(Table[i].name,name))
	   {
	   *red = Table[i].r;
	   *green = Table[i].g;
	   *blue = Table[i].b;
	   return 1;
	   }

	return 0;
	}
