#!/bin/sh

# chkconfig: - 80 30
# description: sugar-server

### BEGIN INIT INFO
# Provides:          sugar-server
# Required-Start:    $all
# Required-Stop:     $network
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: sugar-server
# Description:       sugar-server
### END INIT INFO

PROG=@PROG@
NAME=$(basename $0)
RETVAL=0

case "$1" in
    start|restart)
        echo -n "Starting $NAME..."
        $PROG -q $1 && ($PROG config delegation && $PROG -qs keyring $1 || true)
        RETVAL=$?
        if [ $RETVAL -eq 0 ]; then
            echo "ok"
        else
            echo "failed"
        fi
        ;;
    status)
        $PROG -q status && ($PROG config delegation && $PROG -qs keyring status || true)
        RETVAL=$?
        ;;
    stop)
        echo -n "Stopping $NAME..."
        $PROG -q stop
        RETVAL=$?
        $PROG config delegation && $PROG -qs keyring stop || true
        [ $? -eq 0 ] || RETVAL=1
        if [ $RETVAL -eq 0 ]; then
            echo "ok"
        else
            echo "failed"
        fi
        ;;
    reload)
        $0 status && $0 restart || true
        RETVAL=$?
        ;;
    *)
        echo "Usage: $0 {start|stop|status|restart}"
        exit 1
esac

exit $RETVAL
