# Copyright (C) 2011, Aleksey Lim
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from os.path import join

from sugar_server.util import Option, _
from sugar_server import leases


activation_port = Option(
        _('port for incomming connections for activation service'),
        default=1910, type_cast=int)

default_expiry = Option(
        _('default expiry for delegated leases in days, if integer value, ' \
                'or, exact date in format "yyyymmddThhmmssZ"'),
        default='30', type_cast=leases.Expiry)

max_expiry = Option(
        _('maximal lease expiry value in days, if integer value, or, ' \
                'exact date in format "yyyymmddThhmmssZ"'),
        default='90', type_cast=leases.Expiry)

delegation = Option(
        _('delegate leases if there are no existed ones'),
        default=True, type_cast=Option.bool_cast, action='store_true')

TEST_SN = 'AAA00001978'


def path(*args):
    from sugar_server import env
    return join(env.root.value, 'share', *args)


def leases_path(machine_sn):
    return path(leases.leases_path(machine_sn))


def oats_delegations_path(machine_sn):
    return path(leases.oats_delegations_path(machine_sn))


def lease_delegations_path(machine_sn):
    return path(leases.lease_delegations_path(machine_sn))
