# Copyright (C) 2011, Aleksey Lim
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from sugar_server.util import Option, Command, _


soft_quota = Option(
        _('how much, in percents, the storage should be filled in to start ' \
                'doing regular backup trimming'),
        default=70, type_cast=int)

hard_quota = Option(
        _('how much, in percents, the storage should be filled in to stop ' \
                'receiving backup requests and do emrgency backup trimming'),
        default=90, type_cast=int)

trim_timeout = Option(
        _('try to trim backups in specified number of seconds'),
        default=60 * 60 * 24, type_cast=int)

trim_daily_limit = Option(
        _('keep daily backups for specified days while trimming'),
        default=90, type_cast=int)

trim = Command(
        _('start trimming backups manually according to quotas'))

BACKUP_DIRNAME = '%Y-%m-%d'
