# sugar-lint: disable

import os
import sys
import pwd
import shutil
import logging
import unittest
from os.path import dirname, join, exists, abspath

from sugar_server import env, util


tmproot = abspath(join(dirname(__file__), '.tmp'))
tmpdir = None

env.get_logger = lambda name, fmt=None: logging.getLogger()


def main():
    shutil.rmtree(tmproot, ignore_errors=True)
    unittest.main()


class Pwd(object):

    def __init__(self, pw):
        self.pw_name = pw.pw_name
        self.pw_uid = pw.pw_uid
        self.pw_gid = pw.pw_gid
        self.pw_dir = pw.pw_dir


class Test(unittest.TestCase):

    def setUp(self):
        global tmpdir
        tmpdir = join(tmproot, '.'.join(self.id().split('.')[1:]))
        shutil.rmtree(tmpdir, ignore_errors=True)
        os.makedirs(tmpdir)
        os.chdir(tmpdir)

        me = pwd.getpwuid(os.getgid()).pw_name
        env.user.value = me
        env.keyring_user.value = me
        env.root.value = '.'
        env.debug.value = 3

        self._overriden = []

        logfile = tmpdir + '.log'
        if exists(logfile):
            os.unlink(logfile)

        root_logger = logging.getLogger()
        for handler in root_logger.handlers:
            root_logger.removeHandler(handler)
        logging.basicConfig(level=logging.DEBUG,
                format='%(asctime)s %(levelname)s %(name)s: %(message)s',
                filename=logfile)

    def tearDown(self):
        while self._overriden:
            mod, name, old_handler = self._overriden.pop(0)
            setattr(mod, name, old_handler)
        env.unset_statvfs()
        util._unset_utcnow()
        sys.stdout.flush()

    def override(self, mod, name, new_handler):
        for i_mod, i_name, __ in self._overriden:
            if i_mod == mod and i_name == name:
                break
        else:
            self._overriden.append((mod, name, getattr(mod, name)))
        setattr(mod, name, new_handler)

    def touch(self, *files):
        for i in files:
            if isinstance(i, str):
                if i.endswith(os.sep):
                    i = i + '.stamp'
                path = i
                if exists(path):
                    content = file(path).read()
                else:
                    content = i
            else:
                path, content = i
                if isinstance(content, list):
                    content = '\n'.join(content)
            path = join(tmpdir, path)

            if not exists(dirname(path)):
                os.makedirs(dirname(path))

            f = file(path, 'w')
            f.write(str(content))
            f.close()
