# sugar-lint: disable

import os
import sys
import time
import signal
import shutil
from os.path import dirname, join, abspath

src_root = abspath(join(dirname(__file__), '..', '..'))
sys.path.insert(0, src_root)

from tests import *

from sugar_server import env, process
from sugar_server.util import enforce
import sugar_unit, sugar_unit.env, sugar_unit.bot


class IntegrationTest(Test):

    def setUp(self):
        Test.setUp(self)

        # Have to use the same root for all tests sice backup service
        # uses ssh login
        root = join(tmproot, 'root')
        shutil.rmtree(root, ignore_errors=True)

        current_pw = Pwd(pwd.getpwnam(env.user.value))
        current_pw.pw_dir = root
        self.override(pwd, 'getpwnam', lambda *args: current_pw)

        env.hostname.value = 'localhost'
        env.root.value = root
        try:
            env.init(None, logname=False)
        except SystemExit:
            pass

        os.makedirs('master_keys')
        self.master_lease = 'master_keys/lease'
        env.call_crypto('makekey', self.master_lease)
        self.master_oats = 'master_keys/oats'
        env.call_crypto('makekey', self.master_oats)

        sugar_unit.init(api_url='localhost:8000',
                profile_dir=join(root, 'sugaroid'), nick='sugar-server-test',
                lease_key=self.master_lease + '.public')
        self.bot = sugar_unit.bot.Bot()

        # Let daemonized process break unittsets code immediately
        # w/o falling to the next units
        process._process_exit = os._exit

    def tearDown(self):
        if process.started():
            enforce(process.stop() == 0)
            for __ in range(10):
                if not process.started():
                    break
                time.sleep(.2)
            else:
                enforce(False)
        Test.tearDown(self)
        os.rename(env.root.value, 'root')

        sugaroid_log = join(dirname(__file__), 'test')
        if exists(sugaroid_log):
            os.rename(sugaroid_log, 'sugaroid')

    def start(self, services):
        enforce(not process.started())
        env.services.value = services
        enforce(process.start(False, False) == 0)
        # TODO More reliable way to wait when process will be ready
        time.sleep(1)
