#!/usr/bin/env sugar-unit-client

# sugar-lint: disable

import os
import pwd

from __init__ import IntegrationTest, main

from sugar_server import env, util, misc


etc = env.import_from('etc', 'registry')


class IdIntegrationTest(IntegrationTest):

    def setUp(self):
        IntegrationTest.setUp(self)
        self.start(['registry'])

    def test_register(self):
        assert not self.bot.jabber_url
        assert not self.bot.registered
        self.bot.register()
        self.assertEqual(etc.jabber_url.value, self.bot.jabber_url)
        assert self.bot.registered

    def test_compat_register(self):
        assert not self.bot.jabber_url
        assert not self.bot.registered
        self.bot.compat_register()
        self.assertEqual(etc.jabber_url.value, self.bot.jabber_url)
