#!/usr/bin/env sugar-unit-client

# sugar-lint: disable

import os

from __init__ import IntegrationTest, main

from sugar_server import env, util, misc


backup_etc = env.import_from('etc', 'backup')


class SystemTest(IntegrationTest):

    def setUp(self):
        IntegrationTest.setUp(self)

        self.loadavg = 0
        self.override(os, 'getloadavg', lambda: [self.loadavg])

        self.ps = []
        self.override(misc, 'ps', lambda: self.ps)

    def test_PendingRestoreFlag(self):
        backup_etc.soft_quota.value = 101
        backup_etc.hard_quota.value = 101
        self.start(['registry', 'backup'])

        self.bot.register()
        assert self.bot.registered
        assert not self.bot.pending_restore
        self.bot.store('foo')
        self.bot.backup()

        self.bot.register()
        assert self.bot.pending_restore
        self.bot.restore()
        assert not self.bot.pending_restore

        self.bot.register()
        assert self.bot.pending_restore
        self.bot.backup()
        assert not self.bot.pending_restore
