# sugar-lint: disable

import sys
import time
import binascii
import threading
from optparse import OptionParser
from os.path import dirname, join, abspath

src_root = abspath(join(dirname(__file__), '..', '..'))
sys.path.insert(0, src_root)

from tests import *

from sugar_server import env as _env


class UnitTest(Test):

    def setUp(self):
        Test.setUp(self)

        self._real_keyring = None

        current_pw = Pwd(pwd.getpwnam(_env.user.value))
        current_pw.pw_dir = _env.root.value
        self.override(pwd, 'getpwnam', lambda *args: current_pw)

    def tearDown(self):
        if self._real_keyring is not None:
            self._real_keyring.stop()
        Test.tearDown(self)

    def start_real_keyring(self):
        self._real_keyring = _env.import_from('service', 'keyring')
        threading.Thread(target=self._real_keyring.start).start()
        time.sleep(1)

    def setup_root(self):
        for i in ['share', 'home']:
            shutil.copytree(join(tmproot, '..', 'units', 'data', i), i)
        for i in ['home/backup']:
            os.makedirs(i)
        try:
            _env.init(None, logname=False)
        except SystemExit:
            pass

    def verify(self, text, sig):
        filename = join(tmproot, 'verify')

        f = file(filename, 'w')
        f.write(text)
        f.close()

        f = file(filename + '.sha256.sig', 'wb')
        f.write(binascii.unhexlify(sig.strip()))
        f.close()

        _env.call_crypto('verify', 'sha256', 'home/keyring/server.public', filename)
