#!/usr/bin/env python

# sugar-lint: disable

import os
import threading
from os.path import exists

from __init__ import UnitTest, main

from sugar_server import env, util, registry


class ActivationTest(UnitTest):

    def setUp(self):
        UnitTest.setUp(self)
        self.setup_root()
        activation = env.import_from('service', 'activation')

        class Handler(activation.Handler):

            def __init__(self, received):
                self.received = received
                self.sent = ''
                activation.Handler.__init__(self, self, None, None)

            def recv(self, size):
                data = self.received[:]
                self.received = ''
                return data

            def send(self, data):
                self.sent += data

        self.Handler = Handler
        self.activation = activation

    def test_Handler_WrongInput(self):
        handler = self.Handler('foo')
        self.assertEqual('UNKNOWN\n', handler.sent)

        handler = self.Handler('foo:')
        self.assertEqual('UNKNOWN\n', handler.sent)

    def test_Handler_time01Command(self):
        self.start_real_keyring()

        handler = self.Handler('time01: SHF706002A7')
        self.assertEqual('UNKNOWN\n', handler.sent)

        handler = self.Handler('time01: foo bar')
        self.assertEqual('UNKNOWN\n', handler.sent)

        handler = self.Handler('time01: SHF706002A7 nonce')
        self.assertEqual('UNKNOWN\n', handler.sent)

        handler = self.Handler('time01: SHF706002A7 0123456789012345678901')
        assert handler.sent.startswith('time01:')

    def test_Handler_CanntGetLease(self):
        os.unlink('share/lease-delegations/A7/SHF706002A7')
        self.start_real_keyring()
        handler = self.Handler('SHF706002A7')
        self.assertEqual('UNKNOWN\n', handler.sent)

    def test_Handler_StolenLease(self):
        registry.update('machines', 'SHF706002A7', stolen=1)
        self.start_real_keyring()
        handler = self.Handler('SHF706002A7')
        self.assertEqual('STOLEN', handler.sent)
        assert registry.get('machines', 'SHF706002A7')['revealed']

    def test_Handler_GetLease(self):
        self.start_real_keyring()
        handler = self.Handler('SHF706002A7')
        assert handler.sent.startswith('act01: SHF706002A7')
        assert registry.get('machines', 'SHF706002A7')['activated']

    def test_GET_client_lease(self):
        self.start_real_keyring()
        self.assertRaises(RuntimeError, self.activation.GET_client_lease, {})
        reply = self.activation.GET_client_lease({'machine_sn': 'SHF706002A7'})
        assert 'lease' in reply
        assert reply['lease'].startswith('act01: SHF706002A7')

    def test_Handler_GetTestLease(self):
        handler = self.Handler('AAA00001978')
        assert handler.sent.startswith('act01: AAA00001978')
        assert registry.get('machines', 'AAA00001978')['activated']


if __name__ == '__main__':
    main()
