#!/usr/bin/env python

# sugar-lint: disable

import os
from ConfigParser import ConfigParser
from os.path import exists

from __init__ import UnitTest, main, src_root

import sugar_server
from sugar_server import env, util, registry


class EnvTest(UnitTest):

    def test_setup_env(self):
        self.setup_root()

        self.assertEqual(0755, os.stat('.').st_mode & 0777)
        self.assertEqual(0775, os.stat('home').st_mode & 0777)
        self.assertEqual(0775, os.stat('share').st_mode & 0777)
        self.assertEqual(0775, os.stat('var').st_mode & 0777)
        assert exists('var/log/sugar-server')
        self.assertEqual(0775, os.stat('var/log/sugar-server').st_mode & 0777)
        assert exists('var/sugar-server')
        self.assertEqual(0775, os.stat('var/sugar-server').st_mode & 0777)

    def test_setup_registry(self):
        os.chmod('.', 0777)

        service = env.import_from('service', 'registry')
        service.setup()

        assert exists('.ssh')
        self.assertEqual(0700, os.stat('.ssh').st_mode & 0777)

        self.assertEqual(0600, os.stat('.ssh/authorized_keys').st_mode & 0777)

        registry.update('users', 'uuid-1', machine_sn='SN1', pubkey='pubkey-1')
        registry.update('users', 'uuid-2', machine_sn='SN2', pubkey='pubkey-2')
        registry.update('machines', 'test')
        os.unlink('.ssh/authorized_keys')
        service.setup()
        os.utime(registry._root('users'), (0, 0))
        os.utime(registry._root('machines'), (0, 0))

        self.assertEqual(
                0600,
                os.stat('.ssh/authorized_keys').st_mode & 0777)
        self.assertEqual(
                sorted(['command="./home/backup/sugar-server-rsync uuid-1",no-port-forwarding,no-X11-forwarding,no-agent-forwarding,no-pty pubkey-1\n',
                 'command="./home/backup/sugar-server-rsync uuid-2",no-port-forwarding,no-X11-forwarding,no-agent-forwarding,no-pty pubkey-2\n']),
                sorted(file('.ssh/authorized_keys').readlines()))

        assert os.stat('.ssh/authorized_keys').st_mtime != registry.mtime('users')
        service.stop()
        assert os.stat('.ssh/authorized_keys').st_mtime == registry.mtime('users')
        service.setup()
        assert os.stat('.ssh/authorized_keys').st_mtime == registry.mtime('users')

        old_mtime_value = registry.mtime('users')
        os.utime(registry._root('users'), (old_mtime_value + 2, old_mtime_value + 2))
        service.setup()
        assert os.stat('.ssh/authorized_keys').st_mtime != old_mtime_value
        assert os.stat('.ssh/authorized_keys').st_mtime != registry.mtime('users')
        service.stop()
        assert os.stat('.ssh/authorized_keys').st_mtime == registry.mtime('users')
        service.setup()
        assert os.stat('.ssh/authorized_keys').st_mtime == registry.mtime('users')

    def test_setup_keyring(self):
        service = env.import_from('service', 'keyring')

        service.setup()

        assert exists('home/keyring')
        assert exists('home/keyring/server.public')

        assert exists('home/keyring/private')
        self.assertEqual(0700, os.stat('home/keyring/private').st_mode & 0777)

        assert exists('home/keyring/private/server.public')
        assert exists('home/keyring/private/server.private')
        self.assertEqual(0600, os.stat('home/keyring/private/server.private').st_mode & 0777)

    def test_setup_backup(self):
        service = env.import_from('service', 'backup')

        service.setup()
        assert exists('home/backup')
        self.assertEqual(0700, os.stat('home/backup').st_mode & 0777)

        assert exists('home/backup/sugar-server-rsync')
        self.assertEqual(
                ["sys.path.insert(0, '%s')\n" % src_root],
                [i for i in file('home/backup/sugar-server-rsync').readlines() if i.startswith('sys.path.insert')])

        assert exists('home/backup/sugar-server-rsync.conf')
        config = ConfigParser()
        config.read('home/backup/sugar-server-rsync.conf')
        for prop in util.Option.items.values():
            assert config.has_option(prop.section, prop.name)
            self.assertEqual(str(prop), config.get(prop.section, prop.name))

    def test_assert_serial(self):
        env.assert_machine_sn('AAA00000001')
        self.assertRaises(RuntimeError, env.assert_machine_sn, 'A')

    def test_assert_machine_uuid(self):
        env.assert_machine_uuid('00000000000000000000000000000001')
        self.assertRaises(RuntimeError, env.assert_machine_uuid, '0')


if __name__ == '__main__':
    main()
