#!/usr/bin/env python

# sugar-lint: disable

import os
from os.path import exists

from __init__ import UnitTest, main

from sugar_server import env, httpd
from sugar_server.rest import JSONRest, XMLRest


class HttpdTest(UnitTest):

    __name__ = 'test'

    def setUp(self):
        UnitTest.setUp(self)
        env.hostname.value = 'localhost'
        env.httpd_port.value = 8080
        env.services.value = 'self'
        self.override(env, 'service', lambda x: self)
        httpd.start()

    def tearDown(self):
        httpd.stop()
        UnitTest.tearDown(self)

    def httpd_handler(self, name):
        if hasattr(self, name):
            return getattr(self, name)

    def GET_test_error(self, query):
        raise RuntimeError('FAILED')

    def GET_test_success(self, query):
        return {'test': 'PASSED'}

    def GET_test_empty_return(self, query):
        pass

    def GET_test_query_params(self, query):
        return query

    def test_GET(self):
        rest = JSONRest('http://localhost:8080')
        self.assertEqual(
                {'success': 'OK', 'test': 'PASSED'},
                rest.get('/test/success'))
        self.assertEqual(
                {'success': 'ERR', 'error': 'FAILED'},
                rest.get('/test/error'))
        self.assertEqual(
                {'success': 'OK'},
                rest.get('/test/empty/return'))
        self.assertEqual(
                {'success': 'OK', 'param1': 'value1', 'param2': 'value2'},
                rest.get('/test/query-params', {'param1': 'value1', 'param2': 'value2'}))
        self.assertEqual(
                {'success': 'ERR', 'error': 'No handlers to serve /test/fake HTTP request'},
                rest.get('/test/fake'))

    def POST_test_error(self, query, data):
        raise RuntimeError('FAILED')

    def POST_test_success(self, query, data):
        data['test'] = 'PASSED'
        return data

    def POST_test_empty_return(self, query, data):
        pass

    def POST_test_query_params(self, query, data):
        data.update(query)
        return data

    def test_POST(self):
        rest = JSONRest('http://localhost:8080')
        self.assertEqual(
                {'success': 'OK', 'test': 'PASSED', 'data': 'test'},
                rest.post('/test/success', {'data': 'test'}))
        self.assertEqual(
                {'success': 'ERR', 'error': 'FAILED'},
                rest.post('/test/error', {'data': 'test'}))
        self.assertEqual(
                {'success': 'OK'},
                rest.post('/test/empty/return', {'data': 'test'}))
        self.assertEqual(
                {'success': 'OK', 'param1': 'value1', 'param2': 'value2', 'data': 'test'},
                rest.post('/test/query-params', {'data': 'test'}, {'param1': 'value1', 'param2': 'value2'}))
        self.assertEqual(
                {'success': 'ERR', 'error': 'No handlers to serve /test/fake HTTP request'},
                rest.post('/test/fake', {'data': 'test'}))

        xml_rest = XMLRest('http://localhost:8080')
        self.assertEqual(
                '{"success": "ERR", "error": "Only application/json content type is allowed"}',
                xml_rest.raw_post('/test/fake', ''))


if __name__ == '__main__':
    main()
