#!/usr/bin/env python

# sugar-lint: disable

from __init__ import UnitTest, main

from sugar_server import env


class KeyringTest(UnitTest):

    def setUp(self):
        UnitTest.setUp(self)
        self.setup_root()
        self.service = env.import_from('service', 'keyring')

    def test_WrongCommands(self):
        self.assertRaises(Exception, self.service.handle, '')
        self.assertRaises(Exception, self.service.handle, 'foo')

    def test_signCommand(self):
        handler = Handler(['sign', '1', 'bar'])

        self.service.handle(handler)

        assert handler.sent and handler.sent[0].startswith('sig02:')
        self.assertRaises(Exception, self.service.handle, ['sign'])
        self.assertRaises(Exception, self.service.handle, ['sign', 'foo'])
        self.assertRaises(Exception, self.service.handle, ['sign', '1'])

    def test_sign(self):
        signed_orig = 'sig02: sha256 3082010a0282010100afc1cf127c727b6700ec4715e5e98620090588871bc3fd72f1bd96153be87954334f4b88959dd72e61ba0036d5f1d6d3194dca442ec0cff9785ea84e0a1c75921e84a5b1684731b76ae2394b5d39291ad6e4373ad1a54a102f08b77a73c792bb8cdcaf27e425583b2eb64ef0b525570af622acb2a5cd33e3ef410952100a4494de57b177dc4b5db6b312416a5d644d6a22273fe9cfd2ae972b61d49b644b74748153564e7f551b4f77f1802a1451adf73bbee049e6b378e893c3124b0ecacb927aff17fdba4ea8f7d828cb8913ac655e79bc624d67d78b88966962a67a207ac48a4494a7f38cdee4a786afb8f41c2b155b1d7d0567dd5225d92f46500c6a8f910203010001 20110529T135103Z 3ec1dd7ee8583ad10cde0072f85b3d40c27e1f24c6fc6b71d900b7b24293e0ce2d2087e1789c557243cfccd2865e57cabf37cbd5a1453490f5122626259c43e7af3d381f8bae23a8890f2bbbb52867b0a1ba19cea55893791fe5e9d18095f0bd3c5f596ca82e1de8c99691759e1e89d0e74238f7b559c3b588858c49f85ce634bb8a6eb863262e56c3e2d01b4d52b013d7e6aff98b0dca632ecdc62a7c7d658ee6a37bdf17c63f278afb829c9b76d62bfe4afbe9d5b24318d4974ee89c8793970d9e3063de3575c43ce86b78bedd4dd47fa8b47d8c0daf7561337429137cd6066dcc84ec3d0fb31f53732970af4a82799ed5254a6c826785e8bfd0e23911ee40'
        signed = self.service.sign('20110529T135103Z', 'foo')

        self.assertEqual(' '.join(signed_orig.split()[:-1]), ' '.join(signed.split()[:-1]))
        self.verify('foo', signed_orig.split()[-1])
        self.verify('foo', signed.split()[-1])


class Handler():

    def __init__(self, data):
        self.received = data
        self.sent = []

    def recv_message(self):
        return self.received.pop(0)

    def send_message(self, data):
        self.sent.append(data)


if __name__ == '__main__':
    main()
