#!/usr/bin/env python

# sugar-lint: disable

import os
import time
from datetime import datetime, timedelta
from os.path import exists

from __init__ import UnitTest, main

from sugar_server import util, leases


class LeasesTest(UnitTest):

    def tearDown(self):
        UnitTest.tearDown(self)
        util._unset_utcnow()

    def test_Expiry_Construction(self):
        util._set_utcnow(time.mktime((1900, 1, 1, 1, 1, 1, 1, 1, 1)))

        expire = leases.Expiry(None)
        self.assertEqual('', expire)
        self.assertEqual('', str(expire))
        self.assertEqual('', unicode(expire))
        assert expire.days is None
        assert expire.date is None

        expire = leases.Expiry('')
        self.assertEqual('', expire)
        self.assertEqual('', str(expire))
        self.assertEqual('', unicode(expire))
        assert expire.days is None
        assert expire.date is None

        expire = leases.Expiry('1')
        date = util.utcnow() + timedelta(days=1)
        date_str = date.strftime('%Y%m%dT%H%M%SZ')
        self.assertEqual(date_str, expire)
        self.assertEqual(date_str, str(expire))
        self.assertEqual(date_str, unicode(expire))
        self.assertEqual(1, expire.days)
        self.assertEqual(date, expire.date)

        expire = leases.Expiry(2)
        date = util.utcnow() + timedelta(days=2)
        date_str = date.strftime('%Y%m%dT%H%M%SZ')
        self.assertEqual(date_str, expire)
        self.assertEqual(date_str, str(expire))
        self.assertEqual(date_str, unicode(expire))
        self.assertEqual(2, expire.days)
        self.assertEqual(date, expire.date)

        date = util.utcnow() + timedelta(days=3)
        date_str = date.strftime('%Y%m%dT%H%M%SZ')
        expire = leases.Expiry(date_str)
        self.assertEqual(date_str, expire)
        self.assertEqual(date_str, str(expire))
        self.assertEqual(date_str, unicode(expire))
        self.assertEqual(3, expire.days)
        self.assertEqual(date, expire.date)

        date = util.utcnow() + timedelta(days=4)
        date_str = date.strftime('%Y%m%dT%H%M%SZ')
        expire = leases.Expiry(date)
        self.assertEqual(date_str, expire)
        self.assertEqual(date_str, str(expire))
        self.assertEqual(date_str, unicode(expire))
        self.assertEqual(4, expire.days)
        self.assertEqual(date, expire.date)

        self.assertRaises(RuntimeError, leases.Expiry, '-1')
        self.assertRaises(RuntimeError, leases.Expiry, '1.1')
        self.assertRaises(RuntimeError, leases.Expiry, 1.2)
        self.assertRaises(RuntimeError, leases.Expiry, date.strftime('%Y%m%dT%H%M%S'))
        self.assertRaises(RuntimeError, leases.Expiry, date.strftime('%Y%-m-%dT%H%M%SZ'))


if __name__ == '__main__':
    main()
