#!/usr/bin/env python

# sugar-lint: disable

import os
import time
from os.path import exists, isdir

from __init__ import UnitTest, main

from sugar_server import env, registry, util


class DatastoreTest(UnitTest):

    def setUp(self):
        UnitTest.setUp(self)
        self.rows = [
                {'uid': 'foo-1', 'nickname': 'nickname-1', 'pubkey': 'pubkey-1', 'machine_sn': 'serial-1', 'foo': 0},
                {'uid': 'foo-2', 'nickname': 'nickname-2', 'pubkey': 'pubkey-2', 'machine_sn': 'serial-2', 'foo': 1},
                {'uid': 'foo-3', 'nickname': 'nickname-3', 'pubkey': 'pubkey-3', 'machine_sn': 'serial-3', 'foo': 1},
                ]
        util.rmtree(registry._root('users'))

    def test_OpenEmpty(self):
        self.assertEqual([], [i for i in registry.find('users')])

    def test_find(self):
        for row in self.rows:
            registry.update('users', row['uid'], **row)

        self.assertEqual(
                sorted(self.rows),
                sorted([i for i in registry.find('users')]))
        self.assertEqual(
                [self.rows[1]],
                [i for i in registry.find('users', uid='foo-2')])
        self.assertEqual(
                [],
                [i for i in registry.find('users', uid='foo-2', machine_sn='serial-0')])
        self.assertEqual(
                sorted([self.rows[1], self.rows[2]]),
                sorted([i for i in registry.find('users', foo=1)]))

    def test_update(self):
        row = self.rows.pop(0)
        registry.update('users', row['uid'], **row)
        assert not registry.update('users', row['uid'], **row)
        assert registry.get('users', row['uid'])

        row = self.rows.pop(0)
        assert registry.update('users', row['uid'], **row)
        assert not registry.update('users', row['uid'], **row)
        assert registry.get('users', row['uid'])

        row = self.rows.pop(0)
        assert registry.update('users', row['uid'], **row)
        assert not registry.update('users', row['uid'], **row)
        assert registry.get('users', row['uid'])


if __name__ == '__main__':
    main()
