# Copyright (C) 2011, Aleksey Lim
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from sugar_client.direct import \
        register, update_status, backup_journal, restore_journal, update_system

from sugar_client.env import \
        uid, api_url, auto_register, jabber_url, backup_url, backup_timeout, \
        update_args, update_timeout, debug, machine_sn, machine_uuid, nickname


def set_profile_dir(path):
    import os
    from os.path import join, exists, dirname
    from sugar_client import env

    def profile_path(*args):
        result = join(path, *args)
        if not exists(dirname(result)):
            os.makedirs(dirname(result))
        return result

    env.profile_path = profile_path
