# Copyright (C) 2012, Aleksey Lim
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

"""Config file module.

$Repo: git://git.sugarlabs.org/alsroot/codelets.git$
$File: src/confile.py$
$Data: 2012-02-23$

"""

from ConfigParser import ConfigParser
from gettext import gettext as _

try:
    import json
    if not hasattr(json, 'dumps'):
        raise ImportError()
except ImportError:
    import simplejson as json


class Confile(ConfigParser):

    DEFAULT_SECTION = 'main'

    # pylint: disable-msg=W0221,W0622
    def get(self, section, option, raw=False, vars=None, default=None):
        if default is not None and not self.has_option(section, option):
            return default
        value = ConfigParser.get(self, section, option, raw, vars)
        try:
            return json.loads(value)
        except ValueError:
            return value

    def __contains__(self, option):
        section, option = self._option(option)
        return self.has_option(section, option)

    def __getitem__(self, option):
        section, option = self._option(option)
        if not self.has_option(section, option):
            raise KeyError(_('No such option, "%s/%s"') % (section, option))
        return self.get(section, option)

    def __setitem__(self, option, value):
        section, option = self._option(option)
        if not self.has_section(section):
            self.add_section(section)
        if type(value) not in [str, unicode]:
            value = json.dumps(value)
        return self.set(section, option, value)

    def _option(self, option):
        section = Confile.DEFAULT_SECTION
        if isinstance(option, tuple):
            if len(option) == 2:
                section, option = option
            else:
                if len(option) != 1:
                    raise RuntimeError()
                option = option[0]
        return section, option
