# Copyright (C) 2012, Aleksey Lim
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

"""Network related routines.

$Repo: git://git.sugarlabs.org/alsroot/codelets.git$
$File: src/network.py$
$Data: 2012-02-23$

"""


def is_online():
    with file('/proc/net/route') as route:
        for line in route.readlines():
            try:
                if int(line.split('\t')[1], 16) == 0:
                    return True
            except ValueError:
                pass
    return False
