#!/usr/bin/env python

# sugar-lint: disable

import os
import sys
import dbus
from os.path import abspath, dirname

this_file = abspath(__file__)

from __init__ import tests

from sugar_client import env, system, util


class Ticket3270Test(tests.Test):

    def setUp(self):
        tests.Test.setUp(self)
        if 'http_proxy' in os.environ:
            del os.environ['http_proxy']

    def test_get_http_proxy_LocalUser(self):
        service = env.LocalService(None, None, None)
        assert service.get_http_proxy(None) is None
        os.environ['http_proxy'] = 'foo'
        self.assertEqual('foo', service.get_http_proxy(None))

    def test_get_http_proxy_DBusUser(self):
        env = os.environ.copy()

        http_proxy = util.call(
                ['/usr/bin/env', 'python', this_file, 'get_http_proxy'],
                env=env)
        self.assertEqual('', http_proxy)

        env['http_proxy'] = 'foo'
        http_proxy = util.call(
                ['/usr/bin/env', 'python', this_file, 'get_http_proxy'],
                env=env)
        self.assertEqual('foo', http_proxy)


def get_http_proxy():
    service = env.DBusService(dbus.SessionBus, None,
            '/org/freedesktop/DBus/Bus')
    bus = dbus.SessionBus()
    sender = bus.get_unique_name()
    return service.get_http_proxy(sender)


if __name__ == '__main__':
    if sys.argv[-1] == 'get_http_proxy':
        print get_http_proxy() or ''
    else:
        tests.main()
