#!/usr/bin/env python

# sugar-lint: disable

import os
import sys
import pwd
from ConfigParser import ConfigParser
from os.path import exists, relpath, abspath, isfile, isdir

from __init__ import tests

from sugar_client import env


class EnvTest(tests.Test):

    def setUp(self):
        tests.Test.setUp(self)

        self.chowned = []
        self.override(os, 'chown', lambda *args: self.chowned.append(args))

    def test_profile_path_NonRootUser(self):
        env.profile_path('foo', 'bar')
        assert isdir('sugar/foo')
        assert not exists('sugar/foo/bar')

    def test_ConvertApiUrl(self):
        env.api_url.value = 'localhost'
        self.assertEqual('http://localhost', env.api_url.value)

        env.api_url.value = 'localhost:8080'
        self.assertEqual('http://localhost:8080', env.api_url.value)

        env.api_url.value = 'https://localhost:80'
        self.assertEqual('https://localhost:80', env.api_url.value)

        env.api_url.value = 'https://localhost:80/foo/bar'
        self.assertEqual('https://localhost:80', env.api_url.value)

        env.api_url.value = 'localhost/foo/bar'
        self.assertEqual('http://localhost', env.api_url.value)

        env.api_url.value = 'localhost:8080/foo/bar'
        self.assertEqual('http://localhost:8080', env.api_url.value)

    def test_update_session_NewSections(self):
        session = env.session()
        assert ('foo', 'bar') not in session
        self.assertEqual(False, session.get('foo', 'bar', default=False))
        session['foo', 'bar'] = 'probe'
        self.assertEqual('probe', session['foo', 'bar'])
        env.update_session()

        env._session = None
        session = env.session()
        assert ('foo', 'bar') in session
        self.assertEqual('probe', session.get('foo', 'bar', default=False))
        self.assertEqual('probe', session['foo', 'bar'])

    def test_update_session_UpdateEnvVars(self):
        session = env.session()
        session['api-url'] = 'http://api_url'
        session['uid'] = 'uid'
        session['jabber-url'] = 'jabber_url'
        session['backup-url'] = 'backup_url'
        env.update_session()

        self.assertEqual('http://api_url', env.api_url.value)
        self.assertEqual('uid', env.uid.value)
        self.assertEqual('jabber_url', env.jabber_url.value)
        self.assertEqual('backup_url', env.backup_url.value)

        config = ConfigParser()
        config.read('sugar/sugar-client.conf')
        self.assertEqual('http://api_url', config.get('main', 'api-url'))
        self.assertEqual('uid', config.get('main', 'uid'))
        self.assertEqual('jabber_url', config.get('main', 'jabber-url'))
        self.assertEqual('backup_url', config.get('main', 'backup-url'))

        session['uid'] = 'test'
        env.update_session()

        self.assertEqual('http://api_url', env.api_url.value)
        self.assertEqual('test', env.uid.value)
        self.assertEqual('jabber_url', env.jabber_url.value)
        self.assertEqual('backup_url', env.backup_url.value)

        config = ConfigParser()
        config.read('sugar/sugar-client.conf')
        self.assertEqual('http://api_url', config.get('main', 'api-url'))
        self.assertEqual('test', config.get('main', 'uid'))
        self.assertEqual('jabber_url', config.get('main', 'jabber-url'))
        self.assertEqual('backup_url', config.get('main', 'backup-url'))


if __name__ == '__main__':
    tests.main()
