#!/usr/bin/env python

import logging
import gobject
import dbus.mainloop.glib

import sugar_stats
from sugar_stats.rrd import Rrd


logging.basicConfig(level=logging.DEBUG)

gobject.threads_init()
dbus.mainloop.glib.DBusGMainLoop(set_as_default=True)

backend = Rrd('tmp', 3, ['RRA:AVERAGE:0.5:1:360'])
sugar_stats.start(backend)

mainloop = gobject.MainLoop()
try:
    mainloop.run()
except KeyboardInterrupt:
    pass
finally:
    sugar_stats.stop()
