# Copyright (C) 2012, Aleksey Lim
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from sugar_stats import dbus_monitor
from sugar_stats.sniffer import Sniffer


class Shell(Sniffer):

    _bus = dbus_monitor.session()
    _journal = None

    def start(self):
        self._bus.connect_to_name(
                bus_name='org.laptop.Journal', path='/org/laptop/Journal',
                callback=self.__journal_name_cb)
        self._bus.connect(type='method_call',
                interface='org.laptop.sugar.DataStore',
                path='/org/laptop/sugar/DataStore',
                callback=self.__journal_method_cb)

    def stop(self):
        self._bus.disconnect_by_func(self.__journal_name_cb)
        self._bus.disconnect_by_func(self.__journal_method_cb)
        self._journal = None

    def __journal_name_cb(self, obj):
        if obj is None:
            self._journal = None
        else:
            self._journal = obj.bus_name

    def __journal_method_cb(self, msg):
        if not self._journal or msg.get_sender() != self._journal:
            return
        if msg.get_member() == 'create':
            self.stats.update('journal.creates', 1)
        elif msg.get_member() == 'update':
            self.stats.update('journal.updates', 1)
        elif msg.get_member() == 'delete':
            self.stats.update('journal.deletes', 1)
