# Copyright (C) 2012, Aleksey Lim
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import os

from sugar_stats.sniffer import Sniffer


class System(Sniffer):

    def start(self):
        self.stats.update('system.uptime', True)

    def trigger(self):
        self._diskfree()

    def _diskfree(self):
        stat = os.statvfs(os.environ['HOME'])
        df = stat.f_bfree * stat.f_frsize / 1024
        self.stats.update('system.diskfree', df)
