#!/usr/bin/env python

import sys
from os.path import abspath, join, dirname

import gtk
import dbus.mainloop.glib

import __init__
import env
from libjournal import dataview, datasource, datawidgets


class View(dataview.DataView):

    def __init__(self):
        dataview.DataView.__init__(self)

        self.props.frame_width = 1
        self.props.cell_height = env.metrics_get(env.GRID_CELL_SIZE)

    def do_new_data_cell(self):
        box = gtk.HBox()
        box.props.spacing = env.metrics_get(env.DEFAULT_SPACING)

        keep = datawidgets.KeepButton()
        keep.set_size_request(env.metrics_get(env.GRID_CELL_SIZE), -1)
        box.pack_start(keep, False)

        icon = datawidgets.ActivityIcon()
        icon_box = gtk.EventBox()
        icon_box.props.visible_window = False
        icon_box.add(icon)
        box.pack_start(icon_box, False)

        name = datawidgets.Label(
                data_field='name',
                xalign=0.0)
        name.set_size_request(env.metrics_get(env.GRID_CELL_SIZE) * 4, -1)
        box.pack_start(name, False)

        summary =datawidgets.Label(
                data_field='summary',
                xalign=0.0)
        box.pack_start(summary)

        box.show_all()
        return box


dbus.mainloop.glib.DBusGMainLoop(set_as_default=True)

ds = datasource.DBusDataSource(
        'org.sugarlabs.sweets.Index', '/org/sugarlabs/sweets/Index',
        'org.sugarlabs.sweets.Index')
ds.group = 'sweet'
ds.mountpoint = '~'

window = gtk.Window()
window.connect('destroy', lambda sender: gtk.main_quit())

view = View()
view.datasource = ds

scrolled = gtk.ScrolledWindow()
scrolled.set_policy(gtk.POLICY_NEVER, gtk.POLICY_ALWAYS)
scrolled.add(view)
window.add(scrolled)

window.show_all()
gtk.main()
