/* module.c
 *
 * Copyright (C) 2010, Aleksey Lim
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <pygobject.h>

void collab_register_classes (PyObject *dict);
void collab_register_constants (PyObject *module);
extern PyMethodDef collab_functions[];

DL_EXPORT (void)
init_collab (void)
{
    PyObject *module, *dict;

    init_pygobject ();

    module = Py_InitModule ("_collab", collab_functions);
    dict = PyModule_GetDict (module);
    collab_register_classes (dict);
    collab_register_constants(module);

    if (PyErr_Occurred ()) {
        PyErr_Print ();
        Py_FatalError ("can't initialise module collab");
    }
}
