include (ParseArguments)

##
# Add python binding target for component library
# Makes regular routines like add_library() and install().
#
# add_python_binding (
#   [CODEGEN_ARGS <args-to-pass-to-codegen.py>]
#   [REQUIRES_COMPONENTS <polyol-components>]
#   [DEFS_PATCHES <shell-code-to-patch-generated-defs-files>])
#
# In VALA_PATCHES, use "::" insead of ";".
#
macro (add_python_binding)
    parse_arguments (ARG "COMPONENT;REQUIRES_COMPONENTS;DEFINITIONS;LIBRARIES;CODEGEN_ARGS;DEFS_PATCHES" "" ${ARGN})

    component_vars (${ARG_COMPONENT})

    set (_component_root ${GEN_DIR}/src/${ARG_COMPONENT})
    set (_component_h ${_component_root}/${ARG_COMPONENT}.h)
    set (_lib "_${ARG_COMPONENT}")

    set (_defs "${CURRENT_GEN_DIR}/${ARG_COMPONENT}.defs")
    set (_c "${CURRENT_GEN_DIR}/${ARG_COMPONENT}.c")

    if (PYTHON_H2DEF_FOUND AND MAINTAINER_MODE)
        if (ARG_DEFS_PATCHES)
            set (_patches "")
            foreach (_patch ${ARG_DEFS_PATCHES})
                string (REPLACE "::" ";" _patch "${_patch}")
                set (_patches "${_patches} ${_patch}")
            endforeach ()
        else ()
            set (_patches "true")
        endif ()

        add_custom_command (
            OUTPUT
                ${_defs}
            COMMAND
                sh -c "${PYTHON_H2DEF} -m sugar -n Sugar ${_component_h} > ${_defs}~ && ( mv ${_defs}~ ${_defs} ) || ( rm -f ${_defs}~; false )"
            COMMAND
                sh -c "${_patches}"
            COMMAND
            cat ${CMAKE_CURRENT_SOURCE_DIR}/${ARG_COMPONENT}_override.defs >> ${_defs}
            DEPENDS
                ${CMAKE_CURRENT_SOURCE_DIR}/${ARG_COMPONENT}_override.defs
                ${_component_h}
            VERBATIM)
    elseif (NOT EXISTS ${_defs})
        message (FATAL_ERROR "h2def was not found or "
            "MAINTAINER_MODE is FALSE, thus there is no way to "
            "generate ${_defs}")
    endif ()

    if (PYTHON_CODEGEN_FOUND AND MAINTAINER_MODE)
        set (_args "")
        set (_deps "")

        foreach (_component ${ARG_REQUIRES_COMPONENTS})
            set (_args "${_args} --register ${CMAKE_CURRENT_BINARY_DIR}/${_component}.defs")
            list (APPEND _deps "${GEN_DIR}/bindings/python/_${_component}")
        endforeach ()

        foreach (_arg ${ARG_CODEGEN_ARGS})
            set (_args "${_args} ${_arg}")
        endforeach ()

        add_custom_command (
            OUTPUT
                ${_c}
            COMMAND
            sh -c "${PYTHON_CODEGEN} ${_args} --override ${CMAKE_CURRENT_SOURCE_DIR}/${ARG_COMPONENT}.override --prefix ${ARG_COMPONENT} ${_defs} > ${_c}~ && ( mv ${_c}~ ${_c} ) || ( rm -f ${_c}~; false )"
            COMMAND
                sh -c "echo 'void ${ARG_COMPONENT}_register_constants (PyObject *module) {'" >> ${_c}
            COMMAND
            sh -c "for i in $(grep '^#define SUGAR_[^ ]* *[0-9]*$' ${_component_h} | awk '{print $2}' | sed 's/^SUGAR_//'); do echo \"REGISTER_CONSTANT($i);\"; done" >> ${_c}
            COMMAND
                sh -c "echo '}'" >> ${_c}
            DEPENDS
                ${CMAKE_CURRENT_SOURCE_DIR}/${ARG_COMPONENT}.override
                ${_defs}
                ${_deps}
            VERBATIM)
    elseif (NOT EXISTS ${_c})
        message (FATAL_ERROR "codegen.py was not found or "
            "MAINTAINER_MODE is FALSE, thus there is no way to "
            "generate ${_c}")
    endif ()

    add_library (${_lib} MODULE
        ${_c} ${CMAKE_CURRENT_SOURCE_DIR}/${ARG_COMPONENT}_module.c)
    add_definitions (
        ${ARG_DEFINITIONS}
        ${PYTHON_CFLAGS}
        -I${_component_root})
    target_link_libraries (${_lib}
        ${ARG_LIBRARIES}
        ${PYTHON_LIBRARIES}
        ${CMAKE_PROJECT_NAME}-${ARG_COMPONENT})
    set_target_properties (${_lib}
        PROPERTIES PREFIX "")

    foreach (_component ${ARG_REQUIRES_COMPONENTS})
        add_definitions (
            -I${GEN_DIR}/src/${_component})
        target_link_libraries (${_lib}
            ${CMAKE_PROJECT_NAME}-${_component})
    endforeach ()

    install (TARGETS ${_lib}
        DESTINATION ${PYTHON_SITEDIR}/polyol)
    install (FILES ${CMAKE_CURRENT_SOURCE_DIR}/${ARG_COMPONENT}.py
        DESTINATION ${PYTHON_SITEDIR}/polyol)
    install (FILES ${_defs}
        DESTINATION share/${CMAKE_PROJECT_NAME}/defs)
endmacro ()
