#!/usr/bin/env python

import __init__
import gtk
import gui

def bin_new(border, inscribe):
    bin = gui.Bin()

    bin.props.border_left = border / 4
    bin.props.border_top = border / 3
    bin.props.border_right = border / 2
    bin.props.border_bottom = border

    button = gtk.Button()
    def cb(sender):
        bin.props.border = border * 2
    button.connect('clicked', cb)
    bin.add(button)

    return bin

def box_new(padding):
    box = gtk.HBox()
    box.add(bin_new(padding, False))
    box.add(bin_new(padding, True))
    return box

window = gtk.Window()
window.connect('destroy', lambda sender: gtk.main_quit())

box = gtk.VBox()
window.add(box)

box.add(box_new(10))
box.add(box_new(20))
box.add(box_new(30))

window.show_all()
gtk.main()
