/* module.c
 *
 * Copyright (C) 2010, Aleksey Lim
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <pygobject.h>

#include <pycairo.h>
Pycairo_CAPI_t *Pycairo_CAPI;

void gui_register_classes (PyObject *dict);
void gui_add_constants(PyObject *module, const gchar *strip_prefix);
void gui_register_constants (PyObject *module);
extern PyMethodDef gui_functions[];

DL_EXPORT (void)
init_gui (void)
{
    PyObject *module, *dict;

    init_pygobject ();
    Pycairo_IMPORT;

    module = Py_InitModule ("_gui", gui_functions);
    dict = PyModule_GetDict (module);
    gui_register_classes (dict);
    gui_register_constants (module);
    gui_add_constants(module, "SUGAR_");

    if (PyErr_Occurred ()) {
        PyErr_Print ();
        Py_FatalError ("can't initialise module gui");
    }
}
