#!/usr/bin/env python

import __init__
import gtk
import gui

class HintPalette(gui.Palette):

    def __init__(self):
        gui.Palette.__init__(self)
        self.props.primary_text = 'primary_text'

class MenuPalette(gui.Palette):

    def __init__(self, connector):
        gui.Palette.__init__(self)
        self.props.primary_text = 'primary_text primary_text primary_text'
        self.props.secondary_text = 'secondary_text'

        self.props.secondary = gui.EmbeddedMenu(connector)

        item = gtk.MenuItem(label='1');
        item.show()
        self.props.secondary.insert(item, 0)

        submenu = gui.EmbeddedSubMenu(connector)
        item = gtk.MenuItem(label='4');
        item.show()
        submenu.insert(item, 0)

        item = gtk.MenuItem(label='2');
        item.props.submenu = submenu
        item.show()
        self.props.secondary.insert(item, 0)

        item = gtk.MenuItem(label='3');
        item.show()
        self.props.secondary.insert(item, 0)

class ContentPalette(gui.Palette):

    def __init__(self):
        gui.Palette.__init__(self)
        self.props.primary_text = 'primary_text'
        self.props.secondary_text = 'secondary_text'

        button = gtk.Button('!!!')
        button.show()
        self.props.secondary = button

class MenuContentPalette(gui.Palette):

    def __init__(self, connector):
        gui.Palette.__init__(self)
        self.props.primary_text = 'primary_text primary_text primary_text'
        self.props.secondary_text = 'secondary_text'

        menu = gui.EmbeddedMenu(connector)

        item = gtk.MenuItem(label='1');
        item.show()
        menu.insert(item, 0)

        submenu = gui.EmbeddedSubMenu (connector)
        item = gtk.MenuItem(label='4');
        item.show()
        submenu.insert(item, 0)

        item = gtk.MenuItem(label='2');
        item.props.submenu = submenu
        item.show()
        menu.insert(item, 0)

        item = gtk.MenuItem(label='3');
        item.show()
        menu.insert(item, 0)

        box = gtk.VBox()
        box.pack_start(menu)
        box.pack_start(gtk.SeparatorMenuItem())
        box.pack_start(gtk.Button('!!!'))

        box.show_all()
        self.props.secondary = box

def toolbar_new(horizontal = True):
    tool_bar = gtk.Toolbar()

    if not horizontal:
        tool_bar.props.orientation = gtk.ORIENTATION_VERTICAL

    button = gui.ToolButton()
    button.props.icon_name = 'go-left'
    button.props.tooltip = 'tooltip';
    button.props.accelerator = '<Ctrl>1';
    def cb(sender):
        print sender, sender.props.accelerator
        if sender.props.accelerator == '<Ctrl>1':
            sender.props.accelerator = '<Ctrl>2'
        else:
            sender.props.accelerator = '<Ctrl>1'
    button.connect('clicked', cb)
    tool_bar.insert (button, -1);

    button = gui.ToggleToolButton()
    button.props.icon_name = 'go-right'
    button.props.invoker.props.palette = \
            MenuPalette(button.props.invoker.props.connector)
    tool_bar.insert (button, -1);

    button = gtk.SeparatorToolItem()
    button.set_expand(True)
    tool_bar.insert (button, -1);

    button = gui.RadioToolButton()
    button.props.icon_name = 'go-up'
    button.props.invoker.props.palette = ContentPalette()
    tool_bar.insert (button, -1);

    button2 = gui.RadioToolButton()
    button2.props.icon_name = 'go-down'
    button2.props.group = button
    button2.props.invoker.props.palette = \
            MenuContentPalette(button.props.invoker.props.connector)
    tool_bar.insert (button2, -1);

    return tool_bar

window = gui.Window()
window.connect('destroy', lambda sender: gtk.main_quit())

vbox = gtk.VBox()
window.add(vbox)

vbox.pack_start(toolbar_new(), False)
vbox.pack_end(toolbar_new(), False)

hbox = gtk.HBox()
vbox.pack_start(hbox)

hbox.pack_start(toolbar_new(False), False)
hbox.pack_end(toolbar_new(False), False)

window.show_all()
gtk.main()
