/* misc.c generated by valac 0.12.1, the Vala compiler
 * generated from misc.vala, do not modify */

/* misc.vala
 *
 * Copyright (C) 2010, Aleksey Lim
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include "polyol/env.h"
#include <gee.h>
#include <gobject/gvaluecollector.h>


#define SUGAR_LRU_TYPE__NODE (sugar_lru__node_get_type ())
#define SUGAR_LRU__NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SUGAR_LRU_TYPE__NODE, SugarLRU_Node))
#define SUGAR_LRU__NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SUGAR_LRU_TYPE__NODE, SugarLRU_NodeClass))
#define SUGAR_LRU_IS__NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SUGAR_LRU_TYPE__NODE))
#define SUGAR_LRU_IS__NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SUGAR_LRU_TYPE__NODE))
#define SUGAR_LRU__NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SUGAR_LRU_TYPE__NODE, SugarLRU_NodeClass))

typedef struct _SugarLRU_Node SugarLRU_Node;
typedef struct _SugarLRU_NodeClass SugarLRU_NodeClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _sugar_lru__node_unref0(var) ((var == NULL) ? NULL : (var = (sugar_lru__node_unref (var), NULL)))
typedef struct _SugarLRU_NodePrivate SugarLRU_NodePrivate;
typedef struct _SugarLRUParamSpec_Node SugarLRUParamSpec_Node;
typedef struct _SugarParamSpecLRU SugarParamSpecLRU;

struct _SugarLRUPrivate {
	GType k_type;
	GBoxedCopyFunc k_dup_func;
	GDestroyNotify k_destroy_func;
	GType v_type;
	GBoxedCopyFunc v_dup_func;
	GDestroyNotify v_destroy_func;
	gint _capacity;
	GeeHashMap* _queue;
	SugarLRU_Node* _first;
	SugarLRU_Node* _last;
};

struct _SugarLRU_Node {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SugarLRU_NodePrivate * priv;
	SugarLRU_Node* prev;
	SugarLRU_Node* next;
	gpointer key;
	gpointer value;
};

struct _SugarLRU_NodeClass {
	GTypeClass parent_class;
	void (*finalize) (SugarLRU_Node *self);
};

struct _SugarLRU_NodePrivate {
	GType k_type;
	GBoxedCopyFunc k_dup_func;
	GDestroyNotify k_destroy_func;
	GType v_type;
	GBoxedCopyFunc v_dup_func;
	GDestroyNotify v_destroy_func;
};

struct _SugarLRUParamSpec_Node {
	GParamSpec parent_instance;
};

struct _SugarParamSpecLRU {
	GParamSpec parent_instance;
};


static gpointer sugar_lru_parent_class = NULL;
static gpointer sugar_lru__node_parent_class = NULL;

static gpointer sugar_lru__node_ref (gpointer instance);
static void sugar_lru__node_unref (gpointer instance);
static GParamSpec* sugar_lru_param_spec__node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void sugar_lru_value_set__node (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void sugar_lru_value_take__node (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer sugar_lru_value_get__node (const GValue* value) G_GNUC_UNUSED;
static GType sugar_lru__node_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define SUGAR_LRU_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SUGAR_TYPE_LRU, SugarLRUPrivate))
enum  {
	SUGAR_LRU_DUMMY_PROPERTY
};
static void sugar_lru_set_capacity (SugarLRU* self, gint value);
static void _sugar_lru_actualize_node (SugarLRU* self, SugarLRU_Node* node);
static SugarLRU_Node* sugar_lru__node_new (GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func);
static SugarLRU_Node* sugar_lru__node_construct (GType object_type, GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func);
static void _sugar_lru_remove_node (SugarLRU* self, SugarLRU_Node* node);
#define SUGAR_LRU__NODE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SUGAR_LRU_TYPE__NODE, SugarLRU_NodePrivate))
enum  {
	SUGAR_LRU__NODE_DUMMY_PROPERTY
};
static void sugar_lru__node_finalize (SugarLRU_Node* obj);
static void sugar_lru_finalize (SugarLRU* obj);


/**
 * State of activity sharing
 */
GType sugar_share_scope_get_type (void) {
	static volatile gsize sugar_share_scope_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_share_scope_type_id__volatile)) {
		static const GEnumValue values[] = {{SUGAR_SHARE_SCOPE_PRIVATE, "SUGAR_SHARE_SCOPE_PRIVATE", "private"}, {SUGAR_SHARE_SCOPE_INVITE_ONLY, "SUGAR_SHARE_SCOPE_INVITE_ONLY", "invite-only"}, {SUGAR_SHARE_SCOPE_PUBLIC, "SUGAR_SHARE_SCOPE_PUBLIC", "public"}, {SUGAR_SHARE_SCOPE_LAST, "SUGAR_SHARE_SCOPE_LAST", "last"}, {0, NULL, NULL}};
		GType sugar_share_scope_type_id;
		sugar_share_scope_type_id = g_enum_register_static ("SugarShareScope", values);
		g_once_init_leave (&sugar_share_scope_type_id__volatile, sugar_share_scope_type_id);
	}
	return sugar_share_scope_type_id__volatile;
}


SugarLRU* sugar_lru_construct (GType object_type, GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, gint capacity, GHashFunc key_hash_func, GEqualFunc key_equal_func) {
	SugarLRU* self = NULL;
	GeeHashMap* _tmp0_ = NULL;
	gint _tmp1_;
	self = (SugarLRU*) g_type_create_instance (object_type);
	self->priv->k_type = k_type;
	self->priv->k_dup_func = k_dup_func;
	self->priv->k_destroy_func = k_destroy_func;
	self->priv->v_type = v_type;
	self->priv->v_dup_func = v_dup_func;
	self->priv->v_destroy_func = v_destroy_func;
	_tmp0_ = gee_hash_map_new (k_type, (GBoxedCopyFunc) k_dup_func, k_destroy_func, SUGAR_LRU_TYPE__NODE, (GBoxedCopyFunc) sugar_lru__node_ref, sugar_lru__node_unref, key_hash_func, key_equal_func, NULL);
	_g_object_unref0 (self->priv->_queue);
	self->priv->_queue = _tmp0_;
	_tmp1_ = MAX (1, capacity);
	sugar_lru_set_capacity (self, _tmp1_);
	return self;
}


SugarLRU* sugar_lru_new (GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, gint capacity, GHashFunc key_hash_func, GEqualFunc key_equal_func) {
	return sugar_lru_construct (SUGAR_TYPE_LRU, k_type, k_dup_func, k_destroy_func, v_type, v_dup_func, v_destroy_func, capacity, key_hash_func, key_equal_func);
}


gboolean sugar_lru_has_key (SugarLRU* self, gconstpointer key) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->_queue, key);
	result = _tmp0_;
	return result;
}


gpointer sugar_lru_get (SugarLRU* self, gconstpointer key) {
	gpointer result = NULL;
	gpointer _tmp0_ = NULL;
	SugarLRU_Node* node;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->_queue, key);
	node = (SugarLRU_Node*) _tmp0_;
	if (node == NULL) {
		result = NULL;
		_sugar_lru__node_unref0 (node);
		return result;
	} else {
		gpointer _tmp1_;
		gconstpointer _tmp2_;
		_sugar_lru_actualize_node (self, node);
		_tmp1_ = (_tmp2_ = node->value, ((_tmp2_ == NULL) || (self->priv->v_dup_func == NULL)) ? ((gpointer) _tmp2_) : self->priv->v_dup_func ((gpointer) _tmp2_));
		result = _tmp1_;
		_sugar_lru__node_unref0 (node);
		return result;
	}
	_sugar_lru__node_unref0 (node);
}


void sugar_lru_set (SugarLRU* self, gconstpointer key, gconstpointer value) {
	SugarLRU_Node* _tmp0_ = NULL;
	SugarLRU_Node* node;
	gpointer _tmp1_;
	gconstpointer _tmp2_;
	gpointer _tmp3_;
	gconstpointer _tmp4_;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	sugar_lru_remove (self, key);
	_tmp0_ = sugar_lru__node_new (self->priv->k_type, (GBoxedCopyFunc) self->priv->k_dup_func, self->priv->k_destroy_func, self->priv->v_type, (GBoxedCopyFunc) self->priv->v_dup_func, self->priv->v_destroy_func);
	node = _tmp0_;
	_tmp1_ = (_tmp2_ = key, ((_tmp2_ == NULL) || (self->priv->k_dup_func == NULL)) ? ((gpointer) _tmp2_) : self->priv->k_dup_func ((gpointer) _tmp2_));
	((node->key == NULL) || (self->priv->k_destroy_func == NULL)) ? NULL : (node->key = (self->priv->k_destroy_func (node->key), NULL));
	node->key = _tmp1_;
	_tmp3_ = (_tmp4_ = value, ((_tmp4_ == NULL) || (self->priv->v_dup_func == NULL)) ? ((gpointer) _tmp4_) : self->priv->v_dup_func ((gpointer) _tmp4_));
	((node->value == NULL) || (self->priv->v_destroy_func == NULL)) ? NULL : (node->value = (self->priv->v_destroy_func (node->value), NULL));
	node->value = _tmp3_;
	_sugar_lru_actualize_node (self, node);
	gee_abstract_map_set ((GeeAbstractMap*) self->priv->_queue, key, node);
	_tmp5_ = gee_map_get_size ((GeeMap*) self->priv->_queue);
	if (_tmp5_ > self->priv->_capacity) {
		_sugar_lru_remove_node (self, self->priv->_first);
	}
	_sugar_lru__node_unref0 (node);
}


void sugar_lru_remove (SugarLRU* self, gconstpointer key) {
	gpointer _tmp0_ = NULL;
	SugarLRU_Node* node;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->_queue, key);
	node = (SugarLRU_Node*) _tmp0_;
	if (node == NULL) {
		_sugar_lru__node_unref0 (node);
		return;
	}
	_sugar_lru_remove_node (self, node);
	_sugar_lru__node_unref0 (node);
}


static gpointer _sugar_lru__node_ref0 (gpointer self) {
	return self ? sugar_lru__node_ref (self) : NULL;
}


static void _sugar_lru_actualize_node (SugarLRU* self, SugarLRU_Node* node) {
	SugarLRU_Node* _tmp2_;
	SugarLRU_Node* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	if (self->priv->_first == NULL) {
		SugarLRU_Node* _tmp0_;
		_tmp0_ = _sugar_lru__node_ref0 (node);
		_sugar_lru__node_unref0 (self->priv->_first);
		self->priv->_first = _tmp0_;
	}
	if (self->priv->_last != NULL) {
		SugarLRU_Node* _tmp1_;
		_tmp1_ = _sugar_lru__node_ref0 (node);
		_sugar_lru__node_unref0 (self->priv->_last->next);
		self->priv->_last->next = _tmp1_;
	}
	_tmp2_ = _sugar_lru__node_ref0 (self->priv->_last);
	_sugar_lru__node_unref0 (node->prev);
	node->prev = _tmp2_;
	_sugar_lru__node_unref0 (node->next);
	node->next = NULL;
	_tmp3_ = _sugar_lru__node_ref0 (node);
	_sugar_lru__node_unref0 (self->priv->_last);
	self->priv->_last = _tmp3_;
}


static void _sugar_lru_remove_node (SugarLRU* self, SugarLRU_Node* node) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	if (node->prev != NULL) {
		SugarLRU_Node* _tmp0_;
		_tmp0_ = _sugar_lru__node_ref0 (node->next);
		_sugar_lru__node_unref0 (node->prev->next);
		node->prev->next = _tmp0_;
	} else {
		SugarLRU_Node* _tmp1_;
		_tmp1_ = _sugar_lru__node_ref0 (node->next);
		_sugar_lru__node_unref0 (self->priv->_first);
		self->priv->_first = _tmp1_;
	}
	if (node->next != NULL) {
		SugarLRU_Node* _tmp2_;
		_tmp2_ = _sugar_lru__node_ref0 (node->prev);
		_sugar_lru__node_unref0 (node->next->prev);
		node->next->prev = _tmp2_;
	} else {
		SugarLRU_Node* _tmp3_;
		_tmp3_ = _sugar_lru__node_ref0 (node->prev);
		_sugar_lru__node_unref0 (self->priv->_last);
		self->priv->_last = _tmp3_;
	}
	gee_abstract_map_unset ((GeeAbstractMap*) self->priv->_queue, node->key, NULL);
}


gint sugar_lru_get_capacity (SugarLRU* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_capacity;
	return result;
}


static void sugar_lru_set_capacity (SugarLRU* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_capacity = value;
}


static SugarLRU_Node* sugar_lru__node_construct (GType object_type, GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func) {
	SugarLRU_Node* self = NULL;
	self = (SugarLRU_Node*) g_type_create_instance (object_type);
	self->priv->k_type = k_type;
	self->priv->k_dup_func = k_dup_func;
	self->priv->k_destroy_func = k_destroy_func;
	self->priv->v_type = v_type;
	self->priv->v_dup_func = v_dup_func;
	self->priv->v_destroy_func = v_destroy_func;
	return self;
}


static SugarLRU_Node* sugar_lru__node_new (GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func) {
	return sugar_lru__node_construct (SUGAR_LRU_TYPE__NODE, k_type, k_dup_func, k_destroy_func, v_type, v_dup_func, v_destroy_func);
}


static void sugar_lru_value__node_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void sugar_lru_value__node_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		sugar_lru__node_unref (value->data[0].v_pointer);
	}
}


static void sugar_lru_value__node_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = sugar_lru__node_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer sugar_lru_value__node_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* sugar_lru_value__node_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		SugarLRU_Node* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = sugar_lru__node_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* sugar_lru_value__node_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	SugarLRU_Node** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = sugar_lru__node_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec* sugar_lru_param_spec__node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	SugarLRUParamSpec_Node* spec;
	g_return_val_if_fail (g_type_is_a (object_type, SUGAR_LRU_TYPE__NODE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer sugar_lru_value_get__node (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SUGAR_LRU_TYPE__NODE), NULL);
	return value->data[0].v_pointer;
}


static void sugar_lru_value_set__node (GValue* value, gpointer v_object) {
	SugarLRU_Node* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SUGAR_LRU_TYPE__NODE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SUGAR_LRU_TYPE__NODE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		sugar_lru__node_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		sugar_lru__node_unref (old);
	}
}


static void sugar_lru_value_take__node (GValue* value, gpointer v_object) {
	SugarLRU_Node* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SUGAR_LRU_TYPE__NODE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SUGAR_LRU_TYPE__NODE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		sugar_lru__node_unref (old);
	}
}


static void sugar_lru__node_class_init (SugarLRU_NodeClass * klass) {
	sugar_lru__node_parent_class = g_type_class_peek_parent (klass);
	SUGAR_LRU__NODE_CLASS (klass)->finalize = sugar_lru__node_finalize;
	g_type_class_add_private (klass, sizeof (SugarLRU_NodePrivate));
}


static void sugar_lru__node_instance_init (SugarLRU_Node * self) {
	self->priv = SUGAR_LRU__NODE_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void sugar_lru__node_finalize (SugarLRU_Node* obj) {
	SugarLRU_Node * self;
	self = SUGAR_LRU__NODE (obj);
	_sugar_lru__node_unref0 (self->prev);
	_sugar_lru__node_unref0 (self->next);
	((self->key == NULL) || (self->priv->k_destroy_func == NULL)) ? NULL : (self->key = (self->priv->k_destroy_func (self->key), NULL));
	((self->value == NULL) || (self->priv->v_destroy_func == NULL)) ? NULL : (self->value = (self->priv->v_destroy_func (self->value), NULL));
}


static GType sugar_lru__node_get_type (void) {
	static volatile gsize sugar_lru__node_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_lru__node_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { sugar_lru_value__node_init, sugar_lru_value__node_free_value, sugar_lru_value__node_copy_value, sugar_lru_value__node_peek_pointer, "p", sugar_lru_value__node_collect_value, "p", sugar_lru_value__node_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (SugarLRU_NodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar_lru__node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SugarLRU_Node), 0, (GInstanceInitFunc) sugar_lru__node_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType sugar_lru__node_type_id;
		sugar_lru__node_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SugarLRU_Node", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&sugar_lru__node_type_id__volatile, sugar_lru__node_type_id);
	}
	return sugar_lru__node_type_id__volatile;
}


static gpointer sugar_lru__node_ref (gpointer instance) {
	SugarLRU_Node* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void sugar_lru__node_unref (gpointer instance) {
	SugarLRU_Node* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SUGAR_LRU__NODE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void sugar_value_lru_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void sugar_value_lru_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		sugar_lru_unref (value->data[0].v_pointer);
	}
}


static void sugar_value_lru_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = sugar_lru_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer sugar_value_lru_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* sugar_value_lru_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		SugarLRU* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = sugar_lru_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* sugar_value_lru_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	SugarLRU** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = sugar_lru_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* sugar_param_spec_lru (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	SugarParamSpecLRU* spec;
	g_return_val_if_fail (g_type_is_a (object_type, SUGAR_TYPE_LRU), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer sugar_value_get_lru (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SUGAR_TYPE_LRU), NULL);
	return value->data[0].v_pointer;
}


void sugar_value_set_lru (GValue* value, gpointer v_object) {
	SugarLRU* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SUGAR_TYPE_LRU));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SUGAR_TYPE_LRU));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		sugar_lru_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		sugar_lru_unref (old);
	}
}


void sugar_value_take_lru (GValue* value, gpointer v_object) {
	SugarLRU* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SUGAR_TYPE_LRU));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SUGAR_TYPE_LRU));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		sugar_lru_unref (old);
	}
}


static void sugar_lru_class_init (SugarLRUClass * klass) {
	sugar_lru_parent_class = g_type_class_peek_parent (klass);
	SUGAR_LRU_CLASS (klass)->finalize = sugar_lru_finalize;
	g_type_class_add_private (klass, sizeof (SugarLRUPrivate));
}


static void sugar_lru_instance_init (SugarLRU * self) {
	self->priv = SUGAR_LRU_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void sugar_lru_finalize (SugarLRU* obj) {
	SugarLRU * self;
	self = SUGAR_LRU (obj);
	_g_object_unref0 (self->priv->_queue);
	_sugar_lru__node_unref0 (self->priv->_first);
	_sugar_lru__node_unref0 (self->priv->_last);
}


/**
 * Least Recently Used queue
 *
 * Simple implementation of a length-limited O (1) LRU queue.
 * Adapted version from PyPE, http://pype.sourceforge.net.
 */
GType sugar_lru_get_type (void) {
	static volatile gsize sugar_lru_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_lru_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { sugar_value_lru_init, sugar_value_lru_free_value, sugar_value_lru_copy_value, sugar_value_lru_peek_pointer, "p", sugar_value_lru_collect_value, "p", sugar_value_lru_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (SugarLRUClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar_lru_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SugarLRU), 0, (GInstanceInitFunc) sugar_lru_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType sugar_lru_type_id;
		sugar_lru_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SugarLRU", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&sugar_lru_type_id__volatile, sugar_lru_type_id);
	}
	return sugar_lru_type_id__volatile;
}


gpointer sugar_lru_ref (gpointer instance) {
	SugarLRU* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void sugar_lru_unref (gpointer instance) {
	SugarLRU* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SUGAR_LRU_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



