/* polyol-env.vapi generated by valac 0.12.1, do not modify. */

[CCode (cprefix = "Sugar", lower_case_cprefix = "sugar_")]
namespace Sugar {
	[CCode (ref_function = "sugar_environ_ref", unref_function = "sugar_environ_unref", cheader_filename = "polyol/env.h")]
	public class Environ {
		public const int PREVIEW_HEIGHT;
		public const int PREVIEW_WIDTH;
		public const string ROOT_DIRECTORY;
		[CCode (cname = "sugar_init")]
		public static bool init (ref unowned string[] argv);
		public static void set_window (X.Display display, X.Window window);
		public static Sugar.ActivityInfo activity { get; }
		public static string activity_id { get; }
		public static string? activity_root { get; }
		public static string bundle_id { get; }
		public static bool initialized { get; }
		public static string object_id { get; }
		public static bool secure_mode { get; }
		public static bool sync_dbus { get; set; }
		public static X.ID window { get; }
	}
	[CCode (ref_function = "sugar_lru_ref", unref_function = "sugar_lru_unref", cheader_filename = "polyol/env.h")]
	public class LRU<K,V> {
		public LRU (int capacity, GLib.HashFunc? key_hash_func = null, GLib.EqualFunc? key_equal_func = null);
		public V @get (K key);
		public bool has_key (K key);
		public void remove (K key);
		public void @set (K key, V value);
		public int capacity { get; private set; }
	}
	[CCode (ref_function = "sugar_profile_ref", unref_function = "sugar_profile_unref", cheader_filename = "polyol/env.h")]
	public class Profile {
		public static Sugar.XoColor color { get; }
		public static string name { get; }
		public static string nickname { owned get; }
		public static string path { owned get; }
	}
	[CCode (type_id = "SUGAR_TYPE_ACTIVITY_INFO", cheader_filename = "polyol/env.h")]
	public struct ActivityInfo {
		public string bundle_id;
		public string icon;
		public string name;
		public static bool @get (string path, out Sugar.ActivityInfo result);
	}
	[CCode (type_id = "SUGAR_TYPE_COLOR", cheader_filename = "polyol/env.h")]
	public struct Color {
		public double alpha;
		public uint16 red;
		public uint16 green;
		public uint16 blue;
		public const int BLACK;
		public const int BUTTON_GREY;
		public const int HIGHLIGHT;
		public const int INACTIVE_FILL;
		public const int INACTIVE_STROKE;
		public const int LAST;
		public const int PANEL_GREY;
		public const int SELECTION_GREY;
		public const int TEXT_FIELD_GREY;
		public const int TOOLBAR_GREY;
		public const int TRANSPARENT;
		public const int WHITE;
		public static Sugar.Color? from_string (string color_string);
		public static Sugar.Color @get (int type);
		public string to_string ();
		public string html { owned get; }
		public uint32 integer { get; }
		public string svg { owned get; }
	}
	[CCode (type_id = "SUGAR_TYPE_FONT", cheader_filename = "polyol/env.h")]
	public struct Font {
		public string _format;
		public const int BOLD;
		public const int LAST;
		public const int NORMAL;
		public static Sugar.Font @get (int type);
		public string face { owned get; }
		public string name { owned get; }
		public double size { get; }
	}
	[CCode (type_id = "SUGAR_TYPE_METRICS", cheader_filename = "polyol/env.h")]
	public struct Metrics {
		public static double _zoom_factor;
		public bool scaled;
		public double value;
		[CCode (cname = "SUGAR_DEFAULT_PADDING")]
		public const int DEFAULT_PADDING;
		[CCode (cname = "SUGAR_DEFAULT_SPACING")]
		public const int DEFAULT_SPACING;
		[CCode (cname = "SUGAR_FOCUS_LINE_WIDTH")]
		public const int FOCUS_LINE_WIDTH;
		[CCode (cname = "SUGAR_FONT_BOLD_H")]
		public const int FONT_BOLD_H;
		[CCode (cname = "SUGAR_FONT_NORMAL_H")]
		public const int FONT_NORMAL_H;
		[CCode (cname = "SUGAR_GRID_CELL_SIZE")]
		public const int GRID_CELL_SIZE;
		[CCode (cname = "SUGAR_LARGE_ICON_SIZE")]
		public const int LARGE_ICON_SIZE;
		public const int LAST;
		[CCode (cname = "SUGAR_LINE_WIDTH")]
		public const int LINE_WIDTH;
		[CCode (cname = "SUGAR_MEDIUM_ICON_SIZE")]
		public const int MEDIUM_ICON_SIZE;
		[CCode (cname = "SUGAR_PALETTE_CURSOR_DISTANCE")]
		public const int PALETTE_CURSOR_DISTANCE;
		[CCode (cname = "SUGAR_SMALL_ICON_SIZE")]
		public const int SMALL_ICON_SIZE;
		[CCode (cname = "SUGAR_STANDARD_ICON_SIZE")]
		public const int STANDARD_ICON_SIZE;
		[CCode (cname = "SUGAR_TOOLBAR_ARROW_SIZE")]
		public const int TOOLBAR_ARROW_SIZE;
		[CCode (cname = "SUGAR_TOOLBOX_HORIZONTAL_PADDING")]
		public const int TOOLBOX_HORIZONTAL_PADDING;
		[CCode (cname = "SUGAR_TOOLBOX_SEPARATOR_HEIGHT")]
		public const int TOOLBOX_SEPARATOR_HEIGHT;
		[CCode (cname = "SUGAR_TOOLBOX_TAB_HBORDER")]
		public const int TOOLBOX_TAB_HBORDER;
		[CCode (cname = "SUGAR_TOOLBOX_TAB_LABEL_WIDTH")]
		public const int TOOLBOX_TAB_LABEL_WIDTH;
		[CCode (cname = "SUGAR_TOOLBOX_TAB_VBORDER")]
		public const int TOOLBOX_TAB_VBORDER;
		[CCode (cname = "SUGAR_XLARGE_ICON_SIZE")]
		public const int XLARGE_ICON_SIZE;
		[CCode (cname = "SUGAR_ZOOM_FACTOR")]
		public const int ZOOM_FACTOR;
		public static int @get (int type);
		public static int zoom (double units);
		public static double factor { get; }
	}
	[CCode (type_id = "SUGAR_TYPE_XO_COLOR", cheader_filename = "polyol/env.h")]
	public struct XoColor {
		public Sugar.Color stroke;
		public Sugar.Color fill;
		public static Sugar.XoColor? from_string (string color_string);
		public string to_string ();
	}
	[CCode (cprefix = "SUGAR_SHARE_SCOPE_", cheader_filename = "polyol/env.h")]
	public enum ShareScope {
		PRIVATE,
		INVITE_ONLY,
		PUBLIC,
		LAST
	}
	[CCode (cheader_filename = "polyol/env.h")]
	public const string MIME_AUDIO;
	[CCode (cheader_filename = "polyol/env.h")]
	public const string MIME_IMAGE;
	[CCode (cheader_filename = "polyol/env.h")]
	public const string MIME_LINK;
	[CCode (cheader_filename = "polyol/env.h")]
	public const string MIME_TEXT;
	[CCode (cheader_filename = "polyol/env.h")]
	public const string MIME_VIDEO;
}
