/* entry.vala
 *
 * Copyright (C) 2010, Aleksey Lim
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Port from original sugar-toolkit project.
 * File:   src/sugar/graphics/iconentry.py
 * Commit: c9e63eb8eadb0b133b88e9feb1ca48b75d959a7c
 *
 * Copyright (C) 2007, One Laptop Per Child
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

public class Sugar.Entry : Gtk.Entry {
    public string? primary_icon {
        get {
            return _primary_icon;
        }
        set {
            if (primary_icon == value)
                return;

            _primary_icon = value;

            if (_has_icons) {
                if (primary_icon != null)
                    primary_icon_pixbuf = _load_icon (primary_icon);
                else
                    primary_icon_pixbuf = null;
            }
        }
    }

    public string? secondary_icon {
        get {
            return _secondary_icon;
        }
        set {
            if (secondary_icon == value)
                return;

            _secondary_icon = value;

            if (_has_icons) {
                if (secondary_icon != null)
                    secondary_icon_pixbuf = _load_icon (secondary_icon);
                else
                    secondary_icon_pixbuf = null;
            }
        }
    }

    public bool has_clear_button {
        get {
            return _has_clear_button;
        }
        set {
            if (has_clear_button == value)
                return;

            if (_has_icons && has_clear_button) {
                icon_press.disconnect (_icon_press_cb);
                changed.disconnect (_changed_cb);
                secondary_icon = null;
            }

            _has_clear_button = value;

            if (_has_icons && has_clear_button) {
                icon_press.connect (_icon_press_cb);
                changed.connect (_changed_cb);
                if (text_length > 0)
                    secondary_icon = _CLEAR_ICON;
            }
        }
    }

    public override bool key_press_event (Gdk.EventKey event) {
        if (event.keyval == 0xff1b /*XK_Escape */ ) {
            text = "";
            return true;
        } else {
            return base.key_press_event (event);
        }
    }

    private bool _has_icons {
        get {
            return Gtk.MAJOR_VERSION > 2 ||
                    Gtk.MAJOR_VERSION == 2 && Gtk.MINOR_VERSION >= 16;
        }
    }

    private Gdk.Pixbuf _load_icon (string icon_name) {
        IconAttr attr = { };
        attr.icon_name = icon_name;
        attr.icon_size = Gtk.IconSize.SMALL_TOOLBAR;
        attr.fill_color = Color.get (Color.TOOLBAR_GREY);
        attr.stroke_color = Color.get (Color.TOOLBAR_GREY);
        return icon_get_pixbuf (attr);
    }

    private void _icon_press_cb (Gtk.EntryIconPosition pos, Gdk.Event event) {
        if (pos == Gtk.EntryIconPosition.SECONDARY) {
            text = "";
            secondary_icon = null;
        }
    }

    private void _changed_cb () {
        if (text_length > 0)
            secondary_icon = _CLEAR_ICON;
        else
            secondary_icon = null;
    }

    private const string _CLEAR_ICON = "dialog-cancel";

    private string _primary_icon;
    private string _secondary_icon;
    private bool _has_clear_button;
}
