/* homogenetable.c generated by valac 0.12.1, the Vala compiler
 * generated from homogenetable.vala, do not modify */

/* homogenetable.vala
 *
 * Copyright (C) 2010, Aleksey Lim
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include "polyol/gui.h"
#include <gee.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define SUGAR_HOMOGENE_TABLE_TYPE__CELLS (sugar_homogene_table__cells_get_type ())
#define SUGAR_HOMOGENE_TABLE__CELLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SUGAR_HOMOGENE_TABLE_TYPE__CELLS, SugarHomogeneTable_Cells))
#define SUGAR_HOMOGENE_TABLE__CELLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SUGAR_HOMOGENE_TABLE_TYPE__CELLS, SugarHomogeneTable_CellsClass))
#define SUGAR_HOMOGENE_TABLE_IS__CELLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SUGAR_HOMOGENE_TABLE_TYPE__CELLS))
#define SUGAR_HOMOGENE_TABLE_IS__CELLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SUGAR_HOMOGENE_TABLE_TYPE__CELLS))
#define SUGAR_HOMOGENE_TABLE__CELLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SUGAR_HOMOGENE_TABLE_TYPE__CELLS, SugarHomogeneTable_CellsClass))

typedef struct _SugarHomogeneTable_Cells SugarHomogeneTable_Cells;
typedef struct _SugarHomogeneTable_CellsClass SugarHomogeneTable_CellsClass;

#define SUGAR_HOMOGENE_TABLE_TYPE__ROWS (sugar_homogene_table__rows_get_type ())
#define SUGAR_HOMOGENE_TABLE__ROWS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SUGAR_HOMOGENE_TABLE_TYPE__ROWS, SugarHomogeneTable_Rows))
#define SUGAR_HOMOGENE_TABLE__ROWS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SUGAR_HOMOGENE_TABLE_TYPE__ROWS, SugarHomogeneTable_RowsClass))
#define SUGAR_HOMOGENE_TABLE_IS__ROWS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SUGAR_HOMOGENE_TABLE_TYPE__ROWS))
#define SUGAR_HOMOGENE_TABLE_IS__ROWS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SUGAR_HOMOGENE_TABLE_TYPE__ROWS))
#define SUGAR_HOMOGENE_TABLE__ROWS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SUGAR_HOMOGENE_TABLE_TYPE__ROWS, SugarHomogeneTable_RowsClass))

typedef struct _SugarHomogeneTable_Rows SugarHomogeneTable_Rows;
typedef struct _SugarHomogeneTable_RowsClass SugarHomogeneTable_RowsClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SUGAR_HOMOGENE_TABLE_TYPE__CELL (sugar_homogene_table__cell_get_type ())
#define SUGAR_HOMOGENE_TABLE__CELL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SUGAR_HOMOGENE_TABLE_TYPE__CELL, SugarHomogeneTable_Cell))
#define SUGAR_HOMOGENE_TABLE__CELL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SUGAR_HOMOGENE_TABLE_TYPE__CELL, SugarHomogeneTable_CellClass))
#define SUGAR_HOMOGENE_TABLE_IS__CELL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SUGAR_HOMOGENE_TABLE_TYPE__CELL))
#define SUGAR_HOMOGENE_TABLE_IS__CELL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SUGAR_HOMOGENE_TABLE_TYPE__CELL))
#define SUGAR_HOMOGENE_TABLE__CELL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SUGAR_HOMOGENE_TABLE_TYPE__CELL, SugarHomogeneTable_CellClass))

typedef struct _SugarHomogeneTable_Cell SugarHomogeneTable_Cell;
typedef struct _SugarHomogeneTable_CellClass SugarHomogeneTable_CellClass;
#define _sugar_homogene_table__cell_unref0(var) ((var == NULL) ? NULL : (var = (sugar_homogene_table__cell_unref (var), NULL)))
typedef struct _SugarHomogeneTable_CellPrivate SugarHomogeneTable_CellPrivate;
typedef struct _Block2Data Block2Data;
#define _g_array_free0(var) ((var == NULL) ? NULL : (var = (g_array_free (var, TRUE), NULL)))
typedef struct _Block3Data Block3Data;
typedef struct _SugarHomogeneTableParamSpec_Cell SugarHomogeneTableParamSpec_Cell;
typedef struct _SugarHomogeneTable_CellsPrivate SugarHomogeneTable_CellsPrivate;
typedef struct _SugarHomogeneTable_RowsPrivate SugarHomogeneTable_RowsPrivate;

struct _SugarHomogeneTablePrivate {
	SugarHomogeneTable_Cells* _cell_cache;
	SugarHomogeneTable_Rows* _row_cache;
	gint _cell_cache_pos;
	GtkAdjustment** _adjustments;
	gint _adjustments_length1;
	gint __adjustments_size_;
	GdkWindow* _bin_window;
	gint _cell_count;
	gint _cell_length;
	gint _frame_width;
	gint _frame_height;
	gint _cell_width;
	gint _cell_height;
	gint _cursor_index;
	gint _pending_allocate;
	SugarRange _frame_range;
	GtkOrientation _orientation;
	gboolean _hover_selection;
};

struct _SugarHomogeneTable_Cell {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SugarHomogeneTable_CellPrivate * priv;
	GtkWidget* widget;
	gint index;
};

struct _SugarHomogeneTable_CellClass {
	GTypeClass parent_class;
	void (*finalize) (SugarHomogeneTable_Cell *self);
};

struct _Block2Data {
	int _ref_count_;
	SugarHomogeneTable * self;
	GArray* spare_rows;
};

struct _Block3Data {
	int _ref_count_;
	Block2Data * _data2_;
	gint spare_rows_sp;
};

typedef void (*SugarHomogeneTable_InsertSpareRow) (gint pos_begin, gint pos_end, void* user_data);
struct _SugarHomogeneTableParamSpec_Cell {
	GParamSpec parent_instance;
};

struct _SugarHomogeneTable_Cells {
	GeeArrayList parent_instance;
	SugarHomogeneTable_CellsPrivate * priv;
};

struct _SugarHomogeneTable_CellsClass {
	GeeArrayListClass parent_class;
};

struct _SugarHomogeneTable_Rows {
	GeeArrayList parent_instance;
	SugarHomogeneTable_RowsPrivate * priv;
};

struct _SugarHomogeneTable_RowsClass {
	GeeArrayListClass parent_class;
};


static gpointer sugar_homogene_table_parent_class = NULL;
static gpointer sugar_homogene_table__cell_parent_class = NULL;
static gpointer sugar_homogene_table__cells_parent_class = NULL;
static gpointer sugar_homogene_table__rows_parent_class = NULL;

static GType sugar_homogene_table__cells_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType sugar_homogene_table__rows_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define SUGAR_HOMOGENE_TABLE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SUGAR_TYPE_HOMOGENE_TABLE, SugarHomogeneTablePrivate))
enum  {
	SUGAR_HOMOGENE_TABLE_DUMMY_PROPERTY,
	SUGAR_HOMOGENE_TABLE_CELL_COUNT,
	SUGAR_HOMOGENE_TABLE_FRAME_WIDTH,
	SUGAR_HOMOGENE_TABLE_FRAME_HEIGHT,
	SUGAR_HOMOGENE_TABLE_CELL_WIDTH,
	SUGAR_HOMOGENE_TABLE_CELL_HEIGHT,
	SUGAR_HOMOGENE_TABLE_ORIENTATION,
	SUGAR_HOMOGENE_TABLE_HOVER_SELECTION,
	SUGAR_HOMOGENE_TABLE_CURSOR,
	SUGAR_HOMOGENE_TABLE_FOCUS_CELL,
	SUGAR_HOMOGENE_TABLE_FRAME_RANGE,
	SUGAR_HOMOGENE_TABLE_FRAME_SIZE,
	SUGAR_HOMOGENE_TABLE_IS_EMPTY
};
static SugarHomogeneTable_Cells* sugar_homogene_table__cells_new (void);
static SugarHomogeneTable_Cells* sugar_homogene_table__cells_construct (GType object_type);
static SugarHomogeneTable_Rows* sugar_homogene_table__rows_new (void);
static SugarHomogeneTable_Rows* sugar_homogene_table__rows_construct (GType object_type);
#define SUGAR_HOMOGENE_TABLE__SPARE_ROWS_COUNT 2
static void sugar_homogene_table_real_dispose (GObject* base);
static void _sugar_homogene_table_abandon_cells (SugarHomogeneTable* self);
static GtkWidget* sugar_homogene_table_real_new_cell (SugarHomogeneTable* self);
static void sugar_homogene_table_real_fill_cell (SugarHomogeneTable* self, GtkWidget* cell, gint index);
static void sugar_homogene_table_real_highlight_cell (SugarHomogeneTable* self, GtkWidget* cell, gboolean selected);
static gpointer sugar_homogene_table__cell_ref (gpointer instance);
static void sugar_homogene_table__cell_unref (gpointer instance);
static GParamSpec* sugar_homogene_table_param_spec__cell (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void sugar_homogene_table_value_set__cell (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void sugar_homogene_table_value_take__cell (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer sugar_homogene_table_value_get__cell (const GValue* value) G_GNUC_UNUSED;
static GType sugar_homogene_table__cell_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static SugarHomogeneTable_Cell* _sugar_homogene_table_get_cell (SugarHomogeneTable* self, gint cell_index);
static gint _sugar_homogene_table_get_index_at_pos (SugarHomogeneTable* self, gint x, gint y);
static gint _sugar_homogene_table_rotate (SugarHomogeneTable* self, gint x, gint y);
static gint sugar_homogene_table_get__pos (SugarHomogeneTable* self);
static gint sugar_homogene_table_get__column_count (SugarHomogeneTable* self);
static void sugar_homogene_table_set__pos (SugarHomogeneTable* self, gint value);
static gint sugar_homogene_table_get__frame_length (SugarHomogeneTable* self);
static void _sugar_homogene_table_allocate_rows (SugarHomogeneTable* self, gboolean force);
static gboolean sugar_homogene_table_real_scroll_event (GtkWidget* base, GdkEventScroll* event);
static gint sugar_homogene_table_get__max_pos (SugarHomogeneTable* self);
static void sugar_homogene_table_real_realize (GtkWidget* base);
static gint sugar_homogene_table_get__thickness (SugarHomogeneTable* self);
static gint sugar_homogene_table_get__length (SugarHomogeneTable* self);
static void sugar_homogene_table_real_size_allocate (GtkWidget* base, GdkRectangle* allocation);
static void _sugar_homogene_table_reallocate_cells (SugarHomogeneTable* self);
static void _sugar_homogene_table_resize_table (SugarHomogeneTable* self);
static void sugar_homogene_table_real_unrealize (GtkWidget* base);
static void sugar_homogene_table_real_style_set (GtkWidget* base, GtkStyle* previous_style);
static gboolean sugar_homogene_table_real_expose_event (GtkWidget* base, GdkEventExpose* event);
static void sugar_homogene_table_real_map (GtkWidget* base);
static void sugar_homogene_table_real_size_request (GtkWidget* base, GtkRequisition* requisition);
static gboolean sugar_homogene_table_real_motion_notify_event (GtkWidget* base, GdkEventMotion* event);
static gboolean sugar_homogene_table_real_key_press_event (GtkWidget* base, GdkEventKey* event);
static void sugar_homogene_table_real_forall_internal (GtkContainer* base, gboolean include_internal, GtkCallback callback, void* callback_target);
static void sugar_homogene_table_real_add (GtkContainer* base, GtkWidget* widget);
static void sugar_homogene_table_real_remove (GtkContainer* base, GtkWidget* widget);
static void sugar_homogene_table_real_set_focus_child (GtkContainer* base, GtkWidget* widget);
static gboolean sugar_homogene_table_real_focus (GtkWidget* base, GtkDirectionType direction);
static void _sugar_homogene_table_set_metric (SugarHomogeneTable* self, gint* prop, gint* mutex_prop, gint value);
static gboolean sugar_homogene_table__cell_get_valid (SugarHomogeneTable_Cell* self);
static gint _sugar_homogene_table_get_row_pos (SugarHomogeneTable* self, SugarHomogeneTable_Cells* row);
static void _sugar_homogene_table_set_cursor (SugarHomogeneTable* self, gint cell_index);
static SugarHomogeneTable_Cell* _sugar_homogene_table_pop_a_cell (SugarHomogeneTable* self);
static SugarHomogeneTable_Cell* sugar_homogene_table__cell_new (void);
static SugarHomogeneTable_Cell* sugar_homogene_table__cell_construct (GType object_type);
static void sugar_homogene_table__cell_invalidate_pos (SugarHomogeneTable_Cell* self);
static void _sugar_homogene_table_setup_adjustment (SugarHomogeneTable* self, gboolean dry_run);
static gint sugar_homogene_table_get__frame_row_count (SugarHomogeneTable* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static gint _lambda1_ (gconstpointer a, gconstpointer b);
static gint __lambda1__gcompare_func (gconstpointer a, gconstpointer b);
static gint _lambda2_ (gconstpointer a, gconstpointer b);
static gint __lambda2__gcompare_func (gconstpointer a, gconstpointer b);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
static void _lambda3_ (gint pos_begin, gint pos_end, Block3Data* _data3_);
static void _sugar_homogene_table_allocate_cells (SugarHomogeneTable* self, SugarHomogeneTable_Cells* row, gint cell_y);
static void __lambda3__sugarhomogenetable_insertsparerow (gint pos_begin, gint pos_end, gpointer self);
static void _sugar_homogene_table_adjustment_value_changed_cb (SugarHomogeneTable* self);
static void sugar_homogene_table_real_signal_set_scroll_adjustments (SugarHomogeneTable* self, GtkAdjustment* hadjustment, GtkAdjustment* vadjustment);
static void __sugar_homogene_table_adjustment_value_changed_cb_gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static GObject * sugar_homogene_table_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
enum  {
	SUGAR_HOMOGENE_TABLE__CELL_DUMMY_PROPERTY
};
static void sugar_homogene_table__cell_finalize (SugarHomogeneTable_Cell* obj);
enum  {
	SUGAR_HOMOGENE_TABLE__CELLS_DUMMY_PROPERTY
};
enum  {
	SUGAR_HOMOGENE_TABLE__ROWS_DUMMY_PROPERTY
};
static void sugar_homogene_table_finalize (GObject* obj);
static void _vala_sugar_homogene_table_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sugar_homogene_table_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void sugar_homogene_table_real_dispose (GObject* base) {
	SugarHomogeneTable * self;
	self = (SugarHomogeneTable*) base;
	_sugar_homogene_table_abandon_cells (self);
	gee_abstract_collection_clear ((GeeAbstractCollection*) self->priv->_cell_cache);
	g_signal_emit_by_name (self, "signal-set-scroll-adjustments", NULL, NULL);
}


/**
     * Create new cell
     *
     * @return newly created cell widget
     */
static GtkWidget* sugar_homogene_table_real_new_cell (SugarHomogeneTable* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `sugar_homogene_table_new_cell'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


GtkWidget* sugar_homogene_table_new_cell (SugarHomogeneTable* self) {
	return SUGAR_HOMOGENE_TABLE_GET_CLASS (self)->new_cell (self);
}


/**
     * Fill cell content in
     *
     * @param cell  widget to fill in
     * @param index cell index to fill in
     */
static void sugar_homogene_table_real_fill_cell (SugarHomogeneTable* self, GtkWidget* cell, gint index) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `sugar_homogene_table_fill_cell'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void sugar_homogene_table_fill_cell (SugarHomogeneTable* self, GtkWidget* cell, gint index) {
	SUGAR_HOMOGENE_TABLE_GET_CLASS (self)->fill_cell (self, cell, index);
}


/**
     * Highlight cell
     *
     * Will be invoked if hover_selection is true
     *
     * @param cell      widget to highlight
     * @param selected  set/unset highlighting
     */
static void sugar_homogene_table_real_highlight_cell (SugarHomogeneTable* self, GtkWidget* cell, gboolean selected) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `sugar_homogene_table_highlight_cell'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void sugar_homogene_table_highlight_cell (SugarHomogeneTable* self, GtkWidget* cell, gboolean selected) {
	SUGAR_HOMOGENE_TABLE_GET_CLASS (self)->highlight_cell (self, cell, selected);
}


/**
     * Get cell widget by index
     *
     * @return widget for visible cell, null otherwise
     */
GtkWidget* sugar_homogene_table_get_cell (SugarHomogeneTable* self, gint cell_index) {
	GtkWidget* result = NULL;
	SugarHomogeneTable_Cell* _tmp0_ = NULL;
	SugarHomogeneTable_Cell* cell;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _sugar_homogene_table_get_cell (self, cell_index);
	cell = _tmp0_;
	if (cell == NULL) {
		result = NULL;
		_sugar_homogene_table__cell_unref0 (cell);
		return result;
	} else {
		result = cell->widget;
		_sugar_homogene_table__cell_unref0 (cell);
		return result;
	}
	_sugar_homogene_table__cell_unref0 (cell);
}


/**
     * Get cell index at postion
     *
     * @param x relative to HomogeneTable widget, x position
     * @param y relative to HomogeneTable widget, y position
     * @return  cell index, -1 otherwise
     */
gint sugar_homogene_table_get_index_at_pos (SugarHomogeneTable* self, gint x, gint y) {
	gint result = 0;
	gboolean _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = sugar_homogene_table_get_is_empty (self);
	if (_tmp0_) {
		result = -1;
		return result;
	}
	_tmp1_ = MAX (0, x);
	_tmp2_ = sugar_container_get_child_width ((SugarContainer*) self);
	_tmp3_ = MIN (_tmp1_, _tmp2_ - 1);
	x = _tmp3_;
	_tmp4_ = MAX (0, y);
	_tmp5_ = sugar_container_get_child_height ((SugarContainer*) self);
	_tmp6_ = MIN (_tmp4_, _tmp5_ - 1);
	y = _tmp6_;
	_tmp7_ = _sugar_homogene_table_rotate (self, x, y);
	_tmp8_ = _sugar_homogene_table_rotate (self, y, x);
	_tmp9_ = sugar_homogene_table_get__pos (self);
	_tmp10_ = _sugar_homogene_table_get_index_at_pos (self, _tmp7_, _tmp8_ + _tmp9_);
	result = _tmp10_;
	return result;
}


/**
     * Scroll to position where cell is visible
     */
void sugar_homogene_table_scroll_to_cell (SugarHomogeneTable* self, gint cell_index, gboolean fully_visible) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gint _tmp3_;
	gint row;
	gint pos;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp1_ = sugar_homogene_table_get_is_empty (self);
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp2_;
		_tmp2_ = sugar_homogene_table_get_cursor (self);
		_tmp0_ = cell_index == _tmp2_;
	}
	if (_tmp0_) {
		return;
	}
	sugar_homogene_table_set_focus_cell (self, FALSE);
	_tmp3_ = sugar_homogene_table_get__column_count (self);
	row = cell_index / _tmp3_;
	pos = row * self->priv->_cell_length;
	if (fully_visible) {
		gint _tmp6_;
		_tmp6_ = sugar_homogene_table_get__pos (self);
		_tmp5_ = pos <= _tmp6_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		gboolean _tmp7_ = FALSE;
		if (!fully_visible) {
			gint _tmp8_;
			_tmp8_ = sugar_homogene_table_get__pos (self);
			_tmp7_ = (pos + self->priv->_cell_length) <= _tmp8_;
		} else {
			_tmp7_ = FALSE;
		}
		_tmp4_ = _tmp7_;
	}
	if (_tmp4_) {
		sugar_homogene_table_set__pos (self, pos);
	} else {
		gint _tmp9_;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		_tmp9_ = sugar_homogene_table_get__frame_length (self);
		pos = pos - _tmp9_;
		if (fully_visible) {
			gint _tmp12_;
			_tmp12_ = sugar_homogene_table_get__pos (self);
			_tmp11_ = (pos + self->priv->_cell_length) >= _tmp12_;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			_tmp10_ = TRUE;
		} else {
			gboolean _tmp13_ = FALSE;
			if (!fully_visible) {
				gint _tmp14_;
				_tmp14_ = sugar_homogene_table_get__pos (self);
				_tmp13_ = pos >= _tmp14_;
			} else {
				_tmp13_ = FALSE;
			}
			_tmp10_ = _tmp13_;
		}
		if (_tmp10_) {
			sugar_homogene_table_set__pos (self, pos + self->priv->_cell_length);
		}
	}
}


/**
     * Force to run refill cells
     *
     * @param cells range of cells to refill, if empty then all cells
     */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void sugar_homogene_table_refill (SugarHomogeneTable* self) {
	g_return_if_fail (self != NULL);
	{
		SugarHomogeneTable_Cells* _tmp0_;
		SugarHomogeneTable_Cells* _cell_list;
		gint _tmp1_;
		gint _cell_size;
		gint _cell_index;
		_tmp0_ = _g_object_ref0 (self->priv->_cell_cache);
		_cell_list = _tmp0_;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _cell_list);
		_cell_size = _tmp1_;
		_cell_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			SugarHomogeneTable_Cell* cell;
			_cell_index = _cell_index + 1;
			if (!(_cell_index < _cell_size)) {
				break;
			}
			_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _cell_list, _cell_index);
			cell = (SugarHomogeneTable_Cell*) _tmp2_;
			cell->index = -1;
			_sugar_homogene_table__cell_unref0 (cell);
		}
		_g_object_unref0 (_cell_list);
	}
	_sugar_homogene_table_allocate_rows (self, FALSE);
}


static gboolean sugar_homogene_table_real_scroll_event (GtkWidget* base, GdkEventScroll* event) {
	SugarHomogeneTable * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gint value;
	self = (SugarHomogeneTable*) base;
	if (self->priv->_adjustments[0] == NULL) {
		_tmp0_ = TRUE;
	} else {
		GtkOrientation _tmp1_;
		_tmp1_ = sugar_homogene_table_get_orientation (self);
		_tmp0_ = _tmp1_ != GTK_ORIENTATION_HORIZONTAL;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	value = 0;
	if ((*event).direction == GDK_SCROLL_UP) {
		gdouble _tmp2_;
		gint _tmp3_;
		_tmp2_ = gtk_adjustment_get_value (self->priv->_adjustments[0]);
		_tmp3_ = MAX (0, ((gint) _tmp2_) - self->priv->_cell_length);
		value = _tmp3_;
	} else {
		if ((*event).direction == GDK_SCROLL_DOWN) {
			gint _tmp4_;
			gdouble _tmp5_;
			gint _tmp6_;
			_tmp4_ = sugar_homogene_table_get__max_pos (self);
			_tmp5_ = gtk_adjustment_get_value (self->priv->_adjustments[0]);
			_tmp6_ = MIN (_tmp4_, ((gint) _tmp5_) + self->priv->_cell_length);
			value = _tmp6_;
		} else {
			result = FALSE;
			return result;
		}
	}
	gtk_adjustment_set_value (self->priv->_adjustments[0], (gdouble) value);
	result = TRUE;
	return result;
}


static void sugar_homogene_table_real_realize (GtkWidget* base) {
	SugarHomogeneTable * self;
	GdkWindow* _tmp0_ = NULL;
	GdkColormap* _tmp1_ = NULL;
	GdkWindowAttr _tmp2_ = {0};
	GdkWindowAttr _tmp3_ = {0};
	GdkWindow* _tmp4_ = NULL;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	GdkColormap* _tmp17_ = NULL;
	gint _tmp18_;
	GdkWindowAttr _tmp19_ = {0};
	GdkWindowAttr _tmp20_ = {0};
	GdkWindow* _tmp21_ = NULL;
	GtkStyle* _tmp22_ = NULL;
	GtkStyle* _tmp23_ = NULL;
	GtkStyle* _tmp24_ = NULL;
	self = (SugarHomogeneTable*) base;
	GTK_WIDGET_SET_FLAGS ((GtkWidget*) self, GTK_REALIZED);
	_tmp0_ = gtk_widget_get_parent_window ((GtkWidget*) self);
	_tmp1_ = gtk_widget_get_colormap ((GtkWidget*) self);
	memset (&_tmp2_, 0, sizeof (GdkWindowAttr));
	_tmp2_.window_type = GDK_WINDOW_CHILD;
	_tmp2_.x = ((GtkWidget*) self)->allocation.x;
	_tmp2_.y = ((GtkWidget*) self)->allocation.y;
	_tmp2_.width = ((GtkWidget*) self)->allocation.width;
	_tmp2_.height = ((GtkWidget*) self)->allocation.height;
	_tmp2_.wclass = GDK_INPUT_OUTPUT;
	_tmp2_.colormap = _tmp1_;
	_tmp2_.event_mask = (gint) GDK_VISIBILITY_NOTIFY_MASK;
	_tmp3_ = _tmp2_;
	_tmp4_ = gdk_window_new (_tmp0_, &_tmp3_, (gint) ((GDK_WA_X | GDK_WA_Y) | GDK_WA_COLORMAP));
	_g_object_unref0 (((GtkWidget*) self)->window);
	((GtkWidget*) self)->window = _tmp4_;
	gdk_window_set_user_data (((GtkWidget*) self)->window, self);
	_tmp5_ = sugar_container_get_child_x ((SugarContainer*) self);
	_tmp6_ = sugar_homogene_table_get__pos (self);
	_tmp7_ = _sugar_homogene_table_rotate (self, _tmp5_, -_tmp6_);
	_tmp8_ = sugar_homogene_table_get__pos (self);
	_tmp9_ = sugar_container_get_child_y ((SugarContainer*) self);
	_tmp10_ = _sugar_homogene_table_rotate (self, -_tmp8_, _tmp9_);
	_tmp11_ = sugar_homogene_table_get__thickness (self);
	_tmp12_ = sugar_homogene_table_get__length (self);
	_tmp13_ = _sugar_homogene_table_rotate (self, _tmp11_, _tmp12_);
	_tmp14_ = sugar_homogene_table_get__length (self);
	_tmp15_ = sugar_homogene_table_get__thickness (self);
	_tmp16_ = _sugar_homogene_table_rotate (self, _tmp14_, _tmp15_);
	_tmp17_ = gtk_widget_get_colormap ((GtkWidget*) self);
	_tmp18_ = gtk_widget_get_events ((GtkWidget*) self);
	memset (&_tmp19_, 0, sizeof (GdkWindowAttr));
	_tmp19_.window_type = GDK_WINDOW_CHILD;
	_tmp19_.x = _tmp7_;
	_tmp19_.y = _tmp10_;
	_tmp19_.width = _tmp13_;
	_tmp19_.height = _tmp16_;
	_tmp19_.colormap = _tmp17_;
	_tmp19_.wclass = GDK_INPUT_OUTPUT;
	_tmp19_.event_mask = (_tmp18_ | GDK_EXPOSURE_MASK) | GDK_SCROLL_MASK;
	_tmp20_ = _tmp19_;
	_tmp21_ = gdk_window_new (((GtkWidget*) self)->window, &_tmp20_, (gint) ((GDK_WA_X | GDK_WA_Y) | GDK_WA_COLORMAP));
	self->priv->_bin_window = _tmp21_;
	gdk_window_set_user_data (self->priv->_bin_window, self);
	_tmp22_ = gtk_widget_get_style ((GtkWidget*) self);
	gtk_style_attach (_tmp22_, ((GtkWidget*) self)->window);
	_tmp23_ = gtk_widget_get_style ((GtkWidget*) self);
	gtk_style_set_background (_tmp23_, ((GtkWidget*) self)->window, GTK_STATE_NORMAL);
	_tmp24_ = gtk_widget_get_style ((GtkWidget*) self);
	gtk_style_set_background (_tmp24_, self->priv->_bin_window, GTK_STATE_NORMAL);
	{
		SugarHomogeneTable_Rows* _tmp25_;
		SugarHomogeneTable_Rows* _row_list;
		gint _tmp26_;
		gint _row_size;
		gint _row_index;
		_tmp25_ = _g_object_ref0 (self->priv->_row_cache);
		_row_list = _tmp25_;
		_tmp26_ = gee_collection_get_size ((GeeCollection*) _row_list);
		_row_size = _tmp26_;
		_row_index = -1;
		while (TRUE) {
			gpointer _tmp27_ = NULL;
			SugarHomogeneTable_Cells* row;
			_row_index = _row_index + 1;
			if (!(_row_index < _row_size)) {
				break;
			}
			_tmp27_ = gee_abstract_list_get ((GeeAbstractList*) _row_list, _row_index);
			row = (SugarHomogeneTable_Cells*) _tmp27_;
			{
				SugarHomogeneTable_Cells* _tmp28_;
				SugarHomogeneTable_Cells* _cell_list;
				gint _tmp29_;
				gint _cell_size;
				gint _cell_index;
				_tmp28_ = _g_object_ref0 (row);
				_cell_list = _tmp28_;
				_tmp29_ = gee_collection_get_size ((GeeCollection*) _cell_list);
				_cell_size = _tmp29_;
				_cell_index = -1;
				while (TRUE) {
					gpointer _tmp30_ = NULL;
					SugarHomogeneTable_Cell* cell;
					_cell_index = _cell_index + 1;
					if (!(_cell_index < _cell_size)) {
						break;
					}
					_tmp30_ = gee_abstract_list_get ((GeeAbstractList*) _cell_list, _cell_index);
					cell = (SugarHomogeneTable_Cell*) _tmp30_;
					gtk_widget_set_parent_window (cell->widget, self->priv->_bin_window);
					_sugar_homogene_table__cell_unref0 (cell);
				}
				_g_object_unref0 (_cell_list);
			}
			_g_object_unref0 (row);
		}
		_g_object_unref0 (_row_list);
	}
	if (self->priv->_pending_allocate != (-1)) {
		_sugar_homogene_table_allocate_rows (self, (gboolean) self->priv->_pending_allocate);
		self->priv->_pending_allocate = -1;
	}
}


static void sugar_homogene_table_real_size_allocate (GtkWidget* base, GdkRectangle* allocation) {
	SugarHomogeneTable * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	self = (SugarHomogeneTable*) base;
	if (((GtkWidget*) self)->allocation.x == (*allocation).x) {
		_tmp2_ = ((GtkWidget*) self)->allocation.y == (*allocation).y;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = ((GtkWidget*) self)->allocation.width == (*allocation).width;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = ((GtkWidget*) self)->allocation.height == (*allocation).height;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		_sugar_homogene_table_reallocate_cells (self);
		return;
	}
	((GtkWidget*) self)->allocation = (GtkAllocation) (*allocation);
	_sugar_homogene_table_resize_table (self);
	_tmp3_ = GTK_WIDGET_REALIZED ((GtkWidget*) self);
	if (_tmp3_) {
		gdk_window_move_resize (((GtkWidget*) self)->window, (*allocation).x, (*allocation).y, (*allocation).width, (*allocation).height);
	}
}


static void sugar_homogene_table_real_unrealize (GtkWidget* base) {
	SugarHomogeneTable * self;
	self = (SugarHomogeneTable*) base;
	gdk_window_set_user_data (self->priv->_bin_window, NULL);
	gdk_window_destroy (self->priv->_bin_window);
	self->priv->_bin_window = NULL;
	GTK_WIDGET_CLASS (sugar_homogene_table_parent_class)->unrealize ((GtkWidget*) SUGAR_CONTAINER (self));
}


static void sugar_homogene_table_real_style_set (GtkWidget* base, GtkStyle* previous_style) {
	SugarHomogeneTable * self;
	gboolean _tmp0_;
	self = (SugarHomogeneTable*) base;
	GTK_WIDGET_CLASS (sugar_homogene_table_parent_class)->style_set ((GtkWidget*) SUGAR_CONTAINER (self), previous_style);
	_tmp0_ = GTK_WIDGET_REALIZED ((GtkWidget*) self);
	if (_tmp0_) {
		GtkStyle* _tmp1_ = NULL;
		_tmp1_ = gtk_widget_get_style ((GtkWidget*) self);
		gtk_style_set_background (_tmp1_, self->priv->_bin_window, GTK_STATE_NORMAL);
	}
}


static gboolean sugar_homogene_table_real_expose_event (GtkWidget* base, GdkEventExpose* event) {
	SugarHomogeneTable * self;
	gboolean result = FALSE;
	self = (SugarHomogeneTable*) base;
	if ((*event).window != self->priv->_bin_window) {
		result = FALSE;
		return result;
	}
	GTK_WIDGET_CLASS (sugar_homogene_table_parent_class)->expose_event ((GtkWidget*) SUGAR_CONTAINER (self), event);
	result = FALSE;
	return result;
}


static void sugar_homogene_table_real_map (GtkWidget* base) {
	SugarHomogeneTable * self;
	self = (SugarHomogeneTable*) base;
	GTK_WIDGET_SET_FLAGS ((GtkWidget*) self, GTK_MAPPED);
	{
		SugarHomogeneTable_Rows* _tmp0_;
		SugarHomogeneTable_Rows* _row_list;
		gint _tmp1_;
		gint _row_size;
		gint _row_index;
		_tmp0_ = _g_object_ref0 (self->priv->_row_cache);
		_row_list = _tmp0_;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _row_list);
		_row_size = _tmp1_;
		_row_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			SugarHomogeneTable_Cells* row;
			_row_index = _row_index + 1;
			if (!(_row_index < _row_size)) {
				break;
			}
			_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _row_list, _row_index);
			row = (SugarHomogeneTable_Cells*) _tmp2_;
			{
				SugarHomogeneTable_Cells* _tmp3_;
				SugarHomogeneTable_Cells* _cell_list;
				gint _tmp4_;
				gint _cell_size;
				gint _cell_index;
				_tmp3_ = _g_object_ref0 (row);
				_cell_list = _tmp3_;
				_tmp4_ = gee_collection_get_size ((GeeCollection*) _cell_list);
				_cell_size = _tmp4_;
				_cell_index = -1;
				while (TRUE) {
					gpointer _tmp5_ = NULL;
					SugarHomogeneTable_Cell* cell;
					gboolean _tmp6_;
					_cell_index = _cell_index + 1;
					if (!(_cell_index < _cell_size)) {
						break;
					}
					_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _cell_list, _cell_index);
					cell = (SugarHomogeneTable_Cell*) _tmp5_;
					_tmp6_ = gtk_widget_get_visible (cell->widget);
					if (_tmp6_) {
						gtk_widget_map (cell->widget);
					}
					_sugar_homogene_table__cell_unref0 (cell);
				}
				_g_object_unref0 (_cell_list);
			}
			_g_object_unref0 (row);
		}
		_g_object_unref0 (_row_list);
	}
	gdk_window_show (self->priv->_bin_window);
	gdk_window_show (((GtkWidget*) self)->window);
}


static void sugar_homogene_table_real_size_request (GtkWidget* base, GtkRequisition* requisition) {
	SugarHomogeneTable * self;
	GtkRequisition _requisition = {0};
	self = (SugarHomogeneTable*) base;
	_requisition.width = 0;
	_requisition.height = 0;
	{
		SugarHomogeneTable_Rows* _tmp0_;
		SugarHomogeneTable_Rows* _row_list;
		gint _tmp1_;
		gint _row_size;
		gint _row_index;
		_tmp0_ = _g_object_ref0 (self->priv->_row_cache);
		_row_list = _tmp0_;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _row_list);
		_row_size = _tmp1_;
		_row_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			SugarHomogeneTable_Cells* row;
			_row_index = _row_index + 1;
			if (!(_row_index < _row_size)) {
				break;
			}
			_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _row_list, _row_index);
			row = (SugarHomogeneTable_Cells*) _tmp2_;
			{
				SugarHomogeneTable_Cells* _tmp3_;
				SugarHomogeneTable_Cells* _cell_list;
				gint _tmp4_;
				gint _cell_size;
				gint _cell_index;
				_tmp3_ = _g_object_ref0 (row);
				_cell_list = _tmp3_;
				_tmp4_ = gee_collection_get_size ((GeeCollection*) _cell_list);
				_cell_size = _tmp4_;
				_cell_index = -1;
				while (TRUE) {
					gpointer _tmp5_ = NULL;
					SugarHomogeneTable_Cell* cell;
					GtkRequisition child_requisition = {0};
					GtkRequisition _tmp6_ = {0};
					_cell_index = _cell_index + 1;
					if (!(_cell_index < _cell_size)) {
						break;
					}
					_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _cell_list, _cell_index);
					cell = (SugarHomogeneTable_Cell*) _tmp5_;
					gtk_widget_size_request (cell->widget, &_tmp6_);
					child_requisition = _tmp6_;
					_sugar_homogene_table__cell_unref0 (cell);
				}
				_g_object_unref0 (_cell_list);
			}
			_g_object_unref0 (row);
		}
		_g_object_unref0 (_row_list);
	}
	sugar_container_child_size_request ((SugarContainer*) self, &_requisition);
	if (requisition) {
		*requisition = _requisition;
	}
}


static gboolean sugar_homogene_table_real_motion_notify_event (GtkWidget* base, GdkEventMotion* event) {
	SugarHomogeneTable * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	self = (SugarHomogeneTable*) base;
	_tmp0_ = sugar_homogene_table_get_hover_selection (self);
	if (_tmp0_) {
		gint x = 0;
		gint y = 0;
		gint _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		sugar_container_get_pointer ((SugarContainer*) self, &_tmp1_, &_tmp2_);
		x = _tmp1_;
		y = _tmp2_;
		_tmp3_ = sugar_homogene_table_get_index_at_pos (self, x, y);
		sugar_homogene_table_set_cursor (self, _tmp3_);
	}
	result = FALSE;
	return result;
}


static gboolean sugar_homogene_table_real_key_press_event (GtkWidget* base, GdkEventKey* event) {
	SugarHomogeneTable * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	self = (SugarHomogeneTable*) base;
	_tmp1_ = sugar_homogene_table_get_is_empty (self);
	if (!_tmp1_) {
		gint _tmp2_;
		_tmp2_ = sugar_homogene_table_get_cursor (self);
		_tmp0_ = _tmp2_ >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp3_ = FALSE;
		if ((*event).keyval == 0xff1b) {
			gboolean _tmp4_;
			_tmp4_ = sugar_homogene_table_get_focus_cell (self);
			_tmp3_ = _tmp4_;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			sugar_homogene_table_set_focus_cell (self, FALSE);
		}
	}
	result = FALSE;
	return result;
}


static void sugar_homogene_table_real_forall_internal (GtkContainer* base, gboolean include_internal, GtkCallback callback, void* callback_target) {
	SugarHomogeneTable * self;
	self = (SugarHomogeneTable*) base;
	{
		SugarHomogeneTable_Rows* _tmp0_;
		SugarHomogeneTable_Rows* _row_list;
		gint _tmp1_;
		gint _row_size;
		gint _row_index;
		_tmp0_ = _g_object_ref0 (self->priv->_row_cache);
		_row_list = _tmp0_;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _row_list);
		_row_size = _tmp1_;
		_row_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			SugarHomogeneTable_Cells* row;
			_row_index = _row_index + 1;
			if (!(_row_index < _row_size)) {
				break;
			}
			_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _row_list, _row_index);
			row = (SugarHomogeneTable_Cells*) _tmp2_;
			{
				SugarHomogeneTable_Cells* _tmp3_;
				SugarHomogeneTable_Cells* _cell_list;
				gint _tmp4_;
				gint _cell_size;
				gint _cell_index;
				_tmp3_ = _g_object_ref0 (row);
				_cell_list = _tmp3_;
				_tmp4_ = gee_collection_get_size ((GeeCollection*) _cell_list);
				_cell_size = _tmp4_;
				_cell_index = -1;
				while (TRUE) {
					gpointer _tmp5_ = NULL;
					SugarHomogeneTable_Cell* cell;
					_cell_index = _cell_index + 1;
					if (!(_cell_index < _cell_size)) {
						break;
					}
					_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _cell_list, _cell_index);
					cell = (SugarHomogeneTable_Cell*) _tmp5_;
					callback (cell->widget, callback_target);
					_sugar_homogene_table__cell_unref0 (cell);
				}
				_g_object_unref0 (_cell_list);
			}
			_g_object_unref0 (row);
		}
		_g_object_unref0 (_row_list);
	}
}


static void sugar_homogene_table_real_add (GtkContainer* base, GtkWidget* widget) {
	SugarHomogeneTable * self;
	self = (SugarHomogeneTable*) base;
	g_return_if_fail (widget != NULL);
	g_assert (FALSE);
}


static void sugar_homogene_table_real_remove (GtkContainer* base, GtkWidget* widget) {
	SugarHomogeneTable * self;
	self = (SugarHomogeneTable*) base;
	g_return_if_fail (widget != NULL);
}


static void sugar_homogene_table_real_set_focus_child (GtkContainer* base, GtkWidget* widget) {
	SugarHomogeneTable * self;
	gint x;
	gint y;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint new_cursor;
	gboolean _tmp3_ = FALSE;
	gint _tmp4_;
	self = (SugarHomogeneTable*) base;
	if (widget == NULL) {
		return;
	}
	x = widget->allocation.x;
	y = widget->allocation.y;
	_tmp0_ = _sugar_homogene_table_rotate (self, x, y);
	_tmp1_ = _sugar_homogene_table_rotate (self, y, x);
	_tmp2_ = _sugar_homogene_table_get_index_at_pos (self, _tmp0_, _tmp1_);
	new_cursor = _tmp2_;
	_tmp4_ = sugar_homogene_table_get_cursor (self);
	if (_tmp4_ < 0) {
		_tmp3_ = TRUE;
	} else {
		SugarRange _tmp5_ = {0};
		gboolean _tmp6_;
		sugar_homogene_table_get_frame_range (self, &_tmp5_);
		_tmp6_ = sugar_range_contains (&_tmp5_, new_cursor);
		_tmp3_ = !_tmp6_;
	}
	if (_tmp3_) {
		sugar_homogene_table_set_cursor (self, new_cursor);
	}
}


static gboolean sugar_homogene_table_real_focus (GtkWidget* base, GtkDirectionType direction) {
	SugarHomogeneTable * self;
	gboolean result = FALSE;
	self = (SugarHomogeneTable*) base;
	gtk_widget_grab_focus ((GtkWidget*) self);
	result = TRUE;
	return result;
}


static gint _sugar_homogene_table_rotate (SugarHomogeneTable* self, gint x, gint y) {
	gint result = 0;
	GtkOrientation _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = sugar_homogene_table_get_orientation (self);
	if (_tmp0_ == GTK_ORIENTATION_HORIZONTAL) {
		result = y;
		return result;
	} else {
		result = x;
		return result;
	}
}


static void _sugar_homogene_table_set_metric (SugarHomogeneTable* self, gint* prop, gint* mutex_prop, gint value) {
	g_return_if_fail (self != NULL);
	if (value != (*prop)) {
		*mutex_prop = 0;
		*prop = value;
		_sugar_homogene_table_resize_table (self);
	}
}


static gint _sugar_homogene_table_get_index_at_pos (SugarHomogeneTable* self, gint x, gint y) {
	gint result = 0;
	gint cell_row;
	gint _tmp0_;
	gint _tmp1_;
	gint cell_column;
	gint _tmp2_;
	gint cell_index;
	gint _tmp3_;
	gint _tmp4_;
	g_return_val_if_fail (self != NULL, 0);
	cell_row = y / self->priv->_cell_length;
	_tmp0_ = sugar_homogene_table_get__thickness (self);
	_tmp1_ = sugar_homogene_table_get__column_count (self);
	cell_column = x / (_tmp0_ / _tmp1_);
	_tmp2_ = sugar_homogene_table_get__column_count (self);
	cell_index = (cell_row * _tmp2_) + cell_column;
	_tmp3_ = sugar_homogene_table_get_cell_count (self);
	_tmp4_ = MIN (cell_index, _tmp3_ - 1);
	result = _tmp4_;
	return result;
}


static SugarHomogeneTable_Cell* _sugar_homogene_table_get_cell (SugarHomogeneTable* self, gint cell_index) {
	SugarHomogeneTable_Cell* result = NULL;
	gint _tmp0_;
	gint column;
	gint base_index;
	g_return_val_if_fail (self != NULL, NULL);
	if (cell_index < 0) {
		result = NULL;
		return result;
	}
	_tmp0_ = sugar_homogene_table_get__column_count (self);
	column = cell_index % _tmp0_;
	base_index = cell_index - column;
	{
		SugarHomogeneTable_Rows* _tmp1_;
		SugarHomogeneTable_Rows* _row_list;
		gint _tmp2_;
		gint _row_size;
		gint _row_index;
		_tmp1_ = _g_object_ref0 (self->priv->_row_cache);
		_row_list = _tmp1_;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _row_list);
		_row_size = _tmp2_;
		_row_index = -1;
		while (TRUE) {
			gpointer _tmp3_ = NULL;
			SugarHomogeneTable_Cells* row;
			gboolean _tmp4_ = FALSE;
			gpointer _tmp5_ = NULL;
			SugarHomogeneTable_Cell* _tmp6_;
			gboolean _tmp7_;
			gboolean _tmp8_;
			_row_index = _row_index + 1;
			if (!(_row_index < _row_size)) {
				break;
			}
			_tmp3_ = gee_abstract_list_get ((GeeAbstractList*) _row_list, _row_index);
			row = (SugarHomogeneTable_Cells*) _tmp3_;
			_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) row, 0);
			_tmp6_ = (SugarHomogeneTable_Cell*) _tmp5_;
			_tmp7_ = sugar_homogene_table__cell_get_valid (_tmp6_);
			_tmp8_ = _tmp7_;
			_sugar_homogene_table__cell_unref0 (_tmp6_);
			if (_tmp8_) {
				gpointer _tmp9_ = NULL;
				SugarHomogeneTable_Cell* _tmp10_;
				_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) row, 0);
				_tmp10_ = (SugarHomogeneTable_Cell*) _tmp9_;
				_tmp4_ = _tmp10_->index == base_index;
				_sugar_homogene_table__cell_unref0 (_tmp10_);
			} else {
				_tmp4_ = FALSE;
			}
			if (_tmp4_) {
				gpointer _tmp11_ = NULL;
				_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) row, column);
				result = (SugarHomogeneTable_Cell*) _tmp11_;
				_g_object_unref0 (row);
				_g_object_unref0 (_row_list);
				return result;
			}
			_g_object_unref0 (row);
		}
		_g_object_unref0 (_row_list);
	}
	result = NULL;
	return result;
}


static gint _sugar_homogene_table_get_row_pos (SugarHomogeneTable* self, SugarHomogeneTable_Cells* row) {
	gint result = 0;
	gpointer _tmp0_ = NULL;
	SugarHomogeneTable_Cell* _tmp1_;
	GtkAllocation _tmp2_;
	GtkAllocation allocation;
	gint _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (row != NULL, 0);
	_tmp0_ = gee_abstract_list_get ((GeeAbstractList*) row, 0);
	_tmp1_ = (SugarHomogeneTable_Cell*) _tmp0_;
	_tmp2_ = _tmp1_->widget->allocation;
	_sugar_homogene_table__cell_unref0 (_tmp1_);
	allocation = _tmp2_;
	_tmp3_ = _sugar_homogene_table_rotate (self, allocation.y, allocation.x);
	result = _tmp3_;
	return result;
}


static void _sugar_homogene_table_set_cursor (SugarHomogeneTable* self, gint cell_index) {
	gboolean _tmp0_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = sugar_homogene_table_get_hover_selection (self);
	if (_tmp0_) {
		gint _tmp1_;
		SugarHomogeneTable_Cell* _tmp2_ = NULL;
		SugarHomogeneTable_Cell* cell;
		_tmp1_ = sugar_homogene_table_get_cursor (self);
		_tmp2_ = _sugar_homogene_table_get_cell (self, _tmp1_);
		cell = _tmp2_;
		if (cell != NULL) {
			sugar_homogene_table_highlight_cell (self, cell->widget, FALSE);
		}
		_sugar_homogene_table__cell_unref0 (cell);
	}
	self->priv->_cursor_index = cell_index;
	_tmp3_ = sugar_homogene_table_get_hover_selection (self);
	if (_tmp3_) {
		gint _tmp4_;
		SugarHomogeneTable_Cell* _tmp5_ = NULL;
		SugarHomogeneTable_Cell* cell;
		_tmp4_ = sugar_homogene_table_get_cursor (self);
		_tmp5_ = _sugar_homogene_table_get_cell (self, _tmp4_);
		cell = _tmp5_;
		if (cell != NULL) {
			sugar_homogene_table_highlight_cell (self, cell->widget, TRUE);
		}
		_sugar_homogene_table__cell_unref0 (cell);
	}
	g_signal_emit_by_name (self, "cursor-changed");
}


static void _sugar_homogene_table_abandon_cells (SugarHomogeneTable* self) {
	SugarHomogeneTable_Rows* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	{
		SugarHomogeneTable_Rows* _tmp0_;
		SugarHomogeneTable_Rows* _row_list;
		gint _tmp1_;
		gint _row_size;
		gint _row_index;
		_tmp0_ = _g_object_ref0 (self->priv->_row_cache);
		_row_list = _tmp0_;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _row_list);
		_row_size = _tmp1_;
		_row_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			SugarHomogeneTable_Cells* row;
			_row_index = _row_index + 1;
			if (!(_row_index < _row_size)) {
				break;
			}
			_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _row_list, _row_index);
			row = (SugarHomogeneTable_Cells*) _tmp2_;
			{
				SugarHomogeneTable_Cells* _tmp3_;
				SugarHomogeneTable_Cells* _cell_list;
				gint _tmp4_;
				gint _cell_size;
				gint _cell_index;
				_tmp3_ = _g_object_ref0 (row);
				_cell_list = _tmp3_;
				_tmp4_ = gee_collection_get_size ((GeeCollection*) _cell_list);
				_cell_size = _tmp4_;
				_cell_index = -1;
				while (TRUE) {
					gpointer _tmp5_ = NULL;
					SugarHomogeneTable_Cell* cell;
					_cell_index = _cell_index + 1;
					if (!(_cell_index < _cell_size)) {
						break;
					}
					_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _cell_list, _cell_index);
					cell = (SugarHomogeneTable_Cell*) _tmp5_;
					gtk_widget_unparent (cell->widget);
					_sugar_homogene_table__cell_unref0 (cell);
				}
				_g_object_unref0 (_cell_list);
			}
			_g_object_unref0 (row);
		}
		_g_object_unref0 (_row_list);
	}
	self->priv->_cell_cache_pos = 0;
	_tmp6_ = sugar_homogene_table__rows_new ();
	_g_object_unref0 (self->priv->_row_cache);
	self->priv->_row_cache = _tmp6_;
}


static SugarHomogeneTable_Cell* _sugar_homogene_table_pop_a_cell (SugarHomogeneTable* self) {
	SugarHomogeneTable_Cell* result = NULL;
	SugarHomogeneTable_Cell* cell = NULL;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_collection_get_size ((GeeCollection*) self->priv->_cell_cache);
	if (self->priv->_cell_cache_pos < _tmp0_) {
		gpointer _tmp1_ = NULL;
		_tmp1_ = gee_abstract_list_get ((GeeAbstractList*) self->priv->_cell_cache, self->priv->_cell_cache_pos);
		_sugar_homogene_table__cell_unref0 (cell);
		cell = (SugarHomogeneTable_Cell*) _tmp1_;
		self->priv->_cell_cache_pos = self->priv->_cell_cache_pos + 1;
	} else {
		SugarHomogeneTable_Cell* _tmp2_ = NULL;
		GtkWidget* _tmp3_ = NULL;
		gint _tmp4_;
		_tmp2_ = sugar_homogene_table__cell_new ();
		_sugar_homogene_table__cell_unref0 (cell);
		cell = _tmp2_;
		_tmp3_ = sugar_homogene_table_new_cell (self);
		_g_object_unref0 (cell->widget);
		cell->widget = _tmp3_;
		g_assert (cell->widget != NULL);
		gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->_cell_cache, cell);
		_tmp4_ = gee_collection_get_size ((GeeCollection*) self->priv->_cell_cache);
		self->priv->_cell_cache_pos = _tmp4_;
	}
	sugar_homogene_table__cell_invalidate_pos (cell);
	result = cell;
	return result;
}


static void _sugar_homogene_table_setup_adjustment (SugarHomogeneTable* self, gboolean dry_run) {
	GtkAdjustment* _tmp0_;
	GtkAdjustment* adj;
	gint _tmp1_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (self->priv->_adjustments[0]);
	adj = _tmp0_;
	if (adj == NULL) {
		_g_object_unref0 (adj);
		return;
	}
	gtk_adjustment_set_lower (adj, (gdouble) 0);
	_tmp1_ = sugar_homogene_table_get__column_count (self);
	if (_tmp1_ == 0) {
		gtk_adjustment_set_upper (adj, (gdouble) 0);
	} else {
		gint _tmp2_;
		gint _tmp3_;
		gdouble _tmp4_;
		_tmp2_ = sugar_homogene_table_get_cell_count (self);
		_tmp3_ = sugar_homogene_table_get__column_count (self);
		_tmp4_ = ceil ((gdouble) (((gfloat) _tmp2_) / _tmp3_));
		gtk_adjustment_set_upper (adj, (gdouble) (((gint) _tmp4_) * self->priv->_cell_length));
	}
	_tmp5_ = sugar_homogene_table_get__frame_length (self);
	gtk_adjustment_set_page_size (adj, (gdouble) _tmp5_);
	gtk_adjustment_changed (adj);
	_tmp6_ = sugar_homogene_table_get__pos (self);
	_tmp7_ = sugar_homogene_table_get__max_pos (self);
	if (_tmp6_ > _tmp7_) {
		gint _tmp8_;
		_tmp8_ = sugar_homogene_table_get__max_pos (self);
		sugar_homogene_table_set__pos (self, _tmp8_);
		if (!dry_run) {
			gtk_adjustment_value_changed (adj);
		}
	}
	_g_object_unref0 (adj);
}


static void _sugar_homogene_table_resize_table (SugarHomogeneTable* self) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gint row_count;
	gint _tmp2_;
	gint column_count;
	gboolean _tmp8_ = FALSE;
	gint _tmp9_;
	gint _tmp22_;
	gboolean _tmp25_;
	g_return_if_fail (self != NULL);
	if ((((GtkWidget*) self)->allocation.x + ((GtkWidget*) self)->allocation.width) <= 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = (((GtkWidget*) self)->allocation.y + ((GtkWidget*) self)->allocation.height) <= 0;
	}
	if (_tmp0_) {
		return;
	}
	_tmp1_ = sugar_homogene_table_get_frame_height (self);
	row_count = _tmp1_;
	_tmp2_ = sugar_homogene_table_get_frame_width (self);
	column_count = _tmp2_;
	if (row_count == 0) {
		gint _tmp3_;
		gdouble _tmp4_;
		gint _tmp5_;
		if (self->priv->_cell_height == 0) {
			return;
		}
		_tmp3_ = sugar_homogene_table_get__frame_length (self);
		_tmp4_ = ceil ((gdouble) (_tmp3_ / ((gfloat) self->priv->_cell_height)));
		row_count = (gint) _tmp4_;
		_tmp5_ = MAX (1, row_count);
		row_count = _tmp5_;
	}
	if (column_count == 0) {
		gint _tmp6_;
		gint _tmp7_;
		if (self->priv->_cell_width == 0) {
			return;
		}
		_tmp6_ = sugar_homogene_table_get__thickness (self);
		_tmp7_ = MAX (1, _tmp6_ / self->priv->_cell_width);
		column_count = _tmp7_;
	}
	_tmp9_ = sugar_homogene_table_get__column_count (self);
	if (column_count != _tmp9_) {
		_tmp8_ = TRUE;
	} else {
		gint _tmp10_;
		_tmp10_ = sugar_homogene_table_get__frame_row_count (self);
		_tmp8_ = row_count != _tmp10_;
	}
	if (_tmp8_) {
		_sugar_homogene_table_abandon_cells (self);
		{
			gint i;
			i = row_count + SUGAR_HOMOGENE_TABLE__SPARE_ROWS_COUNT;
			{
				gboolean _tmp11_;
				_tmp11_ = TRUE;
				while (TRUE) {
					SugarHomogeneTable_Cells* _tmp12_ = NULL;
					SugarHomogeneTable_Cells* row;
					if (!_tmp11_) {
						i = i - 1;
					}
					_tmp11_ = FALSE;
					if (!(i > 0)) {
						break;
					}
					_tmp12_ = sugar_homogene_table__cells_new ();
					row = _tmp12_;
					{
						gint j;
						j = column_count;
						{
							gboolean _tmp13_;
							_tmp13_ = TRUE;
							while (TRUE) {
								SugarHomogeneTable_Cell* _tmp14_ = NULL;
								SugarHomogeneTable_Cell* cell;
								gboolean _tmp15_;
								if (!_tmp13_) {
									j = j - 1;
								}
								_tmp13_ = FALSE;
								if (!(j > 0)) {
									break;
								}
								_tmp14_ = _sugar_homogene_table_pop_a_cell (self);
								cell = _tmp14_;
								_tmp15_ = GTK_WIDGET_REALIZED ((GtkWidget*) self);
								if (_tmp15_) {
									gtk_widget_set_parent_window (cell->widget, self->priv->_bin_window);
								}
								gtk_widget_set_parent (cell->widget, (GtkWidget*) self);
								gee_abstract_collection_add ((GeeAbstractCollection*) row, cell);
								_sugar_homogene_table__cell_unref0 (cell);
							}
						}
					}
					gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->_row_cache, row);
					_g_object_unref0 (row);
				}
			}
		}
	} else {
		{
			SugarHomogeneTable_Rows* _tmp16_;
			SugarHomogeneTable_Rows* _row_list;
			gint _tmp17_;
			gint _row_size;
			gint _row_index;
			_tmp16_ = _g_object_ref0 (self->priv->_row_cache);
			_row_list = _tmp16_;
			_tmp17_ = gee_collection_get_size ((GeeCollection*) _row_list);
			_row_size = _tmp17_;
			_row_index = -1;
			while (TRUE) {
				gpointer _tmp18_ = NULL;
				SugarHomogeneTable_Cells* row;
				_row_index = _row_index + 1;
				if (!(_row_index < _row_size)) {
					break;
				}
				_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _row_list, _row_index);
				row = (SugarHomogeneTable_Cells*) _tmp18_;
				{
					SugarHomogeneTable_Cells* _tmp19_;
					SugarHomogeneTable_Cells* _cell_list;
					gint _tmp20_;
					gint _cell_size;
					gint _cell_index;
					_tmp19_ = _g_object_ref0 (row);
					_cell_list = _tmp19_;
					_tmp20_ = gee_collection_get_size ((GeeCollection*) _cell_list);
					_cell_size = _tmp20_;
					_cell_index = -1;
					while (TRUE) {
						gpointer _tmp21_ = NULL;
						SugarHomogeneTable_Cell* cell;
						_cell_index = _cell_index + 1;
						if (!(_cell_index < _cell_size)) {
							break;
						}
						_tmp21_ = gee_abstract_list_get ((GeeAbstractList*) _cell_list, _cell_index);
						cell = (SugarHomogeneTable_Cell*) _tmp21_;
						sugar_homogene_table__cell_invalidate_pos (cell);
						cell->index = -1;
						_sugar_homogene_table__cell_unref0 (cell);
					}
					_g_object_unref0 (_cell_list);
				}
				_g_object_unref0 (row);
			}
			_g_object_unref0 (_row_list);
		}
	}
	_tmp22_ = sugar_homogene_table_get_frame_height (self);
	if (_tmp22_ == 0) {
		self->priv->_cell_length = self->priv->_cell_height;
	} else {
		gint _tmp23_;
		gint _tmp24_;
		_tmp23_ = sugar_homogene_table_get__frame_length (self);
		_tmp24_ = sugar_homogene_table_get__frame_row_count (self);
		self->priv->_cell_length = _tmp23_ / _tmp24_;
	}
	_sugar_homogene_table_setup_adjustment (self, TRUE);
	_tmp25_ = GTK_WIDGET_REALIZED ((GtkWidget*) self);
	if (_tmp25_) {
		gint _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		gint _tmp30_;
		gint _tmp31_;
		_tmp26_ = sugar_homogene_table_get__thickness (self);
		_tmp27_ = sugar_homogene_table_get__length (self);
		_tmp28_ = _sugar_homogene_table_rotate (self, _tmp26_, _tmp27_);
		_tmp29_ = sugar_homogene_table_get__length (self);
		_tmp30_ = sugar_homogene_table_get__thickness (self);
		_tmp31_ = _sugar_homogene_table_rotate (self, _tmp29_, _tmp30_);
		gdk_window_resize (self->priv->_bin_window, _tmp28_, _tmp31_);
	}
	_sugar_homogene_table_allocate_rows (self, TRUE);
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->self);
		_g_array_free0 (_data2_->spare_rows);
		g_slice_free (Block2Data, _data2_);
	}
}


static gint _lambda1_ (gconstpointer a, gconstpointer b) {
	gint result = 0;
	SugarHomogeneTable_Cells* a_row;
	SugarHomogeneTable_Cells* b_row;
	gpointer _tmp0_ = NULL;
	SugarHomogeneTable_Cell* _tmp1_;
	gpointer _tmp2_ = NULL;
	SugarHomogeneTable_Cell* _tmp3_;
	gint _tmp4_;
	a_row = *((SugarHomogeneTable_Cells**) a);
	b_row = *((SugarHomogeneTable_Cells**) b);
	_tmp0_ = gee_abstract_list_get ((GeeAbstractList*) a_row, 0);
	_tmp1_ = (SugarHomogeneTable_Cell*) _tmp0_;
	_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) b_row, 0);
	_tmp3_ = (SugarHomogeneTable_Cell*) _tmp2_;
	_tmp4_ = _tmp1_->widget->allocation.x - _tmp3_->widget->allocation.x;
	_sugar_homogene_table__cell_unref0 (_tmp3_);
	_sugar_homogene_table__cell_unref0 (_tmp1_);
	result = _tmp4_;
	return result;
}


static gint __lambda1__gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = _lambda1_ (a, b);
	return result;
}


static gint _lambda2_ (gconstpointer a, gconstpointer b) {
	gint result = 0;
	SugarHomogeneTable_Cells* a_row;
	SugarHomogeneTable_Cells* b_row;
	gpointer _tmp0_ = NULL;
	SugarHomogeneTable_Cell* _tmp1_;
	gpointer _tmp2_ = NULL;
	SugarHomogeneTable_Cell* _tmp3_;
	gint _tmp4_;
	a_row = *((SugarHomogeneTable_Cells**) a);
	b_row = *((SugarHomogeneTable_Cells**) b);
	_tmp0_ = gee_abstract_list_get ((GeeAbstractList*) a_row, 0);
	_tmp1_ = (SugarHomogeneTable_Cell*) _tmp0_;
	_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) b_row, 0);
	_tmp3_ = (SugarHomogeneTable_Cell*) _tmp2_;
	_tmp4_ = _tmp1_->widget->allocation.y - _tmp3_->widget->allocation.y;
	_sugar_homogene_table__cell_unref0 (_tmp3_);
	_sugar_homogene_table__cell_unref0 (_tmp1_);
	result = _tmp4_;
	return result;
}


static gint __lambda2__gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = _lambda2_ (a, b);
	return result;
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		block2_data_unref (_data3_->_data2_);
		_data3_->_data2_ = NULL;
		g_slice_free (Block3Data, _data3_);
	}
}


static void _lambda3_ (gint pos_begin, gint pos_end, Block3Data* _data3_) {
	Block2Data* _data2_;
	SugarHomogeneTable * self;
	_data2_ = _data3_->_data2_;
	self = _data2_->self;
	while (TRUE) {
		SugarHomogeneTable_Cells* _tmp0_ = NULL;
		SugarHomogeneTable_Cells* row;
		if (!(pos_begin < pos_end)) {
			break;
		}
		if (_data3_->spare_rows_sp >= _data2_->spare_rows->len) {
			g_warning ("homogenetable.vala:829: spare_rows should not be empty.");
			return;
		}
		_tmp0_ = g_array_index (_data2_->spare_rows, SugarHomogeneTable_Cells*, (guint) _data3_->spare_rows_sp);
		row = _tmp0_;
		_data3_->spare_rows_sp = _data3_->spare_rows_sp + 1;
		_sugar_homogene_table_allocate_cells (self, row, pos_begin);
		pos_begin = pos_begin + self->priv->_cell_length;
	}
}


static void __lambda3__sugarhomogenetable_insertsparerow (gint pos_begin, gint pos_end, gpointer self) {
	_lambda3_ (pos_begin, pos_end, self);
}


static void _sugar_homogene_table_allocate_rows (SugarHomogeneTable* self, gboolean force) {
	Block2Data* _data2_;
	gboolean _tmp0_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	SugarRange _tmp8_ = {0};
	SugarRange old_frame_range;
	SugarRange _tmp9_ = {0};
	SugarRange _tmp10_ = {0};
	gint _tmp11_;
	GArray* _tmp12_ = NULL;
	gint _tmp13_;
	GArray* _tmp14_ = NULL;
	GArray* visible_rows;
	gboolean _tmp28_ = FALSE;
	gint _tmp36_;
	gint bin_x;
	gint _tmp37_;
	gint _tmp38_;
	gint bin_y;
	gint _tmp39_;
	gint _tmp40_;
	SugarRange _tmp41_ = {0};
	gboolean _tmp42_;
	gboolean _tmp43_ = FALSE;
	gboolean _tmp44_;
	g_return_if_fail (self != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = GTK_WIDGET_REALIZED ((GtkWidget*) self);
	if (!_tmp0_) {
		gboolean _tmp1_ = FALSE;
		if (self->priv->_pending_allocate > 0) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = force;
		}
		self->priv->_pending_allocate = (gint) _tmp1_;
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return;
	}
	_tmp4_ = sugar_homogene_table_get_is_empty (self);
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		gint _tmp5_;
		_tmp5_ = sugar_homogene_table_get__pos (self);
		_tmp3_ = _tmp5_ < 0;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = sugar_homogene_table_get__pos (self);
		_tmp7_ = sugar_homogene_table_get__max_pos (self);
		_tmp2_ = _tmp6_ > _tmp7_;
	}
	if (_tmp2_) {
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return;
	}
	sugar_homogene_table_get_frame_range (self, &_tmp8_);
	old_frame_range = _tmp8_;
	sugar_range_init (&_tmp9_);
	_tmp10_ = _tmp9_;
	self->priv->_frame_range = _tmp10_;
	_tmp11_ = gee_collection_get_size ((GeeCollection*) self->priv->_row_cache);
	_tmp12_ = g_array_sized_new (FALSE, TRUE, (gulong) ((guint) sizeof (void*)), (guint) _tmp11_);
	_data2_->spare_rows = _tmp12_;
	_tmp13_ = gee_collection_get_size ((GeeCollection*) self->priv->_row_cache);
	_tmp14_ = g_array_sized_new (FALSE, TRUE, (gulong) ((guint) sizeof (void*)), (guint) _tmp13_);
	visible_rows = _tmp14_;
	if (force) {
		{
			SugarHomogeneTable_Rows* _tmp15_;
			SugarHomogeneTable_Rows* _row_list;
			gint _tmp16_;
			gint _row_size;
			gint _row_index;
			_tmp15_ = _g_object_ref0 (self->priv->_row_cache);
			_row_list = _tmp15_;
			_tmp16_ = gee_collection_get_size ((GeeCollection*) _row_list);
			_row_size = _tmp16_;
			_row_index = -1;
			while (TRUE) {
				gpointer _tmp17_ = NULL;
				SugarHomogeneTable_Cells* row;
				_row_index = _row_index + 1;
				if (!(_row_index < _row_size)) {
					break;
				}
				_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _row_list, _row_index);
				row = (SugarHomogeneTable_Cells*) _tmp17_;
				g_array_append_val (_data2_->spare_rows, row);
				_g_object_unref0 (row);
			}
			_g_object_unref0 (_row_list);
		}
	} else {
		GCompareFunc cmp_rows = NULL;
		GtkOrientation _tmp27_;
		{
			SugarHomogeneTable_Rows* _tmp18_;
			SugarHomogeneTable_Rows* _row_list;
			gint _tmp19_;
			gint _row_size;
			gint _row_index;
			_tmp18_ = _g_object_ref0 (self->priv->_row_cache);
			_row_list = _tmp18_;
			_tmp19_ = gee_collection_get_size ((GeeCollection*) _row_list);
			_row_size = _tmp19_;
			_row_index = -1;
			while (TRUE) {
				gpointer _tmp20_ = NULL;
				SugarHomogeneTable_Cells* row;
				gint _tmp21_;
				gint row_pos;
				gboolean _tmp22_ = FALSE;
				gboolean _tmp23_ = FALSE;
				_row_index = _row_index + 1;
				if (!(_row_index < _row_size)) {
					break;
				}
				_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _row_list, _row_index);
				row = (SugarHomogeneTable_Cells*) _tmp20_;
				_tmp21_ = _sugar_homogene_table_get_row_pos (self, row);
				row_pos = _tmp21_;
				if (row_pos < 0) {
					_tmp23_ = TRUE;
				} else {
					gint _tmp24_;
					gint _tmp25_;
					_tmp24_ = sugar_homogene_table_get__pos (self);
					_tmp25_ = sugar_homogene_table_get__frame_length (self);
					_tmp23_ = row_pos > (_tmp24_ + _tmp25_);
				}
				if (_tmp23_) {
					_tmp22_ = TRUE;
				} else {
					gint _tmp26_;
					_tmp26_ = sugar_homogene_table_get__pos (self);
					_tmp22_ = (row_pos + self->priv->_cell_length) < _tmp26_;
				}
				if (_tmp22_) {
					g_array_append_val (_data2_->spare_rows, row);
				} else {
					g_array_append_val (visible_rows, row);
				}
				_g_object_unref0 (row);
			}
			_g_object_unref0 (_row_list);
		}
		_tmp27_ = sugar_homogene_table_get_orientation (self);
		if (_tmp27_ == GTK_ORIENTATION_HORIZONTAL) {
			cmp_rows = __lambda1__gcompare_func;
		} else {
			cmp_rows = __lambda2__gcompare_func;
		}
		g_array_sort (visible_rows, cmp_rows);
	}
	if (visible_rows->len > 0) {
		_tmp28_ = TRUE;
	} else {
		_tmp28_ = _data2_->spare_rows->len > 0;
	}
	if (_tmp28_) {
		Block3Data* _data3_;
		gint _tmp29_;
		gint _tmp30_;
		gint next_row_pos;
		SugarHomogeneTable_InsertSpareRow insert_spare_row;
		void* insert_spare_row_target = NULL;
		GDestroyNotify insert_spare_row_target_destroy_notify = NULL;
		gint _tmp34_;
		gint _tmp35_;
		_data3_ = g_slice_new0 (Block3Data);
		_data3_->_ref_count_ = 1;
		_data3_->_data2_ = block2_data_ref (_data2_);
		_data3_->spare_rows_sp = 0;
		_tmp29_ = sugar_homogene_table_get__pos (self);
		_tmp30_ = sugar_homogene_table_get__pos (self);
		next_row_pos = _tmp29_ - (_tmp30_ % self->priv->_cell_length);
		insert_spare_row = __lambda3__sugarhomogenetable_insertsparerow;
		insert_spare_row_target = block3_data_ref (_data3_);
		insert_spare_row_target_destroy_notify = block3_data_unref;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp31_;
				_tmp31_ = TRUE;
				while (TRUE) {
					SugarHomogeneTable_Cells* _tmp32_ = NULL;
					SugarHomogeneTable_Cells* row;
					gint _tmp33_;
					gint row_pos;
					if (!_tmp31_) {
						i = i + 1;
					}
					_tmp31_ = FALSE;
					if (!(i < visible_rows->len)) {
						break;
					}
					_tmp32_ = g_array_index (visible_rows, SugarHomogeneTable_Cells*, (guint) i);
					row = _tmp32_;
					_tmp33_ = _sugar_homogene_table_get_row_pos (self, row);
					row_pos = _tmp33_;
					insert_spare_row (next_row_pos, row_pos, insert_spare_row_target);
					_sugar_homogene_table_allocate_cells (self, row, row_pos);
					next_row_pos = row_pos + self->priv->_cell_length;
				}
			}
		}
		_tmp34_ = sugar_homogene_table_get__pos (self);
		_tmp35_ = sugar_homogene_table_get__frame_length (self);
		insert_spare_row (next_row_pos, _tmp34_ + _tmp35_, insert_spare_row_target);
		(insert_spare_row_target_destroy_notify == NULL) ? NULL : (insert_spare_row_target_destroy_notify (insert_spare_row_target), NULL);
		insert_spare_row = NULL;
		insert_spare_row_target = NULL;
		insert_spare_row_target_destroy_notify = NULL;
		block3_data_unref (_data3_);
		_data3_ = NULL;
	}
	_tmp36_ = sugar_container_get_child_x ((SugarContainer*) self);
	bin_x = _tmp36_;
	_tmp37_ = sugar_container_get_child_y ((SugarContainer*) self);
	_tmp38_ = sugar_homogene_table_get__pos (self);
	bin_y = _tmp37_ - _tmp38_;
	_tmp39_ = _sugar_homogene_table_rotate (self, bin_x, bin_y);
	_tmp40_ = _sugar_homogene_table_rotate (self, bin_y, bin_x);
	gdk_window_move (self->priv->_bin_window, _tmp39_, _tmp40_);
	gdk_window_process_updates (self->priv->_bin_window, TRUE);
	sugar_homogene_table_get_frame_range (self, &_tmp41_);
	_tmp42_ = sugar_range_is_equal (&_tmp41_, &old_frame_range);
	if (!_tmp42_) {
		g_signal_emit_by_name (self, "frame-scrolled");
	}
	_tmp44_ = sugar_homogene_table_get_focus_cell (self);
	if (_tmp44_) {
		SugarRange _tmp45_ = {0};
		gint _tmp46_;
		gboolean _tmp47_;
		sugar_homogene_table_get_frame_range (self, &_tmp45_);
		_tmp46_ = sugar_homogene_table_get_cursor (self);
		_tmp47_ = sugar_range_contains (&_tmp45_, _tmp46_);
		_tmp43_ = !_tmp47_;
	} else {
		_tmp43_ = FALSE;
	}
	if (_tmp43_) {
		sugar_homogene_table_set_focus_cell (self, FALSE);
	}
	_g_array_free0 (visible_rows);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}


static void _sugar_homogene_table_allocate_cells (SugarHomogeneTable* self, SugarHomogeneTable_Cells* row, gint cell_y) {
	gint cell_x;
	gint cell_row;
	gint _tmp0_;
	gint cell_index;
	gpointer _tmp17_ = NULL;
	SugarHomogeneTable_Cell* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	cell_x = 0;
	cell_row = cell_y / self->priv->_cell_length;
	_tmp0_ = sugar_homogene_table_get__column_count (self);
	cell_index = cell_row * _tmp0_;
	{
		gint cell_column;
		cell_column = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gpointer _tmp3_ = NULL;
				SugarHomogeneTable_Cell* cell;
				gint _tmp8_;
				gint _tmp9_;
				gint cell_thickness;
				gint _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				GdkRectangle _tmp14_ = {0};
				GdkRectangle child_allocation;
				if (!_tmp1_) {
					cell_column++;
				}
				_tmp1_ = FALSE;
				_tmp2_ = gee_collection_get_size ((GeeCollection*) row);
				if (!(cell_column < _tmp2_)) {
					break;
				}
				_tmp3_ = gee_abstract_list_get ((GeeAbstractList*) row, cell_column);
				cell = (SugarHomogeneTable_Cell*) _tmp3_;
				if (cell->index != cell_index) {
					gint _tmp4_;
					_tmp4_ = sugar_homogene_table_get_cell_count (self);
					if (cell_index < _tmp4_) {
						gboolean _tmp5_;
						GtkRequisition child_requisition = {0};
						GtkRequisition _tmp7_ = {0};
						sugar_homogene_table_fill_cell (self, cell->widget, cell_index);
						_tmp5_ = sugar_homogene_table_get_hover_selection (self);
						if (_tmp5_) {
							gint _tmp6_;
							_tmp6_ = sugar_homogene_table_get_cursor (self);
							sugar_homogene_table_highlight_cell (self, cell->widget, cell_index == _tmp6_);
						}
						gtk_widget_size_request (cell->widget, &_tmp7_);
						child_requisition = _tmp7_;
						gtk_widget_show (cell->widget);
					} else {
						gtk_widget_hide (cell->widget);
					}
					cell->index = cell_index;
				}
				_tmp8_ = sugar_homogene_table_get__thickness (self);
				_tmp9_ = sugar_homogene_table_get__column_count (self);
				cell_thickness = _tmp8_ / _tmp9_;
				_tmp10_ = _sugar_homogene_table_rotate (self, cell_x, cell_y);
				_tmp11_ = _sugar_homogene_table_rotate (self, cell_y, cell_x);
				_tmp12_ = _sugar_homogene_table_rotate (self, cell_thickness, self->priv->_cell_length);
				_tmp13_ = _sugar_homogene_table_rotate (self, self->priv->_cell_length, cell_thickness);
				_tmp14_.x = _tmp10_;
				_tmp14_.y = _tmp11_;
				_tmp14_.width = _tmp12_;
				_tmp14_.height = _tmp13_;
				child_allocation = _tmp14_;
				gtk_widget_size_allocate (cell->widget, &child_allocation);
				cell_x = cell_x + cell_thickness;
				cell_index++;
				_sugar_homogene_table__cell_unref0 (cell);
			}
		}
	}
	if (self->priv->_frame_range.start < 0) {
		gpointer _tmp15_ = NULL;
		SugarHomogeneTable_Cell* _tmp16_;
		_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) row, 0);
		_tmp16_ = (SugarHomogeneTable_Cell*) _tmp15_;
		self->priv->_frame_range.start = _tmp16_->index;
		_sugar_homogene_table__cell_unref0 (_tmp16_);
	}
	_tmp17_ = gee_abstract_list_last ((GeeAbstractList*) row);
	_tmp18_ = (SugarHomogeneTable_Cell*) _tmp17_;
	sugar_range_set_last (&self->priv->_frame_range, _tmp18_->index);
	_sugar_homogene_table__cell_unref0 (_tmp18_);
}


static void _sugar_homogene_table_reallocate_cells (SugarHomogeneTable* self) {
	g_return_if_fail (self != NULL);
	{
		SugarHomogeneTable_Cells* _tmp0_;
		SugarHomogeneTable_Cells* _cell_list;
		gint _tmp1_;
		gint _cell_size;
		gint _cell_index;
		_tmp0_ = _g_object_ref0 (self->priv->_cell_cache);
		_cell_list = _tmp0_;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _cell_list);
		_cell_size = _tmp1_;
		_cell_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			SugarHomogeneTable_Cell* cell;
			gboolean _tmp3_;
			GtkAllocation child_allocation;
			GtkRequisition child_requisition = {0};
			GtkRequisition _tmp4_ = {0};
			GdkRectangle _tmp5_;
			_cell_index = _cell_index + 1;
			if (!(_cell_index < _cell_size)) {
				break;
			}
			_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _cell_list, _cell_index);
			cell = (SugarHomogeneTable_Cell*) _tmp2_;
			_tmp3_ = sugar_homogene_table__cell_get_valid (cell);
			if (!_tmp3_) {
				_sugar_homogene_table__cell_unref0 (cell);
				continue;
			}
			child_allocation = cell->widget->allocation;
			gtk_widget_size_request (cell->widget, &_tmp4_);
			child_requisition = _tmp4_;
			_tmp5_ = (GdkRectangle) child_allocation;
			gtk_widget_size_allocate (cell->widget, &_tmp5_);
			_sugar_homogene_table__cell_unref0 (cell);
		}
		_g_object_unref0 (_cell_list);
	}
}


static void _sugar_homogene_table_adjustment_value_changed_cb (SugarHomogeneTable* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_sugar_homogene_table_allocate_rows (self, FALSE);
	_tmp0_ = sugar_homogene_table_get_hover_selection (self);
	if (_tmp0_) {
		gint x = 0;
		gint y = 0;
		gint _tmp1_;
		gint _tmp2_;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		gint _tmp6_;
		sugar_container_get_pointer ((SugarContainer*) self, &_tmp1_, &_tmp2_);
		x = _tmp1_;
		y = _tmp2_;
		_tmp6_ = sugar_container_get_child_x ((SugarContainer*) self);
		if (x >= _tmp6_) {
			gint _tmp7_;
			_tmp7_ = sugar_container_get_child_y ((SugarContainer*) self);
			_tmp5_ = y >= _tmp7_;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			gint _tmp8_;
			gint _tmp9_;
			_tmp8_ = sugar_container_get_child_x ((SugarContainer*) self);
			_tmp9_ = sugar_container_get_child_width ((SugarContainer*) self);
			_tmp4_ = x < (_tmp8_ + _tmp9_);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			gint _tmp10_;
			gint _tmp11_;
			_tmp10_ = sugar_container_get_child_y ((SugarContainer*) self);
			_tmp11_ = sugar_container_get_child_height ((SugarContainer*) self);
			_tmp3_ = y < (_tmp10_ + _tmp11_);
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			gint _tmp12_;
			_tmp12_ = sugar_homogene_table_get_index_at_pos (self, x, y);
			sugar_homogene_table_set_cursor (self, _tmp12_);
		}
	}
}


SugarHomogeneTable* sugar_homogene_table_construct (GType object_type) {
	SugarHomogeneTable * self = NULL;
	self = (SugarHomogeneTable*) sugar_container_construct (object_type);
	return self;
}


gint sugar_homogene_table_get_cell_count (SugarHomogeneTable* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_cell_count;
	return result;
}


void sugar_homogene_table_set_cell_count (SugarHomogeneTable* self, gint value) {
	g_return_if_fail (self != NULL);
	if (self->priv->_cell_count != value) {
		self->priv->_cell_count = value;
		_sugar_homogene_table_setup_adjustment (self, FALSE);
		_sugar_homogene_table_resize_table (self);
	}
	g_object_notify ((GObject *) self, "cell-count");
}


gint sugar_homogene_table_get_frame_width (SugarHomogeneTable* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_frame_width;
	return result;
}


void sugar_homogene_table_set_frame_width (SugarHomogeneTable* self, gint value) {
	g_return_if_fail (self != NULL);
	_sugar_homogene_table_set_metric (self, &self->priv->_frame_width, &self->priv->_cell_width, value);
	g_object_notify ((GObject *) self, "frame-width");
}


gint sugar_homogene_table_get_frame_height (SugarHomogeneTable* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_frame_height;
	return result;
}


void sugar_homogene_table_set_frame_height (SugarHomogeneTable* self, gint value) {
	g_return_if_fail (self != NULL);
	_sugar_homogene_table_set_metric (self, &self->priv->_frame_height, &self->priv->_cell_height, value);
	g_object_notify ((GObject *) self, "frame-height");
}


gint sugar_homogene_table_get_cell_width (SugarHomogeneTable* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_cell_width;
	return result;
}


void sugar_homogene_table_set_cell_width (SugarHomogeneTable* self, gint value) {
	g_return_if_fail (self != NULL);
	_sugar_homogene_table_set_metric (self, &self->priv->_cell_width, &self->priv->_frame_width, value);
	g_object_notify ((GObject *) self, "cell-width");
}


gint sugar_homogene_table_get_cell_height (SugarHomogeneTable* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_cell_height;
	return result;
}


void sugar_homogene_table_set_cell_height (SugarHomogeneTable* self, gint value) {
	g_return_if_fail (self != NULL);
	_sugar_homogene_table_set_metric (self, &self->priv->_cell_height, &self->priv->_frame_height, value);
	g_object_notify ((GObject *) self, "cell-height");
}


GtkOrientation sugar_homogene_table_get_orientation (SugarHomogeneTable* self) {
	GtkOrientation result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_orientation;
	return result;
}


void sugar_homogene_table_set_orientation (SugarHomogeneTable* self, GtkOrientation value) {
	g_return_if_fail (self != NULL);
	if (value != self->priv->_orientation) {
		GtkAdjustment* _tmp0_;
		GtkAdjustment* tmp;
		GtkAdjustment* _tmp1_;
		GtkAdjustment* _tmp2_;
		GtkAdjustment* _tmp3_;
		GtkAdjustment* _tmp4_;
		self->priv->_orientation = value;
		_tmp0_ = _g_object_ref0 (self->priv->_adjustments[0]);
		tmp = _tmp0_;
		_tmp1_ = _g_object_ref0 (self->priv->_adjustments[1]);
		_tmp2_ = _tmp1_;
		_g_object_unref0 (self->priv->_adjustments[0]);
		self->priv->_adjustments[0] = _tmp2_;
		_tmp3_ = _g_object_ref0 (tmp);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (self->priv->_adjustments[1]);
		self->priv->_adjustments[1] = _tmp4_;
		{
			GtkAdjustment** i_collection;
			int i_collection_length1;
			int i_it;
			i_collection = self->priv->_adjustments;
			i_collection_length1 = self->priv->_adjustments_length1;
			for (i_it = 0; i_it < self->priv->_adjustments_length1; i_it = i_it + 1) {
				GtkAdjustment* _tmp5_;
				GtkAdjustment* i;
				_tmp5_ = _g_object_ref0 (i_collection[i_it]);
				i = _tmp5_;
				{
					if (i != NULL) {
						gtk_adjustment_set_lower (i, (gdouble) 0);
						gtk_adjustment_set_upper (i, (gdouble) 0);
					}
					_g_object_unref0 (i);
				}
			}
		}
		_sugar_homogene_table_resize_table (self);
		_g_object_unref0 (tmp);
	}
	g_object_notify ((GObject *) self, "orientation");
}


gboolean sugar_homogene_table_get_hover_selection (SugarHomogeneTable* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_hover_selection;
	return result;
}


void sugar_homogene_table_set_hover_selection (SugarHomogeneTable* self, gboolean value) {
	g_return_if_fail (self != NULL);
	if (value != self->priv->_hover_selection) {
		gint _tmp0_;
		SugarHomogeneTable_Cell* _tmp1_ = NULL;
		SugarHomogeneTable_Cell* cell;
		if (value) {
			gtk_widget_add_events ((GtkWidget*) self, (gint) (GDK_POINTER_MOTION_HINT_MASK | GDK_POINTER_MOTION_MASK));
		}
		self->priv->_hover_selection = value;
		_tmp0_ = sugar_homogene_table_get_cursor (self);
		_tmp1_ = _sugar_homogene_table_get_cell (self, _tmp0_);
		cell = _tmp1_;
		if (cell != NULL) {
			sugar_homogene_table_highlight_cell (self, cell->widget, value);
		}
		_sugar_homogene_table__cell_unref0 (cell);
	}
	g_object_notify ((GObject *) self, "hover-selection");
}


gint sugar_homogene_table_get_cursor (SugarHomogeneTable* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_cursor_index;
	return result;
}


void sugar_homogene_table_set_cursor (SugarHomogeneTable* self, gint value) {
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint cell_index;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = MAX (0, value);
	_tmp1_ = sugar_homogene_table_get_cell_count (self);
	_tmp2_ = MIN (_tmp0_, _tmp1_ - 1);
	cell_index = _tmp2_;
	_tmp3_ = sugar_homogene_table_get_cursor (self);
	if (cell_index != _tmp3_) {
		sugar_homogene_table_scroll_to_cell (self, cell_index, FALSE);
		_sugar_homogene_table_set_cursor (self, cell_index);
	}
	g_object_notify ((GObject *) self, "cursor");
}


gboolean sugar_homogene_table_get_focus_cell (SugarHomogeneTable* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gint _tmp3_;
	SugarHomogeneTable_Cell* _tmp4_ = NULL;
	SugarHomogeneTable_Cell* cell;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = sugar_homogene_table_get_cursor (self);
	if (_tmp1_ < 0) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_;
		g_object_get ((GtkWidget*) self, "has-focus", &_tmp2_, NULL);
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp3_ = sugar_homogene_table_get_cursor (self);
	_tmp4_ = _sugar_homogene_table_get_cell (self, _tmp3_);
	cell = _tmp4_;
	if (cell != NULL) {
		GtkWidget* _tmp5_;
		GtkWidget* focus;
		_tmp5_ = _g_object_ref0 (cell->widget);
		focus = _tmp5_;
		while (TRUE) {
			gboolean _tmp6_ = FALSE;
			GtkContainer* _tmp8_ = NULL;
			GtkWidget* _tmp9_;
			if (focus != NULL) {
				GtkContainer* _tmp7_ = NULL;
				_tmp7_ = gtk_widget_get_parent (focus);
				_tmp6_ = _tmp7_ != NULL;
			} else {
				_tmp6_ = FALSE;
			}
			if (!_tmp6_) {
				break;
			}
			if (focus == GTK_WIDGET (self)) {
				result = TRUE;
				_g_object_unref0 (focus);
				_sugar_homogene_table__cell_unref0 (cell);
				return result;
			}
			_tmp8_ = gtk_widget_get_parent (focus);
			_tmp9_ = _g_object_ref0 ((GtkWidget*) _tmp8_);
			_g_object_unref0 (focus);
			focus = _tmp9_;
		}
		_g_object_unref0 (focus);
	}
	result = FALSE;
	_sugar_homogene_table__cell_unref0 (cell);
	return result;
}


void sugar_homogene_table_set_focus_cell (SugarHomogeneTable* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = sugar_homogene_table_get_focus_cell (self);
	if (value == _tmp0_) {
		return;
	}
	if (value) {
		gboolean _tmp1_;
		gint _tmp2_;
		SugarHomogeneTable_Cell* _tmp3_ = NULL;
		SugarHomogeneTable_Cell* cell;
		g_object_get ((GtkWidget*) self, "has-focus", &_tmp1_, NULL);
		if (!_tmp1_) {
			gtk_widget_grab_focus ((GtkWidget*) self);
		}
		_tmp2_ = sugar_homogene_table_get_cursor (self);
		_tmp3_ = _sugar_homogene_table_get_cell (self, _tmp2_);
		cell = _tmp3_;
		if (cell != NULL) {
			gtk_widget_child_focus (cell->widget, GTK_DIR_TAB_FORWARD);
		}
		_sugar_homogene_table__cell_unref0 (cell);
	} else {
		gtk_widget_grab_focus ((GtkWidget*) self);
	}
	g_object_notify ((GObject *) self, "focus-cell");
}


void sugar_homogene_table_get_frame_range (SugarHomogeneTable* self, SugarRange* result) {
	g_return_if_fail (self != NULL);
	*result = self->priv->_frame_range;
	return;
}


void sugar_homogene_table_set_frame_range (SugarHomogeneTable* self, SugarRange* value) {
	SugarRange _tmp0_ = {0};
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	sugar_homogene_table_get_frame_range (self, &_tmp0_);
	_tmp1_ = sugar_range_is_subset (value, &_tmp0_);
	if (_tmp1_) {
	} else {
		gint _tmp2_;
		SugarRange _tmp3_ = {0};
		gint _tmp4_;
		_tmp2_ = sugar_range_get_size (value);
		sugar_homogene_table_get_frame_range (self, &_tmp3_);
		_tmp4_ = sugar_range_get_size (&_tmp3_);
		if (_tmp2_ <= _tmp4_) {
			gint _tmp5_;
			_tmp5_ = sugar_range_get_last (value);
			sugar_homogene_table_scroll_to_cell (self, _tmp5_, FALSE);
			sugar_homogene_table_scroll_to_cell (self, (*value).start, FALSE);
		} else {
			gboolean _tmp6_ = FALSE;
			SugarRange _tmp7_ = {0};
			gboolean _tmp8_;
			sugar_homogene_table_get_frame_range (self, &_tmp7_);
			_tmp8_ = sugar_range_get_is_empty (&_tmp7_);
			if (_tmp8_) {
				_tmp6_ = TRUE;
			} else {
				SugarRange _tmp9_ = {0};
				sugar_homogene_table_get_frame_range (self, &_tmp9_);
				_tmp6_ = _tmp9_.start < (*value).start;
			}
			if (_tmp6_) {
				SugarRange _tmp10_ = {0};
				gint _tmp11_;
				sugar_homogene_table_get_frame_range (self, &_tmp10_);
				_tmp11_ = sugar_range_get_size (&_tmp10_);
				sugar_homogene_table_scroll_to_cell (self, ((*value).start + _tmp11_) - 1, FALSE);
			} else {
				SugarRange _tmp12_ = {0};
				gint _tmp13_;
				gint _tmp14_;
				sugar_homogene_table_get_frame_range (self, &_tmp12_);
				_tmp13_ = sugar_range_get_last (&_tmp12_);
				_tmp14_ = sugar_range_get_last (value);
				if (_tmp13_ > _tmp14_) {
					gint _tmp15_;
					SugarRange _tmp16_ = {0};
					gint _tmp17_;
					_tmp15_ = sugar_range_get_last (value);
					sugar_homogene_table_get_frame_range (self, &_tmp16_);
					_tmp17_ = sugar_range_get_size (&_tmp16_);
					sugar_homogene_table_scroll_to_cell (self, (_tmp15_ - _tmp17_) + 1, FALSE);
				}
			}
		}
	}
	g_object_notify ((GObject *) self, "frame-range");
}


gint sugar_homogene_table_get_frame_size (SugarHomogeneTable* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = gee_collection_get_size ((GeeCollection*) self->priv->_cell_cache);
	result = _tmp0_;
	return result;
}


gboolean sugar_homogene_table_get_is_empty (SugarHomogeneTable* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = gee_collection_get_size ((GeeCollection*) self->priv->_row_cache);
	if (_tmp1_ == 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->_cell_length == 0;
	}
	result = _tmp0_;
	return result;
}


static gint sugar_homogene_table_get__column_count (SugarHomogeneTable* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = gee_collection_get_size ((GeeCollection*) self->priv->_row_cache);
	if (_tmp0_ > 0) {
		gpointer _tmp1_ = NULL;
		SugarHomogeneTable_Cells* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp1_ = gee_abstract_list_get ((GeeAbstractList*) self->priv->_row_cache, 0);
		_tmp2_ = (SugarHomogeneTable_Cells*) _tmp1_;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		result = _tmp4_;
		return result;
	} else {
		result = 0;
		return result;
	}
}


static gint sugar_homogene_table_get__frame_row_count (SugarHomogeneTable* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = gee_collection_get_size ((GeeCollection*) self->priv->_row_cache);
	result = _tmp0_ - SUGAR_HOMOGENE_TABLE__SPARE_ROWS_COUNT;
	return result;
}


static gint sugar_homogene_table_get__pos (SugarHomogeneTable* self) {
	gint result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	if (self->priv->_adjustments[0] == NULL) {
		_tmp0_ = TRUE;
	} else {
		gdouble _tmp1_;
		gboolean _tmp2_;
		_tmp1_ = gtk_adjustment_get_value (self->priv->_adjustments[0]);
		_tmp2_ = isnan (_tmp1_);
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		result = 0;
		return result;
	} else {
		gdouble _tmp3_;
		gint _tmp4_;
		_tmp3_ = gtk_adjustment_get_value (self->priv->_adjustments[0]);
		_tmp4_ = MAX (0, (gint) _tmp3_);
		result = _tmp4_;
		return result;
	}
}


static void sugar_homogene_table_set__pos (SugarHomogeneTable* self, gint value) {
	g_return_if_fail (self != NULL);
	if (self->priv->_adjustments[0] != NULL) {
		gtk_adjustment_set_value (self->priv->_adjustments[0], (gdouble) value);
	}
}


static gint sugar_homogene_table_get__max_pos (SugarHomogeneTable* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	if (self->priv->_adjustments[0] == NULL) {
		result = 0;
		return result;
	} else {
		gint _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		_tmp0_ = sugar_homogene_table_get__length (self);
		_tmp1_ = sugar_homogene_table_get__frame_length (self);
		_tmp2_ = MAX (0, _tmp0_ - _tmp1_);
		result = _tmp2_;
		return result;
	}
}


static gint sugar_homogene_table_get__thickness (SugarHomogeneTable* self) {
	gint result;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = sugar_container_get_child_width ((SugarContainer*) self);
	_tmp1_ = sugar_container_get_child_height ((SugarContainer*) self);
	_tmp2_ = _sugar_homogene_table_rotate (self, _tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


static gint sugar_homogene_table_get__frame_length (SugarHomogeneTable* self) {
	gint result;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = sugar_container_get_child_height ((SugarContainer*) self);
	_tmp1_ = sugar_container_get_child_width ((SugarContainer*) self);
	_tmp2_ = _sugar_homogene_table_rotate (self, _tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


static gint sugar_homogene_table_get__length (SugarHomogeneTable* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	if (self->priv->_adjustments[0] == NULL) {
		gint _tmp0_;
		_tmp0_ = sugar_homogene_table_get__frame_length (self);
		result = _tmp0_;
		return result;
	} else {
		gdouble _tmp1_;
		_tmp1_ = gtk_adjustment_get_upper (self->priv->_adjustments[0]);
		result = (gint) _tmp1_;
		return result;
	}
}


static void __sugar_homogene_table_adjustment_value_changed_cb_gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self) {
	_sugar_homogene_table_adjustment_value_changed_cb (self);
}


static void sugar_homogene_table_real_signal_set_scroll_adjustments (SugarHomogeneTable* self, GtkAdjustment* hadjustment, GtkAdjustment* vadjustment) {
	gboolean _tmp2_ = FALSE;
	gint _tmp4_;
	GtkAdjustment* _tmp5_;
	GtkAdjustment* _tmp6_;
	gint _tmp7_;
	GtkAdjustment* _tmp8_;
	GtkAdjustment* _tmp9_;
	g_return_if_fail (self != NULL);
	{
		GtkAdjustment** i_collection;
		int i_collection_length1;
		int i_it;
		i_collection = self->priv->_adjustments;
		i_collection_length1 = self->priv->_adjustments_length1;
		for (i_it = 0; i_it < self->priv->_adjustments_length1; i_it = i_it + 1) {
			GtkAdjustment* _tmp0_;
			GtkAdjustment* i;
			_tmp0_ = _g_object_ref0 (i_collection[i_it]);
			i = _tmp0_;
			{
				if (i != NULL) {
					guint _tmp1_;
					g_signal_parse_name ("value-changed", GTK_TYPE_ADJUSTMENT, &_tmp1_, NULL, FALSE);
					g_signal_handlers_disconnect_matched (i, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) __sugar_homogene_table_adjustment_value_changed_cb_gtk_adjustment_value_changed, self);
				}
				_g_object_unref0 (i);
			}
		}
	}
	if (vadjustment == NULL) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = hadjustment == NULL;
	}
	if (_tmp2_) {
		GtkAdjustment** _tmp3_ = NULL;
		_tmp3_ = g_new0 (GtkAdjustment*, 2 + 1);
		_tmp3_[0] = NULL;
		_tmp3_[1] = NULL;
		self->priv->_adjustments = (_vala_array_free (self->priv->_adjustments, self->priv->_adjustments_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->_adjustments = _tmp3_;
		self->priv->_adjustments_length1 = 2;
		self->priv->__adjustments_size_ = 2;
		return;
	}
	_tmp4_ = _sugar_homogene_table_rotate (self, 0, 1);
	_tmp5_ = _g_object_ref0 (vadjustment);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (self->priv->_adjustments[_tmp4_]);
	self->priv->_adjustments[_tmp4_] = _tmp6_;
	g_signal_connect_object (vadjustment, "value-changed", (GCallback) __sugar_homogene_table_adjustment_value_changed_cb_gtk_adjustment_value_changed, self, 0);
	_tmp7_ = _sugar_homogene_table_rotate (self, 1, 0);
	_tmp8_ = _g_object_ref0 (hadjustment);
	_tmp9_ = _tmp8_;
	_g_object_unref0 (self->priv->_adjustments[_tmp7_]);
	self->priv->_adjustments[_tmp7_] = _tmp9_;
	g_signal_connect_object (hadjustment, "value-changed", (GCallback) __sugar_homogene_table_adjustment_value_changed_cb_gtk_adjustment_value_changed, self, 0);
	_sugar_homogene_table_setup_adjustment (self, TRUE);
}


static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
}


static GObject * sugar_homogene_table_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SugarHomogeneTable * self;
	parent_class = G_OBJECT_CLASS (sugar_homogene_table_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SUGAR_HOMOGENE_TABLE (obj);
	g_object_set ((GtkWidget*) self, "can-focus", TRUE, NULL);
	return obj;
}


static void sugar_homogene_table__cell_invalidate_pos (SugarHomogeneTable_Cell* self) {
	GdkRectangle _tmp0_ = {0};
	GdkRectangle null_allocation;
	g_return_if_fail (self != NULL);
	_tmp0_.x = -1;
	_tmp0_.y = -1;
	_tmp0_.width = 0;
	_tmp0_.height = 0;
	null_allocation = _tmp0_;
	gtk_widget_size_allocate (self->widget, &null_allocation);
}


static SugarHomogeneTable_Cell* sugar_homogene_table__cell_construct (GType object_type) {
	SugarHomogeneTable_Cell* self = NULL;
	self = (SugarHomogeneTable_Cell*) g_type_create_instance (object_type);
	return self;
}


static SugarHomogeneTable_Cell* sugar_homogene_table__cell_new (void) {
	return sugar_homogene_table__cell_construct (SUGAR_HOMOGENE_TABLE_TYPE__CELL);
}


static gboolean sugar_homogene_table__cell_get_valid (SugarHomogeneTable_Cell* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->index >= 0) {
		_tmp2_ = self->widget != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = self->widget->allocation.x >= 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = self->widget->allocation.y >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static void sugar_homogene_table_value__cell_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void sugar_homogene_table_value__cell_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		sugar_homogene_table__cell_unref (value->data[0].v_pointer);
	}
}


static void sugar_homogene_table_value__cell_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = sugar_homogene_table__cell_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer sugar_homogene_table_value__cell_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* sugar_homogene_table_value__cell_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		SugarHomogeneTable_Cell* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = sugar_homogene_table__cell_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* sugar_homogene_table_value__cell_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	SugarHomogeneTable_Cell** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = sugar_homogene_table__cell_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec* sugar_homogene_table_param_spec__cell (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	SugarHomogeneTableParamSpec_Cell* spec;
	g_return_val_if_fail (g_type_is_a (object_type, SUGAR_HOMOGENE_TABLE_TYPE__CELL), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer sugar_homogene_table_value_get__cell (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SUGAR_HOMOGENE_TABLE_TYPE__CELL), NULL);
	return value->data[0].v_pointer;
}


static void sugar_homogene_table_value_set__cell (GValue* value, gpointer v_object) {
	SugarHomogeneTable_Cell* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SUGAR_HOMOGENE_TABLE_TYPE__CELL));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SUGAR_HOMOGENE_TABLE_TYPE__CELL));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		sugar_homogene_table__cell_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		sugar_homogene_table__cell_unref (old);
	}
}


static void sugar_homogene_table_value_take__cell (GValue* value, gpointer v_object) {
	SugarHomogeneTable_Cell* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SUGAR_HOMOGENE_TABLE_TYPE__CELL));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SUGAR_HOMOGENE_TABLE_TYPE__CELL));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		sugar_homogene_table__cell_unref (old);
	}
}


static void sugar_homogene_table__cell_class_init (SugarHomogeneTable_CellClass * klass) {
	sugar_homogene_table__cell_parent_class = g_type_class_peek_parent (klass);
	SUGAR_HOMOGENE_TABLE__CELL_CLASS (klass)->finalize = sugar_homogene_table__cell_finalize;
}


static void sugar_homogene_table__cell_instance_init (SugarHomogeneTable_Cell * self) {
	self->widget = NULL;
	self->index = -1;
	self->ref_count = 1;
}


static void sugar_homogene_table__cell_finalize (SugarHomogeneTable_Cell* obj) {
	SugarHomogeneTable_Cell * self;
	self = SUGAR_HOMOGENE_TABLE__CELL (obj);
	_g_object_unref0 (self->widget);
}


static GType sugar_homogene_table__cell_get_type (void) {
	static volatile gsize sugar_homogene_table__cell_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_homogene_table__cell_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { sugar_homogene_table_value__cell_init, sugar_homogene_table_value__cell_free_value, sugar_homogene_table_value__cell_copy_value, sugar_homogene_table_value__cell_peek_pointer, "p", sugar_homogene_table_value__cell_collect_value, "p", sugar_homogene_table_value__cell_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (SugarHomogeneTable_CellClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar_homogene_table__cell_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SugarHomogeneTable_Cell), 0, (GInstanceInitFunc) sugar_homogene_table__cell_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType sugar_homogene_table__cell_type_id;
		sugar_homogene_table__cell_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SugarHomogeneTable_Cell", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&sugar_homogene_table__cell_type_id__volatile, sugar_homogene_table__cell_type_id);
	}
	return sugar_homogene_table__cell_type_id__volatile;
}


static gpointer sugar_homogene_table__cell_ref (gpointer instance) {
	SugarHomogeneTable_Cell* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void sugar_homogene_table__cell_unref (gpointer instance) {
	SugarHomogeneTable_Cell* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SUGAR_HOMOGENE_TABLE__CELL_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static SugarHomogeneTable_Cells* sugar_homogene_table__cells_construct (GType object_type) {
	SugarHomogeneTable_Cells * self = NULL;
	self = (SugarHomogeneTable_Cells*) gee_array_list_construct (object_type, SUGAR_HOMOGENE_TABLE_TYPE__CELL, (GBoxedCopyFunc) sugar_homogene_table__cell_ref, sugar_homogene_table__cell_unref, NULL);
	return self;
}


static SugarHomogeneTable_Cells* sugar_homogene_table__cells_new (void) {
	return sugar_homogene_table__cells_construct (SUGAR_HOMOGENE_TABLE_TYPE__CELLS);
}


static void sugar_homogene_table__cells_class_init (SugarHomogeneTable_CellsClass * klass) {
	sugar_homogene_table__cells_parent_class = g_type_class_peek_parent (klass);
}


static void sugar_homogene_table__cells_instance_init (SugarHomogeneTable_Cells * self) {
}


static GType sugar_homogene_table__cells_get_type (void) {
	static volatile gsize sugar_homogene_table__cells_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_homogene_table__cells_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SugarHomogeneTable_CellsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar_homogene_table__cells_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SugarHomogeneTable_Cells), 0, (GInstanceInitFunc) sugar_homogene_table__cells_instance_init, NULL };
		GType sugar_homogene_table__cells_type_id;
		sugar_homogene_table__cells_type_id = g_type_register_static (GEE_TYPE_ARRAY_LIST, "SugarHomogeneTable_Cells", &g_define_type_info, 0);
		g_once_init_leave (&sugar_homogene_table__cells_type_id__volatile, sugar_homogene_table__cells_type_id);
	}
	return sugar_homogene_table__cells_type_id__volatile;
}


static SugarHomogeneTable_Rows* sugar_homogene_table__rows_construct (GType object_type) {
	SugarHomogeneTable_Rows * self = NULL;
	self = (SugarHomogeneTable_Rows*) gee_array_list_construct (object_type, SUGAR_HOMOGENE_TABLE_TYPE__CELLS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	return self;
}


static SugarHomogeneTable_Rows* sugar_homogene_table__rows_new (void) {
	return sugar_homogene_table__rows_construct (SUGAR_HOMOGENE_TABLE_TYPE__ROWS);
}


static void sugar_homogene_table__rows_class_init (SugarHomogeneTable_RowsClass * klass) {
	sugar_homogene_table__rows_parent_class = g_type_class_peek_parent (klass);
}


static void sugar_homogene_table__rows_instance_init (SugarHomogeneTable_Rows * self) {
}


static GType sugar_homogene_table__rows_get_type (void) {
	static volatile gsize sugar_homogene_table__rows_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_homogene_table__rows_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SugarHomogeneTable_RowsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar_homogene_table__rows_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SugarHomogeneTable_Rows), 0, (GInstanceInitFunc) sugar_homogene_table__rows_instance_init, NULL };
		GType sugar_homogene_table__rows_type_id;
		sugar_homogene_table__rows_type_id = g_type_register_static (GEE_TYPE_ARRAY_LIST, "SugarHomogeneTable_Rows", &g_define_type_info, 0);
		g_once_init_leave (&sugar_homogene_table__rows_type_id__volatile, sugar_homogene_table__rows_type_id);
	}
	return sugar_homogene_table__rows_type_id__volatile;
}


static void sugar_homogene_table_class_init (SugarHomogeneTableClass * klass) {
	sugar_homogene_table_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SugarHomogeneTablePrivate));
	G_OBJECT_CLASS (klass)->dispose = sugar_homogene_table_real_dispose;
	SUGAR_HOMOGENE_TABLE_CLASS (klass)->new_cell = sugar_homogene_table_real_new_cell;
	SUGAR_HOMOGENE_TABLE_CLASS (klass)->fill_cell = sugar_homogene_table_real_fill_cell;
	SUGAR_HOMOGENE_TABLE_CLASS (klass)->highlight_cell = sugar_homogene_table_real_highlight_cell;
	GTK_WIDGET_CLASS (klass)->scroll_event = sugar_homogene_table_real_scroll_event;
	GTK_WIDGET_CLASS (klass)->realize = sugar_homogene_table_real_realize;
	GTK_WIDGET_CLASS (klass)->size_allocate = sugar_homogene_table_real_size_allocate;
	GTK_WIDGET_CLASS (klass)->unrealize = sugar_homogene_table_real_unrealize;
	GTK_WIDGET_CLASS (klass)->style_set = sugar_homogene_table_real_style_set;
	GTK_WIDGET_CLASS (klass)->expose_event = sugar_homogene_table_real_expose_event;
	GTK_WIDGET_CLASS (klass)->map = sugar_homogene_table_real_map;
	GTK_WIDGET_CLASS (klass)->size_request = sugar_homogene_table_real_size_request;
	GTK_WIDGET_CLASS (klass)->motion_notify_event = sugar_homogene_table_real_motion_notify_event;
	GTK_WIDGET_CLASS (klass)->key_press_event = sugar_homogene_table_real_key_press_event;
	GTK_CONTAINER_CLASS (klass)->forall = sugar_homogene_table_real_forall_internal;
	GTK_CONTAINER_CLASS (klass)->add = sugar_homogene_table_real_add;
	GTK_CONTAINER_CLASS (klass)->remove = sugar_homogene_table_real_remove;
	GTK_CONTAINER_CLASS (klass)->set_focus_child = sugar_homogene_table_real_set_focus_child;
	GTK_WIDGET_CLASS (klass)->focus = sugar_homogene_table_real_focus;
	SUGAR_HOMOGENE_TABLE_CLASS (klass)->signal_set_scroll_adjustments = sugar_homogene_table_real_signal_set_scroll_adjustments;
	G_OBJECT_CLASS (klass)->get_property = _vala_sugar_homogene_table_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sugar_homogene_table_set_property;
	G_OBJECT_CLASS (klass)->constructor = sugar_homogene_table_constructor;
	G_OBJECT_CLASS (klass)->finalize = sugar_homogene_table_finalize;
	/**
	     * Number of virtual cells
	     *
	     * Defines maximal number of virtual rows, the minimal has being described
	     * by frame_size/cell_size values.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_HOMOGENE_TABLE_CELL_COUNT, g_param_spec_int ("cell-count", "cell-count", "cell-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Persistent number of frame columns
	     *
	     * Cells will be resized while resizing widget to keep
	     * frame column count the same.
	     * Mutually exclusive to cell_width.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_HOMOGENE_TABLE_FRAME_WIDTH, g_param_spec_int ("frame-width", "frame-width", "frame-width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Persistent number of frame rows
	     *
	     * Cells will be resized while resizing widget to keep
	     * frame row count the same.
	     * Mutually exclusive to cell_height.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_HOMOGENE_TABLE_FRAME_HEIGHT, g_param_spec_int ("frame-height", "frame-height", "frame-height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Persistent cell width
	     *
	     * Number of cells will be changed while resizing widget to keep
	     * cells width the same.
	     * Mutually exclusive to frame_width.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_HOMOGENE_TABLE_CELL_WIDTH, g_param_spec_int ("cell-width", "cell-width", "cell-width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Persistent cell height
	     *
	     * Number of cells will be changed while resizing widget to keep
	     * cells height the same.
	     * Mutually exclusive to frame_height.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_HOMOGENE_TABLE_CELL_HEIGHT, g_param_spec_int ("cell-height", "cell-height", "cell-height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Table orientation
	     *
	     * If orientation is vertical (by default), table will have persistent
	     * number of columns and variable row count and vice versa if orientation
	     * is horizontal.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_HOMOGENE_TABLE_ORIENTATION, g_param_spec_enum ("orientation", "orientation", "orientation", GTK_TYPE_ORIENTATION, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Highlight cell which is under mouse pointer
	     *
	     * While moving mouse pointer, highlight_cell function will be invoked.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_HOMOGENE_TABLE_HOVER_SELECTION, g_param_spec_boolean ("hover-selection", "hover-selection", "hover-selection", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Absolute index of the focused cell
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_HOMOGENE_TABLE_CURSOR, g_param_spec_int ("cursor", "cursor", "cursor", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Is cell focused
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_HOMOGENE_TABLE_FOCUS_CELL, g_param_spec_boolean ("focus-cell", "focus-cell", "focus-cell", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Range of visible cells
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_HOMOGENE_TABLE_FRAME_RANGE, g_param_spec_boxed ("frame-range", "frame-range", "frame-range", SUGAR_TYPE_RANGE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Number of created cells
	     *
	     * This is not about exact number of frame cells visible right now,
	     * just the maximal number of cells that might be in the frame.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_HOMOGENE_TABLE_FRAME_SIZE, g_param_spec_int ("frame-size", "frame-size", "frame-size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * Where there are no cells
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_HOMOGENE_TABLE_IS_EMPTY, g_param_spec_boolean ("is-empty", "is-empty", "is-empty", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * Scroll event used internally by widgets like GtkScrolledWindow
	     *
	     * XXX Since there is no regualr way to set set_scroll_adjustments_signal
	     *     Makefile.am seds resulted homogenetable.c file
	     */
	GTK_WIDGET_CLASS (klass)->set_scroll_adjustments_signal = g_signal_new ("signal_set_scroll_adjustments", SUGAR_TYPE_HOMOGENE_TABLE, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (SugarHomogeneTableClass, signal_set_scroll_adjustments), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, GTK_TYPE_ADJUSTMENT, GTK_TYPE_ADJUSTMENT);
	/**
	     * Current cell was changed
	     */
	g_signal_new ("cursor_changed", SUGAR_TYPE_HOMOGENE_TABLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/**
	     * Visible cells frame was changed
	     */
	g_signal_new ("frame_scrolled", SUGAR_TYPE_HOMOGENE_TABLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void sugar_homogene_table_instance_init (SugarHomogeneTable * self) {
	SugarHomogeneTable_Cells* _tmp0_ = NULL;
	SugarHomogeneTable_Rows* _tmp1_ = NULL;
	GtkAdjustment** _tmp2_ = NULL;
	SugarRange _tmp3_ = {0};
	SugarRange _tmp4_ = {0};
	self->priv = SUGAR_HOMOGENE_TABLE_GET_PRIVATE (self);
	_tmp0_ = sugar_homogene_table__cells_new ();
	self->priv->_cell_cache = _tmp0_;
	_tmp1_ = sugar_homogene_table__rows_new ();
	self->priv->_row_cache = _tmp1_;
	self->priv->_cell_cache_pos = 0;
	_tmp2_ = g_new0 (GtkAdjustment*, 2 + 1);
	_tmp2_[0] = NULL;
	_tmp2_[1] = NULL;
	self->priv->_adjustments = _tmp2_;
	self->priv->_adjustments_length1 = 2;
	self->priv->__adjustments_size_ = self->priv->_adjustments_length1;
	self->priv->_bin_window = NULL;
	self->priv->_cell_count = 0;
	self->priv->_cell_length = 0;
	self->priv->_frame_width = 0;
	self->priv->_frame_height = 0;
	self->priv->_cell_width = 0;
	self->priv->_cell_height = 0;
	self->priv->_cursor_index = -1;
	self->priv->_pending_allocate = -1;
	sugar_range_init (&_tmp3_);
	_tmp4_ = _tmp3_;
	self->priv->_frame_range = _tmp4_;
	self->priv->_orientation = GTK_ORIENTATION_VERTICAL;
	self->priv->_hover_selection = FALSE;
}


static void sugar_homogene_table_finalize (GObject* obj) {
	SugarHomogeneTable * self;
	self = SUGAR_HOMOGENE_TABLE (obj);
	_g_object_unref0 (self->priv->_cell_cache);
	_g_object_unref0 (self->priv->_row_cache);
	self->priv->_adjustments = (_vala_array_free (self->priv->_adjustments, self->priv->_adjustments_length1, (GDestroyNotify) g_object_unref), NULL);
	G_OBJECT_CLASS (sugar_homogene_table_parent_class)->finalize (obj);
}


/**
 * Grid widget with homogeneously placed children of the same class.
 *
 * Grid has fixed number of columns that are visible all time and unlimited
 * rows number (or vice versa if orientation is horizontal). There are frame
 * cells - visible at particular moment - frame cells and virtual (widget is
 * model less itself and only ask callback object about right cell's value)
 * ones - just cells. User can scroll up/down (or left/right if orientation is
 * horizontal) grid to see all virtual cells and the same frame cell will
 * represent content of various virtual cells (widget will call fill_cell to
 * refill frame cell content) in different time moments.
 *
 * There is no way to add cells manually, widget will create them on demand
 * by invoking passed new_cell. By default, widget doesn't have any cells,
 * to make it useful, assign proper value to either frame_width/frame_height or
 * cell_width/cell_height properties. Also set cell_count to set number
 * of virtual cells.
 *
 * Before using widget, inherit it and overload methods:
 *
 *  new_cell
 *  fill_cell
 *  highlight_cell
 *
 * NOTE Since widget is not cell renderers based and uses regular widgets
 * to represent cells, haivng many visible at the same time cells will affect
 * performance, especially with heavy gtk themes.
 *
 * See examples/homogenetable.py for exmaples.
 */
GType sugar_homogene_table_get_type (void) {
	static volatile gsize sugar_homogene_table_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_homogene_table_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SugarHomogeneTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar_homogene_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SugarHomogeneTable), 0, (GInstanceInitFunc) sugar_homogene_table_instance_init, NULL };
		GType sugar_homogene_table_type_id;
		sugar_homogene_table_type_id = g_type_register_static (SUGAR_TYPE_CONTAINER, "SugarHomogeneTable", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&sugar_homogene_table_type_id__volatile, sugar_homogene_table_type_id);
	}
	return sugar_homogene_table_type_id__volatile;
}


static void _vala_sugar_homogene_table_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SugarHomogeneTable * self;
	SugarRange boxed0;
	self = SUGAR_HOMOGENE_TABLE (object);
	switch (property_id) {
		case SUGAR_HOMOGENE_TABLE_CELL_COUNT:
		g_value_set_int (value, sugar_homogene_table_get_cell_count (self));
		break;
		case SUGAR_HOMOGENE_TABLE_FRAME_WIDTH:
		g_value_set_int (value, sugar_homogene_table_get_frame_width (self));
		break;
		case SUGAR_HOMOGENE_TABLE_FRAME_HEIGHT:
		g_value_set_int (value, sugar_homogene_table_get_frame_height (self));
		break;
		case SUGAR_HOMOGENE_TABLE_CELL_WIDTH:
		g_value_set_int (value, sugar_homogene_table_get_cell_width (self));
		break;
		case SUGAR_HOMOGENE_TABLE_CELL_HEIGHT:
		g_value_set_int (value, sugar_homogene_table_get_cell_height (self));
		break;
		case SUGAR_HOMOGENE_TABLE_ORIENTATION:
		g_value_set_enum (value, sugar_homogene_table_get_orientation (self));
		break;
		case SUGAR_HOMOGENE_TABLE_HOVER_SELECTION:
		g_value_set_boolean (value, sugar_homogene_table_get_hover_selection (self));
		break;
		case SUGAR_HOMOGENE_TABLE_CURSOR:
		g_value_set_int (value, sugar_homogene_table_get_cursor (self));
		break;
		case SUGAR_HOMOGENE_TABLE_FOCUS_CELL:
		g_value_set_boolean (value, sugar_homogene_table_get_focus_cell (self));
		break;
		case SUGAR_HOMOGENE_TABLE_FRAME_RANGE:
		sugar_homogene_table_get_frame_range (self, &boxed0);
		g_value_set_boxed (value, &boxed0);
		break;
		case SUGAR_HOMOGENE_TABLE_FRAME_SIZE:
		g_value_set_int (value, sugar_homogene_table_get_frame_size (self));
		break;
		case SUGAR_HOMOGENE_TABLE_IS_EMPTY:
		g_value_set_boolean (value, sugar_homogene_table_get_is_empty (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_sugar_homogene_table_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SugarHomogeneTable * self;
	self = SUGAR_HOMOGENE_TABLE (object);
	switch (property_id) {
		case SUGAR_HOMOGENE_TABLE_CELL_COUNT:
		sugar_homogene_table_set_cell_count (self, g_value_get_int (value));
		break;
		case SUGAR_HOMOGENE_TABLE_FRAME_WIDTH:
		sugar_homogene_table_set_frame_width (self, g_value_get_int (value));
		break;
		case SUGAR_HOMOGENE_TABLE_FRAME_HEIGHT:
		sugar_homogene_table_set_frame_height (self, g_value_get_int (value));
		break;
		case SUGAR_HOMOGENE_TABLE_CELL_WIDTH:
		sugar_homogene_table_set_cell_width (self, g_value_get_int (value));
		break;
		case SUGAR_HOMOGENE_TABLE_CELL_HEIGHT:
		sugar_homogene_table_set_cell_height (self, g_value_get_int (value));
		break;
		case SUGAR_HOMOGENE_TABLE_ORIENTATION:
		sugar_homogene_table_set_orientation (self, g_value_get_enum (value));
		break;
		case SUGAR_HOMOGENE_TABLE_HOVER_SELECTION:
		sugar_homogene_table_set_hover_selection (self, g_value_get_boolean (value));
		break;
		case SUGAR_HOMOGENE_TABLE_CURSOR:
		sugar_homogene_table_set_cursor (self, g_value_get_int (value));
		break;
		case SUGAR_HOMOGENE_TABLE_FOCUS_CELL:
		sugar_homogene_table_set_focus_cell (self, g_value_get_boolean (value));
		break;
		case SUGAR_HOMOGENE_TABLE_FRAME_RANGE:
		sugar_homogene_table_set_frame_range (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



