/* sugar-gui.vapi generated by valac, do not modify. */

[CCode (cprefix = "Sugar", lower_case_cprefix = "sugar_")]
namespace Sugar {
	[CCode (cprefix = "SugarPaletteGroups", lower_case_cprefix = "sugar_palette_groups_")]
	namespace PaletteGroups {
		[CCode (cheader_filename = "gui.h")]
		public static Sugar.PaletteGroup @get (string group_id);
		[CCode (cheader_filename = "gui.h")]
		public static void popdown_all ();
	}
	[CCode (ref_function = "sugar_accelerator_ref", unref_function = "sugar_accelerator_unref", cheader_filename = "gui.h")]
	public class Accelerator {
		public Accelerator (Gtk.Widget accel_widget, string signal_name);
		public string? name { get; set; }
	}
	[CCode (cheader_filename = "gui.h")]
	public class Alignment : Sugar.Bin {
		public Alignment ();
		public override void size_allocate (Gdk.Rectangle allocation);
		public override void size_request (out Gtk.Requisition requisition);
		public override int child_height { get; }
		public override int child_width { get; }
		public override int child_x { get; }
		public override int child_y { get; }
		public float xalign { get; set; }
		public bool xignore { get; set; }
		public float xscale { get; set; }
		public float yalign { get; set; }
		public bool yignore { get; set; }
		public float yscale { get; set; }
	}
	[CCode (cheader_filename = "gui.h")]
	public class Animator : GLib.Object {
		public Animator (double duration, int fps = 20, double start = 0.0, double stop = 1.0, Sugar.AnimationType type = Sugar.AnimationType.OUT_EXPO);
		public void abort ();
		public void start ();
		public bool active { get; }
		public signal void completed (bool aborted);
		public signal void next_frame (double frame);
	}
	[CCode (cheader_filename = "gui.h")]
	public class Bin : Sugar.Container {
		public Bin ();
		public override void add (Gtk.Widget widget);
		public override GLib.Type child_type ();
		public override void forall_internal (bool include_internal, Gtk.Callback callback);
		public override void remove (Gtk.Widget widget);
		public override void size_allocate (Gdk.Rectangle allocation);
		public override void size_request (out Gtk.Requisition requisition);
		public Gtk.Widget child { get; set; }
	}
	[CCode (cheader_filename = "gui.h")]
	public class Box : Sugar.Container {
		protected GLib.List<Gtk.Widget> children;
		public Box ();
		public override void add (Gtk.Widget widget);
		public override void forall_internal (bool include_internal, Gtk.Callback callback);
		public override void remove (Gtk.Widget widget);
		public int children_count { get; set; }
		public virtual signal void insert (Gtk.Widget widget, int pos);
	}
	[CCode (cheader_filename = "gui.h")]
	public class ComboToolButton : Sugar.ToolButton {
		public ComboToolButton ();
		public override void clicked ();
	}
	[CCode (cheader_filename = "gui.h")]
	public abstract class Connector : GLib.Object {
		[CCode (type_id = "SUGAR_CONNECTOR_TYPE_ALIGNMENT", cheader_filename = "gui.h")]
		protected struct Alignment {
			public float palette_halign;
			public float palette_valign;
			public float invoker_halign;
			public float invoker_valign;
			public int position;
		}
		public Connector ();
		public abstract void draw_rectangle (Gdk.EventExpose event, Sugar.PaletteWindow palette);
		protected virtual unowned Sugar.Connector.Alignment[] get_alignments ();
		public static bool get_box_gap (Gdk.Rectangle a, Gdk.Rectangle b, out Gtk.PositionType gap_side, out int gap_start, out int gap_size);
		public void get_palette_pos (Gtk.Requisition palette_size, out int x, out int y);
		public abstract Gdk.Rectangle get_rect ();
		public abstract unowned Gtk.Window get_toplevel ();
		public virtual void on_popdown ();
		public virtual void on_popup ();
		public Sugar.PalettePosition palette_position { get; set; }
		public GLib.Object subject { get; set; }
		public signal void invoker_enter ();
		public signal void invoker_leave ();
		public signal void popdown ();
		public signal void popup ();
	}
	[CCode (cheader_filename = "gui.h")]
	public class Container : Gtk.Container {
		public Container ();
		protected virtual void child_size_request (ref Gtk.Requisition req);
		public void clear ();
		public void get_pointer (out int x, out int y);
		public int border { set; }
		public int border_bottom { get; set; }
		public int border_left { get; set; }
		public int border_right { get; set; }
		public int border_top { get; set; }
		public virtual int child_height { get; }
		public virtual int child_width { get; }
		public virtual int child_x { get; }
		public virtual int child_y { get; }
	}
	[CCode (cheader_filename = "gui.h")]
	public class EmbeddedMenu : Sugar.Bin {
		public EmbeddedMenu (Sugar.Connector? palette_connector);
		public void insert (Gtk.Widget item, int pos = -1);
	}
	[CCode (cheader_filename = "gui.h")]
	public class EmbeddedSubMenu : Gtk.Menu {
		public EmbeddedSubMenu (Sugar.Connector? palette_connector);
		public override bool enter_notify_event (Gdk.EventCrossing event);
		public override bool leave_notify_event (Gdk.EventCrossing event);
	}
	[CCode (cheader_filename = "gui.h")]
	public class Entry : Gtk.Entry {
		public Entry ();
		public override bool key_press_event (Gdk.EventKey event);
		public bool has_clear_button { get; set; }
		public string? primary_icon { get; set; }
		public string? secondary_icon { get; set; }
	}
	[CCode (cheader_filename = "gui.h")]
	public abstract class HomogeneTable : Sugar.Container {
		public HomogeneTable ();
		public override void add (Gtk.Widget widget);
		public override void dispose ();
		public override bool expose_event (Gdk.EventExpose event);
		public abstract void fill_cell (Gtk.Widget cell, int index);
		public override bool focus (Gtk.DirectionType direction);
		public override void forall_internal (bool include_internal, Gtk.Callback callback);
		public unowned Gtk.Widget? get_cell (int cell_index);
		public int get_index_at_pos (int x, int y);
		public abstract void highlight_cell (Gtk.Widget cell, bool selected);
		public override bool key_press_event (Gdk.EventKey event);
		public override void map ();
		public override bool motion_notify_event (Gdk.EventMotion event);
		public abstract Gtk.Widget new_cell ();
		public override void realize ();
		public void refill ();
		public override void remove (Gtk.Widget widget);
		public override bool scroll_event (Gdk.EventScroll event);
		public void scroll_to_cell (int cell_index, bool fully_visible = false);
		public override void set_focus_child (Gtk.Widget? widget);
		public override void size_allocate (Gdk.Rectangle allocation);
		public override void size_request (out Gtk.Requisition requisition);
		public override void style_set (Gtk.Style? previous_style);
		public override void unrealize ();
		public int cell_count { get; set; }
		public int cell_height { get; set; }
		public int cell_width { get; set; }
		public int cursor { get; set; }
		public bool focus_cell { get; set; }
		public int frame_height { get; set; }
		public Sugar.Range frame_range { get; set; }
		public int frame_width { get; set; }
		public bool hover_selection { get; set; }
		public bool is_empty { get; }
		public Gtk.Orientation orientation { get; set; }
		public signal void cursor_changed ();
		public signal void frame_scrolled ();
		public virtual signal void signal_set_scroll_adjustments (Gtk.Adjustment? hadjustment, Gtk.Adjustment? vadjustment);
	}
	[CCode (cheader_filename = "gui.h")]
	public class Icon : Gtk.Image {
		public Icon ();
		public override bool expose_event (Gdk.EventExpose event);
		public override void size_request (out Gtk.Requisition requisition);
		public string? file { get; set; }
		public Sugar.Color fill_color { get; set; }
		public int height { get; }
		public Gtk.IconSize icon_size { set; }
		public int pixel_size { set; }
		public Sugar.Color stroke_color { get; set; }
		public int width { get; }
		public Sugar.XoColor xo_color { set; }
	}
	[CCode (cheader_filename = "gui.h")]
	public class Invoker : GLib.Object {
		public Invoker (Sugar.Connector connector, string group_id = "default");
		public void popdown ();
		public void popup ();
		public Sugar.Connector connector { get; set construct; }
		public bool focused { get; set; }
		public string group_id { get; set construct; }
		public bool is_up { get; set; }
		public Sugar.Palette? palette { get; set; }
		public Sugar.PaletteWindow? palette_window { get; set; }
		public signal void palette_request ();
		public signal void poped_down ();
		public signal void poped_up ();
	}
	[CCode (cheader_filename = "gui.h")]
	public class Label : Gtk.Label {
		public Label ();
		public override void size_allocate (Gdk.Rectangle allocation);
		public override void size_request (out Gtk.Requisition requisition);
		public int max_line_count { get; set; }
	}
	[CCode (cheader_filename = "gui.h")]
	public class Menu : Sugar.Box {
		public Menu ();
		public override void insert (Gtk.Widget widget, int pos);
		public void insert_action (Gtk.Action action, GLib.Object? tag = null, int pos = -1);
		public void insert_scrolled (Gtk.Widget widget, int max_row_count, int max_height, int pos = -1);
		public void insert_separator (int pos = -1);
		public override void size_allocate (Gdk.Rectangle allocation);
		public override void size_request (out Gtk.Requisition requisition);
		public int width { get; set; }
	}
	[CCode (cheader_filename = "gui.h")]
	public class MenuItem : Sugar.PaintBin, Gtk.Activatable {
		public const int SIZE;
		public MenuItem ();
		public override bool button_release_event (Gdk.EventButton event);
		public override bool enter_notify_event (Gdk.EventCrossing event);
		public override void hierarchy_changed (Gtk.Widget? previous_toplevel);
		public override bool leave_notify_event (Gdk.EventCrossing event);
		public override void map ();
		public bool _selected { set; }
		public string? accelerator { get; set; }
		public string? icon { get; set; }
		public string label { get; set; }
		public int label_maxlen { set; }
		public Gtk.Action related_action { get; set; }
		public GLib.Object tag { get; set; }
		public Sugar.Trigger? trigger { get; set; }
		public bool use_action_appearance { get; set; }
		public virtual signal void activate_item ();
	}
	[CCode (cheader_filename = "gui.h")]
	public class MouseSpeedDetector : GLib.Object {
		public MouseSpeedDetector (int delay, int threshold);
		public void start ();
		public void stop ();
		public signal void motion_fast ();
		public signal void motion_slow ();
	}
	[CCode (cheader_filename = "gui.h")]
	public class PaintBin : Sugar.Bin {
		public PaintBin ();
		public override bool expose_event (Gdk.EventExpose event);
		public override void map ();
		public override void realize ();
		public override void size_allocate (Gdk.Rectangle allocation);
		public override void size_request (out Gtk.Requisition requisition);
		public override void style_set (Gtk.Style? previous_style);
		public override int child_height { get; }
		public override int child_width { get; }
		public override int child_x { get; }
		public override int child_y { get; }
		public bool draw_box { get; set; }
		public int padding { set; }
		public int padding_bottom { get; set; }
		public int padding_left { get; set; }
		public int padding_right { get; set; }
		public int padding_top { get; set; }
		public int radius { get; set; }
	}
	[CCode (cheader_filename = "gui.h")]
	public class Palette : Sugar.PaletteWindow, Sugar.MenuContainer {
		public Palette ();
		public override void realize ();
		public override void show ();
		public override void size_request (out Gtk.Requisition requisition);
		public override void style_set (Gtk.Style? previous_style);
		public Sugar.Icon? icon { get; set; }
		public bool icon_visible { get; set; }
		public string? primary_text { get; set; }
		public override Gtk.Widget? secondary { get; set; }
		public string? secondary_text { get; set; }
		public override bool secondary_visible { get; set; }
		public int text_maxlen { set; }
		public signal void activate_menu (Gtk.Widget initiator);
	}
	[CCode (cheader_filename = "gui.h")]
	public class PaletteGroup : GLib.Object {
		public PaletteGroup ();
		public void add (Sugar.Invoker invoker);
		public Sugar.Invoker? get_parent (Sugar.Invoker child);
		public void popdown ();
		public void remove (Sugar.Invoker invoker);
		public string id { get; set; }
		public bool is_up { get; set; }
		public signal void poped_down (Sugar.PaletteGroup group);
		public signal void poped_up (Sugar.PaletteGroup group);
	}
	[CCode (cheader_filename = "gui.h")]
	public class PaletteWindow : Gtk.Window {
		public PaletteWindow ();
		public override bool expose_event (Gdk.EventExpose event);
		public Gdk.Rectangle get_rect ();
		public override bool key_press_event (Gdk.EventKey event);
		public override void realize ();
		public void reveal ();
		public override void size_allocate (Gdk.Rectangle allocation);
		public override void size_request (out Gtk.Requisition requisition);
		public Sugar.Connector connector { get; set; }
		public virtual Gtk.Widget? secondary { get; set; }
		public virtual bool secondary_visible { get; set; }
	}
	[CCode (cheader_filename = "gui.h")]
	public class RadioToolButton : Gtk.RadioToolButton {
		public RadioToolButton ();
		public override bool expose_event (Gdk.EventExpose event);
		public string? accelerator { get; set; }
		public string? icon { set; }
		public Sugar.Invoker invoker { get; set; }
		public string tooltip { get; set; }
	}
	[CCode (cheader_filename = "gui.h")]
	public class Table : Sugar.Box {
		public Table ();
		public override void add (Gtk.Widget widget);
		public override void remove (Gtk.Widget widget);
		public override void size_allocate (Gdk.Rectangle allocation);
		public override void size_request (out Gtk.Requisition requisition);
		public int width { get; set; }
	}
	[CCode (cheader_filename = "gui.h")]
	public class ToggleToolButton : Gtk.ToggleToolButton {
		public ToggleToolButton ();
		public override bool expose_event (Gdk.EventExpose event);
		public string? accelerator { get; set; }
		public string? icon { set; }
		public Sugar.Invoker invoker { get; set; }
		public string tooltip { get; set; }
	}
	[CCode (cheader_filename = "gui.h")]
	public class ToolButton : Gtk.ToolButton {
		public ToolButton ();
		public override bool expose_event (Gdk.EventExpose event);
		public string? accelerator { get; set; }
		public string? icon { set; }
		public Sugar.Invoker invoker { get; set; }
		public string tooltip { get; set; }
	}
	[CCode (cheader_filename = "gui.h")]
	public class ToolConnector : Sugar.WidgetConnector {
		public ToolConnector (Gtk.ToolItem tool_item);
		protected override unowned Sugar.Connector.Alignment[] get_alignments ();
		public Gtk.ToolItem tool_item { get; set; }
	}
	[CCode (cheader_filename = "gui.h")]
	public class ToolText : Gtk.ToolItem {
		public ToolText ();
		public override void size_allocate (Gdk.Rectangle allocation);
		public string text { get; set; }
	}
	[CCode (cheader_filename = "gui.h")]
	public class ToolbarBox : Gtk.VBox {
		public ToolbarBox ();
		public void expand_button (Sugar.ToolbarButton button);
		public void shrink_button (Sugar.ToolbarButton button);
		public Gtk.PositionType orientation { get; set; }
		public int padding { get; set; }
		public Sugar._ToolbarExpander toolbar { get; set; }
	}
	[CCode (cheader_filename = "gui.h")]
	public class ToolbarButton : Sugar.ToolButton {
		public ToolbarButton ();
		public override void clicked ();
		public override bool expose_event (Gdk.EventExpose event);
		public override void parent_set (Gtk.Widget? previous_parent);
		public bool expanded { get; set; }
		public Gtk.Widget page { get; set; }
		public bool popped { get; set; }
	}
	[CCode (cheader_filename = "gui.h")]
	public class Trigger : GLib.Object {
		public Trigger ();
		public static unowned Sugar.Trigger? find_dock (GLib.Type parent_type, Gtk.Widget parent, string prop_name);
		public signal void activate (Gtk.Widget initiator);
	}
	[CCode (cheader_filename = "gui.h")]
	public class WidgetConnector : Sugar.Connector {
		public WidgetConnector (Gtk.Widget widget);
		public override void draw_rectangle (Gdk.EventExpose event, Sugar.PaletteWindow palette);
		public override Gdk.Rectangle get_rect ();
		public override unowned Gtk.Window get_toplevel ();
		public override void on_popdown ();
		public override void on_popup ();
		public Gtk.Widget widget { get; set; }
	}
	[CCode (cheader_filename = "gui.h")]
	public class Window : Gtk.Window {
		public Window ();
	}
	[CCode (cheader_filename = "gui.h")]
	public class _EmbeddedMenu : Gtk.Menu {
		public _EmbeddedMenu (Sugar.Connector? palette_connector);
		public override void deactivate ();
		public void embed (Gtk.Container container);
		public override bool expose_event (Gdk.EventExpose event);
		public override void grab_notify (bool was_grabbed);
		public override void hide ();
		public override void show ();
	}
	[CCode (cheader_filename = "gui.h")]
	public class _ToolbarExpander : Gtk.Toolbar {
		public _ToolbarExpander ();
		public Sugar.ToolbarBox toolbox { get; }
	}
	[CCode (cheader_filename = "gui.h")]
	public interface MenuContainer : GLib.Object {
		public abstract Sugar.Trigger menu_trigger { get; }
	}
	[CCode (type_id = "SUGAR_TYPE_ICON_ATTR", cheader_filename = "gui.h")]
	public struct IconAttr {
		public string? file_name;
		public Sugar.Color fill_color;
		public Sugar.Color stroke_color;
		public int width;
		public int height;
		public static bool cmp (Sugar.IconAttr x, Sugar.IconAttr y);
		public static uint hash (Sugar.IconAttr x);
		public string icon_name { set; }
		public Gtk.IconSize icon_size { set; }
		public Sugar.XoColor xo_color { set; }
	}
	[CCode (type_id = "SUGAR_TYPE_RANGE", cheader_filename = "gui.h")]
	public struct Range {
		public int start;
		public int stop;
		public int step;
		public Range ();
		public bool contains (int value);
		public bool is_equal (Sugar.Range other);
		public bool is_subset (Sugar.Range other);
		public bool is_empty { get; }
		public int last { get; set; }
		public int size { get; }
	}
	[CCode (type_id = "SUGAR_TYPE_TIMESTAMP", cheader_filename = "gui.h")]
	public struct Timestamp {
		public GLib.TimeVal tv;
		public Timestamp ();
		public double diff (Sugar.Timestamp other);
	}
	[CCode (cprefix = "SUGAR_ANIMATION_TYPE_", cheader_filename = "gui.h")]
	public enum AnimationType {
		OUT_EXPO,
		IN_EXPO
	}
	[CCode (cprefix = "SUGAR_PALETTE_POSITION_", cheader_filename = "gui.h")]
	public enum PalettePosition {
		ANCHORED,
		AT_CURSOR
	}
	[CCode (cheader_filename = "gui.h")]
	public static Gdk.Color color_to_rgb (Sugar.Color color);
	[CCode (cheader_filename = "gui.h")]
	public static Gdk.Color color_type_to_rgb (int type);
	[CCode (cheader_filename = "gui.h")]
	public static void icon_cache_reset ();
	[CCode (cheader_filename = "gui.h")]
	public static Gdk.Pixbuf? icon_get_pixbuf (Sugar.IconAttr attr);
	[CCode (cheader_filename = "gui.h")]
	public static Cairo.Surface? icon_get_surface (Sugar.IconAttr attr, bool cache = true);
	[CCode (cheader_filename = "gui.h")]
	public static unowned string to_string (char* str);
	[CCode (cheader_filename = "gui.h")]
	public static unowned uchar[] to_uchars (char* str);
}
