# sugar-lint: disable

import os
import sys
import shutil
import unittest
import subprocess
from os.path import dirname, join, exists, abspath


tmproot = join(abspath(dirname(__file__)), '.tmp')
tmpdir = None


def main():
    shutil.rmtree(tmproot, ignore_errors=True)
    unittest.main()


class Test(unittest.TestCase):

    def setUp(self):
        global tmpdir
        tmpdir = join(tmproot, '.'.join(self.id().split('.')[1:]))
        shutil.rmtree(tmpdir, ignore_errors=True)
        os.makedirs(tmpdir)
        os.chdir(tmpdir)

        logfile = tmpdir + '.log'
        if exists(logfile):
            os.unlink(logfile)

        self._logfile = file(logfile, 'a')
        sys.stdout = sys.stderr = self._logfile

    def tearDown(self):
        sys.stdout.flush()

    def touch(self, *files):
        for i in files:
            if isinstance(i, str):
                if i.endswith(os.sep):
                    i = i + '.stamp'
                path = i
                if exists(path):
                    content = file(path).read()
                else:
                    content = i
            else:
                path, content = i
                if isinstance(content, list):
                    content = '\n'.join(content)
            path = join(tmpdir, path)

            if not exists(dirname(path)):
                os.makedirs(dirname(path))

            f = file(path, 'w')
            f.write(str(content))
            f.close()


if subprocess.call('make tests-toolkit', shell=True) != 0:
    print 'Cannot make deps'
    exit(1)

sys.path.insert(0, '../../bindings/python')
