/* jobject.c generated by valac 0.12.1, the Vala compiler
 * generated from jobject.vala, do not modify */

/* jobject.vala
 *
 * Copyright (C) 2010, Aleksey Lim
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include "polyol/ds.h"
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <polyol/env.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <time.h>
#include <glib/gstdio.h>
#include <errno.h>

#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define SUGAR_JOBJECT_TYPE__WRITEQUEUEITEM (sugar_jobject__writequeueitem_get_type ())
typedef struct _SugarJobject_WriteQueueItem SugarJobject_WriteQueueItem;
#define _g_queue_free0(var) ((var == NULL) ? NULL : (var = (g_queue_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define SUGAR_TYPE_DATASTORE (sugar_datastore_get_type ())
#define SUGAR_DATASTORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SUGAR_TYPE_DATASTORE, SugarDatastore))
#define SUGAR_DATASTORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SUGAR_TYPE_DATASTORE, SugarDatastoreClass))
#define SUGAR_IS_DATASTORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SUGAR_TYPE_DATASTORE))
#define SUGAR_IS_DATASTORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SUGAR_TYPE_DATASTORE))
#define SUGAR_DATASTORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SUGAR_TYPE_DATASTORE, SugarDatastoreClass))

typedef struct _SugarDatastore SugarDatastore;
typedef struct _SugarDatastoreClass SugarDatastoreClass;
typedef struct _SugarDatastorePrivate SugarDatastorePrivate;
#define _sugar_jobject__writequeueitem_free0(var) ((var == NULL) ? NULL : (var = (sugar_jobject__writequeueitem_free (var), NULL)))
typedef struct _Block1Data Block1Data;

struct _SugarJobjectPrivate {
	gulong _updated_handler;
	GHashTable* _metadata;
	GHashTable* _changed;
	gchar* _file_path;
};

struct _SugarJobject_WriteQueueItem {
	gchar* file_path;
	gboolean transfer_ownership;
	gboolean cow;
	gboolean unlink_on_success;
	gboolean unlink_on_fail;
};

struct _SugarDatastore {
	GObject parent_instance;
	SugarDatastorePrivate * priv;
	DBusGConnection* connection;
	DBusGProxy* service;
};

struct _SugarDatastoreClass {
	GObjectClass parent_class;
};

struct _Block1Data {
	int _ref_count_;
	SugarJobject * self;
	gboolean on_update;
};


static gpointer sugar_jobject_parent_class = NULL;
static GQueue* sugar_jobject__write_queue;
static GQueue* sugar_jobject__write_queue = NULL;

#define SUGAR_JOBJECT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SUGAR_TYPE_JOBJECT, SugarJobjectPrivate))
enum  {
	SUGAR_JOBJECT_DUMMY_PROPERTY,
	SUGAR_JOBJECT_UID,
	SUGAR_JOBJECT_TIMESTAMP,
	SUGAR_JOBJECT_TITLE,
	SUGAR_JOBJECT_TITLE_SET_BY_USER,
	SUGAR_JOBJECT_MIME_TYPE,
	SUGAR_JOBJECT_SHARE_SCOPE,
	SUGAR_JOBJECT_ACTIVITY,
	SUGAR_JOBJECT_ACTIVITY_ID,
	SUGAR_JOBJECT_KEEP,
	SUGAR_JOBJECT_PREVIEW,
	SUGAR_JOBJECT_ICON_COLOR,
	SUGAR_JOBJECT_FILE_PATH
};
static GType sugar_jobject__writequeueitem_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static SugarJobject_WriteQueueItem* sugar_jobject__writequeueitem_dup (const SugarJobject_WriteQueueItem* self);
static void sugar_jobject__writequeueitem_free (SugarJobject_WriteQueueItem* self);
static void sugar_jobject__writequeueitem_copy (const SugarJobject_WriteQueueItem* self, SugarJobject_WriteQueueItem* dest);
static void sugar_jobject__writequeueitem_destroy (SugarJobject_WriteQueueItem* self);
static SugarJobject* sugar_jobject_new (void);
static SugarJobject* sugar_jobject_construct (GType object_type);
static void _g_value_unset_gdestroy_notify (void* data);
static void _g_free0_ (gpointer var);
static void _sugar_jobject_get_properties (SugarJobject* self, const gchar* uid, gboolean on_update, GError** error);
static void sugar_jobject_real_dispose (GObject* base);
GType sugar_datastore_get_type (void) G_GNUC_CONST;
SugarDatastore* sugar_datastore_instance (GError** error);
static void _sugar_jobject_unlink (SugarJobject* self, const gchar* file_path);
static void _sugar_jobject_write (SugarJobject* self, const gchar* file_path, gboolean transfer_ownership, gboolean cow);
static DBusGProxy* _sugar_jobject_get_ds (SugarJobject* self, GError** error);
static void _sugar_jobject_delete_cb (SugarJobject* self, GError* _error_);
static void _dynamic_delete0 (DBusGProxy* self, const gchar* param1, gpointer param2, void* param2_target, GError** error);
static GValue* _g_value_dup (GValue* self);
static void _sugar_jobject_ds_updated_cb (SugarJobject* self, const gchar* uid);
static void __sugar_jobject_ds_updated_cb_sugar_datastore_updated (SugarDatastore* _sender, const gchar* object_id, gpointer self);
static void sugar_jobject__writequeueitem_init (SugarJobject_WriteQueueItem *self, const gchar* file_path, gboolean transfer_ownership, gboolean cow);
static void _sugar_jobject_write_begin (SugarJobject* self);
static gchar* _dynamic_create1 (DBusGProxy* self, GHashTable* param1, const gchar* param2, gboolean param3, GError** error);
static void sugar_jobject_set_uid (SugarJobject* self, const gchar* value);
static void _dynamic_update2 (DBusGProxy* self, const gchar* param1, GHashTable* param2, const gchar* param3, gboolean param4, GError** error);
static void _sugar_jobject_write_end (SugarJobject* self, GError* _error_);
static void _sugar_jobject_create_cb (SugarJobject* self, const gchar* uid, GError* _error_);
static void _dynamic_create3 (DBusGProxy* self, GHashTable* param1, const gchar* param2, gboolean param3, gpointer param4, void* param4_target, GError** error);
static void _sugar_jobject_update_cb (SugarJobject* self, GError* _error_);
static void _dynamic_update4 (DBusGProxy* self, const gchar* param1, GHashTable* param2, const gchar* param3, gboolean param4, gpointer param5, void* param5_target, GError** error);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static GHashTable* _dynamic_get_properties5 (DBusGProxy* self, const gchar* param1, GError** error);
static void _lambda0_ (const gchar* key, GValue* src_value, Block1Data* _data1_);
static void __lambda0__gh_func (gconstpointer key, gconstpointer value, gpointer self);
static gchar* _dynamic_get_filename6 (DBusGProxy* self, const gchar* param1, GError** error);
static void sugar_jobject_finalize (GObject* obj);
static void _vala_sugar_jobject_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sugar_jobject_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const gchar* SUGAR_JOBJECT__share_scope_values[3] = {"private", "invite", "public"};

static void _g_value_unset_gdestroy_notify (void* data) {
	g_value_unset (data);
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static SugarJobject* sugar_jobject_construct (GType object_type) {
	SugarJobject * self = NULL;
	GHashTable* _tmp0_ = NULL;
	GHashTable* metadata;
	GHashTable* _tmp1_;
	GHashTable* _tmp2_ = NULL;
	GQueue* _tmp3_ = NULL;
	self = (SugarJobject*) g_object_new (object_type, NULL);
	_tmp0_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, _g_value_unset_gdestroy_notify);
	metadata = _tmp0_;
	_tmp1_ = _g_hash_table_ref0 (metadata);
	_g_hash_table_unref0 (self->priv->_metadata);
	self->priv->_metadata = _tmp1_;
	_tmp2_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, NULL);
	_g_hash_table_unref0 (self->priv->_changed);
	self->priv->_changed = _tmp2_;
	_tmp3_ = g_queue_new ();
	_g_queue_free0 (sugar_jobject__write_queue);
	sugar_jobject__write_queue = _tmp3_;
	_g_hash_table_unref0 (metadata);
	return self;
}


static SugarJobject* sugar_jobject_new (void) {
	return sugar_jobject_construct (SUGAR_TYPE_JOBJECT);
}


/**
     * Create new local object
     *
     * @return  new Jobject in all cases
     *
     * Function doesn't ask sugar-datastore, just creates new local
     * representation of journal entry. To send data to sugar-datastore,
     * use Jobject.write. To create representation of already exist journal
     * entry, use Jobject.find.
     */
SugarJobject* sugar_jobject_create (void) {
	SugarJobject* result = NULL;
	SugarJobject* _tmp0_ = NULL;
	SugarJobject* jobject;
	const gchar* _tmp1_ = NULL;
	SugarActivityInfo _tmp2_ = {0};
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	SugarXoColor _tmp7_ = {0};
	_tmp0_ = sugar_jobject_new ();
	jobject = _tmp0_;
	_tmp1_ = _ ("%s Activity");
	sugar_environ_get_activity (&_tmp2_);
	_tmp3_ = g_strdup_printf (_tmp1_, _tmp2_.name);
	_tmp4_ = _tmp3_;
	sugar_jobject_set_title (jobject, _tmp4_);
	_g_free0 (_tmp4_);
	sugar_jobject_set_title_set_by_user (jobject, FALSE);
	_tmp5_ = sugar_environ_get_bundle_id ();
	sugar_jobject_set_activity (jobject, _tmp5_);
	_tmp6_ = sugar_environ_get_activity_id ();
	sugar_jobject_set_activity_id (jobject, _tmp6_);
	sugar_jobject_set_keep (jobject, FALSE);
	sugar_jobject_set_share_scope (jobject, SUGAR_SHARE_SCOPE_PRIVATE);
	sugar_profile_get_color (&_tmp7_);
	sugar_jobject_set_icon_color (jobject, &_tmp7_);
	result = jobject;
	return result;
}


/**
     * Create representation of journal entry
     *
     * @param uid   unique id of journal entry
     * @return      Jobject or null on errors
     *
     * If function cannot connect to sugar-datastore or journal entry with
     * given uid does not exist, Error will be thrown.
     */
SugarJobject* sugar_jobject_find (const gchar* uid) {
	SugarJobject* result = NULL;
	SugarJobject* _tmp0_ = NULL;
	SugarJobject* jobject;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (uid != NULL, NULL);
	_tmp0_ = sugar_jobject_new ();
	jobject = _tmp0_;
	_sugar_jobject_get_properties (jobject, uid, FALSE, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (jobject);
		goto __catch0_g_error;
	}
	result = jobject;
	return result;
	_g_object_unref0 (jobject);
	goto __finally0;
	__catch0_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("jobject.vala:297: Cannot find journal entry %s: %s", uid, _error_->message);
		result = NULL;
		_g_error_free0 (_error_);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


static void sugar_jobject_real_dispose (GObject* base) {
	SugarJobject * self;
	GError * _inner_error_ = NULL;
	self = (SugarJobject*) base;
	if (self->priv->_updated_handler != 0) {
		SugarDatastore* _tmp0_ = NULL;
		SugarDatastore* _tmp1_;
		SugarDatastore* _tmp2_;
		_tmp0_ = sugar_datastore_instance (&_inner_error_);
		_tmp1_ = _tmp0_;
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		_tmp2_ = _tmp1_;
		g_signal_handler_disconnect ((GObject*) _tmp2_, self->priv->_updated_handler);
		_g_object_unref0 (_tmp2_);
		goto __finally1;
		__catch1_g_error:
		{
			GError * _error_;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (_error_);
		}
		__finally1:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_sugar_jobject_unlink (self, self->priv->_file_path);
	G_OBJECT_CLASS (sugar_jobject_parent_class)->dispose (G_OBJECT (self));
}


/**
     * Get field by name
     *
     * @param field_name    field name
     * @return              stored field value or null if field doesn't exist
     */
GValue* sugar_jobject_get_field (SugarJobject* self, const gchar* field_name) {
	GValue* result = NULL;
	gconstpointer _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (field_name != NULL, NULL);
	_tmp0_ = g_hash_table_lookup (self->priv->_metadata, field_name);
	result = (GValue*) _tmp0_;
	return result;
}


/**
     * Set field by name
     *
     * @param field_name    field name
     * @param field_value   value to store
     *
     * Function will also emit notify signal for appropriate field property.
     */
static gchar* string_delimit (const gchar* self, const gchar* delimiters, gchar new_delimiter) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (delimiters != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strdelimit (_result_, delimiters, new_delimiter);
	result = _result_;
	return result;
}


void sugar_jobject_set_field (SugarJobject* self, const gchar* field_name, GValue* field_value) {
	gchar* _tmp0_ = NULL;
	gchar* prop_name;
	GObjectClass* _tmp1_ = NULL;
	GParamSpec* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (field_name != NULL);
	g_return_if_fail (g_strcmp0 (field_name, "uid") != 0);
	_sugar_jobject_set_field (self, field_name, field_value);
	_tmp0_ = string_delimit (field_name, "_", '-');
	prop_name = _tmp0_;
	_tmp1_ = G_OBJECT_GET_CLASS ((GObject*) self);
	_tmp2_ = g_object_class_find_property (_tmp1_, prop_name);
	if (_tmp2_ != NULL) {
		g_object_notify ((GObject*) self, prop_name);
	}
	_g_free0 (prop_name);
}


/**
     * Write metadata changes to sugar-datastore
     *
     * Method is async, write_end signal will be emited on receiving reply from
     * sugar-datastore. If Jobject was constructed by Jobject.create, new
     * journal entry will be created on sugar-datastore side and uid property
     * will be set after emiting write_end.
     *
     * There is no need in waiting write_end before second write invocation,
     * write will queue calls.
     *
     * If activity doesn't support GLib main loop, set Environ.sync_dbus to true to
     * make all time synchronous DBus calls.
     */
void sugar_jobject_write (SugarJobject* self) {
	g_return_if_fail (self != NULL);
	_sugar_jobject_write (self, NULL, FALSE, FALSE);
}


/**
     * Write metadata changes and file to sugar-datastore
     *
     * @param file_path             path to the file that should be associated
     *                              with journal entry, if null, current
     *                              associated file will be preserved
     * @param transfer_ownership    should sugar-datastore take ownership
     *                              of passed file_path
     *
     * Does the same that Jobject.write does. Also stores file that will be
     * associated with journal entry.
     *
     * If file_path argument was specified and transfer_ownership is true,
     * caller should not rely on existence of file_path after write call. On
     * successful invocation, file_path will be moved to new location, after
     * error, file will be deleted.
     *
     * There is no need in waiting write_end before second write invocation,
     * write will queue calls.
     */
void sugar_jobject_write_file (SugarJobject* self, const gchar* file_path, gboolean transfer_ownership) {
	g_return_if_fail (self != NULL);
	_sugar_jobject_write (self, file_path, transfer_ownership, FALSE);
}


/**
     * Initiate copy-on-write copy of current journal entry
     *
     * Does the same Jobject.write does and reset uid property to null,
     * thus second journal entry will appear only after followed write call.
     */
void sugar_jobject_cow (SugarJobject* self) {
	g_return_if_fail (self != NULL);
	_sugar_jobject_write (self, NULL, FALSE, TRUE);
}


/**
     * Delete journal entry
     *
     * @return  true if dbus call was successfully sent, otherwise false
     *
     * If newly create Jobject was never written, function does nothing.
     * Function makes async dbus call.
     *
     * If activity doesn't support GLib main loop, set Environ.sync_dbus to true to
     * make all time synchronous DBus calls.
     */
static void __sugar_jobject_delete_cb_cb (DBusGProxy* proxy, DBusGProxyCall* call, void* user_data) {
	GError* error;
	error = NULL;
	dbus_g_proxy_end_call (proxy, call, &error, G_TYPE_INVALID);
	_sugar_jobject_delete_cb (user_data, error);
	g_object_unref (user_data);
}


static void _dynamic_delete0 (DBusGProxy* self, const gchar* param1, gpointer param2, void* param2_target, GError** error) {
	dbus_g_proxy_begin_call (self, "delete", __sugar_jobject_delete_cb_cb, g_object_ref (param2_target), NULL, G_TYPE_STRING, param1, G_TYPE_INVALID, G_TYPE_INVALID);
	if (*error) {
		return;
	}
}


gboolean sugar_jobject_unlink (SugarJobject* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = sugar_jobject_get_uid (self);
	if (_tmp0_ == NULL) {
		g_debug ("jobject.vala:405: Jobject was never written, just discard it");
	} else {
		const gchar* _tmp1_ = NULL;
		DBusGProxy* _tmp2_ = NULL;
		DBusGProxy* _tmp3_;
		DBusGProxy* _tmp4_;
		const gchar* _tmp5_ = NULL;
		_tmp1_ = sugar_jobject_get_uid (self);
		g_debug ("jobject.vala:407: Delete Jobject %s", _tmp1_);
		_tmp2_ = _sugar_jobject_get_ds (self, &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
		_tmp4_ = _tmp3_;
		_tmp5_ = sugar_jobject_get_uid (self);
		_dynamic_delete0 (_tmp4_, _tmp5_, _sugar_jobject_delete_cb, self, &_inner_error_);
		_g_object_unref0 (_tmp4_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError * _error_;
			const gchar* _tmp6_ = NULL;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			_tmp6_ = sugar_jobject_get_uid (self);
			g_warning ("jobject.vala:412: Cannot delete journal entry %s: %s", _tmp6_, _error_->message);
			result = FALSE;
			_g_error_free0 (_error_);
			return result;
		}
		__finally2:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_sugar_jobject_unlink (self, self->priv->_file_path);
		_g_free0 (self->priv->_file_path);
		self->priv->_file_path = NULL;
	}
	result = TRUE;
	return result;
}


const gchar* _sugar_jobject_get_string (SugarJobject* self, const gchar* field_name) {
	const gchar* result = NULL;
	GValue* _tmp0_ = NULL;
	GValue* field_value;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (field_name != NULL, NULL);
	_tmp0_ = sugar_jobject_get_field (self, field_name);
	field_value = _tmp0_;
	if (field_value != NULL) {
		gboolean _tmp2_;
		_tmp2_ = G_VALUE_HOLDS (field_value, G_TYPE_STRING);
		_tmp1_ = _tmp2_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp3_ = NULL;
		_tmp3_ = g_value_get_string (field_value);
		result = _tmp3_;
		return result;
	} else {
		result = "";
		return result;
	}
}


void _sugar_jobject_set_string (SugarJobject* self, const gchar* field_name, const gchar* field_value) {
	GValue _tmp0_ = {0};
	GValue _tmp1_ = {0};
	GValue string_value;
	g_return_if_fail (self != NULL);
	g_return_if_fail (field_name != NULL);
	g_return_if_fail (field_value != NULL);
	g_value_init (&_tmp0_, G_TYPE_STRING);
	_tmp1_ = _tmp0_;
	string_value = _tmp1_;
	g_value_set_string (&string_value, field_value);
	_sugar_jobject_set_field (self, field_name, &string_value);
	G_IS_VALUE (&string_value) ? (g_value_unset (&string_value), NULL) : NULL;
}


static GValue* _g_value_dup (GValue* self) {
	return g_boxed_copy (G_TYPE_VALUE, self);
}


static gpointer __g_value_dup0 (gpointer self) {
	return self ? _g_value_dup (self) : NULL;
}


void _sugar_jobject_set_field (SugarJobject* self, const gchar* field_name, GValue* field_value) {
	gchar* _tmp0_;
	GValue* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (field_name != NULL);
	_tmp0_ = g_strdup (field_name);
	_tmp1_ = __g_value_dup0 (field_value);
	g_hash_table_replace (self->priv->_metadata, _tmp0_, _tmp1_);
	_tmp2_ = g_strdup (field_name);
	g_hash_table_replace (self->priv->_changed, _tmp2_, GINT_TO_POINTER (TRUE));
}


static void __sugar_jobject_ds_updated_cb_sugar_datastore_updated (SugarDatastore* _sender, const gchar* object_id, gpointer self) {
	_sugar_jobject_ds_updated_cb (self, object_id);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static DBusGProxy* _sugar_jobject_get_ds (SugarJobject* self, GError** error) {
	DBusGProxy* result = NULL;
	SugarDatastore* _tmp0_ = NULL;
	SugarDatastore* ds;
	DBusGProxy* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = sugar_datastore_instance (&_inner_error_);
	ds = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	if (self->priv->_updated_handler == 0) {
		gulong _tmp1_;
		_tmp1_ = g_signal_connect_object (ds, "updated", (GCallback) __sugar_jobject_ds_updated_cb_sugar_datastore_updated, self, 0);
		self->priv->_updated_handler = _tmp1_;
	}
	_tmp2_ = _g_object_ref0 (ds->service);
	result = _tmp2_;
	_g_object_unref0 (ds);
	return result;
}


static gpointer _sugar_jobject__writequeueitem_dup0 (gpointer self) {
	return self ? sugar_jobject__writequeueitem_dup (self) : NULL;
}


static void _sugar_jobject_write (SugarJobject* self, const gchar* file_path, gboolean transfer_ownership, gboolean cow) {
	SugarJobject_WriteQueueItem queue_item = {0};
	SugarJobject_WriteQueueItem* _tmp0_;
	g_return_if_fail (self != NULL);
	sugar_jobject__writequeueitem_init (&queue_item, file_path, transfer_ownership, cow);
	_tmp0_ = _sugar_jobject__writequeueitem_dup0 (&queue_item);
	g_queue_push_tail (sugar_jobject__write_queue, _tmp0_);
	if (sugar_jobject__write_queue->length > 1) {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = sugar_jobject_get_uid (self);
		g_debug ("jobject.vala:456: Queue Jobject.write uid=%s file_path=%s transfer=%d", _tmp1_, queue_item.file_path, (gint) queue_item.transfer_ownership);
	} else {
		_sugar_jobject_write_begin (self);
	}
	sugar_jobject__writequeueitem_destroy (&queue_item);
}


static gchar* _dynamic_create1 (DBusGProxy* self, GHashTable* param1, const gchar* param2, gboolean param3, GError** error) {
	gchar* result;
	dbus_g_proxy_call (self, "create", error, dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE), param1, G_TYPE_STRING, param2, G_TYPE_BOOLEAN, param3, G_TYPE_INVALID, G_TYPE_STRING, &result, G_TYPE_INVALID);
	if (*error) {
		return NULL;
	}
	return result;
}


static void _dynamic_update2 (DBusGProxy* self, const gchar* param1, GHashTable* param2, const gchar* param3, gboolean param4, GError** error) {
	dbus_g_proxy_call (self, "update", error, G_TYPE_STRING, param1, dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE), param2, G_TYPE_STRING, param3, G_TYPE_BOOLEAN, param4, G_TYPE_INVALID, G_TYPE_INVALID);
	if (*error) {
		return;
	}
}


static void __sugar_jobject_create_cb_cb (DBusGProxy* proxy, DBusGProxyCall* call, void* user_data) {
	GError* error;
	const gchar* uid;
	error = NULL;
	dbus_g_proxy_end_call (proxy, call, &error, G_TYPE_STRING, &uid, G_TYPE_INVALID);
	_sugar_jobject_create_cb (user_data, uid, error);
	g_object_unref (user_data);
}


static void _dynamic_create3 (DBusGProxy* self, GHashTable* param1, const gchar* param2, gboolean param3, gpointer param4, void* param4_target, GError** error) {
	dbus_g_proxy_begin_call (self, "create", __sugar_jobject_create_cb_cb, g_object_ref (param4_target), NULL, dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE), param1, G_TYPE_STRING, param2, G_TYPE_BOOLEAN, param3, G_TYPE_INVALID, G_TYPE_INVALID);
	if (*error) {
		return;
	}
}


static void __sugar_jobject_update_cb_cb (DBusGProxy* proxy, DBusGProxyCall* call, void* user_data) {
	GError* error;
	error = NULL;
	dbus_g_proxy_end_call (proxy, call, &error, G_TYPE_INVALID);
	_sugar_jobject_update_cb (user_data, error);
	g_object_unref (user_data);
}


static void _dynamic_update4 (DBusGProxy* self, const gchar* param1, GHashTable* param2, const gchar* param3, gboolean param4, gpointer param5, void* param5_target, GError** error) {
	dbus_g_proxy_begin_call (self, "update", __sugar_jobject_update_cb_cb, g_object_ref (param5_target), NULL, G_TYPE_STRING, param1, dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE), param2, G_TYPE_STRING, param3, G_TYPE_BOOLEAN, param4, G_TYPE_INVALID, G_TYPE_INVALID);
	if (*error) {
		return;
	}
}


static void _sugar_jobject_write_begin (SugarJobject* self) {
	gconstpointer _tmp0_ = NULL;
	SugarJobject_WriteQueueItem* _tmp1_;
	SugarJobject_WriteQueueItem* queue_item;
	const gchar* _tmp2_ = NULL;
	time_t _tmp3_;
	gboolean _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_queue_peek_head (sugar_jobject__write_queue);
	_tmp1_ = _sugar_jobject__writequeueitem_dup0 ((SugarJobject_WriteQueueItem*) _tmp0_);
	queue_item = _tmp1_;
	_tmp2_ = sugar_jobject_get_uid (self);
	g_debug ("jobject.vala:466: Jobject.write uid=%s file_path=%s transfer=%d", _tmp2_, (*queue_item).file_path, (gint) (*queue_item).transfer_ownership);
	_tmp3_ = time (NULL);
	sugar_jobject_set_timestamp (self, (glong) _tmp3_);
	g_hash_table_remove_all (self->priv->_changed);
	_tmp4_ = sugar_environ_get_sync_dbus ();
	if (_tmp4_) {
		const gchar* _tmp5_ = NULL;
		_tmp5_ = sugar_jobject_get_uid (self);
		if (_tmp5_ == NULL) {
			DBusGProxy* _tmp6_ = NULL;
			DBusGProxy* _tmp7_;
			DBusGProxy* _tmp8_;
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp6_ = _sugar_jobject_get_ds (self, &_inner_error_);
			_tmp7_ = _tmp6_;
			if (_inner_error_ != NULL) {
				goto __catch3_g_error;
			}
			_tmp8_ = _tmp7_;
			_tmp9_ = _dynamic_create1 (_tmp8_, self->priv->_metadata, (*queue_item).file_path, (*queue_item).transfer_ownership, &_inner_error_);
			_tmp10_ = _tmp9_;
			_g_object_unref0 (_tmp8_);
			_tmp11_ = _tmp10_;
			if (_inner_error_ != NULL) {
				goto __catch3_g_error;
			}
			_tmp12_ = _tmp11_;
			sugar_jobject_set_uid (self, _tmp12_);
			_g_free0 (_tmp12_);
		} else {
			DBusGProxy* _tmp13_ = NULL;
			DBusGProxy* _tmp14_;
			DBusGProxy* _tmp15_;
			const gchar* _tmp16_ = NULL;
			_tmp13_ = _sugar_jobject_get_ds (self, &_inner_error_);
			_tmp14_ = _tmp13_;
			if (_inner_error_ != NULL) {
				goto __catch3_g_error;
			}
			_tmp15_ = _tmp14_;
			_tmp16_ = sugar_jobject_get_uid (self);
			_dynamic_update2 (_tmp15_, _tmp16_, self->priv->_metadata, (*queue_item).file_path, (*queue_item).transfer_ownership, &_inner_error_);
			_g_object_unref0 (_tmp15_);
			if (_inner_error_ != NULL) {
				goto __catch3_g_error;
			}
		}
		_sugar_jobject_write_end (self, NULL);
	} else {
		const gchar* _tmp17_ = NULL;
		_tmp17_ = sugar_jobject_get_uid (self);
		if (_tmp17_ == NULL) {
			DBusGProxy* _tmp18_ = NULL;
			DBusGProxy* _tmp19_;
			DBusGProxy* _tmp20_;
			_tmp18_ = _sugar_jobject_get_ds (self, &_inner_error_);
			_tmp19_ = _tmp18_;
			if (_inner_error_ != NULL) {
				goto __catch3_g_error;
			}
			_tmp20_ = _tmp19_;
			_dynamic_create3 (_tmp20_, self->priv->_metadata, (*queue_item).file_path, (*queue_item).transfer_ownership, _sugar_jobject_create_cb, self, &_inner_error_);
			_g_object_unref0 (_tmp20_);
			if (_inner_error_ != NULL) {
				goto __catch3_g_error;
			}
		} else {
			DBusGProxy* _tmp21_ = NULL;
			DBusGProxy* _tmp22_;
			DBusGProxy* _tmp23_;
			const gchar* _tmp24_ = NULL;
			_tmp21_ = _sugar_jobject_get_ds (self, &_inner_error_);
			_tmp22_ = _tmp21_;
			if (_inner_error_ != NULL) {
				goto __catch3_g_error;
			}
			_tmp23_ = _tmp22_;
			_tmp24_ = sugar_jobject_get_uid (self);
			_dynamic_update4 (_tmp23_, _tmp24_, self->priv->_metadata, (*queue_item).file_path, (*queue_item).transfer_ownership, _sugar_jobject_update_cb, self, &_inner_error_);
			_g_object_unref0 (_tmp23_);
			if (_inner_error_ != NULL) {
				goto __catch3_g_error;
			}
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_sugar_jobject_write_end (self, _error_);
		_g_error_free0 (_error_);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_sugar_jobject__writequeueitem_free0 (queue_item);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_sugar_jobject__writequeueitem_free0 (queue_item);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	result = ((gchar*) self)[index];
	return result;
}


static void _sugar_jobject_write_end (SugarJobject* self, GError* _error_) {
	gpointer _tmp0_ = NULL;
	SugarJobject_WriteQueueItem* queue_item;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_queue_pop_head (sugar_jobject__write_queue);
	queue_item = (SugarJobject_WriteQueueItem*) _tmp0_;
	if (_error_ != NULL) {
		const gchar* _tmp1_ = NULL;
		if ((*queue_item).unlink_on_success) {
			_sugar_jobject_unlink (self, (*queue_item).file_path);
		}
		_tmp1_ = sugar_jobject_get_uid (self);
		g_warning ("jobject.vala:500: Cannot write jobject %s: %s", _tmp1_, _error_->message);
	} else {
		gboolean _tmp2_ = FALSE;
		gchar _tmp4_;
		if ((*queue_item).unlink_on_fail) {
			_sugar_jobject_unlink (self, (*queue_item).file_path);
		}
		if ((*queue_item).cow) {
			gconstpointer _tmp3_ = NULL;
			_tmp3_ = g_hash_table_lookup (self->priv->_metadata, "uid");
			_tmp2_ = ((GValue*) _tmp3_) != NULL;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			g_hash_table_remove (self->priv->_metadata, "uid");
		}
		_tmp4_ = string_get ((*queue_item).file_path, (glong) 0);
		if (_tmp4_ != '\0') {
			_sugar_jobject_unlink (self, self->priv->_file_path);
			_g_free0 (self->priv->_file_path);
			self->priv->_file_path = NULL;
		}
	}
	_tmp5_ = g_queue_is_empty (sugar_jobject__write_queue);
	if (_tmp5_) {
		const gchar* _tmp6_ = NULL;
		if (_error_ == NULL) {
			_tmp6_ = NULL;
		} else {
			_tmp6_ = _error_->message;
		}
		g_signal_emit_by_name (self, "write-end", _tmp6_);
	} else {
		_sugar_jobject_write_begin (self);
	}
	_sugar_jobject__writequeueitem_free0 (queue_item);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		g_slice_free (Block1Data, _data1_);
	}
}


static GHashTable* _dynamic_get_properties5 (DBusGProxy* self, const gchar* param1, GError** error) {
	GHashTable* result;
	dbus_g_proxy_call (self, "get_properties", error, G_TYPE_STRING, param1, G_TYPE_INVALID, dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE), &result, G_TYPE_INVALID);
	if (*error) {
		return NULL;
	}
	return result;
}


static void _lambda0_ (const gchar* key, GValue* src_value, Block1Data* _data1_) {
	SugarJobject * self;
	const gchar* field_name;
	gboolean _tmp0_ = FALSE;
	self = _data1_->self;
	g_return_if_fail (key != NULL);
	field_name = (const gchar*) key;
	if (!_data1_->on_update) {
		_tmp0_ = TRUE;
	} else {
		gconstpointer _tmp1_ = NULL;
		_tmp1_ = g_hash_table_lookup (self->priv->_changed, field_name);
		_tmp0_ = !GPOINTER_TO_INT (_tmp1_);
	}
	if (_tmp0_) {
		GValue _tmp2_ = {0};
		GValue dst_value;
		gchar* _tmp3_ = NULL;
		gchar* prop_name;
		gboolean _tmp4_;
		gchar* _tmp20_;
		GValue* _tmp21_;
		gboolean _tmp22_ = FALSE;
		dst_value = _tmp2_;
		_tmp3_ = string_delimit (field_name, "_", '-');
		prop_name = _tmp3_;
		_tmp4_ = G_VALUE_HOLDS (src_value, G_TYPE_BOXED);
		if (_tmp4_) {
			gboolean _tmp5_ = FALSE;
			GObjectClass* _tmp6_ = NULL;
			GParamSpec* _tmp7_ = NULL;
			_tmp6_ = G_OBJECT_GET_CLASS ((GObject*) self);
			_tmp7_ = g_object_class_find_property (_tmp6_, prop_name);
			if (_tmp7_ != NULL) {
				_tmp5_ = g_strcmp0 (field_name, "preview") != 0;
			} else {
				_tmp5_ = FALSE;
			}
			if (_tmp5_) {
				void* _tmp8_ = NULL;
				GArray* array_value;
				void* _tmp9_ = NULL;
				const gchar* str_value;
				gchar* tr_value_p;
				GValue _tmp13_ = {0};
				GValue _tmp14_ = {0};
				const gchar* _tmp15_;
				_tmp8_ = g_value_get_boxed (src_value);
				array_value = (GArray*) _tmp8_;
				_tmp9_ = g_malloc ((gsize) (array_value->len + 1));
				str_value = _tmp9_;
				tr_value_p = (gchar*) str_value;
				{
					guint i;
					i = array_value->len + 1;
					{
						gboolean _tmp10_;
						_tmp10_ = TRUE;
						while (TRUE) {
							guint _tmp11_;
							guchar _tmp12_;
							if (!_tmp10_) {
							}
							_tmp10_ = FALSE;
							_tmp11_ = i;
							i = _tmp11_ - 1;
							if (!(_tmp11_ > 0)) {
								break;
							}
							_tmp12_ = g_array_index (array_value, guchar, i);
							tr_value_p[i] = (gchar) _tmp12_;
						}
					}
				}
				tr_value_p[array_value->len] = '\0';
				g_value_init (&_tmp13_, G_TYPE_STRING);
				_tmp14_ = _tmp13_;
				G_IS_VALUE (&dst_value) ? (g_value_unset (&dst_value), NULL) : NULL;
				dst_value = _tmp14_;
				_tmp15_ = str_value;
				str_value = NULL;
				g_value_take_string (&dst_value, (gchar*) _tmp15_);
			} else {
				GValue _tmp16_;
				GValue _tmp17_ = {0};
				if (G_IS_VALUE (src_value)) {
					g_value_init (&_tmp17_, G_VALUE_TYPE (src_value));
					g_value_copy (src_value, &_tmp17_);
				} else {
					_tmp17_ = *src_value;
				}
				_tmp16_ = _tmp17_;
				G_IS_VALUE (&dst_value) ? (g_value_unset (&dst_value), NULL) : NULL;
				dst_value = _tmp16_;
			}
		} else {
			GValue _tmp18_ = {0};
			GValue _tmp19_ = {0};
			g_value_init (&_tmp18_, G_TYPE_STRING);
			_tmp19_ = _tmp18_;
			G_IS_VALUE (&dst_value) ? (g_value_unset (&dst_value), NULL) : NULL;
			dst_value = _tmp19_;
			g_value_transform (src_value, &dst_value);
		}
		_tmp20_ = g_strdup (field_name);
		_tmp21_ = __g_value_dup0 (&dst_value);
		g_hash_table_replace (self->priv->_metadata, _tmp20_, _tmp21_);
		if (_data1_->on_update) {
			GObjectClass* _tmp23_ = NULL;
			GParamSpec* _tmp24_ = NULL;
			_tmp23_ = G_OBJECT_GET_CLASS ((GObject*) self);
			_tmp24_ = g_object_class_find_property (_tmp23_, prop_name);
			_tmp22_ = _tmp24_ != NULL;
		} else {
			_tmp22_ = FALSE;
		}
		if (_tmp22_) {
			g_object_notify ((GObject*) self, prop_name);
		}
		_g_free0 (prop_name);
		G_IS_VALUE (&dst_value) ? (g_value_unset (&dst_value), NULL) : NULL;
	}
}


static void __lambda0__gh_func (gconstpointer key, gconstpointer value, gpointer self) {
	_lambda0_ (key, value, self);
}


static void _sugar_jobject_get_properties (SugarJobject* self, const gchar* uid, gboolean on_update, GError** error) {
	Block1Data* _data1_;
	DBusGProxy* _tmp0_ = NULL;
	DBusGProxy* _tmp1_;
	DBusGProxy* _tmp2_;
	GHashTable* _tmp3_ = NULL;
	GHashTable* _tmp4_;
	GHashTable* metadata;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uid != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_data1_->on_update = on_update;
	_tmp0_ = _sugar_jobject_get_ds (self, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return;
	}
	_tmp2_ = _tmp1_;
	_tmp3_ = _dynamic_get_properties5 (_tmp2_, uid, &_inner_error_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	metadata = _tmp4_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return;
	}
	g_hash_table_foreach (metadata, __lambda0__gh_func, _data1_);
	sugar_jobject_set_uid (self, uid);
	_g_hash_table_unref0 (metadata);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


static void _sugar_jobject_unlink (SugarJobject* self, const gchar* file_path) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	if (file_path != NULL) {
		gboolean _tmp2_;
		_tmp2_ = g_file_test (file_path, G_FILE_TEST_EXISTS);
		_tmp1_ = _tmp2_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gint _tmp3_;
		_tmp3_ = g_unlink (file_path);
		_tmp0_ = _tmp3_ != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		const gchar* _tmp4_ = NULL;
		_tmp4_ = g_strerror (errno);
		g_warning ("jobject.vala:565: Cannot remove file %s: %s", file_path, _tmp4_);
	}
}


static void _sugar_jobject_create_cb (SugarJobject* self, const gchar* uid, GError* _error_) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (uid != NULL);
	if (_error_ == NULL) {
		sugar_jobject_set_uid (self, uid);
	}
	_sugar_jobject_write_end (self, _error_);
}


static void _sugar_jobject_update_cb (SugarJobject* self, GError* _error_) {
	g_return_if_fail (self != NULL);
	_sugar_jobject_write_end (self, _error_);
}


static void _sugar_jobject_delete_cb (SugarJobject* self, GError* _error_) {
	g_return_if_fail (self != NULL);
	if (_error_ != NULL) {
		g_warning ("jobject.vala:580: Cannot delete jobject entry: %s", _error_->message);
	}
}


static void _sugar_jobject_ds_updated_cb (SugarJobject* self, const gchar* uid) {
	const gchar* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uid != NULL);
	_tmp0_ = sugar_jobject_get_uid (self);
	if (g_strcmp0 (uid, _tmp0_) != 0) {
		return;
	}
	g_debug ("jobject.vala:587: Update jobject %s", uid);
	_sugar_jobject_get_properties (self, uid, TRUE, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch4_g_error;
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("jobject.vala:592: Cannot update Jobject %s: %s", uid, _error_->message);
		_g_error_free0 (_error_);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


const gchar* sugar_jobject_get_uid (SugarJobject* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	const gchar* field_value;
	const gchar* _tmp1_ = NULL;
	gchar _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _sugar_jobject_get_string (self, "uid");
	field_value = _tmp0_;
	_tmp2_ = string_get (field_value, (glong) 0);
	if (_tmp2_ != '\0') {
		_tmp1_ = field_value;
	} else {
		_tmp1_ = NULL;
	}
	result = _tmp1_;
	return result;
}


static void sugar_jobject_set_uid (SugarJobject* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	_sugar_jobject_set_string (self, "uid", value);
	g_object_notify ((GObject *) self, "uid");
}


glong sugar_jobject_get_timestamp (SugarJobject* self) {
	glong result;
	const gchar* _tmp0_ = NULL;
	glong _tmp1_;
	g_return_val_if_fail (self != NULL, 0L);
	_tmp0_ = _sugar_jobject_get_string (self, "timestamp");
	_tmp1_ = atol (_tmp0_);
	result = _tmp1_;
	return result;
}


static void g_time_local (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	struct tm _tmp0_ = {0};
	localtime_r (&time, &_tmp0_);
	_result_ = _tmp0_;
	*result = _result_;
	return;
}


static gchar* g_time_format (struct tm *self, const gchar* format) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* buffer;
	gint buffer_length1;
	gint _buffer_size_;
	gchar* _tmp1_;
	g_return_val_if_fail (format != NULL, NULL);
	_tmp0_ = g_new0 (gchar, 64);
	buffer = _tmp0_;
	buffer_length1 = 64;
	_buffer_size_ = 64;
	strftime (buffer, buffer_length1, format, &(*self));
	_tmp1_ = g_strdup ((const gchar*) buffer);
	result = _tmp1_;
	buffer = (g_free (buffer), NULL);
	return result;
}


void sugar_jobject_set_timestamp (SugarJobject* self, glong value) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	struct tm _tmp2_ = {0};
	struct tm _tmp3_ = {0};
	struct tm time;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup_printf ("%li", value);
	_tmp1_ = _tmp0_;
	_sugar_jobject_set_string (self, "timestamp", _tmp1_);
	_g_free0 (_tmp1_);
	g_time_local ((time_t) value, &_tmp2_);
	_tmp3_ = _tmp2_;
	time = _tmp3_;
	_tmp4_ = g_time_format (&time, "%Y-%m-%dT%H:%M:%S");
	_tmp5_ = _tmp4_;
	_sugar_jobject_set_string (self, "mtime", _tmp5_);
	_g_free0 (_tmp5_);
	g_object_notify ((GObject *) self, "timestamp");
}


const gchar* sugar_jobject_get_title (SugarJobject* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _sugar_jobject_get_string (self, "title");
	result = _tmp0_;
	return result;
}


void sugar_jobject_set_title (SugarJobject* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	_sugar_jobject_set_string (self, "title", value);
	g_object_notify ((GObject *) self, "title");
}


gboolean sugar_jobject_get_title_set_by_user (SugarJobject* self) {
	gboolean result;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = _sugar_jobject_get_string (self, "title_set_by_user");
	_tmp1_ = atoi (_tmp0_);
	result = _tmp1_ != 0;
	return result;
}


void sugar_jobject_set_title_set_by_user (SugarJobject* self, gboolean value) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	if (value) {
		_tmp0_ = "1";
	} else {
		_tmp0_ = "0";
	}
	_sugar_jobject_set_string (self, "title_set_by_user", _tmp0_);
	g_object_notify ((GObject *) self, "title-set-by-user");
}


const gchar* sugar_jobject_get_mime_type (SugarJobject* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _sugar_jobject_get_string (self, "mime_type");
	result = _tmp0_;
	return result;
}


void sugar_jobject_set_mime_type (SugarJobject* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	_sugar_jobject_set_string (self, "mime_type", value);
	g_object_notify ((GObject *) self, "mime-type");
}


SugarShareScope sugar_jobject_get_share_scope (SugarJobject* self) {
	SugarShareScope result;
	const gchar* _tmp0_ = NULL;
	const gchar* field_value;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = _sugar_jobject_get_string (self, "share-scope");
	field_value = _tmp0_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				if (!_tmp1_) {
					i++;
				}
				_tmp1_ = FALSE;
				if (!(i < SUGAR_SHARE_SCOPE_LAST)) {
					break;
				}
				if (g_strcmp0 (field_value, SUGAR_JOBJECT__share_scope_values[i]) == 0) {
					result = (SugarShareScope) i;
					return result;
				}
			}
		}
	}
	result = SUGAR_SHARE_SCOPE_PRIVATE;
	return result;
}


void sugar_jobject_set_share_scope (SugarJobject* self, SugarShareScope value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (value < 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = value >= SUGAR_SHARE_SCOPE_LAST;
	}
	if (_tmp0_) {
		value = SUGAR_SHARE_SCOPE_PRIVATE;
	}
	_sugar_jobject_set_string (self, "share-scope", SUGAR_JOBJECT__share_scope_values[value]);
	g_object_notify ((GObject *) self, "share-scope");
}


const gchar* sugar_jobject_get_activity (SugarJobject* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	const gchar* field_value;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _sugar_jobject_get_string (self, "activity");
	field_value = _tmp0_;
	_tmp1_ = string_get (field_value, (glong) 0);
	if (_tmp1_ != '\0') {
		result = field_value;
		return result;
	} else {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = sugar_jobject_get_uid (self);
		g_warning ("jobject.vala:145: Empty activity for %s jobject", _tmp2_);
		result = "unknown.activity";
		return result;
	}
}


void sugar_jobject_set_activity (SugarJobject* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	_sugar_jobject_set_string (self, "activity", value);
	g_object_notify ((GObject *) self, "activity");
}


const gchar* sugar_jobject_get_activity_id (SugarJobject* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	const gchar* field_value;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _sugar_jobject_get_string (self, "activity_id");
	field_value = _tmp0_;
	_tmp1_ = string_get (field_value, (glong) 0);
	if (_tmp1_ != '\0') {
		result = field_value;
		return result;
	} else {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = sugar_jobject_get_uid (self);
		g_warning ("jobject.vala:166: Empty activity_id for %s jobject", _tmp2_);
		result = "0000000000000000000000000000000000000000";
		return result;
	}
}


void sugar_jobject_set_activity_id (SugarJobject* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	_sugar_jobject_set_string (self, "activity_id", value);
	g_object_notify ((GObject *) self, "activity-id");
}


gboolean sugar_jobject_get_keep (SugarJobject* self) {
	gboolean result;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = _sugar_jobject_get_string (self, "keep");
	_tmp1_ = atoi (_tmp0_);
	result = _tmp1_ != 0;
	return result;
}


void sugar_jobject_set_keep (SugarJobject* self, gboolean value) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	if (value) {
		_tmp0_ = "1";
	} else {
		_tmp0_ = "0";
	}
	_sugar_jobject_set_string (self, "keep", _tmp0_);
	g_object_notify ((GObject *) self, "keep");
}


GArray* sugar_jobject_get_preview (SugarJobject* self) {
	GArray* result;
	GValue* _tmp0_ = NULL;
	GValue* preview_value;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = sugar_jobject_get_field (self, "preview");
	preview_value = _tmp0_;
	_tmp1_ = G_VALUE_HOLDS (preview_value, G_TYPE_BOXED);
	if (_tmp1_) {
		void* _tmp2_ = NULL;
		_tmp2_ = g_value_get_boxed (preview_value);
		result = (GArray*) _tmp2_;
		return result;
	} else {
		result = NULL;
		return result;
	}
}


void sugar_jobject_set_preview (SugarJobject* self, GArray* value) {
	GType _tmp0_;
	GValue _tmp1_ = {0};
	GValue _tmp2_ = {0};
	GValue preview_value;
	g_return_if_fail (self != NULL);
	_tmp0_ = DBUS_TYPE_G_UCHAR_ARRAY;
	g_value_init (&_tmp1_, _tmp0_);
	_tmp2_ = _tmp1_;
	preview_value = _tmp2_;
	g_value_set_boxed (&preview_value, value);
	_sugar_jobject_set_field (self, "preview", &preview_value);
	G_IS_VALUE (&preview_value) ? (g_value_unset (&preview_value), NULL) : NULL;
	g_object_notify ((GObject *) self, "preview");
}


void sugar_jobject_get_icon_color (SugarJobject* self, SugarXoColor* result) {
	const gchar* _tmp0_ = NULL;
	const gchar* field_value;
	gchar _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _sugar_jobject_get_string (self, "icon-color");
	field_value = _tmp0_;
	_tmp1_ = string_get (field_value, (glong) 0);
	if (_tmp1_ != '\0') {
		SugarXoColor* _tmp2_ = NULL;
		SugarXoColor* _tmp3_;
		SugarXoColor _tmp4_;
		_tmp2_ = sugar_xo_color_from_string (field_value);
		_tmp3_ = _tmp2_;
		_tmp4_ = *_tmp3_;
		_g_free0 (_tmp3_);
		*result = _tmp4_;
		return;
	} else {
		const gchar* _tmp5_ = NULL;
		SugarXoColor _tmp6_ = {0};
		_tmp5_ = sugar_jobject_get_uid (self);
		g_warning ("jobject.vala:218: Jobject %s lacks of icon-color", _tmp5_);
		sugar_profile_get_color (&_tmp6_);
		*result = _tmp6_;
		return;
	}
}


void sugar_jobject_set_icon_color (SugarJobject* self, SugarXoColor* value) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = sugar_xo_color_to_string (value);
	_tmp1_ = _tmp0_;
	_sugar_jobject_set_string (self, "icon-color", _tmp1_);
	_g_free0 (_tmp1_);
	g_object_notify ((GObject *) self, "icon-color");
}


static gchar* _dynamic_get_filename6 (DBusGProxy* self, const gchar* param1, GError** error) {
	gchar* result;
	dbus_g_proxy_call (self, "get_filename", error, G_TYPE_STRING, param1, G_TYPE_INVALID, G_TYPE_STRING, &result, G_TYPE_INVALID);
	if (*error) {
		return NULL;
	}
	return result;
}


const gchar* sugar_jobject_get_file_path (SugarJobject* self) {
	const gchar* result;
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->_file_path == NULL) {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = sugar_jobject_get_uid (self);
		_tmp0_ = _tmp1_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		DBusGProxy* _tmp2_ = NULL;
		DBusGProxy* _tmp3_;
		DBusGProxy* _tmp4_;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp2_ = _sugar_jobject_get_ds (self, &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
		_tmp4_ = _tmp3_;
		_tmp5_ = sugar_jobject_get_uid (self);
		_tmp6_ = _dynamic_get_filename6 (_tmp4_, _tmp5_, &_inner_error_);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp4_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
		_g_free0 (self->priv->_file_path);
		self->priv->_file_path = _tmp8_;
		goto __finally5;
		__catch5_g_error:
		{
			GError * _error_;
			const gchar* _tmp9_ = NULL;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			_tmp9_ = sugar_jobject_get_uid (self);
			g_warning ("jobject.vala:242: Cannot get filename for %s: %s", _tmp9_, _error_->message);
			_g_error_free0 (_error_);
		}
		__finally5:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = self->priv->_file_path;
	return result;
}


static void sugar_jobject__writequeueitem_init (SugarJobject_WriteQueueItem *self, const gchar* file_path, gboolean transfer_ownership, gboolean cow) {
	gboolean _tmp6_ = FALSE;
	memset (self, 0, sizeof (SugarJobject_WriteQueueItem));
	if (file_path == NULL) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("");
		_g_free0 ((*self).file_path);
		(*self).file_path = _tmp0_;
		transfer_ownership = FALSE;
	} else {
		gboolean _tmp1_;
		_tmp1_ = g_path_is_absolute (file_path);
		if (!_tmp1_) {
			gchar* _tmp2_ = NULL;
			gchar* _tmp3_;
			gchar* _tmp4_ = NULL;
			_tmp2_ = g_get_current_dir ();
			_tmp3_ = _tmp2_;
			_tmp4_ = g_build_filename (_tmp3_, file_path, NULL);
			_g_free0 ((*self).file_path);
			(*self).file_path = _tmp4_;
			_g_free0 (_tmp3_);
		} else {
			gchar* _tmp5_;
			_tmp5_ = g_strdup (file_path);
			_g_free0 ((*self).file_path);
			(*self).file_path = _tmp5_;
		}
	}
	(*self).cow = cow;
	if (transfer_ownership) {
		gboolean _tmp7_;
		_tmp7_ = sugar_environ_get_secure_mode ();
		_tmp6_ = _tmp7_;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		g_warning ("jobject.vala:619: %s", "There is no way to just move files to the " "datastore under rainbow without creating 0777 " "directories, thus have to copy file");
		(*self).transfer_ownership = FALSE;
		(*self).unlink_on_success = TRUE;
		(*self).unlink_on_fail = TRUE;
	} else {
		(*self).transfer_ownership = transfer_ownership;
		(*self).unlink_on_success = FALSE;
		(*self).unlink_on_fail = transfer_ownership;
	}
}


static void sugar_jobject__writequeueitem_copy (const SugarJobject_WriteQueueItem* self, SugarJobject_WriteQueueItem* dest) {
	dest->file_path = g_strdup (self->file_path);
	dest->transfer_ownership = self->transfer_ownership;
	dest->cow = self->cow;
	dest->unlink_on_success = self->unlink_on_success;
	dest->unlink_on_fail = self->unlink_on_fail;
}


static void sugar_jobject__writequeueitem_destroy (SugarJobject_WriteQueueItem* self) {
	_g_free0 ((*self).file_path);
}


static SugarJobject_WriteQueueItem* sugar_jobject__writequeueitem_dup (const SugarJobject_WriteQueueItem* self) {
	SugarJobject_WriteQueueItem* dup;
	dup = g_new0 (SugarJobject_WriteQueueItem, 1);
	sugar_jobject__writequeueitem_copy (self, dup);
	return dup;
}


static void sugar_jobject__writequeueitem_free (SugarJobject_WriteQueueItem* self) {
	sugar_jobject__writequeueitem_destroy (self);
	g_free (self);
}


static GType sugar_jobject__writequeueitem_get_type (void) {
	static volatile gsize sugar_jobject__writequeueitem_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_jobject__writequeueitem_type_id__volatile)) {
		GType sugar_jobject__writequeueitem_type_id;
		sugar_jobject__writequeueitem_type_id = g_boxed_type_register_static ("SugarJobject_WriteQueueItem", (GBoxedCopyFunc) sugar_jobject__writequeueitem_dup, (GBoxedFreeFunc) sugar_jobject__writequeueitem_free);
		g_once_init_leave (&sugar_jobject__writequeueitem_type_id__volatile, sugar_jobject__writequeueitem_type_id);
	}
	return sugar_jobject__writequeueitem_type_id__volatile;
}


static void sugar_jobject_class_init (SugarJobjectClass * klass) {
	sugar_jobject_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SugarJobjectPrivate));
	G_OBJECT_CLASS (klass)->dispose = sugar_jobject_real_dispose;
	G_OBJECT_CLASS (klass)->get_property = _vala_sugar_jobject_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sugar_jobject_set_property;
	G_OBJECT_CLASS (klass)->finalize = sugar_jobject_finalize;
	/**
	     * Unique journal entry id
	     *
	     * Value could be null if jobject was never written to sugar-datastore.
	     * This field can not be changed manually.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_JOBJECT_UID, g_param_spec_string ("uid", "uid", "uid", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * Last time when jobject was saved by activity
	     *
	     * While changing metadata in Journal activity,
	     * timestamp is not being changed.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_JOBJECT_TIMESTAMP, g_param_spec_long ("timestamp", "timestamp", "timestamp", G_MINLONG, G_MAXLONG, 0L, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Title of journal entry
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_JOBJECT_TITLE, g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Was title value set by user
	     *
	     * This value should be set to true after setting title in reaction on user
	     * input e.g. after setting title from GUI entry widget.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_JOBJECT_TITLE_SET_BY_USER, g_param_spec_boolean ("title-set-by-user", "title-set-by-user", "title-set-by-user", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * MIME type of file associated with journal entry
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_JOBJECT_MIME_TYPE, g_param_spec_string ("mime-type", "mime-type", "mime-type", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Type of sharing of journal entry
	     *
	     * How object was shared.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_JOBJECT_SHARE_SCOPE, g_param_spec_enum ("share-scope", "share-scope", "share-scope", SUGAR_TYPE_SHARE_SCOPE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The bundle_id of activity which created this object
	     *
	     * This value can't be empty or set explicitly, it will be initiated only in
	     * Jobject.create.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_JOBJECT_ACTIVITY, g_param_spec_string ("activity", "activity", "activity", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The activity instance id which created this object
	     *
	     * This value can't be empty or set explicitly, it will be initiated only in
	     * Jobject.create.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_JOBJECT_ACTIVITY_ID, g_param_spec_string ("activity-id", "activity-id", "activity-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Was object stared by user
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_JOBJECT_KEEP, g_param_spec_boolean ("keep", "keep", "keep", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Preview of lastly saved object
	     *
	     * Preview should be in PNG format.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_JOBJECT_PREVIEW, g_param_spec_pointer ("preview", "preview", "preview", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Color pair of user who created this object
	     *
	     * If object was shared, this color could be not color of current user.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_JOBJECT_ICON_COLOR, g_param_spec_boxed ("icon-color", "icon-color", "icon-color", SUGAR_TYPE_XO_COLOR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * File that is associated with current Jobject
	     *
	     * @return  full path or null if there is no associated file
	     *
	     * Property returns path to the file that is stored by sugar-datastore.
	     * The only valid operation is read. To change associated file,
	     * use Jobject.write_file.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_JOBJECT_FILE_PATH, g_param_spec_string ("file-path", "file-path", "file-path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * Signal will be emited on receiving async results of Jobject.write call
	     *
	     * @param error if error was occured, error will contain error message,
	     *              null otherwise
	     */
	g_signal_new ("write_end", SUGAR_TYPE_JOBJECT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}


static void sugar_jobject_instance_init (SugarJobject * self) {
	self->priv = SUGAR_JOBJECT_GET_PRIVATE (self);
}


static void sugar_jobject_finalize (GObject* obj) {
	SugarJobject * self;
	self = SUGAR_JOBJECT (obj);
	_g_hash_table_unref0 (self->priv->_metadata);
	_g_hash_table_unref0 (self->priv->_changed);
	_g_free0 (self->priv->_file_path);
	G_OBJECT_CLASS (sugar_jobject_parent_class)->finalize (obj);
}


/**
 * High level interface to journal entry
 *
 * To create new journal entry, call Journal.create to make empty local object,
 * then call Jobject.write to create journal entry on sugar-datastore side.
 * If journal entry already exists, use Journal.find.
 *
 * On every property change (or set_field invocation), Jobject won't send new
 * data to sugar-datastore, call Jobject.write. Properties could be changed
 * implicitly (if entry was changed in Journal activity for example), so,
 * connect to notification signal to reflect on such changes e.g. notify::title.
 */
GType sugar_jobject_get_type (void) {
	static volatile gsize sugar_jobject_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_jobject_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SugarJobjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar_jobject_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SugarJobject), 0, (GInstanceInitFunc) sugar_jobject_instance_init, NULL };
		GType sugar_jobject_type_id;
		sugar_jobject_type_id = g_type_register_static (G_TYPE_OBJECT, "SugarJobject", &g_define_type_info, 0);
		g_once_init_leave (&sugar_jobject_type_id__volatile, sugar_jobject_type_id);
	}
	return sugar_jobject_type_id__volatile;
}


static void _vala_sugar_jobject_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SugarJobject * self;
	SugarXoColor boxed0;
	self = SUGAR_JOBJECT (object);
	switch (property_id) {
		case SUGAR_JOBJECT_UID:
		g_value_set_string (value, sugar_jobject_get_uid (self));
		break;
		case SUGAR_JOBJECT_TIMESTAMP:
		g_value_set_long (value, sugar_jobject_get_timestamp (self));
		break;
		case SUGAR_JOBJECT_TITLE:
		g_value_set_string (value, sugar_jobject_get_title (self));
		break;
		case SUGAR_JOBJECT_TITLE_SET_BY_USER:
		g_value_set_boolean (value, sugar_jobject_get_title_set_by_user (self));
		break;
		case SUGAR_JOBJECT_MIME_TYPE:
		g_value_set_string (value, sugar_jobject_get_mime_type (self));
		break;
		case SUGAR_JOBJECT_SHARE_SCOPE:
		g_value_set_enum (value, sugar_jobject_get_share_scope (self));
		break;
		case SUGAR_JOBJECT_ACTIVITY:
		g_value_set_string (value, sugar_jobject_get_activity (self));
		break;
		case SUGAR_JOBJECT_ACTIVITY_ID:
		g_value_set_string (value, sugar_jobject_get_activity_id (self));
		break;
		case SUGAR_JOBJECT_KEEP:
		g_value_set_boolean (value, sugar_jobject_get_keep (self));
		break;
		case SUGAR_JOBJECT_PREVIEW:
		g_value_set_pointer (value, sugar_jobject_get_preview (self));
		break;
		case SUGAR_JOBJECT_ICON_COLOR:
		sugar_jobject_get_icon_color (self, &boxed0);
		g_value_set_boxed (value, &boxed0);
		break;
		case SUGAR_JOBJECT_FILE_PATH:
		g_value_set_string (value, sugar_jobject_get_file_path (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_sugar_jobject_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SugarJobject * self;
	self = SUGAR_JOBJECT (object);
	switch (property_id) {
		case SUGAR_JOBJECT_UID:
		sugar_jobject_set_uid (self, g_value_get_string (value));
		break;
		case SUGAR_JOBJECT_TIMESTAMP:
		sugar_jobject_set_timestamp (self, g_value_get_long (value));
		break;
		case SUGAR_JOBJECT_TITLE:
		sugar_jobject_set_title (self, g_value_get_string (value));
		break;
		case SUGAR_JOBJECT_TITLE_SET_BY_USER:
		sugar_jobject_set_title_set_by_user (self, g_value_get_boolean (value));
		break;
		case SUGAR_JOBJECT_MIME_TYPE:
		sugar_jobject_set_mime_type (self, g_value_get_string (value));
		break;
		case SUGAR_JOBJECT_SHARE_SCOPE:
		sugar_jobject_set_share_scope (self, g_value_get_enum (value));
		break;
		case SUGAR_JOBJECT_ACTIVITY:
		sugar_jobject_set_activity (self, g_value_get_string (value));
		break;
		case SUGAR_JOBJECT_ACTIVITY_ID:
		sugar_jobject_set_activity_id (self, g_value_get_string (value));
		break;
		case SUGAR_JOBJECT_KEEP:
		sugar_jobject_set_keep (self, g_value_get_boolean (value));
		break;
		case SUGAR_JOBJECT_PREVIEW:
		sugar_jobject_set_preview (self, g_value_get_pointer (value));
		break;
		case SUGAR_JOBJECT_ICON_COLOR:
		sugar_jobject_set_icon_color (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



