/* gtk-2.18.c
 *
 * Copyright (C) 2010, Aleksey Lim
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>

gboolean gtk_widget_get_visible (GtkWidget *widget) {
    g_return_val_if_fail (GTK_IS_WIDGET (widget), FALSE);
    return GTK_WIDGET_VISIBLE (widget);
}

void gtk_widget_set_visible (GtkWidget *widget, gboolean visible) {
    g_return_if_fail (GTK_IS_WIDGET (widget));
    if (visible)
        gtk_widget_show (widget);
    else
        gtk_widget_hide (widget);
}

GtkStateType gtk_widget_get_state (GtkWidget *widget) {
    g_return_val_if_fail (GTK_IS_WIDGET (widget), GTK_STATE_NORMAL);
    return widget->state;
}
