/* toolitem.c generated by valac 0.12.1, the Vala compiler
 * generated from toolitem.vala, do not modify */

/* toolitem.vala
 *
 * Copyright (C) 2010, Aleksey Lim
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/*
 * Port from original sugar-toolkit project.
 * File:   src/sugar/graphics/toolbutton.py
 *         src/sugar/graphics/toggletoolbutton.py
 *         src/sugar/graphics/radiotoolbutton.py
 * Commit: 161aec771e058416d672c36b3129cc4a1a11c7e2
 *
 * Copyright (C) 2007, Red Hat, Inc.
 * Copyright (C) 2008, One Laptop Per Child
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include "polyol/gui.h"
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _sugar_accelerator_unref0(var) ((var == NULL) ? NULL : (var = (sugar_accelerator_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _SugarToolButtonPrivate {
	SugarInvoker* _invoker;
	SugarAccelerator* _accelerator;
	gchar* _tooltip;
};

struct _SugarComboToolButtonPrivate {
	GtkRadioAction* _action;
};

struct _SugarToggleToolButtonPrivate {
	SugarInvoker* _invoker;
	SugarAccelerator* _accelerator;
	gchar* _tooltip;
};

struct _SugarRadioToolButtonPrivate {
	SugarInvoker* _invoker;
	SugarAccelerator* _accelerator;
	gchar* _tooltip;
};


static gpointer sugar_tool_button_parent_class = NULL;
static gpointer sugar_combo_tool_button_parent_class = NULL;
static gpointer sugar_toggle_tool_button_parent_class = NULL;
static gpointer sugar_radio_tool_button_parent_class = NULL;

#define SUGAR_TOOL_BUTTON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SUGAR_TYPE_TOOL_BUTTON, SugarToolButtonPrivate))
enum  {
	SUGAR_TOOL_BUTTON_DUMMY_PROPERTY,
	SUGAR_TOOL_BUTTON_INVOKER,
	SUGAR_TOOL_BUTTON_TOOLTIP,
	SUGAR_TOOL_BUTTON_ACCELERATOR,
	SUGAR_TOOL_BUTTON_ICON_NAME,
	SUGAR_TOOL_BUTTON_ICON
};
static void sugar_tool_button_real_clicked (GtkToolButton* base);
static void sugar_tool_button_real_hierarchy_changed (GtkWidget* base, GtkWidget* previous_toplevel);
static gboolean sugar_tool_button_real_expose_event (GtkWidget* base, GdkEventExpose* event);
void _sugar_expose_event (GtkToolItem* item, SugarInvoker* invoker, GdkEventExpose* event);
static void sugar_tool_button_set_invoker (SugarToolButton* self, SugarInvoker* value);
static GObject * sugar_tool_button_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void sugar_tool_button_finalize (GObject* obj);
static void _vala_sugar_tool_button_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sugar_tool_button_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define SUGAR_COMBO_TOOL_BUTTON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SUGAR_TYPE_COMBO_TOOL_BUTTON, SugarComboToolButtonPrivate))
enum  {
	SUGAR_COMBO_TOOL_BUTTON_DUMMY_PROPERTY,
	SUGAR_COMBO_TOOL_BUTTON_ACTION
};
static void sugar_combo_tool_button_real_clicked (GtkToolButton* base);
static void _sugar_combo_tool_button_action_sensitive_cb (SugarComboToolButton* self, GObject* sender, GParamSpec* param);
static void _sugar_combo_tool_button_on_action_update (SugarComboToolButton* self);
static void _sugar_combo_tool_button_action_changed_cb (SugarComboToolButton* self, GtkRadioAction* current);
static void __sugar_combo_tool_button_action_sensitive_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __sugar_combo_tool_button_action_changed_cb_gtk_radio_action_changed (GtkRadioAction* _sender, GtkRadioAction* current, gpointer self);
static void sugar_combo_tool_button_finalize (GObject* obj);
static void _vala_sugar_combo_tool_button_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sugar_combo_tool_button_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define SUGAR_TOGGLE_TOOL_BUTTON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SUGAR_TYPE_TOGGLE_TOOL_BUTTON, SugarToggleToolButtonPrivate))
enum  {
	SUGAR_TOGGLE_TOOL_BUTTON_DUMMY_PROPERTY,
	SUGAR_TOGGLE_TOOL_BUTTON_INVOKER,
	SUGAR_TOGGLE_TOOL_BUTTON_TOOLTIP,
	SUGAR_TOGGLE_TOOL_BUTTON_ACCELERATOR,
	SUGAR_TOGGLE_TOOL_BUTTON_ICON_NAME,
	SUGAR_TOGGLE_TOOL_BUTTON_ICON
};
static void sugar_toggle_tool_button_real_clicked (GtkToolButton* base);
static void sugar_toggle_tool_button_real_hierarchy_changed (GtkWidget* base, GtkWidget* previous_toplevel);
static gboolean sugar_toggle_tool_button_real_expose_event (GtkWidget* base, GdkEventExpose* event);
static void sugar_toggle_tool_button_set_invoker (SugarToggleToolButton* self, SugarInvoker* value);
static GObject * sugar_toggle_tool_button_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void sugar_toggle_tool_button_finalize (GObject* obj);
static void _vala_sugar_toggle_tool_button_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sugar_toggle_tool_button_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define SUGAR_RADIO_TOOL_BUTTON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SUGAR_TYPE_RADIO_TOOL_BUTTON, SugarRadioToolButtonPrivate))
enum  {
	SUGAR_RADIO_TOOL_BUTTON_DUMMY_PROPERTY,
	SUGAR_RADIO_TOOL_BUTTON_INVOKER,
	SUGAR_RADIO_TOOL_BUTTON_TOOLTIP,
	SUGAR_RADIO_TOOL_BUTTON_ACCELERATOR,
	SUGAR_RADIO_TOOL_BUTTON_ICON_NAME,
	SUGAR_RADIO_TOOL_BUTTON_ICON
};
static void sugar_radio_tool_button_real_clicked (GtkToolButton* base);
static void sugar_radio_tool_button_real_hierarchy_changed (GtkWidget* base, GtkWidget* previous_toplevel);
static gboolean sugar_radio_tool_button_real_expose_event (GtkWidget* base, GdkEventExpose* event);
static void sugar_radio_tool_button_set_invoker (SugarRadioToolButton* self, SugarInvoker* value);
static GObject * sugar_radio_tool_button_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void sugar_radio_tool_button_finalize (GObject* obj);
static void _vala_sugar_radio_tool_button_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sugar_radio_tool_button_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void sugar_tool_button_real_clicked (GtkToolButton* base) {
	SugarToolButton * self;
	self = (SugarToolButton*) base;
	sugar_invoker_popdown (self->priv->_invoker);
}


static void sugar_tool_button_real_hierarchy_changed (GtkWidget* base, GtkWidget* previous_toplevel) {
	SugarToolButton * self;
	self = (SugarToolButton*) base;
	if (((GtkBin*) self)->child != NULL) {
		((GtkBin*) self)->child->state = (guchar) GTK_STATE_NORMAL;
	}
}


static gboolean sugar_tool_button_real_expose_event (GtkWidget* base, GdkEventExpose* event) {
	SugarToolButton * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	self = (SugarToolButton*) base;
	_sugar_expose_event ((GtkToolItem*) self, self->priv->_invoker, event);
	_tmp0_ = GTK_WIDGET_CLASS (sugar_tool_button_parent_class)->expose_event ((GtkWidget*) GTK_TOOL_BUTTON (self), event);
	result = _tmp0_;
	return result;
}


SugarToolButton* sugar_tool_button_construct (GType object_type) {
	SugarToolButton * self = NULL;
	self = (SugarToolButton*) g_object_new (object_type, NULL);
	return self;
}


SugarToolButton* sugar_tool_button_new (void) {
	return sugar_tool_button_construct (SUGAR_TYPE_TOOL_BUTTON);
}


SugarInvoker* sugar_tool_button_get_invoker (SugarToolButton* self) {
	SugarInvoker* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_invoker;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void sugar_tool_button_set_invoker (SugarToolButton* self, SugarInvoker* value) {
	SugarInvoker* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_invoker);
	self->priv->_invoker = _tmp0_;
	g_object_notify ((GObject *) self, "invoker");
}


const gchar* sugar_tool_button_get_tooltip (SugarToolButton* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_tooltip;
	return result;
}


void sugar_tool_button_set_tooltip (SugarToolButton* self, const gchar* value) {
	gchar* _tmp0_;
	SugarPalette* _tmp1_ = NULL;
	SugarPalette* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_tooltip);
	self->priv->_tooltip = _tmp0_;
	_tmp1_ = sugar_invoker_get_palette (self->priv->_invoker);
	if (_tmp1_ == NULL) {
		SugarPalette* _tmp2_ = NULL;
		SugarPalette* _tmp3_;
		_tmp2_ = sugar_palette_new ();
		_tmp3_ = g_object_ref_sink (_tmp2_);
		sugar_invoker_set_palette (self->priv->_invoker, _tmp3_);
		_g_object_unref0 (_tmp3_);
	}
	_tmp4_ = sugar_invoker_get_palette (self->priv->_invoker);
	_tmp5_ = sugar_tool_button_get_tooltip (self);
	sugar_palette_set_primary_text (_tmp4_, _tmp5_);
	_tmp6_ = sugar_tool_button_get_tooltip (self);
	gtk_tool_button_set_label ((GtkToolButton*) self, _tmp6_);
	g_object_notify ((GObject *) self, "tooltip");
}


const gchar* sugar_tool_button_get_accelerator (SugarToolButton* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = sugar_accelerator_get_name (self->priv->_accelerator);
	result = _tmp0_;
	return result;
}


void sugar_tool_button_set_accelerator (SugarToolButton* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	sugar_accelerator_set_name (self->priv->_accelerator, value);
	g_object_notify ((GObject *) self, "accelerator");
}


void sugar_tool_button_set_icon_name (SugarToolButton* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (value == NULL) {
		gtk_tool_button_set_icon_widget ((GtkToolButton*) self, NULL);
	} else {
		SugarIcon* _tmp0_ = NULL;
		SugarIcon* icon;
		_tmp0_ = sugar_icon_new ();
		icon = g_object_ref_sink (_tmp0_);
		sugar_icon_set_file (icon, value);
		gtk_widget_show ((GtkWidget*) icon);
		gtk_tool_button_set_icon_widget ((GtkToolButton*) self, (GtkWidget*) icon);
		_g_object_unref0 (icon);
	}
	g_object_notify ((GObject *) self, "icon-name");
}


SugarIcon* sugar_tool_button_get_icon (SugarToolButton* self) {
	SugarIcon* result;
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_tool_button_get_icon_widget ((GtkToolButton*) self);
	_tmp1_ = _tmp0_;
	result = SUGAR_IS_ICON (_tmp1_) ? ((SugarIcon*) _tmp1_) : NULL;
	return result;
}


static GObject * sugar_tool_button_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SugarToolButton * self;
	SugarAccelerator* _tmp0_ = NULL;
	SugarToolConnector* _tmp1_ = NULL;
	SugarToolConnector* _tmp2_;
	SugarInvoker* _tmp3_ = NULL;
	SugarInvoker* _tmp4_;
	parent_class = G_OBJECT_CLASS (sugar_tool_button_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SUGAR_TOOL_BUTTON (obj);
	_tmp0_ = sugar_accelerator_new ((GtkWidget*) self, "clicked");
	_sugar_accelerator_unref0 (self->priv->_accelerator);
	self->priv->_accelerator = _tmp0_;
	_tmp1_ = sugar_tool_connector_new ((GtkToolItem*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = sugar_invoker_new ((SugarConnector*) _tmp2_, "default");
	_tmp4_ = _tmp3_;
	sugar_tool_button_set_invoker (self, _tmp4_);
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
	return obj;
}


static void sugar_tool_button_class_init (SugarToolButtonClass * klass) {
	sugar_tool_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SugarToolButtonPrivate));
	GTK_TOOL_BUTTON_CLASS (klass)->clicked = sugar_tool_button_real_clicked;
	GTK_WIDGET_CLASS (klass)->hierarchy_changed = sugar_tool_button_real_hierarchy_changed;
	GTK_WIDGET_CLASS (klass)->expose_event = sugar_tool_button_real_expose_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_sugar_tool_button_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sugar_tool_button_set_property;
	G_OBJECT_CLASS (klass)->constructor = sugar_tool_button_constructor;
	G_OBJECT_CLASS (klass)->finalize = sugar_tool_button_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_TOOL_BUTTON_INVOKER, g_param_spec_object ("invoker", "invoker", "invoker", SUGAR_TYPE_INVOKER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/** Set a simple palette with just a single label */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_TOOL_BUTTON_TOOLTIP, g_param_spec_string ("tooltip", "tooltip", "tooltip", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_TOOL_BUTTON_ACCELERATOR, g_param_spec_string ("accelerator", "accelerator", "accelerator", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_TOOL_BUTTON_ICON_NAME, g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_TOOL_BUTTON_ICON, g_param_spec_object ("icon", "icon", "icon", SUGAR_TYPE_ICON, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void sugar_tool_button_instance_init (SugarToolButton * self) {
	self->priv = SUGAR_TOOL_BUTTON_GET_PRIVATE (self);
}


static void sugar_tool_button_finalize (GObject* obj) {
	SugarToolButton * self;
	self = SUGAR_TOOL_BUTTON (obj);
	_g_object_unref0 (self->priv->_invoker);
	_sugar_accelerator_unref0 (self->priv->_accelerator);
	_g_free0 (self->priv->_tooltip);
	G_OBJECT_CLASS (sugar_tool_button_parent_class)->finalize (obj);
}


GType sugar_tool_button_get_type (void) {
	static volatile gsize sugar_tool_button_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_tool_button_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SugarToolButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar_tool_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SugarToolButton), 0, (GInstanceInitFunc) sugar_tool_button_instance_init, NULL };
		GType sugar_tool_button_type_id;
		sugar_tool_button_type_id = g_type_register_static (GTK_TYPE_TOOL_BUTTON, "SugarToolButton", &g_define_type_info, 0);
		g_once_init_leave (&sugar_tool_button_type_id__volatile, sugar_tool_button_type_id);
	}
	return sugar_tool_button_type_id__volatile;
}


static void _vala_sugar_tool_button_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SugarToolButton * self;
	self = SUGAR_TOOL_BUTTON (object);
	switch (property_id) {
		case SUGAR_TOOL_BUTTON_INVOKER:
		g_value_set_object (value, sugar_tool_button_get_invoker (self));
		break;
		case SUGAR_TOOL_BUTTON_TOOLTIP:
		g_value_set_string (value, sugar_tool_button_get_tooltip (self));
		break;
		case SUGAR_TOOL_BUTTON_ACCELERATOR:
		g_value_set_string (value, sugar_tool_button_get_accelerator (self));
		break;
		case SUGAR_TOOL_BUTTON_ICON:
		g_value_set_object (value, sugar_tool_button_get_icon (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_sugar_tool_button_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SugarToolButton * self;
	self = SUGAR_TOOL_BUTTON (object);
	switch (property_id) {
		case SUGAR_TOOL_BUTTON_INVOKER:
		sugar_tool_button_set_invoker (self, g_value_get_object (value));
		break;
		case SUGAR_TOOL_BUTTON_TOOLTIP:
		sugar_tool_button_set_tooltip (self, g_value_get_string (value));
		break;
		case SUGAR_TOOL_BUTTON_ACCELERATOR:
		sugar_tool_button_set_accelerator (self, g_value_get_string (value));
		break;
		case SUGAR_TOOL_BUTTON_ICON_NAME:
		sugar_tool_button_set_icon_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void sugar_combo_tool_button_real_clicked (GtkToolButton* base) {
	SugarComboToolButton * self;
	gboolean _tmp0_ = FALSE;
	SugarInvoker* _tmp1_ = NULL;
	gboolean _tmp2_;
	self = (SugarComboToolButton*) base;
	_tmp1_ = sugar_tool_button_get_invoker ((SugarToolButton*) self);
	_tmp2_ = sugar_invoker_get_is_up (_tmp1_);
	if (_tmp2_) {
		gboolean _tmp3_ = FALSE;
		SugarInvoker* _tmp4_ = NULL;
		SugarPaletteWindow* _tmp5_ = NULL;
		_tmp4_ = sugar_tool_button_get_invoker ((SugarToolButton*) self);
		_tmp5_ = sugar_invoker_get_palette_window (_tmp4_);
		if (_tmp5_ == NULL) {
			_tmp3_ = TRUE;
		} else {
			SugarInvoker* _tmp6_ = NULL;
			SugarPaletteWindow* _tmp7_ = NULL;
			gboolean _tmp8_;
			_tmp6_ = sugar_tool_button_get_invoker ((SugarToolButton*) self);
			_tmp7_ = sugar_invoker_get_palette_window (_tmp6_);
			_tmp8_ = sugar_palette_window_get_secondary_visible (_tmp7_);
			_tmp3_ = _tmp8_;
		}
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		SugarInvoker* _tmp9_ = NULL;
		_tmp9_ = sugar_tool_button_get_invoker ((SugarToolButton*) self);
		sugar_invoker_popdown (_tmp9_);
	} else {
		SugarInvoker* _tmp10_ = NULL;
		_tmp10_ = sugar_tool_button_get_invoker ((SugarToolButton*) self);
		sugar_invoker_popup (_tmp10_);
	}
}


static void _sugar_combo_tool_button_action_sensitive_cb (SugarComboToolButton* self, GObject* sender, GParamSpec* param) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (param != NULL);
	_sugar_combo_tool_button_on_action_update (self);
}


static void _sugar_combo_tool_button_action_changed_cb (SugarComboToolButton* self, GtkRadioAction* current) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (current != NULL);
	_sugar_combo_tool_button_on_action_update (self);
}


static void _sugar_combo_tool_button_on_action_update (SugarComboToolButton* self) {
	GtkRadioAction* _tmp0_ = NULL;
	GSList* _tmp1_ = NULL;
	SugarIcon* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = sugar_combo_tool_button_get_action (self);
	_tmp1_ = gtk_radio_action_get_group (_tmp0_);
	{
		GSList* i_collection;
		GSList* i_it;
		i_collection = _tmp1_;
		for (i_it = i_collection; i_it != NULL; i_it = i_it->next) {
			GtkRadioAction* _tmp2_;
			GtkRadioAction* i;
			_tmp2_ = _g_object_ref0 ((GtkRadioAction*) i_it->data);
			i = _tmp2_;
			{
				gint _tmp3_;
				gint _tmp4_;
				GtkRadioAction* _tmp6_ = NULL;
				gboolean _tmp7_;
				g_object_get (i, "value", &_tmp3_, NULL);
				_tmp4_ = gtk_radio_action_get_current_value (i);
				if (_tmp3_ == _tmp4_) {
					const gchar* _tmp5_ = NULL;
					_tmp5_ = gtk_action_get_icon_name ((GtkAction*) i);
					sugar_tool_button_set_icon_name ((SugarToolButton*) self, _tmp5_);
				}
				_tmp6_ = sugar_combo_tool_button_get_action (self);
				_tmp7_ = gtk_action_get_sensitive ((GtkAction*) _tmp6_);
				gtk_action_set_sensitive ((GtkAction*) i, _tmp7_);
				_g_object_unref0 (i);
			}
		}
	}
	_tmp8_ = sugar_tool_button_get_icon ((SugarToolButton*) self);
	if (_tmp8_ != NULL) {
		SugarIcon* _tmp9_ = NULL;
		GtkRadioAction* _tmp10_ = NULL;
		gboolean _tmp11_;
		SugarIcon* _tmp12_ = NULL;
		_tmp9_ = sugar_tool_button_get_icon ((SugarToolButton*) self);
		_tmp10_ = sugar_combo_tool_button_get_action (self);
		_tmp11_ = gtk_action_get_sensitive ((GtkAction*) _tmp10_);
		gtk_widget_set_sensitive ((GtkWidget*) _tmp9_, _tmp11_);
		_tmp12_ = sugar_tool_button_get_icon ((SugarToolButton*) self);
		gtk_widget_queue_draw ((GtkWidget*) _tmp12_);
	}
}


SugarComboToolButton* sugar_combo_tool_button_construct (GType object_type) {
	SugarComboToolButton * self = NULL;
	self = (SugarComboToolButton*) sugar_tool_button_construct (object_type);
	return self;
}


SugarComboToolButton* sugar_combo_tool_button_new (void) {
	return sugar_combo_tool_button_construct (SUGAR_TYPE_COMBO_TOOL_BUTTON);
}


GtkRadioAction* sugar_combo_tool_button_get_action (SugarComboToolButton* self) {
	GtkRadioAction* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_action;
	return result;
}


static void __sugar_combo_tool_button_action_sensitive_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_sugar_combo_tool_button_action_sensitive_cb (self, _sender, pspec);
}


static void __sugar_combo_tool_button_action_changed_cb_gtk_radio_action_changed (GtkRadioAction* _sender, GtkRadioAction* current, gpointer self) {
	_sugar_combo_tool_button_action_changed_cb (self, current);
}


void sugar_combo_tool_button_set_action (SugarComboToolButton* self, GtkRadioAction* value) {
	GtkRadioAction* _tmp0_ = NULL;
	GtkRadioAction* _tmp6_;
	GtkRadioAction* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = sugar_combo_tool_button_get_action (self);
	if (_tmp0_ != NULL) {
		GtkRadioAction* _tmp1_ = NULL;
		guint _tmp2_;
		GQuark _tmp3_;
		GtkRadioAction* _tmp4_ = NULL;
		guint _tmp5_;
		_tmp1_ = sugar_combo_tool_button_get_action (self);
		g_signal_parse_name ("notify::sensitive", G_TYPE_OBJECT, &_tmp2_, &_tmp3_, TRUE);
		g_signal_handlers_disconnect_matched ((GObject*) _tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, _tmp3_, NULL, (GCallback) __sugar_combo_tool_button_action_sensitive_cb_g_object_notify, self);
		_tmp4_ = sugar_combo_tool_button_get_action (self);
		g_signal_parse_name ("changed", GTK_TYPE_RADIO_ACTION, &_tmp5_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) __sugar_combo_tool_button_action_changed_cb_gtk_radio_action_changed, self);
	}
	_tmp6_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_action);
	self->priv->_action = _tmp6_;
	_tmp7_ = sugar_combo_tool_button_get_action (self);
	if (_tmp7_ != NULL) {
		GtkRadioAction* _tmp8_ = NULL;
		GtkRadioAction* _tmp9_ = NULL;
		_tmp8_ = sugar_combo_tool_button_get_action (self);
		g_signal_connect_object ((GObject*) _tmp8_, "notify::sensitive", (GCallback) __sugar_combo_tool_button_action_sensitive_cb_g_object_notify, self, 0);
		_tmp9_ = sugar_combo_tool_button_get_action (self);
		g_signal_connect_object (_tmp9_, "changed", (GCallback) __sugar_combo_tool_button_action_changed_cb_gtk_radio_action_changed, self, 0);
		_sugar_combo_tool_button_on_action_update (self);
	}
	g_object_notify ((GObject *) self, "action");
}


static void sugar_combo_tool_button_class_init (SugarComboToolButtonClass * klass) {
	sugar_combo_tool_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SugarComboToolButtonPrivate));
	GTK_TOOL_BUTTON_CLASS (klass)->clicked = sugar_combo_tool_button_real_clicked;
	G_OBJECT_CLASS (klass)->get_property = _vala_sugar_combo_tool_button_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sugar_combo_tool_button_set_property;
	G_OBJECT_CLASS (klass)->finalize = sugar_combo_tool_button_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_COMBO_TOOL_BUTTON_ACTION, g_param_spec_object ("action", "action", "action", GTK_TYPE_RADIO_ACTION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void sugar_combo_tool_button_instance_init (SugarComboToolButton * self) {
	self->priv = SUGAR_COMBO_TOOL_BUTTON_GET_PRIVATE (self);
}


static void sugar_combo_tool_button_finalize (GObject* obj) {
	SugarComboToolButton * self;
	self = SUGAR_COMBO_TOOL_BUTTON (obj);
	_g_object_unref0 (self->priv->_action);
	G_OBJECT_CLASS (sugar_combo_tool_button_parent_class)->finalize (obj);
}


GType sugar_combo_tool_button_get_type (void) {
	static volatile gsize sugar_combo_tool_button_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_combo_tool_button_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SugarComboToolButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar_combo_tool_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SugarComboToolButton), 0, (GInstanceInitFunc) sugar_combo_tool_button_instance_init, NULL };
		GType sugar_combo_tool_button_type_id;
		sugar_combo_tool_button_type_id = g_type_register_static (SUGAR_TYPE_TOOL_BUTTON, "SugarComboToolButton", &g_define_type_info, 0);
		g_once_init_leave (&sugar_combo_tool_button_type_id__volatile, sugar_combo_tool_button_type_id);
	}
	return sugar_combo_tool_button_type_id__volatile;
}


static void _vala_sugar_combo_tool_button_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SugarComboToolButton * self;
	self = SUGAR_COMBO_TOOL_BUTTON (object);
	switch (property_id) {
		case SUGAR_COMBO_TOOL_BUTTON_ACTION:
		g_value_set_object (value, sugar_combo_tool_button_get_action (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_sugar_combo_tool_button_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SugarComboToolButton * self;
	self = SUGAR_COMBO_TOOL_BUTTON (object);
	switch (property_id) {
		case SUGAR_COMBO_TOOL_BUTTON_ACTION:
		sugar_combo_tool_button_set_action (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void sugar_toggle_tool_button_real_clicked (GtkToolButton* base) {
	SugarToggleToolButton * self;
	self = (SugarToggleToolButton*) base;
	sugar_invoker_popdown (self->priv->_invoker);
}


static void sugar_toggle_tool_button_real_hierarchy_changed (GtkWidget* base, GtkWidget* previous_toplevel) {
	SugarToggleToolButton * self;
	self = (SugarToggleToolButton*) base;
	if (((GtkBin*) self)->child != NULL) {
		((GtkBin*) self)->child->state = (guchar) GTK_STATE_NORMAL;
	}
}


static gboolean sugar_toggle_tool_button_real_expose_event (GtkWidget* base, GdkEventExpose* event) {
	SugarToggleToolButton * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	self = (SugarToggleToolButton*) base;
	_sugar_expose_event ((GtkToolItem*) self, self->priv->_invoker, event);
	_tmp0_ = GTK_WIDGET_CLASS (sugar_toggle_tool_button_parent_class)->expose_event ((GtkWidget*) GTK_TOGGLE_TOOL_BUTTON (self), event);
	result = _tmp0_;
	return result;
}


SugarToggleToolButton* sugar_toggle_tool_button_construct (GType object_type) {
	SugarToggleToolButton * self = NULL;
	self = (SugarToggleToolButton*) g_object_new (object_type, NULL);
	return self;
}


SugarToggleToolButton* sugar_toggle_tool_button_new (void) {
	return sugar_toggle_tool_button_construct (SUGAR_TYPE_TOGGLE_TOOL_BUTTON);
}


SugarInvoker* sugar_toggle_tool_button_get_invoker (SugarToggleToolButton* self) {
	SugarInvoker* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_invoker;
	return result;
}


static void sugar_toggle_tool_button_set_invoker (SugarToggleToolButton* self, SugarInvoker* value) {
	SugarInvoker* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_invoker);
	self->priv->_invoker = _tmp0_;
	g_object_notify ((GObject *) self, "invoker");
}


const gchar* sugar_toggle_tool_button_get_tooltip (SugarToggleToolButton* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_tooltip;
	return result;
}


void sugar_toggle_tool_button_set_tooltip (SugarToggleToolButton* self, const gchar* value) {
	gchar* _tmp0_;
	SugarPalette* _tmp1_ = NULL;
	SugarPalette* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_tooltip);
	self->priv->_tooltip = _tmp0_;
	_tmp1_ = sugar_invoker_get_palette (self->priv->_invoker);
	if (_tmp1_ == NULL) {
		SugarPalette* _tmp2_ = NULL;
		SugarPalette* _tmp3_;
		_tmp2_ = sugar_palette_new ();
		_tmp3_ = g_object_ref_sink (_tmp2_);
		sugar_invoker_set_palette (self->priv->_invoker, _tmp3_);
		_g_object_unref0 (_tmp3_);
	}
	_tmp4_ = sugar_invoker_get_palette (self->priv->_invoker);
	_tmp5_ = sugar_toggle_tool_button_get_tooltip (self);
	sugar_palette_set_primary_text (_tmp4_, _tmp5_);
	_tmp6_ = sugar_toggle_tool_button_get_tooltip (self);
	gtk_tool_button_set_label ((GtkToolButton*) self, _tmp6_);
	g_object_notify ((GObject *) self, "tooltip");
}


const gchar* sugar_toggle_tool_button_get_accelerator (SugarToggleToolButton* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = sugar_accelerator_get_name (self->priv->_accelerator);
	result = _tmp0_;
	return result;
}


void sugar_toggle_tool_button_set_accelerator (SugarToggleToolButton* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	sugar_accelerator_set_name (self->priv->_accelerator, value);
	g_object_notify ((GObject *) self, "accelerator");
}


void sugar_toggle_tool_button_set_icon_name (SugarToggleToolButton* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (value == NULL) {
		gtk_tool_button_set_icon_widget ((GtkToolButton*) self, NULL);
	} else {
		SugarIcon* _tmp0_ = NULL;
		SugarIcon* icon;
		_tmp0_ = sugar_icon_new ();
		icon = g_object_ref_sink (_tmp0_);
		sugar_icon_set_file (icon, value);
		gtk_widget_show ((GtkWidget*) icon);
		gtk_tool_button_set_icon_widget ((GtkToolButton*) self, (GtkWidget*) icon);
		_g_object_unref0 (icon);
	}
	g_object_notify ((GObject *) self, "icon-name");
}


SugarIcon* sugar_toggle_tool_button_get_icon (SugarToggleToolButton* self) {
	SugarIcon* result;
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_tool_button_get_icon_widget ((GtkToolButton*) self);
	_tmp1_ = _tmp0_;
	result = SUGAR_IS_ICON (_tmp1_) ? ((SugarIcon*) _tmp1_) : NULL;
	return result;
}


static GObject * sugar_toggle_tool_button_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SugarToggleToolButton * self;
	SugarAccelerator* _tmp0_ = NULL;
	SugarToolConnector* _tmp1_ = NULL;
	SugarToolConnector* _tmp2_;
	SugarInvoker* _tmp3_ = NULL;
	SugarInvoker* _tmp4_;
	parent_class = G_OBJECT_CLASS (sugar_toggle_tool_button_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SUGAR_TOGGLE_TOOL_BUTTON (obj);
	_tmp0_ = sugar_accelerator_new ((GtkWidget*) self, "clicked");
	_sugar_accelerator_unref0 (self->priv->_accelerator);
	self->priv->_accelerator = _tmp0_;
	_tmp1_ = sugar_tool_connector_new ((GtkToolItem*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = sugar_invoker_new ((SugarConnector*) _tmp2_, "default");
	_tmp4_ = _tmp3_;
	sugar_toggle_tool_button_set_invoker (self, _tmp4_);
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
	return obj;
}


static void sugar_toggle_tool_button_class_init (SugarToggleToolButtonClass * klass) {
	sugar_toggle_tool_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SugarToggleToolButtonPrivate));
	GTK_TOOL_BUTTON_CLASS (klass)->clicked = sugar_toggle_tool_button_real_clicked;
	GTK_WIDGET_CLASS (klass)->hierarchy_changed = sugar_toggle_tool_button_real_hierarchy_changed;
	GTK_WIDGET_CLASS (klass)->expose_event = sugar_toggle_tool_button_real_expose_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_sugar_toggle_tool_button_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sugar_toggle_tool_button_set_property;
	G_OBJECT_CLASS (klass)->constructor = sugar_toggle_tool_button_constructor;
	G_OBJECT_CLASS (klass)->finalize = sugar_toggle_tool_button_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_TOGGLE_TOOL_BUTTON_INVOKER, g_param_spec_object ("invoker", "invoker", "invoker", SUGAR_TYPE_INVOKER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/** Set a simple palette with just a single label */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_TOGGLE_TOOL_BUTTON_TOOLTIP, g_param_spec_string ("tooltip", "tooltip", "tooltip", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_TOGGLE_TOOL_BUTTON_ACCELERATOR, g_param_spec_string ("accelerator", "accelerator", "accelerator", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_TOGGLE_TOOL_BUTTON_ICON_NAME, g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_TOGGLE_TOOL_BUTTON_ICON, g_param_spec_object ("icon", "icon", "icon", SUGAR_TYPE_ICON, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void sugar_toggle_tool_button_instance_init (SugarToggleToolButton * self) {
	self->priv = SUGAR_TOGGLE_TOOL_BUTTON_GET_PRIVATE (self);
}


static void sugar_toggle_tool_button_finalize (GObject* obj) {
	SugarToggleToolButton * self;
	self = SUGAR_TOGGLE_TOOL_BUTTON (obj);
	_g_object_unref0 (self->priv->_invoker);
	_sugar_accelerator_unref0 (self->priv->_accelerator);
	_g_free0 (self->priv->_tooltip);
	G_OBJECT_CLASS (sugar_toggle_tool_button_parent_class)->finalize (obj);
}


GType sugar_toggle_tool_button_get_type (void) {
	static volatile gsize sugar_toggle_tool_button_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_toggle_tool_button_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SugarToggleToolButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar_toggle_tool_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SugarToggleToolButton), 0, (GInstanceInitFunc) sugar_toggle_tool_button_instance_init, NULL };
		GType sugar_toggle_tool_button_type_id;
		sugar_toggle_tool_button_type_id = g_type_register_static (GTK_TYPE_TOGGLE_TOOL_BUTTON, "SugarToggleToolButton", &g_define_type_info, 0);
		g_once_init_leave (&sugar_toggle_tool_button_type_id__volatile, sugar_toggle_tool_button_type_id);
	}
	return sugar_toggle_tool_button_type_id__volatile;
}


static void _vala_sugar_toggle_tool_button_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SugarToggleToolButton * self;
	self = SUGAR_TOGGLE_TOOL_BUTTON (object);
	switch (property_id) {
		case SUGAR_TOGGLE_TOOL_BUTTON_INVOKER:
		g_value_set_object (value, sugar_toggle_tool_button_get_invoker (self));
		break;
		case SUGAR_TOGGLE_TOOL_BUTTON_TOOLTIP:
		g_value_set_string (value, sugar_toggle_tool_button_get_tooltip (self));
		break;
		case SUGAR_TOGGLE_TOOL_BUTTON_ACCELERATOR:
		g_value_set_string (value, sugar_toggle_tool_button_get_accelerator (self));
		break;
		case SUGAR_TOGGLE_TOOL_BUTTON_ICON:
		g_value_set_object (value, sugar_toggle_tool_button_get_icon (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_sugar_toggle_tool_button_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SugarToggleToolButton * self;
	self = SUGAR_TOGGLE_TOOL_BUTTON (object);
	switch (property_id) {
		case SUGAR_TOGGLE_TOOL_BUTTON_INVOKER:
		sugar_toggle_tool_button_set_invoker (self, g_value_get_object (value));
		break;
		case SUGAR_TOGGLE_TOOL_BUTTON_TOOLTIP:
		sugar_toggle_tool_button_set_tooltip (self, g_value_get_string (value));
		break;
		case SUGAR_TOGGLE_TOOL_BUTTON_ACCELERATOR:
		sugar_toggle_tool_button_set_accelerator (self, g_value_get_string (value));
		break;
		case SUGAR_TOGGLE_TOOL_BUTTON_ICON_NAME:
		sugar_toggle_tool_button_set_icon_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void sugar_radio_tool_button_real_clicked (GtkToolButton* base) {
	SugarRadioToolButton * self;
	self = (SugarRadioToolButton*) base;
	sugar_invoker_popdown (self->priv->_invoker);
}


static void sugar_radio_tool_button_real_hierarchy_changed (GtkWidget* base, GtkWidget* previous_toplevel) {
	SugarRadioToolButton * self;
	self = (SugarRadioToolButton*) base;
	if (((GtkBin*) self)->child != NULL) {
		((GtkBin*) self)->child->state = (guchar) GTK_STATE_NORMAL;
	}
}


static gboolean sugar_radio_tool_button_real_expose_event (GtkWidget* base, GdkEventExpose* event) {
	SugarRadioToolButton * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	self = (SugarRadioToolButton*) base;
	_sugar_expose_event ((GtkToolItem*) self, self->priv->_invoker, event);
	_tmp0_ = GTK_WIDGET_CLASS (sugar_radio_tool_button_parent_class)->expose_event ((GtkWidget*) GTK_RADIO_TOOL_BUTTON (self), event);
	result = _tmp0_;
	return result;
}


SugarRadioToolButton* sugar_radio_tool_button_construct (GType object_type) {
	SugarRadioToolButton * self = NULL;
	self = (SugarRadioToolButton*) g_object_new (object_type, NULL);
	return self;
}


SugarRadioToolButton* sugar_radio_tool_button_new (void) {
	return sugar_radio_tool_button_construct (SUGAR_TYPE_RADIO_TOOL_BUTTON);
}


SugarInvoker* sugar_radio_tool_button_get_invoker (SugarRadioToolButton* self) {
	SugarInvoker* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_invoker;
	return result;
}


static void sugar_radio_tool_button_set_invoker (SugarRadioToolButton* self, SugarInvoker* value) {
	SugarInvoker* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_invoker);
	self->priv->_invoker = _tmp0_;
	g_object_notify ((GObject *) self, "invoker");
}


const gchar* sugar_radio_tool_button_get_tooltip (SugarRadioToolButton* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_tooltip;
	return result;
}


void sugar_radio_tool_button_set_tooltip (SugarRadioToolButton* self, const gchar* value) {
	gchar* _tmp0_;
	SugarPalette* _tmp1_ = NULL;
	SugarPalette* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_tooltip);
	self->priv->_tooltip = _tmp0_;
	_tmp1_ = sugar_invoker_get_palette (self->priv->_invoker);
	if (_tmp1_ == NULL) {
		SugarPalette* _tmp2_ = NULL;
		SugarPalette* _tmp3_;
		_tmp2_ = sugar_palette_new ();
		_tmp3_ = g_object_ref_sink (_tmp2_);
		sugar_invoker_set_palette (self->priv->_invoker, _tmp3_);
		_g_object_unref0 (_tmp3_);
	}
	_tmp4_ = sugar_invoker_get_palette (self->priv->_invoker);
	_tmp5_ = sugar_radio_tool_button_get_tooltip (self);
	sugar_palette_set_primary_text (_tmp4_, _tmp5_);
	_tmp6_ = sugar_radio_tool_button_get_tooltip (self);
	gtk_tool_button_set_label ((GtkToolButton*) self, _tmp6_);
	g_object_notify ((GObject *) self, "tooltip");
}


const gchar* sugar_radio_tool_button_get_accelerator (SugarRadioToolButton* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = sugar_accelerator_get_name (self->priv->_accelerator);
	result = _tmp0_;
	return result;
}


void sugar_radio_tool_button_set_accelerator (SugarRadioToolButton* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	sugar_accelerator_set_name (self->priv->_accelerator, value);
	g_object_notify ((GObject *) self, "accelerator");
}


void sugar_radio_tool_button_set_icon_name (SugarRadioToolButton* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (value == NULL) {
		gtk_tool_button_set_icon_widget ((GtkToolButton*) self, NULL);
	} else {
		SugarIcon* _tmp0_ = NULL;
		SugarIcon* icon;
		_tmp0_ = sugar_icon_new ();
		icon = g_object_ref_sink (_tmp0_);
		sugar_icon_set_file (icon, value);
		gtk_widget_show ((GtkWidget*) icon);
		gtk_tool_button_set_icon_widget ((GtkToolButton*) self, (GtkWidget*) icon);
		_g_object_unref0 (icon);
	}
	g_object_notify ((GObject *) self, "icon-name");
}


SugarIcon* sugar_radio_tool_button_get_icon (SugarRadioToolButton* self) {
	SugarIcon* result;
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_tool_button_get_icon_widget ((GtkToolButton*) self);
	_tmp1_ = _tmp0_;
	result = SUGAR_IS_ICON (_tmp1_) ? ((SugarIcon*) _tmp1_) : NULL;
	return result;
}


static GObject * sugar_radio_tool_button_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SugarRadioToolButton * self;
	SugarAccelerator* _tmp0_ = NULL;
	SugarToolConnector* _tmp1_ = NULL;
	SugarToolConnector* _tmp2_;
	SugarInvoker* _tmp3_ = NULL;
	SugarInvoker* _tmp4_;
	parent_class = G_OBJECT_CLASS (sugar_radio_tool_button_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SUGAR_RADIO_TOOL_BUTTON (obj);
	_tmp0_ = sugar_accelerator_new ((GtkWidget*) self, "clicked");
	_sugar_accelerator_unref0 (self->priv->_accelerator);
	self->priv->_accelerator = _tmp0_;
	_tmp1_ = sugar_tool_connector_new ((GtkToolItem*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = sugar_invoker_new ((SugarConnector*) _tmp2_, "default");
	_tmp4_ = _tmp3_;
	sugar_radio_tool_button_set_invoker (self, _tmp4_);
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
	return obj;
}


static void sugar_radio_tool_button_class_init (SugarRadioToolButtonClass * klass) {
	sugar_radio_tool_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SugarRadioToolButtonPrivate));
	GTK_TOOL_BUTTON_CLASS (klass)->clicked = sugar_radio_tool_button_real_clicked;
	GTK_WIDGET_CLASS (klass)->hierarchy_changed = sugar_radio_tool_button_real_hierarchy_changed;
	GTK_WIDGET_CLASS (klass)->expose_event = sugar_radio_tool_button_real_expose_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_sugar_radio_tool_button_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sugar_radio_tool_button_set_property;
	G_OBJECT_CLASS (klass)->constructor = sugar_radio_tool_button_constructor;
	G_OBJECT_CLASS (klass)->finalize = sugar_radio_tool_button_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_RADIO_TOOL_BUTTON_INVOKER, g_param_spec_object ("invoker", "invoker", "invoker", SUGAR_TYPE_INVOKER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/** Set a simple palette with just a single label */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_RADIO_TOOL_BUTTON_TOOLTIP, g_param_spec_string ("tooltip", "tooltip", "tooltip", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_RADIO_TOOL_BUTTON_ACCELERATOR, g_param_spec_string ("accelerator", "accelerator", "accelerator", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_RADIO_TOOL_BUTTON_ICON_NAME, g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_RADIO_TOOL_BUTTON_ICON, g_param_spec_object ("icon", "icon", "icon", SUGAR_TYPE_ICON, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void sugar_radio_tool_button_instance_init (SugarRadioToolButton * self) {
	self->priv = SUGAR_RADIO_TOOL_BUTTON_GET_PRIVATE (self);
}


static void sugar_radio_tool_button_finalize (GObject* obj) {
	SugarRadioToolButton * self;
	self = SUGAR_RADIO_TOOL_BUTTON (obj);
	_g_object_unref0 (self->priv->_invoker);
	_sugar_accelerator_unref0 (self->priv->_accelerator);
	_g_free0 (self->priv->_tooltip);
	G_OBJECT_CLASS (sugar_radio_tool_button_parent_class)->finalize (obj);
}


GType sugar_radio_tool_button_get_type (void) {
	static volatile gsize sugar_radio_tool_button_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_radio_tool_button_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SugarRadioToolButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar_radio_tool_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SugarRadioToolButton), 0, (GInstanceInitFunc) sugar_radio_tool_button_instance_init, NULL };
		GType sugar_radio_tool_button_type_id;
		sugar_radio_tool_button_type_id = g_type_register_static (GTK_TYPE_RADIO_TOOL_BUTTON, "SugarRadioToolButton", &g_define_type_info, 0);
		g_once_init_leave (&sugar_radio_tool_button_type_id__volatile, sugar_radio_tool_button_type_id);
	}
	return sugar_radio_tool_button_type_id__volatile;
}


static void _vala_sugar_radio_tool_button_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SugarRadioToolButton * self;
	self = SUGAR_RADIO_TOOL_BUTTON (object);
	switch (property_id) {
		case SUGAR_RADIO_TOOL_BUTTON_INVOKER:
		g_value_set_object (value, sugar_radio_tool_button_get_invoker (self));
		break;
		case SUGAR_RADIO_TOOL_BUTTON_TOOLTIP:
		g_value_set_string (value, sugar_radio_tool_button_get_tooltip (self));
		break;
		case SUGAR_RADIO_TOOL_BUTTON_ACCELERATOR:
		g_value_set_string (value, sugar_radio_tool_button_get_accelerator (self));
		break;
		case SUGAR_RADIO_TOOL_BUTTON_ICON:
		g_value_set_object (value, sugar_radio_tool_button_get_icon (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_sugar_radio_tool_button_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SugarRadioToolButton * self;
	self = SUGAR_RADIO_TOOL_BUTTON (object);
	switch (property_id) {
		case SUGAR_RADIO_TOOL_BUTTON_INVOKER:
		sugar_radio_tool_button_set_invoker (self, g_value_get_object (value));
		break;
		case SUGAR_RADIO_TOOL_BUTTON_TOOLTIP:
		sugar_radio_tool_button_set_tooltip (self, g_value_get_string (value));
		break;
		case SUGAR_RADIO_TOOL_BUTTON_ACCELERATOR:
		sugar_radio_tool_button_set_accelerator (self, g_value_get_string (value));
		break;
		case SUGAR_RADIO_TOOL_BUTTON_ICON_NAME:
		sugar_radio_tool_button_set_icon_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


void _sugar_expose_event (GtkToolItem* item, SugarInvoker* invoker, GdkEventExpose* event) {
	gboolean _tmp0_ = FALSE;
	SugarPaletteWindow* _tmp1_ = NULL;
	g_return_if_fail (item != NULL);
	g_return_if_fail (invoker != NULL);
	_tmp1_ = sugar_invoker_get_palette_window (invoker);
	if (_tmp1_ != NULL) {
		gboolean _tmp2_;
		_tmp2_ = sugar_invoker_get_is_up (invoker);
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		SugarConnector* _tmp3_ = NULL;
		SugarPaletteWindow* _tmp4_ = NULL;
		_tmp3_ = sugar_invoker_get_connector (invoker);
		_tmp4_ = sugar_invoker_get_palette_window (invoker);
		sugar_connector_draw_rectangle (_tmp3_, event, _tmp4_);
	} else {
		if (((GtkBin*) item)->child->state == GTK_STATE_PRELIGHT) {
			GtkStyle* _tmp5_ = NULL;
			_tmp5_ = gtk_widget_get_style (((GtkBin*) item)->child);
			gtk_paint_box (_tmp5_, (*event).window, GTK_STATE_PRELIGHT, GTK_SHADOW_NONE, &(*event).area, ((GtkBin*) item)->child, "toolbutton-prelight", ((GtkWidget*) item)->allocation.x, ((GtkWidget*) item)->allocation.y, ((GtkWidget*) item)->allocation.width, ((GtkWidget*) item)->allocation.height);
		}
	}
}



