#!/usr/bin/env python

from __init__ import *

import unittest
import gtk
import gobject

import env, collab


class DBusTubesTest(unittest.TestCase):

    def testCreateOffline(self):
        set_activity_id(0)
        conn = collab.Connection()
        tubes = []
        tubes_disappeared = []

        def cb(_, tube):
            tubes.append(tube)
        conn.connect('channel-appeared', cb)

        def cb(_, tube):
            tubes_disappeared.append(tube)
        conn.connect('channel-disappeared', cb)

        conn.offer_channel ('test.tube')
        gobject.timeout_add_seconds(3, lambda: gtk.main_quit())
        gtk.main ()

        self.assertEqual ([], tubes)
        self.assertEqual ([], tubes_disappeared)

    def testCreateDuringStateChanging(self):
        set_activity_id(10)
        conn = collab.Connection()
        conn.props.scope = env.SHARE_SCOPE_PUBLIC;
        tubes = []
        tubes_disappeared = []

        def cb(_, tube):
            tubes.append(tube)
        conn.connect('channel-appeared', cb)

        def cb(_, tube):
            tubes_disappeared.append(tube)
        conn.connect('channel-disappeared', cb)

        conn.offer_channel ('test.tube')
        gobject.timeout_add_seconds(3, lambda: gtk.main_quit())
        gtk.main ()

        self.assertEqual ([], tubes)
        self.assertEqual ([], tubes_disappeared)

    def testCreate(self):
        tubes = []
        tubes_disappeared = []
        me = []
        owner = []
        appeared = []
        disappeared = []

        set_activity_id(20)
        conn = collab.Connection()

        def cb(_, tube):
            def me_cb(_, __):
                me.append(tube.props.me)
            tube.connect('notify::me', me_cb)

            def owner_cb(_, __):
                owner.append(tube.props.owner)
            tube.connect('notify::owner', owner_cb)

            def buddy_appeared_cb(_, buddy, bus_name):
                appeared.append(buddy)
            tube.connect('buddy_appeared', buddy_appeared_cb)

            def buddy_disappeared_cb(_, buddy):
                disappeared.append(buddy)
            tube.connect('buddy_disappeared', buddy_disappeared_cb)

            tubes.append(tube)
        conn.connect('channel-appeared', cb)

        conn.props.scope = env.SHARE_SCOPE_PUBLIC;
        gobject.timeout_add_seconds(3, lambda: gtk.main_quit())
        gtk.main ()

        conn.offer_channel ('test.tube')

        gobject.timeout_add_seconds(3, lambda: gtk.main_quit())
        gtk.main ()

        def cb(_, tube):
            tubes_disappeared.append(tube)
        conn.connect('channel-disappeared', cb)

        conn.props.scope = env.SHARE_SCOPE_PRIVATE;
        gobject.timeout_add_seconds(3, lambda: gtk.main_quit())
        gtk.main ()

        self.assertEqual (1, len(tubes))
        self.assertEqual (1, len(tubes_disappeared))
        self.assertEqual ('test.tube', tubes[0].props.bus_name)
        self.assertEqual ('test.tube', tubes_disappeared[0].props.bus_name)
        self.assertEqual (True, tubes[0].props.initiator)
        self.assertEqual (1, len(me))
        self.assertEqual (1, len(owner))
        self.assertEqual (1, len(appeared))
        #self.assertEqual (1, len(disappeared))
        self.assertEqual (me[0], appeared[0])
        self.assertEqual (owner[0], appeared[0])
        #self.assertEqual (me[0].props.handle, disappeared[0].props.handle)

    def testJoinedTubesOfTheSameBuddy(self):
        tubes_1 = []
        tubes_2 = []

        set_activity_id(30)
        conn_1 = collab.Connection()
        def cb(_, tube):
            tubes_1.append(tube)
        conn_1.connect('channel-appeared', cb)

        set_activity_id(30)
        conn_2 = collab.Connection()
        def cb(_, tube):
            tubes_2.append(tube)
        conn_2.connect('channel-appeared', cb)

        conn_1.props.scope = env.SHARE_SCOPE_PUBLIC;
        gobject.timeout_add_seconds(3, lambda: gtk.main_quit())
        gtk.main ()

        conn_1.offer_channel ('test.tube')

        gobject.timeout_add_seconds(3, lambda: gtk.main_quit())
        gtk.main ()

        self.assertEqual (1, len(tubes_1))
        self.assertEqual (0, len(tubes_2))

        conn_2.props.scope = env.SHARE_SCOPE_PUBLIC;
        gobject.timeout_add_seconds(3, lambda: gtk.main_quit())
        gtk.main ()

        self.assertEqual (1, len(tubes_1))
        self.assertEqual (1, len(tubes_2))

        self.assertEqual (tubes_1[0].props.bus_name, tubes_2[0].props.bus_name)
        self.assertEqual (True, tubes_1[0].props.initiator)
        self.assertEqual (True, tubes_2[0].props.initiator)


if __name__ == '__main__':
    unittest.main()
