/* trigger.vala
 *
 * Copyright (C) 2010, Aleksey Lim
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Notify about various operations that requires datastore connection
 *
 * Used to link Jobjects with Datastore object.
 */
public class Sugar.DataTrigger : Object {
    /**
     * Write passed jobject to datastore
     */
    public signal void write (Jobject jobject);

    /**
     * Delete passed jobject from datastore
     */
    public signal void unlink (Jobject jobject);

    /**
     * Get additional fields from datastore
     */
    public signal void fetch (Jobject jobject);
}
