/* channel.c generated by valac 0.12.1, the Vala compiler
 * generated from channel.vala, do not modify */

/* channel.vala
 *
 * Copyright (C) 2010, Aleksey Lim
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include "polyol/collab.h"
#include <stdlib.h>
#include <string.h>

#define _g_free0(var) (var = (g_free (var), NULL))

struct _SugarChannelPrivate {
	gchar* _bus_name;
	guint _me;
	guint _owner;
	gchar* _address;
};


static gpointer sugar_channel_parent_class = NULL;

#define SUGAR_CHANNEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SUGAR_TYPE_CHANNEL, SugarChannelPrivate))
enum  {
	SUGAR_CHANNEL_DUMMY_PROPERTY,
	SUGAR_CHANNEL_INITIATOR,
	SUGAR_CHANNEL_BUS_NAME,
	SUGAR_CHANNEL_ME,
	SUGAR_CHANNEL_OWNER,
	SUGAR_CHANNEL_ADDRESS
};
static void sugar_channel_set_me (SugarChannel* self, guint value);
static void sugar_channel_set_owner (SugarChannel* self, guint value);
static void g_cclosure_user_marshal_VOID__UINT_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void sugar_channel_finalize (GObject* obj);
static void _vala_sugar_channel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sugar_channel_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


void _sugar_channel_add_buddy (SugarChannel* self, guint buddy, const gchar* bus_name) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bus_name != NULL);
	_tmp0_ = g_strdup_printf ("%u", buddy);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("Buddy ", _tmp1_, " appeared", NULL);
	_tmp3_ = _tmp2_;
	g_debug ("channel.vala:85: %s", _tmp3_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	if (buddy == self->_self_handle) {
		sugar_channel_set_me (self, buddy);
	}
	if (buddy == self->_initiator_id) {
		sugar_channel_set_owner (self, buddy);
	}
	g_signal_emit_by_name (self, "buddy-appeared", buddy, bus_name);
}


void _sugar_channel_remove_buddies (SugarChannel* self, guint* removed, int removed_length1) {
	g_return_if_fail (self != NULL);
	{
		guint* i_collection;
		int i_collection_length1;
		int i_it;
		i_collection = removed;
		i_collection_length1 = removed_length1;
		for (i_it = 0; i_it < removed_length1; i_it = i_it + 1) {
			guint i;
			i = i_collection[i_it];
			{
				gchar* _tmp0_ = NULL;
				gchar* _tmp1_;
				gchar* _tmp2_ = NULL;
				gchar* _tmp3_;
				_tmp0_ = g_strdup_printf ("%u", i);
				_tmp1_ = _tmp0_;
				_tmp2_ = g_strconcat ("Buddy ", _tmp1_, " disappeared", NULL);
				_tmp3_ = _tmp2_;
				g_debug ("channel.vala:97: %s", _tmp3_);
				_g_free0 (_tmp3_);
				_g_free0 (_tmp1_);
				g_signal_emit_by_name (self, "buddy-disappeared", i);
			}
		}
	}
}


SugarChannel* sugar_channel_construct (GType object_type) {
	SugarChannel * self = NULL;
	self = (SugarChannel*) g_object_new (object_type, NULL);
	return self;
}


gboolean sugar_channel_get_initiator (SugarChannel* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->_self_handle == self->_initiator_id;
	return result;
}


const gchar* sugar_channel_get_bus_name (SugarChannel* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_bus_name;
	return result;
}


void sugar_channel_set_bus_name (SugarChannel* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_bus_name);
	self->priv->_bus_name = _tmp0_;
	g_object_notify ((GObject *) self, "bus-name");
}


guint sugar_channel_get_me (SugarChannel* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_me;
	return result;
}


static void sugar_channel_set_me (SugarChannel* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_me = value;
	g_object_notify ((GObject *) self, "me");
}


guint sugar_channel_get_owner (SugarChannel* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_owner;
	return result;
}


static void sugar_channel_set_owner (SugarChannel* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_owner = value;
	g_object_notify ((GObject *) self, "owner");
}


const gchar* sugar_channel_get_address (SugarChannel* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_address;
	return result;
}


void sugar_channel_set_address (SugarChannel* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_address);
	self->priv->_address = _tmp0_;
	g_object_notify ((GObject *) self, "address");
}


static void g_cclosure_user_marshal_VOID__UINT_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_STRING) (gpointer data1, guint arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_STRING callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_string (param_values + 2), data2);
}


static void sugar_channel_class_init (SugarChannelClass * klass) {
	sugar_channel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SugarChannelPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_sugar_channel_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sugar_channel_set_property;
	G_OBJECT_CLASS (klass)->finalize = sugar_channel_finalize;
	/**
	     * Was "me" boddy an initiator of channel creation
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_CHANNEL_INITIATOR, g_param_spec_boolean ("initiator", "initiator", "initiator", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * A DBus name representing the channel whithin Connection
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_CHANNEL_BUS_NAME, g_param_spec_string ("bus-name", "bus-name", "bus-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * This side buddy
	     *
	     * This property value is null right after channel creation and will be set
	     * after getting buddy_appeared signal with appropriate buddy. To be assured
	     * about property value, check it for null and either use this value or
	     * connect to notify::me (or buddy_appeared) signal.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_CHANNEL_ME, g_param_spec_uint ("me", "me", "me", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * An intiator of channel creation
	     *
	     * This property value is null right after channel creation and will be set
	     * after getting buddy_appeared signal with appropriate buddy. To be assured
	     * about property value, check it for null and either use this value or
	     * connect to notify::owner (or buddy_appeared) signal.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_CHANNEL_OWNER, g_param_spec_uint ("owner", "owner", "owner", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * DBus connection address associated with the channel
	     *
	     * All interaction will happen only on DBus connection with this address.
	     * http://people.collabora.co.uk/~danni/telepathy-book/sect.tubes.dbus.html
	     *
	     * @return  DBus connection address
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_CHANNEL_ADDRESS, g_param_spec_string ("address", "address", "address", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Buddy was appeared in the channel
	     *
	     * @param buddy     Telepathy handle for buddy that was appeared
	     * @param bus_name  buddy DBus name to identify it whithin the channel
	     */
	g_signal_new ("buddy_appeared", SUGAR_TYPE_CHANNEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_STRING, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_STRING);
	/**
	     * Buddy was disappeared from the channel
	     *
	     * @param buddy     Telepathy handle for buddy that was disappeared
	     */
	g_signal_new ("buddy_disappeared", SUGAR_TYPE_CHANNEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
}


static void sugar_channel_instance_init (SugarChannel * self) {
	self->priv = SUGAR_CHANNEL_GET_PRIVATE (self);
	self->_self_handle = G_MAXUINT;
}


static void sugar_channel_finalize (GObject* obj) {
	SugarChannel * self;
	self = SUGAR_CHANNEL (obj);
	_g_free0 (self->priv->_bus_name);
	_g_free0 (self->priv->_address);
	G_OBJECT_CLASS (sugar_channel_parent_class)->finalize (obj);
}


/**
 * Programmable data transfer method within sugar connection
 *
 * Transport mechanism via Telepathy DBus Tubes. After getting Channel object,
 * use address property as regular DBus connection address to all interactions
 * within the tube.
 */
GType sugar_channel_get_type (void) {
	static volatile gsize sugar_channel_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_channel_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SugarChannelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar_channel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SugarChannel), 0, (GInstanceInitFunc) sugar_channel_instance_init, NULL };
		GType sugar_channel_type_id;
		sugar_channel_type_id = g_type_register_static (G_TYPE_OBJECT, "SugarChannel", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&sugar_channel_type_id__volatile, sugar_channel_type_id);
	}
	return sugar_channel_type_id__volatile;
}


static void _vala_sugar_channel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SugarChannel * self;
	self = SUGAR_CHANNEL (object);
	switch (property_id) {
		case SUGAR_CHANNEL_INITIATOR:
		g_value_set_boolean (value, sugar_channel_get_initiator (self));
		break;
		case SUGAR_CHANNEL_BUS_NAME:
		g_value_set_string (value, sugar_channel_get_bus_name (self));
		break;
		case SUGAR_CHANNEL_ME:
		g_value_set_uint (value, sugar_channel_get_me (self));
		break;
		case SUGAR_CHANNEL_OWNER:
		g_value_set_uint (value, sugar_channel_get_owner (self));
		break;
		case SUGAR_CHANNEL_ADDRESS:
		g_value_set_string (value, sugar_channel_get_address (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_sugar_channel_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SugarChannel * self;
	self = SUGAR_CHANNEL (object);
	switch (property_id) {
		case SUGAR_CHANNEL_BUS_NAME:
		sugar_channel_set_bus_name (self, g_value_get_string (value));
		break;
		case SUGAR_CHANNEL_ME:
		sugar_channel_set_me (self, g_value_get_uint (value));
		break;
		case SUGAR_CHANNEL_OWNER:
		sugar_channel_set_owner (self, g_value_get_uint (value));
		break;
		case SUGAR_CHANNEL_ADDRESS:
		sugar_channel_set_address (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



