/* gtk-2.14.c
 *
 * Copyright (C) 2010, Aleksey Lim
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>

gdouble gtk_adjustment_get_lower (GtkAdjustment *adjustment) {
    g_return_val_if_fail (GTK_IS_ADJUSTMENT (adjustment), 0.0);
    return adjustment->lower;
}

void gtk_adjustment_set_lower (GtkAdjustment *adjustment, gdouble lower) {
    g_return_if_fail (GTK_IS_ADJUSTMENT (adjustment));
    g_object_set (adjustment, "lower", lower, NULL);
}

gdouble gtk_adjustment_get_upper (GtkAdjustment *adjustment) {
    g_return_val_if_fail (GTK_IS_ADJUSTMENT (adjustment), 0.0);
    return adjustment->upper;
}

void gtk_adjustment_set_upper (GtkAdjustment *adjustment, gdouble upper) {
    g_return_if_fail (GTK_IS_ADJUSTMENT (adjustment));
    g_object_set (adjustment, "upper", upper, NULL);
}

gdouble gtk_adjustment_get_page_size (GtkAdjustment *adjustment) {
    g_return_val_if_fail (GTK_IS_ADJUSTMENT (adjustment), 0.0);
    return adjustment->page_size;
}

void gtk_adjustment_set_page_size (GtkAdjustment *adjustment,
        gdouble page_size) {
    g_return_if_fail (GTK_IS_ADJUSTMENT (adjustment));
    g_object_set (adjustment, "page-size", page_size, NULL);
}

guint16 gtk_entry_get_text_length (GtkEntry *entry) {
    g_return_val_if_fail (GTK_IS_ENTRY (entry), 0);
    return strlen (gtk_entry_get_text (entry));
}
