/* menu.c generated by valac 0.12.1, the Vala compiler
 * generated from menu.vala, do not modify */

/* menu.vala
 *
 * Copyright (C) 2010, Aleksey Lim
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include "polyol/gui.h"
#include <gtk/gtk.h>
#include <polyol/env.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _sugar_accelerator_unref0(var) ((var == NULL) ? NULL : (var = (sugar_accelerator_unref (var), NULL)))

#define SUGAR_TYPE__MENUSCROLLEDITEM (sugar__menuscrolleditem_get_type ())
#define SUGAR__MENUSCROLLEDITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SUGAR_TYPE__MENUSCROLLEDITEM, Sugar_MenuScrolledItem))
#define SUGAR__MENUSCROLLEDITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SUGAR_TYPE__MENUSCROLLEDITEM, Sugar_MenuScrolledItemClass))
#define SUGAR_IS__MENUSCROLLEDITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SUGAR_TYPE__MENUSCROLLEDITEM))
#define SUGAR_IS__MENUSCROLLEDITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SUGAR_TYPE__MENUSCROLLEDITEM))
#define SUGAR__MENUSCROLLEDITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SUGAR_TYPE__MENUSCROLLEDITEM, Sugar_MenuScrolledItemClass))

typedef struct _Sugar_MenuScrolledItem Sugar_MenuScrolledItem;
typedef struct _Sugar_MenuScrolledItemClass Sugar_MenuScrolledItemClass;

#define SUGAR_TYPE__MENUSEPARATOR (sugar__menuseparator_get_type ())
#define SUGAR__MENUSEPARATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SUGAR_TYPE__MENUSEPARATOR, Sugar_MenuSeparator))
#define SUGAR__MENUSEPARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SUGAR_TYPE__MENUSEPARATOR, Sugar_MenuSeparatorClass))
#define SUGAR_IS__MENUSEPARATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SUGAR_TYPE__MENUSEPARATOR))
#define SUGAR_IS__MENUSEPARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SUGAR_TYPE__MENUSEPARATOR))
#define SUGAR__MENUSEPARATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SUGAR_TYPE__MENUSEPARATOR, Sugar_MenuSeparatorClass))

typedef struct _Sugar_MenuSeparator Sugar_MenuSeparator;
typedef struct _Sugar_MenuSeparatorClass Sugar_MenuSeparatorClass;
typedef struct _Sugar_MenuScrolledItemPrivate Sugar_MenuScrolledItemPrivate;
typedef struct _Sugar_MenuSeparatorPrivate Sugar_MenuSeparatorPrivate;

struct _SugarMenuItemPrivate {
	SugarTrigger* _trigger;
	GObject* _tag;
	GtkAction* _related_action;
	SugarAccelerator* _accelerator;
	GtkHBox* _box;
	GtkAccelLabel* _label;
	SugarIcon* _icon;
	SugarColor _icon_fill_color;
	SugarColor _icon_stroke_color;
	GtkAlignment* _icon_box;
};

struct _Sugar_MenuScrolledItem {
	SugarBin parent_instance;
	Sugar_MenuScrolledItemPrivate * priv;
};

struct _Sugar_MenuScrolledItemClass {
	SugarBinClass parent_class;
};

struct _Sugar_MenuScrolledItemPrivate {
	GtkWidget* _child;
	gint _max_height;
	GtkScrolledWindow* _scrolled;
	gint _border_right;
};

struct _Sugar_MenuSeparator {
	GtkSeparatorMenuItem parent_instance;
	Sugar_MenuSeparatorPrivate * priv;
};

struct _Sugar_MenuSeparatorClass {
	GtkSeparatorMenuItemClass parent_class;
};


static gpointer sugar_menu_item_parent_class = NULL;
static gpointer sugar_menu_parent_class = NULL;
static gpointer sugar__menuscrolleditem_parent_class = NULL;
static gpointer sugar__menuseparator_parent_class = NULL;

#define SUGAR_MENU_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SUGAR_TYPE_MENU_ITEM, SugarMenuItemPrivate))
enum  {
	SUGAR_MENU_ITEM_DUMMY_PROPERTY,
	SUGAR_MENU_ITEM_TRIGGER,
	SUGAR_MENU_ITEM_ACCELERATOR,
	SUGAR_MENU_ITEM_LABEL,
	SUGAR_MENU_ITEM_LABEL_MAXLEN,
	SUGAR_MENU_ITEM_ICON_NAME,
	SUGAR_MENU_ITEM_ICON,
	SUGAR_MENU_ITEM_TAG,
	SUGAR_MENU_ITEM_RELATED_ACTION
};
static void sugar_menu_item_real_dispose (GObject* base);
static void sugar_menu_item_real_hierarchy_changed (GtkWidget* base, GtkWidget* previous_toplevel);
static gboolean sugar_menu_item_real_button_release_event (GtkWidget* base, GdkEventButton* event);
static gboolean sugar_menu_item_real_enter_notify_event (GtkWidget* base, GdkEventCrossing* event);
static gboolean sugar_menu_item_real_leave_notify_event (GtkWidget* base, GdkEventCrossing* event);
static void sugar_menu_item_real_map (GtkWidget* base);
static void _sugar_menu_item_update_icon (SugarMenuItem* self);
static void _sugar_menu_item_label_new (SugarMenuItem* self, const gchar* text);
static void _sugar_menu_item_related_action_activate_cb (SugarMenuItem* self);
static void _sugar_menu_item_related_action_sensitive_cb (SugarMenuItem* self, GObject* sender, GParamSpec* param);
static void __sugar_menu_item_related_action_sensitive_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __sugar_menu_item_related_action_activate_cb_gtk_action_activate (GtkAction* _sender, gpointer self);
static void sugar_menu_item_real_activate_item (SugarMenuItem* self);
static GObject * sugar_menu_item_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void sugar_menu_item_finalize (GObject* obj);
static void _vala_sugar_menu_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sugar_menu_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
enum  {
	SUGAR_MENU_DUMMY_PROPERTY,
	SUGAR_MENU_WIDTH
};
Sugar_MenuScrolledItem* sugar__menuscrolleditem_new (GtkWidget* child, gint max_height);
Sugar_MenuScrolledItem* sugar__menuscrolleditem_construct (GType object_type, GtkWidget* child, gint max_height);
GType sugar__menuscrolleditem_get_type (void) G_GNUC_CONST;
Sugar_MenuSeparator* sugar__menuseparator_new (void);
Sugar_MenuSeparator* sugar__menuseparator_construct (GType object_type);
GType sugar__menuseparator_get_type (void) G_GNUC_CONST;
static void sugar_menu_real_insert (SugarBox* base, GtkWidget* widget, gint pos);
static void sugar_menu_real_size_request (GtkWidget* base, GtkRequisition* requisition);
static void sugar_menu_real_size_allocate (GtkWidget* base, GdkRectangle* allocation);
static GObject * sugar_menu_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _vala_sugar_menu_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sugar_menu_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define SUGAR__MENUSCROLLEDITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SUGAR_TYPE__MENUSCROLLEDITEM, Sugar_MenuScrolledItemPrivate))
enum  {
	SUGAR__MENUSCROLLEDITEM_DUMMY_PROPERTY,
	SUGAR__MENUSCROLLEDITEM_CHILD_WIDTH
};
static void sugar__menuscrolleditem_real_size_request (GtkWidget* base, GtkRequisition* requisition);
static void sugar__menuscrolleditem_finalize (GObject* obj);
static void _vala_sugar__menuscrolleditem_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
enum  {
	SUGAR__MENUSEPARATOR_DUMMY_PROPERTY
};


SugarTrigger* sugar_menu_container_get_menu_trigger (SugarMenuContainer* self) {
	return SUGAR_MENU_CONTAINER_GET_INTERFACE (self)->get_menu_trigger (self);
}


static void sugar_menu_container_base_init (SugarMenuContainerIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_object_interface_install_property (iface, g_param_spec_object ("menu-trigger", "menu-trigger", "menu-trigger", SUGAR_TYPE_TRIGGER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	}
}


GType sugar_menu_container_get_type (void) {
	static volatile gsize sugar_menu_container_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_menu_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SugarMenuContainerIface), (GBaseInitFunc) sugar_menu_container_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType sugar_menu_container_type_id;
		sugar_menu_container_type_id = g_type_register_static (G_TYPE_INTERFACE, "SugarMenuContainer", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (sugar_menu_container_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&sugar_menu_container_type_id__volatile, sugar_menu_container_type_id);
	}
	return sugar_menu_container_type_id__volatile;
}


static void sugar_menu_item_real_dispose (GObject* base) {
	SugarMenuItem * self;
	self = (SugarMenuItem*) base;
	sugar_menu_item_set_related_action (self, NULL);
	G_OBJECT_CLASS (sugar_menu_item_parent_class)->dispose ((GObject*) SUGAR_PAINT_BIN (self));
}


static void sugar_menu_item_real_hierarchy_changed (GtkWidget* base, GtkWidget* previous_toplevel) {
	SugarMenuItem * self;
	GtkContainer* _tmp0_ = NULL;
	SugarTrigger* _tmp1_ = NULL;
	self = (SugarMenuItem*) base;
	_tmp0_ = gtk_widget_get_parent ((GtkWidget*) self);
	_tmp1_ = sugar_trigger_find_dock (SUGAR_TYPE_MENU_CONTAINER, (GtkWidget*) _tmp0_, "menu_trigger");
	sugar_menu_item_set_trigger (self, _tmp1_);
}


static gboolean sugar_menu_item_real_button_release_event (GtkWidget* base, GdkEventButton* event) {
	SugarMenuItem * self;
	gboolean result = FALSE;
	self = (SugarMenuItem*) base;
	if ((*event).button == 1) {
		g_signal_emit_by_name (self, "activate-item");
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


static gboolean sugar_menu_item_real_enter_notify_event (GtkWidget* base, GdkEventCrossing* event) {
	SugarMenuItem * self;
	gboolean result = FALSE;
	self = (SugarMenuItem*) base;
	sugar_menu_item_set__selected (self, TRUE);
	result = FALSE;
	return result;
}


static gboolean sugar_menu_item_real_leave_notify_event (GtkWidget* base, GdkEventCrossing* event) {
	SugarMenuItem * self;
	gboolean result = FALSE;
	self = (SugarMenuItem*) base;
	sugar_menu_item_set__selected (self, FALSE);
	result = FALSE;
	return result;
}


static void sugar_menu_item_real_map (GtkWidget* base) {
	SugarMenuItem * self;
	self = (SugarMenuItem*) base;
	sugar_menu_item_set__selected (self, FALSE);
	GTK_WIDGET_CLASS (sugar_menu_item_parent_class)->map ((GtkWidget*) SUGAR_PAINT_BIN (self));
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _sugar_menu_item_update_icon (SugarMenuItem* self) {
	const gchar* _tmp0_ = NULL;
	GtkAction* _tmp2_ = NULL;
	GtkAction* _tmp3_;
	GtkToggleAction* _tmp4_;
	GtkToggleAction* toggle;
	g_return_if_fail (self != NULL);
	_tmp0_ = sugar_icon_get_file (self->priv->_icon);
	if (_tmp0_ == NULL) {
		GtkContainer* _tmp1_ = NULL;
		_tmp1_ = gtk_widget_get_parent ((GtkWidget*) self->priv->_icon);
		if (_tmp1_ != NULL) {
			gtk_container_remove ((GtkContainer*) self->priv->_icon_box, (GtkWidget*) self->priv->_icon);
		}
		return;
	}
	_tmp2_ = sugar_menu_item_get_related_action (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (GTK_IS_TOGGLE_ACTION (_tmp3_) ? ((GtkToggleAction*) _tmp3_) : NULL);
	toggle = _tmp4_;
	if (toggle == NULL) {
		GtkContainer* _tmp5_ = NULL;
		_tmp5_ = gtk_widget_get_parent ((GtkWidget*) self->priv->_icon);
		if (_tmp5_ == NULL) {
			gtk_container_add ((GtkContainer*) self->priv->_icon_box, (GtkWidget*) self->priv->_icon);
		}
	} else {
		gint _tmp6_;
		gboolean _tmp7_;
		_tmp6_ = sugar_metrics_get (SUGAR_MENU_ITEM_SIZE);
		sugar_icon_set_pixel_size (self->priv->_icon, (gint) ((_tmp6_ / 4.0) * 3.0));
		_tmp7_ = gtk_action_get_sensitive ((GtkAction*) toggle);
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->_icon, _tmp7_);
		if (GTK_IS_RADIO_ACTION (toggle)) {
			gboolean _tmp8_;
			GtkContainer* _tmp13_ = NULL;
			_tmp8_ = gtk_toggle_action_get_active (toggle);
			if (_tmp8_) {
				sugar_icon_set_fill_color (self->priv->_icon, &self->priv->_icon_fill_color);
				sugar_icon_set_stroke_color (self->priv->_icon, &self->priv->_icon_stroke_color);
			} else {
				SugarColor _tmp9_ = {0};
				SugarColor _tmp10_ = {0};
				SugarColor _tmp11_ = {0};
				SugarColor _tmp12_ = {0};
				sugar_color_get (SUGAR_COLOR_BUTTON_GREY, &_tmp9_);
				_tmp10_ = _tmp9_;
				sugar_icon_set_stroke_color (self->priv->_icon, &_tmp10_);
				sugar_color_get (SUGAR_COLOR_TOOLBAR_GREY, &_tmp11_);
				_tmp12_ = _tmp11_;
				sugar_icon_set_fill_color (self->priv->_icon, &_tmp12_);
			}
			_tmp13_ = gtk_widget_get_parent ((GtkWidget*) self->priv->_icon);
			if (_tmp13_ == NULL) {
				gtk_container_add ((GtkContainer*) self->priv->_icon_box, (GtkWidget*) self->priv->_icon);
			}
		} else {
			gboolean _tmp14_;
			_tmp14_ = gtk_toggle_action_get_active (toggle);
			if (_tmp14_) {
				GtkContainer* _tmp15_ = NULL;
				_tmp15_ = gtk_widget_get_parent ((GtkWidget*) self->priv->_icon);
				if (_tmp15_ == NULL) {
					gtk_container_add ((GtkContainer*) self->priv->_icon_box, (GtkWidget*) self->priv->_icon);
				}
			} else {
				GtkContainer* _tmp16_ = NULL;
				_tmp16_ = gtk_widget_get_parent ((GtkWidget*) self->priv->_icon);
				if (_tmp16_ != NULL) {
					gtk_container_remove ((GtkContainer*) self->priv->_icon_box, (GtkWidget*) self->priv->_icon);
				}
			}
		}
	}
	_g_object_unref0 (toggle);
}


static void _sugar_menu_item_label_new (SugarMenuItem* self, const gchar* text) {
	GtkAccelLabel* _tmp0_ = NULL;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = (GtkAccelLabel*) gtk_accel_label_new (text);
	_g_object_unref0 (self->priv->_label);
	self->priv->_label = g_object_ref_sink (_tmp0_);
	gtk_misc_set_alignment ((GtkMisc*) self->priv->_label, 0.0f, 0.5f);
	gtk_accel_label_set_accel_widget (self->priv->_label, (GtkWidget*) self);
	gtk_label_set_ellipsize ((GtkLabel*) self->priv->_label, PANGO_ELLIPSIZE_MIDDLE);
	_tmp1_ = sugar_metrics_get (SUGAR_MENU_ITEM_SIZE);
	gtk_widget_set_size_request ((GtkWidget*) self->priv->_label, -1, _tmp1_);
	sugar_menu_item_set_label_maxlen (self, 60);
	gtk_widget_show ((GtkWidget*) self->priv->_label);
	gtk_box_pack_end ((GtkBox*) self->priv->_box, (GtkWidget*) self->priv->_label, TRUE, TRUE, (guint) 0);
}


static void _sugar_menu_item_related_action_activate_cb (SugarMenuItem* self) {
	g_return_if_fail (self != NULL);
	_sugar_menu_item_update_icon (self);
}


static void _sugar_menu_item_related_action_sensitive_cb (SugarMenuItem* self, GObject* sender, GParamSpec* param) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (param != NULL);
	_sugar_menu_item_update_icon (self);
}


SugarMenuItem* sugar_menu_item_construct (GType object_type) {
	SugarMenuItem * self = NULL;
	self = (SugarMenuItem*) sugar_paint_bin_construct (object_type);
	return self;
}


SugarMenuItem* sugar_menu_item_new (void) {
	return sugar_menu_item_construct (SUGAR_TYPE_MENU_ITEM);
}


SugarTrigger* sugar_menu_item_get_trigger (SugarMenuItem* self) {
	SugarTrigger* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_trigger;
	return result;
}


void sugar_menu_item_set_trigger (SugarMenuItem* self, SugarTrigger* value) {
	SugarTrigger* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_trigger);
	self->priv->_trigger = _tmp0_;
	g_object_notify ((GObject *) self, "trigger");
}


const gchar* sugar_menu_item_get_accelerator (SugarMenuItem* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = sugar_accelerator_get_name (self->priv->_accelerator);
	result = _tmp0_;
	return result;
}


void sugar_menu_item_set_accelerator (SugarMenuItem* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	sugar_accelerator_set_name (self->priv->_accelerator, value);
	g_object_notify ((GObject *) self, "accelerator");
}


const gchar* sugar_menu_item_get_label (SugarMenuItem* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_label_get_label ((GtkLabel*) self->priv->_label);
	result = _tmp0_;
	return result;
}


void sugar_menu_item_set_label (SugarMenuItem* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = sugar_menu_item_get_label (self);
	if (g_strcmp0 (value, _tmp0_) == 0) {
		return;
	}
	gtk_container_remove ((GtkContainer*) self->priv->_box, (GtkWidget*) self->priv->_label);
	_sugar_menu_item_label_new (self, value);
	g_object_notify ((GObject *) self, "label");
}


void sugar_menu_item_set_label_maxlen (SugarMenuItem* self, gint value) {
	g_return_if_fail (self != NULL);
	gtk_label_set_max_width_chars ((GtkLabel*) self->priv->_label, value);
	g_object_notify ((GObject *) self, "label-maxlen");
}


const gchar* sugar_menu_item_get_icon_name (SugarMenuItem* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = sugar_icon_get_file (self->priv->_icon);
	result = _tmp0_;
	return result;
}


void sugar_menu_item_set_icon_name (SugarMenuItem* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	GtkAction* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = sugar_menu_item_get_icon_name (self);
	if (g_strcmp0 (value, _tmp0_) == 0) {
		return;
	}
	sugar_icon_set_file (self->priv->_icon, value);
	_tmp1_ = sugar_menu_item_get_related_action (self);
	if (GTK_IS_RADIO_ACTION (_tmp1_)) {
		SugarColor _tmp2_ = {0};
		SugarColor _tmp3_ = {0};
		sugar_icon_get_fill_color (self->priv->_icon, &_tmp2_);
		self->priv->_icon_fill_color = _tmp2_;
		sugar_icon_get_stroke_color (self->priv->_icon, &_tmp3_);
		self->priv->_icon_stroke_color = _tmp3_;
	}
	_sugar_menu_item_update_icon (self);
	g_object_notify ((GObject *) self, "icon-name");
}


SugarIcon* sugar_menu_item_get_icon (SugarMenuItem* self) {
	SugarIcon* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_icon;
	return result;
}


GObject* sugar_menu_item_get_tag (SugarMenuItem* self) {
	GObject* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_tag;
	return result;
}


void sugar_menu_item_set_tag (SugarMenuItem* self, GObject* value) {
	GObject* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_tag);
	self->priv->_tag = _tmp0_;
	g_object_notify ((GObject *) self, "tag");
}


GtkAction* sugar_menu_item_get_related_action (SugarMenuItem* self) {
	GtkAction* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_related_action;
	return result;
}


static void __sugar_menu_item_related_action_sensitive_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_sugar_menu_item_related_action_sensitive_cb (self, _sender, pspec);
}


static void __sugar_menu_item_related_action_activate_cb_gtk_action_activate (GtkAction* _sender, gpointer self) {
	_sugar_menu_item_related_action_activate_cb (self);
}


void sugar_menu_item_set_related_action (SugarMenuItem* self, GtkAction* value) {
	GtkAction* _tmp0_ = NULL;
	GtkAction* _tmp1_ = NULL;
	GtkAction* _tmp9_;
	GtkAction* _tmp10_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = sugar_menu_item_get_related_action (self);
	if (value == _tmp0_) {
		return;
	}
	_tmp1_ = sugar_menu_item_get_related_action (self);
	if (_tmp1_ != NULL) {
		GtkAction* _tmp2_ = NULL;
		guint _tmp3_;
		GQuark _tmp4_;
		GtkAction* _tmp5_ = NULL;
		guint _tmp6_;
		GtkAction* _tmp7_ = NULL;
		GtkAction* _tmp8_;
		_tmp2_ = sugar_menu_item_get_related_action (self);
		g_signal_parse_name ("notify::sensitive", G_TYPE_OBJECT, &_tmp3_, &_tmp4_, TRUE);
		g_signal_handlers_disconnect_matched ((GObject*) _tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, _tmp4_, NULL, (GCallback) __sugar_menu_item_related_action_sensitive_cb_g_object_notify, self);
		_tmp5_ = sugar_menu_item_get_related_action (self);
		g_signal_parse_name ("activate", GTK_TYPE_ACTION, &_tmp6_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) __sugar_menu_item_related_action_activate_cb_gtk_action_activate, self);
		_tmp7_ = sugar_menu_item_get_related_action (self);
		GTK_ACTION_GET_CLASS (_tmp8_ = _tmp7_)->disconnect_proxy (_tmp8_, (GtkWidget*) self);
	}
	_tmp9_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_related_action);
	self->priv->_related_action = _tmp9_;
	_tmp10_ = sugar_menu_item_get_related_action (self);
	if (_tmp10_ != NULL) {
		GtkAction* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		GtkAction* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		const gchar* _tmp16_ = NULL;
		GtkAction* _tmp18_ = NULL;
		GtkAction* _tmp19_;
		GtkAction* _tmp20_ = NULL;
		GtkAction* _tmp21_ = NULL;
		_tmp11_ = sugar_menu_item_get_related_action (self);
		_tmp12_ = gtk_action_get_label (_tmp11_);
		sugar_menu_item_set_label (self, _tmp12_);
		_tmp13_ = sugar_menu_item_get_related_action (self);
		_tmp14_ = gtk_action_get_icon_name (_tmp13_);
		sugar_menu_item_set_icon_name (self, _tmp14_);
		_tmp16_ = sugar_menu_item_get_icon_name (self);
		if (_tmp16_ == NULL) {
			GtkAction* _tmp17_ = NULL;
			_tmp17_ = sugar_menu_item_get_related_action (self);
			_tmp15_ = GTK_IS_TOGGLE_ACTION (_tmp17_);
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			sugar_menu_item_set_icon_name (self, "emblem-favorite");
		}
		_sugar_menu_item_update_icon (self);
		_tmp18_ = sugar_menu_item_get_related_action (self);
		GTK_ACTION_GET_CLASS (_tmp19_ = _tmp18_)->connect_proxy (_tmp19_, (GtkWidget*) self);
		_tmp20_ = sugar_menu_item_get_related_action (self);
		g_signal_connect_object ((GObject*) _tmp20_, "notify::sensitive", (GCallback) __sugar_menu_item_related_action_sensitive_cb_g_object_notify, self, 0);
		_tmp21_ = sugar_menu_item_get_related_action (self);
		g_signal_connect_object (_tmp21_, "activate", (GCallback) __sugar_menu_item_related_action_activate_cb_gtk_action_activate, self, 0);
	}
	g_object_notify ((GObject *) self, "related-action");
}


void sugar_menu_item_set__selected (SugarMenuItem* self, gboolean value) {
	gint _tmp0_ = 0;
	gint color;
	GdkColor _tmp1_ = {0};
	GdkColor _tmp2_ = {0};
	g_return_if_fail (self != NULL);
	if (value) {
		_tmp0_ = SUGAR_COLOR_BUTTON_GREY;
	} else {
		_tmp0_ = SUGAR_COLOR_BLACK;
	}
	color = _tmp0_;
	sugar_color_type_to_rgb (color, &_tmp1_);
	_tmp2_ = _tmp1_;
	gtk_widget_modify_bg ((GtkWidget*) self, GTK_STATE_NORMAL, &_tmp2_);
}


static void sugar_menu_item_real_activate_item (SugarMenuItem* self) {
	GtkAction* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = sugar_menu_item_get_related_action (self);
	if (_tmp0_ != NULL) {
		GtkAction* _tmp1_ = NULL;
		_tmp1_ = sugar_menu_item_get_related_action (self);
		gtk_action_activate (_tmp1_);
	}
	if (self->priv->_trigger != NULL) {
		g_signal_emit_by_name (self->priv->_trigger, "activate", (GtkWidget*) self);
	}
}


static GObject * sugar_menu_item_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SugarMenuItem * self;
	gint _tmp0_;
	SugarAccelerator* _tmp1_ = NULL;
	GtkHBox* _tmp2_ = NULL;
	SugarIcon* _tmp3_ = NULL;
	GtkAlignment* _tmp4_ = NULL;
	gint _tmp5_;
	gint _tmp6_;
	parent_class = G_OBJECT_CLASS (sugar_menu_item_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SUGAR_MENU_ITEM (obj);
	sugar_paint_bin_set_radius ((SugarPaintBin*) self, 0);
	_tmp0_ = sugar_metrics_get (SUGAR_DEFAULT_PADDING);
	sugar_paint_bin_set_padding_right ((SugarPaintBin*) self, _tmp0_ * 2);
	_tmp1_ = sugar_accelerator_new ((GtkWidget*) self, "activate_item");
	_sugar_accelerator_unref0 (self->priv->_accelerator);
	self->priv->_accelerator = _tmp1_;
	_tmp2_ = (GtkHBox*) gtk_hbox_new (FALSE, 0);
	_g_object_unref0 (self->priv->_box);
	self->priv->_box = g_object_ref_sink (_tmp2_);
	gtk_widget_show ((GtkWidget*) self->priv->_box);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) self->priv->_box);
	_tmp3_ = sugar_icon_new ();
	_g_object_unref0 (self->priv->_icon);
	self->priv->_icon = g_object_ref_sink (_tmp3_);
	gtk_widget_show ((GtkWidget*) self->priv->_icon);
	_tmp4_ = (GtkAlignment*) gtk_alignment_new (0.5f, 0.5f, (gfloat) 0, (gfloat) 0);
	_g_object_unref0 (self->priv->_icon_box);
	self->priv->_icon_box = g_object_ref_sink (_tmp4_);
	_tmp5_ = sugar_metrics_get (SUGAR_MENU_ITEM_SIZE);
	_tmp6_ = sugar_metrics_get (SUGAR_MENU_ITEM_SIZE);
	gtk_widget_set_size_request ((GtkWidget*) self->priv->_icon_box, _tmp5_, _tmp6_);
	gtk_widget_show ((GtkWidget*) self->priv->_icon_box);
	gtk_box_pack_start ((GtkBox*) self->priv->_box, (GtkWidget*) self->priv->_icon_box, FALSE, TRUE, (guint) 0);
	_sugar_menu_item_label_new (self, "");
	sugar_menu_item_set__selected (self, FALSE);
	gtk_widget_add_events ((GtkWidget*) self, (gint) (((GDK_LEAVE_NOTIFY_MASK | GDK_ENTER_NOTIFY_MASK) | GDK_BUTTON_PRESS_MASK) | GDK_BUTTON_RELEASE_MASK));
	return obj;
}


static void sugar_menu_item_class_init (SugarMenuItemClass * klass) {
	sugar_menu_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SugarMenuItemPrivate));
	G_OBJECT_CLASS (klass)->dispose = sugar_menu_item_real_dispose;
	GTK_WIDGET_CLASS (klass)->hierarchy_changed = sugar_menu_item_real_hierarchy_changed;
	GTK_WIDGET_CLASS (klass)->button_release_event = sugar_menu_item_real_button_release_event;
	GTK_WIDGET_CLASS (klass)->enter_notify_event = sugar_menu_item_real_enter_notify_event;
	GTK_WIDGET_CLASS (klass)->leave_notify_event = sugar_menu_item_real_leave_notify_event;
	GTK_WIDGET_CLASS (klass)->map = sugar_menu_item_real_map;
	SUGAR_MENU_ITEM_CLASS (klass)->activate_item = sugar_menu_item_real_activate_item;
	G_OBJECT_CLASS (klass)->get_property = _vala_sugar_menu_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sugar_menu_item_set_property;
	G_OBJECT_CLASS (klass)->constructor = sugar_menu_item_constructor;
	G_OBJECT_CLASS (klass)->finalize = sugar_menu_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_MENU_ITEM_TRIGGER, g_param_spec_object ("trigger", "trigger", "trigger", SUGAR_TYPE_TRIGGER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_MENU_ITEM_ACCELERATOR, g_param_spec_string ("accelerator", "accelerator", "accelerator", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_MENU_ITEM_LABEL, g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_MENU_ITEM_LABEL_MAXLEN, g_param_spec_int ("label-maxlen", "label-maxlen", "label-maxlen", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_MENU_ITEM_ICON_NAME, g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_MENU_ITEM_ICON, g_param_spec_object ("icon", "icon", "icon", SUGAR_TYPE_ICON, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_MENU_ITEM_TAG, g_param_spec_object ("tag", "tag", "tag", G_TYPE_OBJECT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_MENU_ITEM_RELATED_ACTION, g_param_spec_object ("related-action", "related-action", "related-action", GTK_TYPE_ACTION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("activate_item", SUGAR_TYPE_MENU_ITEM, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (SugarMenuItemClass, activate_item), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void sugar_menu_item_instance_init (SugarMenuItem * self) {
	self->priv = SUGAR_MENU_ITEM_GET_PRIVATE (self);
}


static void sugar_menu_item_finalize (GObject* obj) {
	SugarMenuItem * self;
	self = SUGAR_MENU_ITEM (obj);
	_g_object_unref0 (self->priv->_trigger);
	_g_object_unref0 (self->priv->_tag);
	_g_object_unref0 (self->priv->_related_action);
	_sugar_accelerator_unref0 (self->priv->_accelerator);
	_g_object_unref0 (self->priv->_box);
	_g_object_unref0 (self->priv->_label);
	_g_object_unref0 (self->priv->_icon);
	_g_object_unref0 (self->priv->_icon_box);
	G_OBJECT_CLASS (sugar_menu_item_parent_class)->finalize (obj);
}


GType sugar_menu_item_get_type (void) {
	static volatile gsize sugar_menu_item_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_menu_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SugarMenuItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar_menu_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SugarMenuItem), 0, (GInstanceInitFunc) sugar_menu_item_instance_init, NULL };
		GType sugar_menu_item_type_id;
		sugar_menu_item_type_id = g_type_register_static (SUGAR_TYPE_PAINT_BIN, "SugarMenuItem", &g_define_type_info, 0);
		g_once_init_leave (&sugar_menu_item_type_id__volatile, sugar_menu_item_type_id);
	}
	return sugar_menu_item_type_id__volatile;
}


static void _vala_sugar_menu_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SugarMenuItem * self;
	self = SUGAR_MENU_ITEM (object);
	switch (property_id) {
		case SUGAR_MENU_ITEM_TRIGGER:
		g_value_set_object (value, sugar_menu_item_get_trigger (self));
		break;
		case SUGAR_MENU_ITEM_ACCELERATOR:
		g_value_set_string (value, sugar_menu_item_get_accelerator (self));
		break;
		case SUGAR_MENU_ITEM_LABEL:
		g_value_set_string (value, sugar_menu_item_get_label (self));
		break;
		case SUGAR_MENU_ITEM_ICON_NAME:
		g_value_set_string (value, sugar_menu_item_get_icon_name (self));
		break;
		case SUGAR_MENU_ITEM_ICON:
		g_value_set_object (value, sugar_menu_item_get_icon (self));
		break;
		case SUGAR_MENU_ITEM_TAG:
		g_value_set_object (value, sugar_menu_item_get_tag (self));
		break;
		case SUGAR_MENU_ITEM_RELATED_ACTION:
		g_value_set_object (value, sugar_menu_item_get_related_action (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_sugar_menu_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SugarMenuItem * self;
	self = SUGAR_MENU_ITEM (object);
	switch (property_id) {
		case SUGAR_MENU_ITEM_TRIGGER:
		sugar_menu_item_set_trigger (self, g_value_get_object (value));
		break;
		case SUGAR_MENU_ITEM_ACCELERATOR:
		sugar_menu_item_set_accelerator (self, g_value_get_string (value));
		break;
		case SUGAR_MENU_ITEM_LABEL:
		sugar_menu_item_set_label (self, g_value_get_string (value));
		break;
		case SUGAR_MENU_ITEM_LABEL_MAXLEN:
		sugar_menu_item_set_label_maxlen (self, g_value_get_int (value));
		break;
		case SUGAR_MENU_ITEM_ICON_NAME:
		sugar_menu_item_set_icon_name (self, g_value_get_string (value));
		break;
		case SUGAR_MENU_ITEM_TAG:
		sugar_menu_item_set_tag (self, g_value_get_object (value));
		break;
		case SUGAR_MENU_ITEM_RELATED_ACTION:
		sugar_menu_item_set_related_action (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


/**
     * Place item to scrolled window
     *
     * @param widget        widget to insert to menu
     * @param max_row_count maximal height of scrolled window
     *                      in MenuItem's heights; <=0 to ignore
     * @param max_height    maximal height of scrolled window
     *                      <=0 to ignore
     * @param pos           position in menu to insert
     */
void sugar_menu_insert_scrolled (SugarMenu* self, GtkWidget* widget, gint max_row_count, gint max_height, gint pos) {
	gboolean _tmp0_ = FALSE;
	gint height;
	gint height_in_rows;
	gint _tmp8_;
	Sugar_MenuScrolledItem* _tmp9_ = NULL;
	Sugar_MenuScrolledItem* scrolled;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail ((max_row_count > 0) || (max_height > 0));
	if (SUGAR_IS_TABLE (widget)) {
		gint _tmp1_;
		_tmp1_ = sugar_menu_get_width (self);
		_tmp0_ = _tmp1_ >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkWidget* _tmp2_;
		gint _tmp3_;
		_tmp2_ = widget;
		_tmp3_ = sugar_menu_get_width (self);
		sugar_table_set_width (SUGAR_IS_TABLE (_tmp2_) ? ((SugarTable*) _tmp2_) : NULL, _tmp3_);
	}
	height = G_MAXINT;
	height_in_rows = G_MAXINT;
	if (max_row_count > 0) {
		gint _tmp4_;
		_tmp4_ = sugar_metrics_get (SUGAR_MENU_ITEM_SIZE);
		height_in_rows = max_row_count * _tmp4_;
	}
	if (max_height > 0) {
		gint _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp5_ = sugar_metrics_get (SUGAR_MENU_ITEM_SIZE);
		_tmp6_ = MAX (_tmp5_, max_height);
		max_height = _tmp6_;
		_tmp7_ = sugar_metrics_get (SUGAR_MENU_ITEM_SIZE);
		height = max_height - (max_height % _tmp7_);
	}
	_tmp8_ = MIN (height_in_rows, height);
	_tmp9_ = sugar__menuscrolleditem_new (widget, _tmp8_);
	scrolled = g_object_ref_sink (_tmp9_);
	gtk_widget_show ((GtkWidget*) scrolled);
	g_signal_emit_by_name ((SugarBox*) self, "insert", (GtkWidget*) scrolled, pos);
	_g_object_unref0 (scrolled);
}


/**
     * Create and insert action based MenuItem
     *
     * @param action    action to make menu item based on
     * @param tag       tag for newly created menu item
     * @param pos       position in menu to insert
     */
void sugar_menu_insert_action (SugarMenu* self, GtkAction* action, GObject* tag, gint pos) {
	SugarMenuItem* _tmp0_ = NULL;
	SugarMenuItem* item;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	gtk_action_set_visible (action, TRUE);
	_tmp0_ = sugar_menu_item_new ();
	item = g_object_ref_sink (_tmp0_);
	sugar_menu_item_set_tag (item, tag);
	sugar_menu_item_set_related_action (item, action);
	g_signal_emit_by_name ((SugarBox*) self, "insert", (GtkWidget*) item, pos);
	_g_object_unref0 (item);
}


void sugar_menu_insert_separator (SugarMenu* self, gint pos) {
	Sugar_MenuSeparator* _tmp0_ = NULL;
	Sugar_MenuSeparator* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = sugar__menuseparator_new ();
	_tmp1_ = g_object_ref_sink (_tmp0_);
	g_signal_emit_by_name ((SugarBox*) self, "insert", (GtkWidget*) _tmp1_, pos);
	_g_object_unref0 (_tmp1_);
}


static void sugar_menu_real_insert (SugarBox* base, GtkWidget* widget, gint pos) {
	SugarMenu * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp4_ = FALSE;
	self = (SugarMenu*) base;
	g_return_if_fail (widget != NULL);
	if (SUGAR_IS_TABLE (widget)) {
		gint _tmp1_;
		_tmp1_ = sugar_menu_get_width (self);
		_tmp0_ = _tmp1_ >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkWidget* _tmp2_;
		gint _tmp3_;
		_tmp2_ = widget;
		_tmp3_ = sugar_menu_get_width (self);
		sugar_table_set_width (SUGAR_IS_TABLE (_tmp2_) ? ((SugarTable*) _tmp2_) : NULL, _tmp3_);
	}
	if (SUGAR_IS__MENUSCROLLEDITEM (widget)) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = SUGAR_IS__MENUSEPARATOR (widget);
	}
	if (_tmp4_) {
		SUGAR_BOX_CLASS (sugar_menu_parent_class)->insert (SUGAR_BOX (self), widget, pos);
	} else {
		SugarBin* _tmp5_ = NULL;
		SugarBin* child;
		gint _tmp6_;
		gint _tmp7_;
		_tmp5_ = sugar_bin_new ();
		child = g_object_ref_sink (_tmp5_);
		sugar_container_set_border ((SugarContainer*) child, 0);
		_tmp6_ = sugar_metrics_get (SUGAR_DEFAULT_SPACING);
		sugar_container_set_border_left ((SugarContainer*) child, _tmp6_);
		_tmp7_ = sugar_metrics_get (SUGAR_DEFAULT_SPACING);
		sugar_container_set_border_right ((SugarContainer*) child, _tmp7_);
		gtk_widget_show ((GtkWidget*) child);
		gtk_container_add ((GtkContainer*) child, widget);
		SUGAR_BOX_CLASS (sugar_menu_parent_class)->insert (SUGAR_BOX (self), (GtkWidget*) child, pos);
		_g_object_unref0 (child);
	}
}


static void sugar_menu_real_size_request (GtkWidget* base, GtkRequisition* requisition) {
	SugarMenu * self;
	GtkRequisition _requisition = {0};
	self = (SugarMenu*) base;
	_requisition.width = 0;
	_requisition.height = 0;
	{
		GList* child_collection;
		GList* child_it;
		child_collection = ((SugarBox*) self)->children;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* _tmp0_;
			GtkWidget* child;
			_tmp0_ = _g_object_ref0 ((GtkWidget*) child_it->data);
			child = _tmp0_;
			{
				GtkRequisition child_requisition = {0};
				GtkRequisition _tmp1_ = {0};
				gint _tmp2_;
				gtk_widget_size_request (child, &_tmp1_);
				child_requisition = _tmp1_;
				_tmp2_ = MAX (_requisition.width, child_requisition.width);
				_requisition.width = _tmp2_;
				_requisition.height = _requisition.height + child_requisition.height;
				_g_object_unref0 (child);
			}
		}
	}
	sugar_container_child_size_request ((SugarContainer*) self, &_requisition);
	if (requisition) {
		*requisition = _requisition;
	}
}


static void sugar_menu_real_size_allocate (GtkWidget* base, GdkRectangle* allocation) {
	SugarMenu * self;
	gint _tmp0_;
	gint y;
	self = (SugarMenu*) base;
	((GtkWidget*) self)->allocation = (GtkAllocation) (*allocation);
	_tmp0_ = sugar_container_get_child_y ((SugarContainer*) self);
	y = _tmp0_;
	{
		GList* child_collection;
		GList* child_it;
		child_collection = ((SugarBox*) self)->children;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* _tmp1_;
			GtkWidget* child;
			_tmp1_ = _g_object_ref0 ((GtkWidget*) child_it->data);
			child = _tmp1_;
			{
				GtkRequisition child_requisition = {0};
				GtkRequisition _tmp2_ = {0};
				gint _tmp3_;
				gint _tmp4_;
				GdkRectangle _tmp5_ = {0};
				GdkRectangle child_allocation;
				gtk_widget_get_child_requisition (child, &_tmp2_);
				child_requisition = _tmp2_;
				_tmp3_ = sugar_container_get_child_x ((SugarContainer*) self);
				_tmp4_ = sugar_container_get_child_width ((SugarContainer*) self);
				_tmp5_.x = _tmp3_;
				_tmp5_.y = y;
				_tmp5_.width = _tmp4_;
				_tmp5_.height = child_requisition.height;
				child_allocation = _tmp5_;
				gtk_widget_size_allocate (child, &child_allocation);
				y = y + child_requisition.height;
				_g_object_unref0 (child);
			}
		}
	}
}


SugarMenu* sugar_menu_construct (GType object_type) {
	SugarMenu * self = NULL;
	self = (SugarMenu*) sugar_box_construct (object_type);
	return self;
}


SugarMenu* sugar_menu_new (void) {
	return sugar_menu_construct (SUGAR_TYPE_MENU);
}


gint sugar_menu_get_width (SugarMenu* self) {
	gint result;
	gint width_request = 0;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	gtk_widget_get_size_request ((GtkWidget*) self, &_tmp0_, NULL);
	width_request = _tmp0_;
	result = width_request;
	return result;
}


void sugar_menu_set_width (SugarMenu* self, gint value) {
	gint height_request = 0;
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	gtk_widget_get_size_request ((GtkWidget*) self, NULL, &_tmp0_);
	height_request = _tmp0_;
	gtk_widget_set_size_request ((GtkWidget*) self, value, height_request);
	g_object_notify ((GObject *) self, "width");
}


static GObject * sugar_menu_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SugarMenu * self;
	parent_class = G_OBJECT_CLASS (sugar_menu_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SUGAR_MENU (obj);
	GTK_WIDGET_SET_FLAGS ((GtkWidget*) self, GTK_NO_WINDOW);
	return obj;
}


static void sugar_menu_class_init (SugarMenuClass * klass) {
	sugar_menu_parent_class = g_type_class_peek_parent (klass);
	SUGAR_BOX_CLASS (klass)->insert = sugar_menu_real_insert;
	GTK_WIDGET_CLASS (klass)->size_request = sugar_menu_real_size_request;
	GTK_WIDGET_CLASS (klass)->size_allocate = sugar_menu_real_size_allocate;
	G_OBJECT_CLASS (klass)->get_property = _vala_sugar_menu_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sugar_menu_set_property;
	G_OBJECT_CLASS (klass)->constructor = sugar_menu_constructor;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_MENU_WIDTH, g_param_spec_int ("width", "width", "width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void sugar_menu_instance_init (SugarMenu * self) {
}


GType sugar_menu_get_type (void) {
	static volatile gsize sugar_menu_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_menu_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SugarMenuClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar_menu_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SugarMenu), 0, (GInstanceInitFunc) sugar_menu_instance_init, NULL };
		GType sugar_menu_type_id;
		sugar_menu_type_id = g_type_register_static (SUGAR_TYPE_BOX, "SugarMenu", &g_define_type_info, 0);
		g_once_init_leave (&sugar_menu_type_id__volatile, sugar_menu_type_id);
	}
	return sugar_menu_type_id__volatile;
}


static void _vala_sugar_menu_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SugarMenu * self;
	self = SUGAR_MENU (object);
	switch (property_id) {
		case SUGAR_MENU_WIDTH:
		g_value_set_int (value, sugar_menu_get_width (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_sugar_menu_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SugarMenu * self;
	self = SUGAR_MENU (object);
	switch (property_id) {
		case SUGAR_MENU_WIDTH:
		sugar_menu_set_width (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


Sugar_MenuScrolledItem* sugar__menuscrolleditem_construct (GType object_type, GtkWidget* child, gint max_height) {
	Sugar_MenuScrolledItem * self = NULL;
	GtkWidget* _tmp0_;
	GtkScrolledWindow* _tmp1_ = NULL;
	gint _tmp2_;
	GtkStyle* _tmp3_ = NULL;
	g_return_val_if_fail (child != NULL, NULL);
	self = (Sugar_MenuScrolledItem*) sugar_bin_construct (object_type);
	_tmp0_ = _g_object_ref0 (child);
	_g_object_unref0 (self->priv->_child);
	self->priv->_child = _tmp0_;
	self->priv->_max_height = max_height;
	_tmp1_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	_g_object_unref0 (self->priv->_scrolled);
	self->priv->_scrolled = g_object_ref_sink (_tmp1_);
	g_object_set (self->priv->_scrolled, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	g_object_set (self->priv->_scrolled, "vscrollbar-policy", GTK_POLICY_AUTOMATIC, NULL);
	gtk_scrolled_window_add_with_viewport (self->priv->_scrolled, self->priv->_child);
	gtk_widget_show ((GtkWidget*) self->priv->_scrolled);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) self->priv->_scrolled);
	_tmp2_ = sugar_metrics_get (SUGAR_DEFAULT_SPACING);
	_tmp3_ = gtk_widget_get_style ((GtkWidget*) self->priv->_scrolled);
	sugar_container_set_border_left ((SugarContainer*) self, _tmp2_ - _tmp3_->ythickness);
	return self;
}


Sugar_MenuScrolledItem* sugar__menuscrolleditem_new (GtkWidget* child, gint max_height) {
	return sugar__menuscrolleditem_construct (SUGAR_TYPE__MENUSCROLLEDITEM, child, max_height);
}


static void sugar__menuscrolleditem_real_size_request (GtkWidget* base, GtkRequisition* requisition) {
	Sugar_MenuScrolledItem * self;
	GtkRequisition _requisition = {0};
	GtkRequisition fake_requisition = {0};
	GtkRequisition _tmp0_ = {0};
	GtkRequisition _tmp1_ = {0};
	GtkStyle* _tmp4_ = NULL;
	self = (Sugar_MenuScrolledItem*) base;
	gtk_widget_size_request ((GtkWidget*) self->priv->_scrolled, &_tmp0_);
	fake_requisition = _tmp0_;
	gtk_widget_size_request (self->priv->_child, &_tmp1_);
	_requisition = _tmp1_;
	if (_requisition.height < self->priv->_max_height) {
		gint _tmp2_;
		_tmp2_ = sugar_container_get_border_left ((SugarContainer*) self);
		self->priv->_border_right = _tmp2_;
	} else {
		gint _tmp3_;
		_tmp3_ = MIN (self->priv->_max_height, _requisition.height);
		_requisition.height = _tmp3_;
		self->priv->_border_right = 0;
	}
	_tmp4_ = gtk_widget_get_style ((GtkWidget*) self->priv->_scrolled);
	_requisition.height = _requisition.height + (2 * _tmp4_->ythickness);
	sugar_container_child_size_request ((SugarContainer*) self, &_requisition);
	if (requisition) {
		*requisition = _requisition;
	}
}


static gint sugar__menuscrolleditem_real_get_child_width (SugarContainer* base) {
	gint result;
	Sugar_MenuScrolledItem* self;
	self = (Sugar_MenuScrolledItem*) base;
	result = SUGAR_CONTAINER_CLASS (sugar__menuscrolleditem_parent_class)->get_child_width ((SugarContainer*) SUGAR_BIN (self)) - self->priv->_border_right;
	return result;
}


static void sugar__menuscrolleditem_class_init (Sugar_MenuScrolledItemClass * klass) {
	sugar__menuscrolleditem_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (Sugar_MenuScrolledItemPrivate));
	GTK_WIDGET_CLASS (klass)->size_request = sugar__menuscrolleditem_real_size_request;
	SUGAR_CONTAINER_CLASS (klass)->get_child_width = sugar__menuscrolleditem_real_get_child_width;
	G_OBJECT_CLASS (klass)->get_property = _vala_sugar__menuscrolleditem_get_property;
	G_OBJECT_CLASS (klass)->finalize = sugar__menuscrolleditem_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), SUGAR__MENUSCROLLEDITEM_CHILD_WIDTH, "child-width");
}


static void sugar__menuscrolleditem_instance_init (Sugar_MenuScrolledItem * self) {
	self->priv = SUGAR__MENUSCROLLEDITEM_GET_PRIVATE (self);
	self->priv->_border_right = 0;
}


static void sugar__menuscrolleditem_finalize (GObject* obj) {
	Sugar_MenuScrolledItem * self;
	self = SUGAR__MENUSCROLLEDITEM (obj);
	_g_object_unref0 (self->priv->_child);
	_g_object_unref0 (self->priv->_scrolled);
	G_OBJECT_CLASS (sugar__menuscrolleditem_parent_class)->finalize (obj);
}


GType sugar__menuscrolleditem_get_type (void) {
	static volatile gsize sugar__menuscrolleditem_type_id__volatile = 0;
	if (g_once_init_enter (&sugar__menuscrolleditem_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (Sugar_MenuScrolledItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar__menuscrolleditem_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Sugar_MenuScrolledItem), 0, (GInstanceInitFunc) sugar__menuscrolleditem_instance_init, NULL };
		GType sugar__menuscrolleditem_type_id;
		sugar__menuscrolleditem_type_id = g_type_register_static (SUGAR_TYPE_BIN, "Sugar_MenuScrolledItem", &g_define_type_info, 0);
		g_once_init_leave (&sugar__menuscrolleditem_type_id__volatile, sugar__menuscrolleditem_type_id);
	}
	return sugar__menuscrolleditem_type_id__volatile;
}


static void _vala_sugar__menuscrolleditem_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Sugar_MenuScrolledItem * self;
	self = SUGAR__MENUSCROLLEDITEM (object);
	switch (property_id) {
		case SUGAR__MENUSCROLLEDITEM_CHILD_WIDTH:
		g_value_set_int (value, sugar_container_get_child_width ((SugarContainer*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


Sugar_MenuSeparator* sugar__menuseparator_construct (GType object_type) {
	Sugar_MenuSeparator * self = NULL;
	self = (Sugar_MenuSeparator*) g_object_new (object_type, NULL);
	return self;
}


Sugar_MenuSeparator* sugar__menuseparator_new (void) {
	return sugar__menuseparator_construct (SUGAR_TYPE__MENUSEPARATOR);
}


static void sugar__menuseparator_class_init (Sugar_MenuSeparatorClass * klass) {
	sugar__menuseparator_parent_class = g_type_class_peek_parent (klass);
}


static void sugar__menuseparator_instance_init (Sugar_MenuSeparator * self) {
}


GType sugar__menuseparator_get_type (void) {
	static volatile gsize sugar__menuseparator_type_id__volatile = 0;
	if (g_once_init_enter (&sugar__menuseparator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (Sugar_MenuSeparatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar__menuseparator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Sugar_MenuSeparator), 0, (GInstanceInitFunc) sugar__menuseparator_instance_init, NULL };
		GType sugar__menuseparator_type_id;
		sugar__menuseparator_type_id = g_type_register_static (GTK_TYPE_SEPARATOR_MENU_ITEM, "Sugar_MenuSeparator", &g_define_type_info, 0);
		g_once_init_leave (&sugar__menuseparator_type_id__volatile, sugar__menuseparator_type_id);
	}
	return sugar__menuseparator_type_id__volatile;
}



void sugar_menu_item_activate_item (SugarMenuItem* self) { g_signal_emit_by_name (self, "activate_item"); }
