/* misc.c generated by valac 0.12.1, the Vala compiler
 * generated from misc.vala, do not modify */

/* misc.vala
 *
 * Copyright (C) 2010, Aleksey Lim
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include "polyol/gui.h"
#include <string.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <polyol/env.h>
#include <gdk-pixbuf/gdk-pixdata.h>

typedef struct _Block1Data Block1Data;
#define _g_array_free0(var) ((var == NULL) ? NULL : (var = (g_array_free (var, TRUE), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gtk_icon_info_free0(var) ((var == NULL) ? NULL : (var = (gtk_icon_info_free (var), NULL)))

struct _Block1Data {
	int _ref_count_;
	GArray* _result_;
};


static gpointer sugar_trigger_parent_class = NULL;
extern gchar* sugar__default_icon_path;
gchar* sugar__default_icon_path = NULL;

enum  {
	SUGAR_TRIGGER_DUMMY_PROPERTY
};
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static gboolean _lambda0_ (const gchar* buf, gsize count, Block1Data* _data1_, GError** error);
static gboolean __lambda0__gdk_pixbuf_save_func (const gchar* buf, gsize count, GError** error, gpointer self);


void sugar_range_init (SugarRange *self) {
	memset (self, 0, sizeof (SugarRange));
	(*self).start = -1;
	(*self).stop = -1;
	(*self).step = 1;
}


gboolean sugar_range_contains (SugarRange *self, gint value) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	if (value >= (*self).start) {
		_tmp0_ = value < (*self).stop;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


gboolean sugar_range_is_equal (SugarRange *self, SugarRange* other) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	if ((*self).start == (*other).start) {
		_tmp0_ = (*self).stop == (*other).stop;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


gboolean sugar_range_is_subset (SugarRange *self, SugarRange* other) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	_tmp1_ = sugar_range_contains (other, (*self).start);
	if (_tmp1_) {
		gint _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = sugar_range_get_last (&(*self));
		_tmp3_ = sugar_range_contains (other, _tmp2_);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


gint sugar_range_get_last (SugarRange* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (*self).stop - (*self).step;
	return result;
}


void sugar_range_set_last (SugarRange* self, gint value) {
	g_return_if_fail (self != NULL);
	(*self).stop = value + (*self).step;
}


gint sugar_range_get_size (SugarRange* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (*self).stop - (*self).start;
	return result;
}


gboolean sugar_range_get_is_empty (SugarRange* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = (*self).stop == (*self).start;
	return result;
}


SugarRange* sugar_range_dup (const SugarRange* self) {
	SugarRange* dup;
	dup = g_new0 (SugarRange, 1);
	memcpy (dup, self, sizeof (SugarRange));
	return dup;
}


void sugar_range_free (SugarRange* self) {
	g_free (self);
}


GType sugar_range_get_type (void) {
	static volatile gsize sugar_range_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_range_type_id__volatile)) {
		GType sugar_range_type_id;
		sugar_range_type_id = g_boxed_type_register_static ("SugarRange", (GBoxedCopyFunc) sugar_range_dup, (GBoxedFreeFunc) sugar_range_free);
		g_once_init_leave (&sugar_range_type_id__volatile, sugar_range_type_id);
	}
	return sugar_range_type_id__volatile;
}


void sugar_timestamp_init (SugarTimestamp *self) {
	memset (self, 0, sizeof (SugarTimestamp));
	g_get_current_time (&(*self).tv);
}


gdouble sugar_timestamp_diff (SugarTimestamp *self, SugarTimestamp* other) {
	gdouble result = 0.0;
	glong d_sec;
	glong d_usec;
	d_sec = (*self).tv.tv_sec - (*other).tv.tv_sec;
	d_usec = (*self).tv.tv_usec - (*other).tv.tv_usec;
	if ((d_sec >= 0) != (d_usec >= 0)) {
		gint _tmp0_ = 0;
		gint sign;
		if (d_sec > 0) {
			_tmp0_ = +1;
		} else {
			_tmp0_ = -1;
		}
		sign = _tmp0_;
		d_sec = d_sec - ((glong) sign);
		d_usec = d_usec + ((glong) (sign * 1000000));
	}
	result = ((gdouble) d_sec) + (((gdouble) d_usec) / 1000000.0);
	return result;
}


SugarTimestamp* sugar_timestamp_dup (const SugarTimestamp* self) {
	SugarTimestamp* dup;
	dup = g_new0 (SugarTimestamp, 1);
	memcpy (dup, self, sizeof (SugarTimestamp));
	return dup;
}


void sugar_timestamp_free (SugarTimestamp* self) {
	g_free (self);
}


GType sugar_timestamp_get_type (void) {
	static volatile gsize sugar_timestamp_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_timestamp_type_id__volatile)) {
		GType sugar_timestamp_type_id;
		sugar_timestamp_type_id = g_boxed_type_register_static ("SugarTimestamp", (GBoxedCopyFunc) sugar_timestamp_dup, (GBoxedFreeFunc) sugar_timestamp_free);
		g_once_init_leave (&sugar_timestamp_type_id__volatile, sugar_timestamp_type_id);
	}
	return sugar_timestamp_type_id__volatile;
}


/** XXX no way to type cast char* to unowned string directly */
const gchar* sugar_to_string (gchar* str) {
	const gchar* result = NULL;
	result = (const gchar*) str;
	return result;
}


/** XXX no way to type cast char* to unowned uchar[] directly */
guchar* sugar_to_uchars (gchar* str, int* result_length1) {
	guchar* result = NULL;
	guchar* _tmp0_;
	_tmp0_ = (guchar*) str;
	if (result_length1) {
		*result_length1 = -1;
	}
	result = _tmp0_;
	return result;
}


SugarTrigger* sugar_trigger_find_dock (GType parent_type, GtkWidget* parent, const gchar* prop_name) {
	SugarTrigger* result = NULL;
	GType _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (prop_name != NULL, NULL);
	_tmp0_ = G_TYPE_FROM_INSTANCE ((GObject*) parent);
	_tmp1_ = g_type_is_a (_tmp0_, parent_type);
	if (_tmp1_) {
		GValue _tmp2_ = {0};
		GValue _tmp3_ = {0};
		GValue trigger;
		GObject* _tmp4_ = NULL;
		GObject* _tmp5_;
		g_value_init (&_tmp2_, G_TYPE_OBJECT);
		_tmp3_ = _tmp2_;
		trigger = _tmp3_;
		g_object_get_property ((GObject*) parent, prop_name, &trigger);
		_tmp4_ = g_value_get_object (&trigger);
		_tmp5_ = _tmp4_;
		result = SUGAR_IS_TRIGGER (_tmp5_) ? ((SugarTrigger*) _tmp5_) : NULL;
		G_IS_VALUE (&trigger) ? (g_value_unset (&trigger), NULL) : NULL;
		return result;
	} else {
		GtkContainer* _tmp6_ = NULL;
		_tmp6_ = gtk_widget_get_parent (parent);
		if (_tmp6_ != NULL) {
			GtkContainer* _tmp7_ = NULL;
			SugarTrigger* _tmp8_ = NULL;
			_tmp7_ = gtk_widget_get_parent (parent);
			_tmp8_ = sugar_trigger_find_dock (parent_type, (GtkWidget*) _tmp7_, prop_name);
			result = _tmp8_;
			return result;
		} else {
			result = NULL;
			return result;
		}
	}
}


SugarTrigger* sugar_trigger_construct (GType object_type) {
	SugarTrigger * self = NULL;
	self = (SugarTrigger*) g_object_new (object_type, NULL);
	return self;
}


SugarTrigger* sugar_trigger_new (void) {
	return sugar_trigger_construct (SUGAR_TYPE_TRIGGER);
}


static void sugar_trigger_class_init (SugarTriggerClass * klass) {
	sugar_trigger_parent_class = g_type_class_peek_parent (klass);
	g_signal_new ("activate", SUGAR_TYPE_TRIGGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GTK_TYPE_WIDGET);
}


static void sugar_trigger_instance_init (SugarTrigger * self) {
}


GType sugar_trigger_get_type (void) {
	static volatile gsize sugar_trigger_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_trigger_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SugarTriggerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar_trigger_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SugarTrigger), 0, (GInstanceInitFunc) sugar_trigger_instance_init, NULL };
		GType sugar_trigger_type_id;
		sugar_trigger_type_id = g_type_register_static (G_TYPE_OBJECT, "SugarTrigger", &g_define_type_info, 0);
		g_once_init_leave (&sugar_trigger_type_id__volatile, sugar_trigger_type_id);
	}
	return sugar_trigger_type_id__volatile;
}


void sugar_color_type_to_rgb (gint type, GdkColor* result) {
	SugarColor _tmp0_ = {0};
	SugarColor _tmp1_ = {0};
	GdkColor _tmp2_ = {0};
	GdkColor _tmp3_ = {0};
	sugar_color_get (type, &_tmp0_);
	_tmp1_ = _tmp0_;
	sugar_color_to_rgb (&_tmp1_, &_tmp2_);
	_tmp3_ = _tmp2_;
	*result = _tmp3_;
	return;
}


void sugar_color_to_rgb (SugarColor* color, GdkColor* result) {
	GdkColor _tmp0_ = {0};
	GdkColor gdk_color;
	gdk_color = _tmp0_;
	gdk_color.red = (*color).red;
	gdk_color.green = (*color).green;
	gdk_color.blue = (*color).blue;
	*result = gdk_color;
	return;
}


/**
     * Get preview image of current activity Gdk window
     *
     * @return  array of bytes with PNG image or null if Environ.window
     *          was not set; useful to set Jobject.preview property
     */
static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_array_free0 (_data1_->_result_);
		g_slice_free (Block1Data, _data1_);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean _lambda0_ (const gchar* buf, gsize count, Block1Data* _data1_, GError** error) {
	gboolean result = FALSE;
	g_return_val_if_fail (buf != NULL, FALSE);
	g_array_append_vals (_data1_->_result_, buf, (guint) count);
	result = TRUE;
	return result;
}


static gboolean __lambda0__gdk_pixbuf_save_func (const gchar* buf, gsize count, GError** error, gpointer self) {
	gboolean result;
	result = _lambda0_ (buf, count, self, error);
	return result;
}


GArray* sugar_get_preview (GError** error) {
	GArray* result = NULL;
	Block1Data* _data1_;
	XID _tmp0_;
	XID _tmp1_;
	GdkWindow* _tmp2_ = NULL;
	GdkWindow* _tmp3_;
	GdkWindow* window;
	gint width = 0;
	gint height = 0;
	gint _tmp4_;
	gint _tmp5_;
	GdkPixbuf* _tmp6_ = NULL;
	GdkPixbuf* _tmp7_;
	GdkPixbuf* pixbuf;
	GdkPixbuf* _tmp8_ = NULL;
	GdkPixbuf* preview;
	GArray* _tmp9_ = NULL;
	GArray* _tmp10_;
	GError * _inner_error_ = NULL;
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_tmp0_ = sugar_environ_get_window ();
	g_assert (_tmp0_ != 0);
	_tmp1_ = sugar_environ_get_window ();
	_tmp2_ = gdk_window_foreign_new ((GdkNativeWindow) _tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	window = _tmp3_;
	g_return_val_if_fail (window != NULL, NULL);
	gdk_drawable_get_size ((GdkDrawable*) window, &_tmp4_, &_tmp5_);
	width = _tmp4_;
	height = _tmp5_;
	_tmp6_ = gdk_pixbuf_get_from_drawable (NULL, (GdkDrawable*) window, NULL, 0, 0, 0, 0, width, height);
	_tmp7_ = _g_object_ref0 (_tmp6_);
	pixbuf = _tmp7_;
	g_return_val_if_fail (pixbuf != NULL, NULL);
	_tmp8_ = gdk_pixbuf_scale_simple (pixbuf, SUGAR_ENVIRON_PREVIEW_WIDTH, SUGAR_ENVIRON_PREVIEW_HEIGHT, GDK_INTERP_BILINEAR);
	preview = _tmp8_;
	g_return_val_if_fail (pixbuf != NULL, NULL);
	_tmp9_ = g_array_new (FALSE, FALSE, (gulong) 1);
	_data1_->_result_ = _tmp9_;
	gdk_pixbuf_save_to_callback (preview, __lambda0__gdk_pixbuf_save_func, _data1_, "png", &_inner_error_, NULL);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (preview);
		_g_object_unref0 (pixbuf);
		_g_object_unref0 (window);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return NULL;
	}
	_tmp10_ = _data1_->_result_;
	_data1_->_result_ = NULL;
	result = _tmp10_;
	_g_object_unref0 (preview);
	_g_object_unref0 (pixbuf);
	_g_object_unref0 (window);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}


gchar* sugar_default_icon_path (void) {
	gchar* result = NULL;
	gint svg_size;
	GtkIconTheme* _tmp1_ = NULL;
	GtkIconInfo* _tmp2_ = NULL;
	GtkIconInfo* icon;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_;
	if (sugar__default_icon_path != NULL) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (sugar__default_icon_path);
		result = _tmp0_;
		return result;
	}
	svg_size = 1024;
	_tmp1_ = gtk_icon_theme_get_default ();
	_tmp2_ = gtk_icon_theme_lookup_icon (_tmp1_, "application-octet-stream", svg_size, GTK_ICON_LOOKUP_FORCE_SVG);
	icon = _tmp2_;
	g_assert (icon != NULL);
	_tmp3_ = gtk_icon_info_get_filename (icon);
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (sugar__default_icon_path);
	sugar__default_icon_path = _tmp4_;
	_tmp5_ = g_strdup (sugar__default_icon_path);
	result = _tmp5_;
	_gtk_icon_info_free0 (icon);
	return result;
}



