/* paletteinvoker.c generated by valac 0.12.1, the Vala compiler
 * generated from paletteinvoker.vala, do not modify */

/* paletteinvoker.vala
 *
 * Copyright (C) 2010, Aleksey Lim
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/*
 * Port from original sugar-toolkit project.
 * File:   src/sugar/graphics/palettewindow.py
 * Commit: c684950ecff34e910e6da5840737a469f95a0e79
 *
 * Copyright (C) 2007, Eduardo Silva <edsiper@gmail.com>
 * Copyright (C) 2008, One Laptop Per Child
 * Copyright (C) 2009, Tomeu Vizoso
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include "polyol/gui.h"
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _SugarInvokerPrivate {
	gboolean _is_up;
	gboolean _focused;
	gchar* _group_id;
	SugarConnector* _connector;
	SugarPaletteWindow* _palette;
	SugarAnimator* _popup_anim;
	SugarAnimator* _popdown_anim;
	SugarAnimator* _secondary_anim;
	SugarMouseSpeedDetector* _mouse_detector;
	gboolean _secondary_visible;
};


static gpointer sugar_invoker_parent_class = NULL;

#define SUGAR_INVOKER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SUGAR_TYPE_INVOKER, SugarInvokerPrivate))
enum  {
	SUGAR_INVOKER_DUMMY_PROPERTY,
	SUGAR_INVOKER_CONNECTOR,
	SUGAR_INVOKER_GROUP_ID,
	SUGAR_INVOKER_PALETTE_WINDOW,
	SUGAR_INVOKER_PALETTE,
	SUGAR_INVOKER_IS_UP,
	SUGAR_INVOKER_FOCUSED
};
static void sugar_invoker_real_dispose (GObject* base);
static void _sugar_invoker_popup (SugarInvoker* self, gboolean immediate, gboolean force_secondary);
static void _sugar_invoker_popdown (SugarInvoker* self, gboolean immediate);
static void sugar_invoker_set_is_up (SugarInvoker* self, gboolean value);
static void _sugar_invoker_reveal_palette (SugarInvoker* self);
static void _sugar_invoker_on_enter (SugarInvoker* self);
static void sugar_invoker_set_focused (SugarInvoker* self, gboolean value);
static void _sugar_invoker_on_leave (SugarInvoker* self);
static void _sugar_invoker_invoker_enter_cb (SugarInvoker* self);
static void _sugar_invoker_invoker_leave_cb (SugarInvoker* self);
static void _sugar_invoker_force_popup_cb (SugarInvoker* self);
static void _sugar_invoker_force_popdown_cb (SugarInvoker* self);
static void _sugar_invoker_palette_show_cb (SugarInvoker* self);
static void _sugar_invoker_palette_hide_cb (SugarInvoker* self);
static gboolean _sugar_invoker_palette_enter_notify_event_cb (SugarInvoker* self, GdkEventCrossing* event);
static gboolean _sugar_invoker_palette_leave_notify_event_cb (SugarInvoker* self, GdkEventCrossing* event);
static void _sugar_invoker_popup_completed_cb (SugarInvoker* self, gboolean aborted);
static void _sugar_invoker_popdown_completed_cb (SugarInvoker* self, gboolean aborted);
static void _sugar_invoker_motion_slow_cb (SugarInvoker* self);
static void _sugar_invoker_secondary_completed_cb (SugarInvoker* self, gboolean aborted);
static void __sugar_invoker_invoker_enter_cb_sugar_connector_invoker_enter (SugarConnector* _sender, gpointer self);
static void __sugar_invoker_invoker_leave_cb_sugar_connector_invoker_leave (SugarConnector* _sender, gpointer self);
static void __sugar_invoker_force_popup_cb_sugar_connector_popup (SugarConnector* _sender, gpointer self);
static void __sugar_invoker_force_popdown_cb_sugar_connector_popdown (SugarConnector* _sender, gpointer self);
static void __sugar_invoker_palette_show_cb_gtk_widget_show (GtkWidget* _sender, gpointer self);
static void __sugar_invoker_palette_hide_cb_gtk_widget_hide (GtkWidget* _sender, gpointer self);
static gboolean __sugar_invoker_palette_enter_notify_event_cb_gtk_widget_enter_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self);
static gboolean __sugar_invoker_palette_leave_notify_event_cb_gtk_widget_leave_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self);
static GObject * sugar_invoker_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void __sugar_invoker_popup_completed_cb_sugar_animator_completed (SugarAnimator* _sender, gboolean aborted, gpointer self);
static void __sugar_invoker_popdown_completed_cb_sugar_animator_completed (SugarAnimator* _sender, gboolean aborted, gpointer self);
static void __sugar_invoker_secondary_completed_cb_sugar_animator_completed (SugarAnimator* _sender, gboolean aborted, gpointer self);
static void __sugar_invoker_motion_slow_cb_sugar_mouse_speed_detector_motion_slow (SugarMouseSpeedDetector* _sender, gpointer self);
static void sugar_invoker_finalize (GObject* obj);
static void _vala_sugar_invoker_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sugar_invoker_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


SugarInvoker* sugar_invoker_construct (GType object_type, SugarConnector* connector, const gchar* group_id) {
	SugarInvoker * self = NULL;
	g_return_val_if_fail (connector != NULL, NULL);
	g_return_val_if_fail (group_id != NULL, NULL);
	self = (SugarInvoker*) g_object_new (object_type, "connector", connector, "group-id", group_id, NULL);
	return self;
}


SugarInvoker* sugar_invoker_new (SugarConnector* connector, const gchar* group_id) {
	return sugar_invoker_construct (SUGAR_TYPE_INVOKER, connector, group_id);
}


static void sugar_invoker_real_dispose (GObject* base) {
	SugarInvoker * self;
	self = (SugarInvoker*) base;
	sugar_invoker_set_group_id (self, NULL);
	G_OBJECT_CLASS (sugar_invoker_parent_class)->dispose (G_OBJECT (self));
}


void sugar_invoker_popup (SugarInvoker* self) {
	g_return_if_fail (self != NULL);
	_sugar_invoker_popup (self, TRUE, TRUE);
}


void sugar_invoker_popdown (SugarInvoker* self) {
	g_return_if_fail (self != NULL);
	_sugar_invoker_popdown (self, TRUE);
}


static gchar* bool_to_string (gboolean self) {
	gchar* result = NULL;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}


static void _sugar_invoker_popup (SugarInvoker* self, gboolean immediate, gboolean force_secondary) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gboolean _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gboolean _tmp17_;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gboolean _tmp24_;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_;
	gchar* _tmp27_ = NULL;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_;
	gchar* _tmp33_ = NULL;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bool_to_string (immediate);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("Invoker._popup immediate=", _tmp1_, " ", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = bool_to_string (force_secondary);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat ("force_secondary=", _tmp5_, " ", NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp3_, _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = sugar_animator_get_active (self->priv->_popup_anim);
	_tmp11_ = bool_to_string (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strconcat ("popup_anim=", _tmp12_, " ", NULL);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strconcat (_tmp9_, _tmp14_, NULL);
	_tmp16_ = _tmp15_;
	_tmp17_ = sugar_animator_get_active (self->priv->_popdown_anim);
	_tmp18_ = bool_to_string (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_strconcat ("popdown_anim=", _tmp19_, " ", NULL);
	_tmp21_ = _tmp20_;
	_tmp22_ = g_strconcat (_tmp16_, _tmp21_, NULL);
	_tmp23_ = _tmp22_;
	_tmp24_ = sugar_animator_get_active (self->priv->_secondary_anim);
	_tmp25_ = bool_to_string (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = g_strconcat ("secondary_anim=", _tmp26_, NULL);
	_tmp28_ = _tmp27_;
	_tmp29_ = g_strconcat (_tmp23_, _tmp28_, NULL);
	_tmp30_ = _tmp29_;
	_tmp31_ = bool_to_string (self->priv->_secondary_visible);
	_tmp32_ = _tmp31_;
	_tmp33_ = g_strconcat ("secondary_visible=", _tmp32_, NULL);
	_tmp34_ = _tmp33_;
	_tmp35_ = g_strconcat (_tmp30_, _tmp34_, NULL);
	_tmp36_ = _tmp35_;
	g_debug ("paletteinvoker.vala:171: %s", _tmp36_);
	_g_free0 (_tmp36_);
	_g_free0 (_tmp34_);
	_g_free0 (_tmp32_);
	_g_free0 (_tmp30_);
	_g_free0 (_tmp28_);
	_g_free0 (_tmp26_);
	_g_free0 (_tmp23_);
	_g_free0 (_tmp21_);
	_g_free0 (_tmp19_);
	_g_free0 (_tmp16_);
	_g_free0 (_tmp14_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	sugar_animator_abort (self->priv->_popdown_anim);
	self->priv->_secondary_visible = self->priv->_secondary_visible | force_secondary;
	if (immediate) {
		sugar_invoker_set_is_up (self, TRUE);
		sugar_animator_abort (self->priv->_popup_anim);
		_sugar_invoker_reveal_palette (self);
	} else {
		sugar_animator_start (self->priv->_popup_anim);
	}
}


static void _sugar_invoker_popdown (SugarInvoker* self, gboolean immediate) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gboolean _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gboolean _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gboolean _tmp18_;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gboolean _tmp25_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = bool_to_string (immediate);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("Invoker._popdown immediate=", _tmp1_, " ", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = sugar_animator_get_active (self->priv->_popup_anim);
	_tmp5_ = bool_to_string (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat ("popup_anim=", _tmp6_, " ", NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strconcat (_tmp3_, _tmp8_, NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = sugar_animator_get_active (self->priv->_popdown_anim);
	_tmp12_ = bool_to_string (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat ("popdown_anim=", _tmp13_, " ", NULL);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_strconcat (_tmp10_, _tmp15_, NULL);
	_tmp17_ = _tmp16_;
	_tmp18_ = sugar_animator_get_active (self->priv->_secondary_anim);
	_tmp19_ = bool_to_string (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_strconcat ("secondary_anim=", _tmp20_, NULL);
	_tmp22_ = _tmp21_;
	_tmp23_ = g_strconcat (_tmp17_, _tmp22_, NULL);
	_tmp24_ = _tmp23_;
	g_debug ("paletteinvoker.vala:191: %s", _tmp24_);
	_g_free0 (_tmp24_);
	_g_free0 (_tmp22_);
	_g_free0 (_tmp20_);
	_g_free0 (_tmp17_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	sugar_animator_abort (self->priv->_popup_anim);
	sugar_animator_abort (self->priv->_secondary_anim);
	sugar_mouse_speed_detector_stop (self->priv->_mouse_detector);
	self->priv->_secondary_visible = FALSE;
	if (immediate) {
		_tmp25_ = TRUE;
	} else {
		_tmp25_ = !self->priv->_is_up;
	}
	if (_tmp25_) {
		SugarPaletteWindow* _tmp26_ = NULL;
		sugar_invoker_set_is_up (self, FALSE);
		sugar_animator_abort (self->priv->_popdown_anim);
		_tmp26_ = sugar_invoker_get_palette_window (self);
		if (_tmp26_ != NULL) {
			SugarPaletteWindow* _tmp27_ = NULL;
			SugarPaletteWindow* _tmp28_ = NULL;
			_tmp27_ = sugar_invoker_get_palette_window (self);
			gtk_widget_hide ((GtkWidget*) _tmp27_);
			_tmp28_ = sugar_invoker_get_palette_window (self);
			sugar_palette_window_set_secondary_visible (_tmp28_, FALSE);
		}
	} else {
		sugar_animator_start (self->priv->_popdown_anim);
	}
}


static void _sugar_invoker_reveal_palette (SugarInvoker* self) {
	SugarPaletteWindow* _tmp0_ = NULL;
	SugarPaletteWindow* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	SugarPaletteWindow* _tmp4_ = NULL;
	SugarConnector* _tmp5_ = NULL;
	GtkWindow* _tmp6_ = NULL;
	SugarPaletteWindow* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = sugar_invoker_get_palette_window (self);
	if (_tmp0_ == NULL) {
		g_signal_emit_by_name (self, "palette-request");
		return;
	}
	_tmp1_ = sugar_invoker_get_palette_window (self);
	_tmp2_ = sugar_palette_window_get_secondary (_tmp1_);
	if (_tmp2_ != NULL) {
		SugarPaletteWindow* _tmp3_ = NULL;
		_tmp3_ = sugar_invoker_get_palette_window (self);
		sugar_palette_window_set_secondary_visible (_tmp3_, self->priv->_secondary_visible);
		if (!self->priv->_secondary_visible) {
			sugar_animator_start (self->priv->_secondary_anim);
		}
	}
	_tmp4_ = sugar_invoker_get_palette_window (self);
	_tmp5_ = sugar_invoker_get_connector (self);
	_tmp6_ = sugar_connector_get_toplevel (_tmp5_);
	gtk_window_set_transient_for ((GtkWindow*) _tmp4_, _tmp6_);
	_tmp7_ = sugar_invoker_get_palette_window (self);
	sugar_palette_window_reveal (_tmp7_);
}


static void _sugar_invoker_on_enter (SugarInvoker* self) {
	const gchar* _tmp0_ = NULL;
	SugarPaletteGroup* _tmp1_ = NULL;
	SugarPaletteGroup* _tmp2_;
	SugarInvoker* _tmp3_ = NULL;
	SugarInvoker* _tmp4_;
	SugarInvoker* parent;
	g_return_if_fail (self != NULL);
	sugar_invoker_set_focused (self, TRUE);
	_tmp0_ = sugar_invoker_get_group_id (self);
	_tmp1_ = sugar_palette_groups_get (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = sugar_palette_group_get_parent (_tmp2_, self);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	parent = _tmp4_;
	if (parent != NULL) {
		sugar_animator_abort (parent->priv->_popdown_anim);
	}
	sugar_animator_abort (self->priv->_popdown_anim);
	_g_object_unref0 (parent);
}


static void _sugar_invoker_on_leave (SugarInvoker* self) {
	g_return_if_fail (self != NULL);
	sugar_invoker_set_focused (self, FALSE);
	_sugar_invoker_popdown (self, FALSE);
}


static void _sugar_invoker_invoker_enter_cb (SugarInvoker* self) {
	g_return_if_fail (self != NULL);
	_sugar_invoker_on_enter (self);
	sugar_mouse_speed_detector_start (self->priv->_mouse_detector);
}


static void _sugar_invoker_invoker_leave_cb (SugarInvoker* self) {
	g_return_if_fail (self != NULL);
	_sugar_invoker_on_leave (self);
	sugar_mouse_speed_detector_stop (self->priv->_mouse_detector);
}


static void _sugar_invoker_force_popup_cb (SugarInvoker* self) {
	g_return_if_fail (self != NULL);
	_sugar_invoker_popup (self, TRUE, TRUE);
}


static void _sugar_invoker_force_popdown_cb (SugarInvoker* self) {
	g_return_if_fail (self != NULL);
	_sugar_invoker_popdown (self, TRUE);
}


static void _sugar_invoker_palette_show_cb (SugarInvoker* self) {
	SugarConnector* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = sugar_invoker_get_connector (self);
	sugar_connector_on_popup (_tmp0_);
	g_signal_emit_by_name (self, "poped-up");
}


static void _sugar_invoker_palette_hide_cb (SugarInvoker* self) {
	SugarConnector* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_sugar_invoker_popdown (self, TRUE);
	_tmp0_ = sugar_invoker_get_connector (self);
	sugar_connector_on_popdown (_tmp0_);
	g_signal_emit_by_name (self, "poped-down");
}


static gboolean _sugar_invoker_palette_enter_notify_event_cb (SugarInvoker* self, GdkEventCrossing* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if ((*event).detail != GDK_NOTIFY_INFERIOR) {
		_tmp0_ = (*event).mode == GDK_CROSSING_NORMAL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		_sugar_invoker_on_enter (self);
	}
	result = FALSE;
	return result;
}


static gboolean _sugar_invoker_palette_leave_notify_event_cb (SugarInvoker* self, GdkEventCrossing* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if ((*event).detail != GDK_NOTIFY_INFERIOR) {
		_tmp0_ = (*event).mode == GDK_CROSSING_NORMAL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		_sugar_invoker_on_leave (self);
	}
	result = FALSE;
	return result;
}


static void _sugar_invoker_popup_completed_cb (SugarInvoker* self, gboolean aborted) {
	g_return_if_fail (self != NULL);
	if (!aborted) {
		_sugar_invoker_popup (self, TRUE, FALSE);
	}
}


static void _sugar_invoker_popdown_completed_cb (SugarInvoker* self, gboolean aborted) {
	g_return_if_fail (self != NULL);
	if (!aborted) {
		_sugar_invoker_popdown (self, TRUE);
	}
}


static void _sugar_invoker_motion_slow_cb (SugarInvoker* self) {
	g_return_if_fail (self != NULL);
	sugar_mouse_speed_detector_stop (self->priv->_mouse_detector);
	if (self->priv->_is_up) {
		sugar_animator_abort (self->priv->_popdown_anim);
	} else {
		gboolean immediate;
		const gchar* _tmp0_ = NULL;
		immediate = FALSE;
		_tmp0_ = sugar_invoker_get_group_id (self);
		if (_tmp0_ != NULL) {
			const gchar* _tmp1_ = NULL;
			SugarPaletteGroup* _tmp2_ = NULL;
			SugarPaletteGroup* _tmp3_;
			gboolean _tmp4_;
			_tmp1_ = sugar_invoker_get_group_id (self);
			_tmp2_ = sugar_palette_groups_get (_tmp1_);
			_tmp3_ = _tmp2_;
			_tmp4_ = sugar_palette_group_get_is_up (_tmp3_);
			immediate = _tmp4_;
			_g_object_unref0 (_tmp3_);
		}
		_sugar_invoker_popup (self, immediate, FALSE);
	}
}


static void _sugar_invoker_secondary_completed_cb (SugarInvoker* self, gboolean aborted) {
	g_return_if_fail (self != NULL);
	if (!aborted) {
		_sugar_invoker_popup (self, TRUE, TRUE);
	}
}


SugarConnector* sugar_invoker_get_connector (SugarInvoker* self) {
	SugarConnector* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_connector;
	return result;
}


static void __sugar_invoker_invoker_enter_cb_sugar_connector_invoker_enter (SugarConnector* _sender, gpointer self) {
	_sugar_invoker_invoker_enter_cb (self);
}


static void __sugar_invoker_invoker_leave_cb_sugar_connector_invoker_leave (SugarConnector* _sender, gpointer self) {
	_sugar_invoker_invoker_leave_cb (self);
}


static void __sugar_invoker_force_popup_cb_sugar_connector_popup (SugarConnector* _sender, gpointer self) {
	_sugar_invoker_force_popup_cb (self);
}


static void __sugar_invoker_force_popdown_cb_sugar_connector_popdown (SugarConnector* _sender, gpointer self) {
	_sugar_invoker_force_popdown_cb (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void sugar_invoker_set_connector (SugarInvoker* self, SugarConnector* value) {
	SugarConnector* _tmp0_ = NULL;
	SugarConnector* _tmp9_;
	SugarConnector* _tmp10_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = sugar_invoker_get_connector (self);
	if (_tmp0_ != NULL) {
		SugarConnector* _tmp1_ = NULL;
		guint _tmp2_;
		SugarConnector* _tmp3_ = NULL;
		guint _tmp4_;
		SugarConnector* _tmp5_ = NULL;
		guint _tmp6_;
		SugarConnector* _tmp7_ = NULL;
		guint _tmp8_;
		_tmp1_ = sugar_invoker_get_connector (self);
		g_signal_parse_name ("invoker-enter", SUGAR_TYPE_CONNECTOR, &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) __sugar_invoker_invoker_enter_cb_sugar_connector_invoker_enter, self);
		_tmp3_ = sugar_invoker_get_connector (self);
		g_signal_parse_name ("invoker-leave", SUGAR_TYPE_CONNECTOR, &_tmp4_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) __sugar_invoker_invoker_leave_cb_sugar_connector_invoker_leave, self);
		_tmp5_ = sugar_invoker_get_connector (self);
		g_signal_parse_name ("popup", SUGAR_TYPE_CONNECTOR, &_tmp6_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) __sugar_invoker_force_popup_cb_sugar_connector_popup, self);
		_tmp7_ = sugar_invoker_get_connector (self);
		g_signal_parse_name ("popdown", SUGAR_TYPE_CONNECTOR, &_tmp8_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) __sugar_invoker_force_popdown_cb_sugar_connector_popdown, self);
	}
	_tmp9_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_connector);
	self->priv->_connector = _tmp9_;
	_tmp10_ = sugar_invoker_get_connector (self);
	if (_tmp10_ != NULL) {
		SugarConnector* _tmp11_ = NULL;
		SugarConnector* _tmp12_ = NULL;
		SugarConnector* _tmp13_ = NULL;
		SugarConnector* _tmp14_ = NULL;
		_tmp11_ = sugar_invoker_get_connector (self);
		g_signal_connect_object (_tmp11_, "invoker-enter", (GCallback) __sugar_invoker_invoker_enter_cb_sugar_connector_invoker_enter, self, 0);
		_tmp12_ = sugar_invoker_get_connector (self);
		g_signal_connect_object (_tmp12_, "invoker-leave", (GCallback) __sugar_invoker_invoker_leave_cb_sugar_connector_invoker_leave, self, 0);
		_tmp13_ = sugar_invoker_get_connector (self);
		g_signal_connect_object (_tmp13_, "popup", (GCallback) __sugar_invoker_force_popup_cb_sugar_connector_popup, self, 0);
		_tmp14_ = sugar_invoker_get_connector (self);
		g_signal_connect_object (_tmp14_, "popdown", (GCallback) __sugar_invoker_force_popdown_cb_sugar_connector_popdown, self, 0);
	}
	g_object_notify ((GObject *) self, "connector");
}


const gchar* sugar_invoker_get_group_id (SugarInvoker* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_group_id;
	return result;
}


void sugar_invoker_set_group_id (SugarInvoker* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp3_;
	const gchar* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = sugar_invoker_get_group_id (self);
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_ = NULL;
		SugarPaletteGroup* _tmp2_ = NULL;
		SugarPaletteGroup* group;
		_tmp1_ = sugar_invoker_get_group_id (self);
		_tmp2_ = sugar_palette_groups_get (_tmp1_);
		group = _tmp2_;
		sugar_palette_group_remove (group, self);
		_g_object_unref0 (group);
	}
	_tmp3_ = g_strdup (value);
	_g_free0 (self->priv->_group_id);
	self->priv->_group_id = _tmp3_;
	_tmp4_ = sugar_invoker_get_group_id (self);
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_ = NULL;
		SugarPaletteGroup* _tmp6_ = NULL;
		SugarPaletteGroup* group;
		_tmp5_ = sugar_invoker_get_group_id (self);
		_tmp6_ = sugar_palette_groups_get (_tmp5_);
		group = _tmp6_;
		sugar_palette_group_add (group, self);
		_g_object_unref0 (group);
	}
	g_object_notify ((GObject *) self, "group-id");
}


SugarPaletteWindow* sugar_invoker_get_palette_window (SugarInvoker* self) {
	SugarPaletteWindow* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_palette;
	return result;
}


static void __sugar_invoker_palette_show_cb_gtk_widget_show (GtkWidget* _sender, gpointer self) {
	_sugar_invoker_palette_show_cb (self);
}


static void __sugar_invoker_palette_hide_cb_gtk_widget_hide (GtkWidget* _sender, gpointer self) {
	_sugar_invoker_palette_hide_cb (self);
}


static gboolean __sugar_invoker_palette_enter_notify_event_cb_gtk_widget_enter_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self) {
	gboolean result;
	result = _sugar_invoker_palette_enter_notify_event_cb (self, event);
	return result;
}


static gboolean __sugar_invoker_palette_leave_notify_event_cb_gtk_widget_leave_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self) {
	gboolean result;
	result = _sugar_invoker_palette_leave_notify_event_cb (self, event);
	return result;
}


void sugar_invoker_set_palette_window (SugarInvoker* self, SugarPaletteWindow* value) {
	SugarPaletteWindow* _tmp0_ = NULL;
	SugarPaletteWindow* _tmp10_;
	SugarPaletteWindow* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = sugar_invoker_get_palette_window (self);
	if (_tmp0_ != NULL) {
		SugarPaletteWindow* _tmp1_ = NULL;
		guint _tmp2_;
		SugarPaletteWindow* _tmp3_ = NULL;
		guint _tmp4_;
		SugarPaletteWindow* _tmp5_ = NULL;
		guint _tmp6_;
		SugarPaletteWindow* _tmp7_ = NULL;
		guint _tmp8_;
		SugarPaletteWindow* _tmp9_ = NULL;
		_sugar_invoker_popdown (self, TRUE);
		_tmp1_ = sugar_invoker_get_palette_window (self);
		g_signal_parse_name ("show", GTK_TYPE_WIDGET, &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) __sugar_invoker_palette_show_cb_gtk_widget_show, self);
		_tmp3_ = sugar_invoker_get_palette_window (self);
		g_signal_parse_name ("hide", GTK_TYPE_WIDGET, &_tmp4_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) __sugar_invoker_palette_hide_cb_gtk_widget_hide, self);
		_tmp5_ = sugar_invoker_get_palette_window (self);
		g_signal_parse_name ("enter-notify-event", GTK_TYPE_WIDGET, &_tmp6_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) __sugar_invoker_palette_enter_notify_event_cb_gtk_widget_enter_notify_event, self);
		_tmp7_ = sugar_invoker_get_palette_window (self);
		g_signal_parse_name ("leave-notify-event", GTK_TYPE_WIDGET, &_tmp8_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) __sugar_invoker_palette_leave_notify_event_cb_gtk_widget_leave_notify_event, self);
		_tmp9_ = sugar_invoker_get_palette_window (self);
		sugar_palette_window_set_connector (_tmp9_, NULL);
	}
	_tmp10_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_palette);
	self->priv->_palette = _tmp10_;
	_tmp11_ = sugar_invoker_get_palette_window (self);
	if (_tmp11_ != NULL) {
		SugarPaletteWindow* _tmp12_ = NULL;
		SugarConnector* _tmp13_ = NULL;
		SugarPaletteWindow* _tmp14_ = NULL;
		SugarPaletteWindow* _tmp15_ = NULL;
		SugarPaletteWindow* _tmp16_ = NULL;
		SugarPaletteWindow* _tmp17_ = NULL;
		_tmp12_ = sugar_invoker_get_palette_window (self);
		_tmp13_ = sugar_invoker_get_connector (self);
		sugar_palette_window_set_connector (_tmp12_, _tmp13_);
		_tmp14_ = sugar_invoker_get_palette_window (self);
		g_signal_connect_object ((GtkWidget*) _tmp14_, "show", (GCallback) __sugar_invoker_palette_show_cb_gtk_widget_show, self, 0);
		_tmp15_ = sugar_invoker_get_palette_window (self);
		g_signal_connect_object ((GtkWidget*) _tmp15_, "hide", (GCallback) __sugar_invoker_palette_hide_cb_gtk_widget_hide, self, 0);
		_tmp16_ = sugar_invoker_get_palette_window (self);
		g_signal_connect_object ((GtkWidget*) _tmp16_, "enter-notify-event", (GCallback) __sugar_invoker_palette_enter_notify_event_cb_gtk_widget_enter_notify_event, self, 0);
		_tmp17_ = sugar_invoker_get_palette_window (self);
		g_signal_connect_object ((GtkWidget*) _tmp17_, "leave-notify-event", (GCallback) __sugar_invoker_palette_leave_notify_event_cb_gtk_widget_leave_notify_event, self, 0);
		if (self->priv->_is_up) {
			_sugar_invoker_reveal_palette (self);
		}
	}
	g_object_notify ((GObject *) self, "palette-window");
}


SugarPalette* sugar_invoker_get_palette (SugarInvoker* self) {
	SugarPalette* result;
	SugarPaletteWindow* _tmp0_ = NULL;
	SugarPaletteWindow* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = sugar_invoker_get_palette_window (self);
	_tmp1_ = _tmp0_;
	result = SUGAR_IS_PALETTE (_tmp1_) ? ((SugarPalette*) _tmp1_) : NULL;
	return result;
}


void sugar_invoker_set_palette (SugarInvoker* self, SugarPalette* value) {
	g_return_if_fail (self != NULL);
	sugar_invoker_set_palette_window (self, (SugarPaletteWindow*) value);
	g_object_notify ((GObject *) self, "palette");
}


gboolean sugar_invoker_get_is_up (SugarInvoker* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_up;
	return result;
}


static void sugar_invoker_set_is_up (SugarInvoker* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_up = value;
	g_object_notify ((GObject *) self, "is-up");
}


gboolean sugar_invoker_get_focused (SugarInvoker* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_focused;
	return result;
}


static void sugar_invoker_set_focused (SugarInvoker* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_focused = value;
	g_object_notify ((GObject *) self, "focused");
}


static void __sugar_invoker_popup_completed_cb_sugar_animator_completed (SugarAnimator* _sender, gboolean aborted, gpointer self) {
	_sugar_invoker_popup_completed_cb (self, aborted);
}


static void __sugar_invoker_popdown_completed_cb_sugar_animator_completed (SugarAnimator* _sender, gboolean aborted, gpointer self) {
	_sugar_invoker_popdown_completed_cb (self, aborted);
}


static void __sugar_invoker_secondary_completed_cb_sugar_animator_completed (SugarAnimator* _sender, gboolean aborted, gpointer self) {
	_sugar_invoker_secondary_completed_cb (self, aborted);
}


static void __sugar_invoker_motion_slow_cb_sugar_mouse_speed_detector_motion_slow (SugarMouseSpeedDetector* _sender, gpointer self) {
	_sugar_invoker_motion_slow_cb (self);
}


static GObject * sugar_invoker_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SugarInvoker * self;
	SugarAnimator* _tmp0_ = NULL;
	SugarAnimator* _tmp1_ = NULL;
	SugarAnimator* _tmp2_ = NULL;
	SugarMouseSpeedDetector* _tmp3_ = NULL;
	parent_class = G_OBJECT_CLASS (sugar_invoker_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SUGAR_INVOKER (obj);
	_tmp0_ = sugar_animator_new (0.5, 10, 0.0, 1.0, SUGAR_ANIMATION_TYPE_OUT_EXPO);
	_g_object_unref0 (self->priv->_popup_anim);
	self->priv->_popup_anim = _tmp0_;
	g_signal_connect_object (self->priv->_popup_anim, "completed", (GCallback) __sugar_invoker_popup_completed_cb_sugar_animator_completed, self, 0);
	_tmp1_ = sugar_animator_new (0.6, 10, 0.0, 1.0, SUGAR_ANIMATION_TYPE_OUT_EXPO);
	_g_object_unref0 (self->priv->_popdown_anim);
	self->priv->_popdown_anim = _tmp1_;
	g_signal_connect_object (self->priv->_popdown_anim, "completed", (GCallback) __sugar_invoker_popdown_completed_cb_sugar_animator_completed, self, 0);
	_tmp2_ = sugar_animator_new (1.5, 10, 0.0, 1.0, SUGAR_ANIMATION_TYPE_OUT_EXPO);
	_g_object_unref0 (self->priv->_secondary_anim);
	self->priv->_secondary_anim = _tmp2_;
	g_signal_connect_object (self->priv->_secondary_anim, "completed", (GCallback) __sugar_invoker_secondary_completed_cb_sugar_animator_completed, self, 0);
	_tmp3_ = sugar_mouse_speed_detector_new (200, 5);
	_g_object_unref0 (self->priv->_mouse_detector);
	self->priv->_mouse_detector = _tmp3_;
	g_signal_connect_object (self->priv->_mouse_detector, "motion-slow", (GCallback) __sugar_invoker_motion_slow_cb_sugar_mouse_speed_detector_motion_slow, self, 0);
	return obj;
}


static void sugar_invoker_class_init (SugarInvokerClass * klass) {
	sugar_invoker_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SugarInvokerPrivate));
	G_OBJECT_CLASS (klass)->dispose = sugar_invoker_real_dispose;
	G_OBJECT_CLASS (klass)->get_property = _vala_sugar_invoker_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sugar_invoker_set_property;
	G_OBJECT_CLASS (klass)->constructor = sugar_invoker_constructor;
	G_OBJECT_CLASS (klass)->finalize = sugar_invoker_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_INVOKER_CONNECTOR, g_param_spec_object ("connector", "connector", "connector", SUGAR_TYPE_CONNECTOR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_INVOKER_GROUP_ID, g_param_spec_string ("group-id", "group-id", "group-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_INVOKER_PALETTE_WINDOW, g_param_spec_object ("palette-window", "palette-window", "palette-window", SUGAR_TYPE_PALETTE_WINDOW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_INVOKER_PALETTE, g_param_spec_object ("palette", "palette", "palette", SUGAR_TYPE_PALETTE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_INVOKER_IS_UP, g_param_spec_boolean ("is-up", "is-up", "is-up", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * Is cursor under invoker's widget or palette_request
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUGAR_INVOKER_FOCUSED, g_param_spec_boolean ("focused", "focused", "focused", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("palette_request", SUGAR_TYPE_INVOKER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("poped_up", SUGAR_TYPE_INVOKER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("poped_down", SUGAR_TYPE_INVOKER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void sugar_invoker_instance_init (SugarInvoker * self) {
	self->priv = SUGAR_INVOKER_GET_PRIVATE (self);
	self->priv->_is_up = FALSE;
	self->priv->_focused = FALSE;
}


static void sugar_invoker_finalize (GObject* obj) {
	SugarInvoker * self;
	self = SUGAR_INVOKER (obj);
	_g_free0 (self->priv->_group_id);
	_g_object_unref0 (self->priv->_connector);
	_g_object_unref0 (self->priv->_palette);
	_g_object_unref0 (self->priv->_popup_anim);
	_g_object_unref0 (self->priv->_popdown_anim);
	_g_object_unref0 (self->priv->_secondary_anim);
	_g_object_unref0 (self->priv->_mouse_detector);
	G_OBJECT_CLASS (sugar_invoker_parent_class)->finalize (obj);
}


GType sugar_invoker_get_type (void) {
	static volatile gsize sugar_invoker_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_invoker_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SugarInvokerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar_invoker_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SugarInvoker), 0, (GInstanceInitFunc) sugar_invoker_instance_init, NULL };
		GType sugar_invoker_type_id;
		sugar_invoker_type_id = g_type_register_static (G_TYPE_OBJECT, "SugarInvoker", &g_define_type_info, 0);
		g_once_init_leave (&sugar_invoker_type_id__volatile, sugar_invoker_type_id);
	}
	return sugar_invoker_type_id__volatile;
}


static void _vala_sugar_invoker_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SugarInvoker * self;
	self = SUGAR_INVOKER (object);
	switch (property_id) {
		case SUGAR_INVOKER_CONNECTOR:
		g_value_set_object (value, sugar_invoker_get_connector (self));
		break;
		case SUGAR_INVOKER_GROUP_ID:
		g_value_set_string (value, sugar_invoker_get_group_id (self));
		break;
		case SUGAR_INVOKER_PALETTE_WINDOW:
		g_value_set_object (value, sugar_invoker_get_palette_window (self));
		break;
		case SUGAR_INVOKER_PALETTE:
		g_value_set_object (value, sugar_invoker_get_palette (self));
		break;
		case SUGAR_INVOKER_IS_UP:
		g_value_set_boolean (value, sugar_invoker_get_is_up (self));
		break;
		case SUGAR_INVOKER_FOCUSED:
		g_value_set_boolean (value, sugar_invoker_get_focused (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_sugar_invoker_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SugarInvoker * self;
	self = SUGAR_INVOKER (object);
	switch (property_id) {
		case SUGAR_INVOKER_CONNECTOR:
		sugar_invoker_set_connector (self, g_value_get_object (value));
		break;
		case SUGAR_INVOKER_GROUP_ID:
		sugar_invoker_set_group_id (self, g_value_get_string (value));
		break;
		case SUGAR_INVOKER_PALETTE_WINDOW:
		sugar_invoker_set_palette_window (self, g_value_get_object (value));
		break;
		case SUGAR_INVOKER_PALETTE:
		sugar_invoker_set_palette (self, g_value_get_object (value));
		break;
		case SUGAR_INVOKER_IS_UP:
		sugar_invoker_set_is_up (self, g_value_get_boolean (value));
		break;
		case SUGAR_INVOKER_FOCUSED:
		sugar_invoker_set_focused (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



